/*
 * Decompiled with CFR 0.152.
 */
package com.android.apex;

import com.android.apex.ApexInfoList;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;

public class XmlWriter
implements Closeable {
    private PrintWriter out;
    private StringBuilder outBuffer;
    private int indent;
    private boolean startLine;

    public XmlWriter(PrintWriter printWriter) {
        this.out = printWriter;
        this.outBuffer = new StringBuilder();
        this.indent = 0;
        this.startLine = true;
    }

    private void printIndent() {
        assert (this.startLine);
        for (int i = 0; i < this.indent; ++i) {
            this.outBuffer.append("    ");
        }
        this.startLine = false;
    }

    void print(String code) {
        String[] lines = code.split("\n", -1);
        for (int i = 0; i < lines.length; ++i) {
            if (this.startLine && !lines[i].isEmpty()) {
                this.printIndent();
            }
            this.outBuffer.append(lines[i]);
            if (i + 1 >= lines.length) continue;
            this.outBuffer.append("\n");
            this.startLine = true;
        }
    }

    void increaseIndent() {
        ++this.indent;
    }

    void decreaseIndent() {
        --this.indent;
    }

    void printXml() {
        this.out.print(this.outBuffer.toString());
    }

    @Override
    public void close() {
        if (this.out != null) {
            this.out.close();
        }
    }

    public static void write(XmlWriter _out, ApexInfoList apexInfoList) throws IOException {
        _out.print("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        if (apexInfoList != null) {
            apexInfoList.write(_out, "apex-info-list");
        }
        _out.printXml();
    }
}

