/*
 * Decompiled with CFR 0.152.
 */
package com.android.bluetooth.x.com.android.modules.utils;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;
import com.android.bluetooth.x.com.android.modules.utils.ISynchronousResultReceiver;
import com.android.internal.annotations.GuardedBy;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SynchronousResultReceiver<T>
implements Parcelable {
    private static final String TAG = "SynchronousResultReceiver";
    private final boolean mLocal;
    private boolean mIsCompleted;
    private static final Object sLock = new Object();
    private static final int QUEUE_THRESHOLD = 4;
    @GuardedBy(value={"sLock"})
    private CompletableFuture<Result<T>> mFuture = new CompletableFuture();
    @GuardedBy(value={"sLock"})
    private static final ConcurrentLinkedQueue<SynchronousResultReceiver> sAvailableReceivers = new ConcurrentLinkedQueue();
    ISynchronousResultReceiver mReceiver = null;
    public static final Parcelable.Creator<SynchronousResultReceiver<?>> CREATOR = new Parcelable.Creator<SynchronousResultReceiver<?>>(){

        @Override
        public SynchronousResultReceiver<?> createFromParcel(Parcel in) {
            return new SynchronousResultReceiver(in);
        }

        public SynchronousResultReceiver<?>[] newArray(int size) {
            return new SynchronousResultReceiver[size];
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> SynchronousResultReceiver<T> get() {
        Object object = sLock;
        synchronized (object) {
            if (sAvailableReceivers.isEmpty()) {
                return new SynchronousResultReceiver<T>();
            }
            SynchronousResultReceiver receiver = sAvailableReceivers.poll();
            receiver.resetLocked();
            return receiver;
        }
    }

    private SynchronousResultReceiver() {
        this.mLocal = true;
        this.mIsCompleted = false;
    }

    @GuardedBy(value={"sLock"})
    private void releaseLocked() {
        this.mFuture = null;
        if (sAvailableReceivers.size() < 4) {
            sAvailableReceivers.add(this);
        }
    }

    @GuardedBy(value={"sLock"})
    private void resetLocked() {
        this.mFuture = new CompletableFuture();
        this.mIsCompleted = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Result<T>> getFuture() {
        Object object = sLock;
        synchronized (object) {
            return this.mFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void complete(Result<T> result) {
        if (this.mIsCompleted) {
            throw new IllegalStateException("Receiver has already been completed");
        }
        this.mIsCompleted = true;
        if (this.mLocal) {
            this.getFuture().complete(result);
        } else {
            ISynchronousResultReceiver rr;
            SynchronousResultReceiver synchronousResultReceiver = this;
            synchronized (synchronousResultReceiver) {
                rr = this.mReceiver;
            }
            if (rr != null) {
                try {
                    rr.send(result);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Failed to complete future");
                }
            }
        }
    }

    public void send(T resultData) {
        this.complete(new Result<T>(resultData));
    }

    public void propagateException(RuntimeException e) {
        Objects.requireNonNull(e, "RuntimeException cannot be null");
        this.complete(new Result(e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result<T> awaitResultNoInterrupt(Duration timeout) throws TimeoutException {
        Objects.requireNonNull(timeout, "Null timeout is not allowed");
        long startWaitNanoTime = SystemClock.elapsedRealtimeNanos();
        Duration remainingTime = timeout;
        while (!remainingTime.isNegative()) {
            try {
                Result<T> result = this.getFuture().get(remainingTime.toMillis(), TimeUnit.MILLISECONDS);
                Object object = sLock;
                synchronized (object) {
                    this.releaseLocked();
                    return result;
                }
            }
            catch (ExecutionException e) {
                throw new AssertionError("Error receiving response", e);
            }
            catch (InterruptedException e) {
                remainingTime = timeout.minus(Duration.ofNanos(SystemClock.elapsedRealtimeNanos() - startWaitNanoTime));
            }
        }
        Object object = sLock;
        synchronized (object) {
            this.releaseLocked();
        }
        throw new TimeoutException();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToParcel(Parcel out, int flags) {
        SynchronousResultReceiver synchronousResultReceiver = this;
        synchronized (synchronousResultReceiver) {
            if (this.mReceiver == null) {
                this.mReceiver = new MyResultReceiver();
            }
            out.writeStrongBinder(this.mReceiver.asBinder());
        }
    }

    private SynchronousResultReceiver(Parcel in) {
        this.mLocal = false;
        this.mIsCompleted = false;
        this.mReceiver = ISynchronousResultReceiver.Stub.asInterface(in.readStrongBinder());
    }

    public static class Result<T>
    implements Parcelable {
        private final T mObject;
        private final RuntimeException mException;
        public static final Parcelable.Creator<Result<?>> CREATOR = new Parcelable.Creator<Result<?>>(){

            @Override
            public Result createFromParcel(Parcel in) {
                return new Result(in);
            }

            public Result[] newArray(int size) {
                return new Result[size];
            }
        };

        public Result(RuntimeException exception) {
            this.mObject = null;
            this.mException = exception;
        }

        public Result(T object) {
            this.mObject = object;
            this.mException = null;
        }

        public T getValue(T defaultValue) {
            if (this.mException != null) {
                throw this.mException;
            }
            if (this.mObject == null) {
                return defaultValue;
            }
            return this.mObject;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeValue(this.mObject);
            out.writeValue(this.mException);
        }

        private Result(Parcel in) {
            this.mObject = in.readValue(null);
            this.mException = (RuntimeException)in.readValue(null);
        }
    }

    private class MyResultReceiver
    extends ISynchronousResultReceiver.Stub {
        private MyResultReceiver() {
        }

        @Override
        public void send(Result result) {
            Result res = result;
            CompletableFuture<Result<Result>> future = SynchronousResultReceiver.this.getFuture();
            if (future != null) {
                future.complete(res);
            }
        }
    }
}

