/*
 * Decompiled with CFR 0.152.
 */
package com.android.ims.internal;

import android.compat.annotation.UnsupportedAppUsage;
import android.net.Uri;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telecom.VideoProfile;
import android.view.Surface;
import com.android.ims.internal.IImsVideoCallCallback;

public interface IImsVideoCallProvider
extends IInterface {
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/telephony/java/com/android/ims/internal/IImsVideoCallProvider.aidl:44:1:44:69")
    public void setCallback(IImsVideoCallCallback var1) throws RemoteException;

    public void setCamera(String var1, int var2) throws RemoteException;

    public void setPreviewSurface(Surface var1) throws RemoteException;

    public void setDisplaySurface(Surface var1) throws RemoteException;

    public void setDeviceOrientation(int var1) throws RemoteException;

    public void setZoom(float var1) throws RemoteException;

    public void sendSessionModifyRequest(VideoProfile var1, VideoProfile var2) throws RemoteException;

    public void sendSessionModifyResponse(VideoProfile var1) throws RemoteException;

    public void requestCameraCapabilities() throws RemoteException;

    public void requestCallDataUsage() throws RemoteException;

    public void setPauseImage(Uri var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IImsVideoCallProvider {
        public static final String DESCRIPTOR = "com.android.ims.internal.IImsVideoCallProvider";
        static final int TRANSACTION_setCallback = 1;
        static final int TRANSACTION_setCamera = 2;
        static final int TRANSACTION_setPreviewSurface = 3;
        static final int TRANSACTION_setDisplaySurface = 4;
        static final int TRANSACTION_setDeviceOrientation = 5;
        static final int TRANSACTION_setZoom = 6;
        static final int TRANSACTION_sendSessionModifyRequest = 7;
        static final int TRANSACTION_sendSessionModifyResponse = 8;
        static final int TRANSACTION_requestCameraCapabilities = 9;
        static final int TRANSACTION_requestCallDataUsage = 10;
        static final int TRANSACTION_setPauseImage = 11;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IImsVideoCallProvider asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IImsVideoCallProvider) {
                return (IImsVideoCallProvider)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setCallback";
                }
                case 2: {
                    return "setCamera";
                }
                case 3: {
                    return "setPreviewSurface";
                }
                case 4: {
                    return "setDisplaySurface";
                }
                case 5: {
                    return "setDeviceOrientation";
                }
                case 6: {
                    return "setZoom";
                }
                case 7: {
                    return "sendSessionModifyRequest";
                }
                case 8: {
                    return "sendSessionModifyResponse";
                }
                case 9: {
                    return "requestCameraCapabilities";
                }
                case 10: {
                    return "requestCallDataUsage";
                }
                case 11: {
                    return "setPauseImage";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    IImsVideoCallCallback _arg0 = IImsVideoCallCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setCallback(_arg0);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setCamera(_arg0, _arg1);
                    break;
                }
                case 3: {
                    Surface _arg0 = data.readTypedObject(Surface.CREATOR);
                    data.enforceNoDataAvail();
                    this.setPreviewSurface(_arg0);
                    break;
                }
                case 4: {
                    Surface _arg0 = data.readTypedObject(Surface.CREATOR);
                    data.enforceNoDataAvail();
                    this.setDisplaySurface(_arg0);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setDeviceOrientation(_arg0);
                    break;
                }
                case 6: {
                    float _arg0 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.setZoom(_arg0);
                    break;
                }
                case 7: {
                    VideoProfile _arg0 = data.readTypedObject(VideoProfile.CREATOR);
                    VideoProfile _arg1 = data.readTypedObject(VideoProfile.CREATOR);
                    data.enforceNoDataAvail();
                    this.sendSessionModifyRequest(_arg0, _arg1);
                    break;
                }
                case 8: {
                    VideoProfile _arg0 = data.readTypedObject(VideoProfile.CREATOR);
                    data.enforceNoDataAvail();
                    this.sendSessionModifyResponse(_arg0);
                    break;
                }
                case 9: {
                    this.requestCameraCapabilities();
                    break;
                }
                case 10: {
                    this.requestCallDataUsage();
                    break;
                }
                case 11: {
                    Uri _arg0 = data.readTypedObject(Uri.CREATOR);
                    data.enforceNoDataAvail();
                    this.setPauseImage(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 10;
        }

        private static class Proxy
        implements IImsVideoCallProvider {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCallback(IImsVideoCallCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCamera(String cameraId, int uid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(cameraId);
                    _data.writeInt(uid);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPreviewSurface(Surface surface) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(surface, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDisplaySurface(Surface surface) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(surface, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDeviceOrientation(int rotation) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(rotation);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setZoom(float value) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloat(value);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendSessionModifyRequest(VideoProfile fromProfile, VideoProfile toProfile) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(fromProfile, 0);
                    _data.writeTypedObject(toProfile, 0);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendSessionModifyResponse(VideoProfile responseProfile) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(responseProfile, 0);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void requestCameraCapabilities() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void requestCallDataUsage() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPauseImage(Uri uri) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(uri, 0);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IImsVideoCallProvider {
        @Override
        public void setCallback(IImsVideoCallCallback callback) throws RemoteException {
        }

        @Override
        public void setCamera(String cameraId, int uid) throws RemoteException {
        }

        @Override
        public void setPreviewSurface(Surface surface) throws RemoteException {
        }

        @Override
        public void setDisplaySurface(Surface surface) throws RemoteException {
        }

        @Override
        public void setDeviceOrientation(int rotation) throws RemoteException {
        }

        @Override
        public void setZoom(float value) throws RemoteException {
        }

        @Override
        public void sendSessionModifyRequest(VideoProfile fromProfile, VideoProfile toProfile) throws RemoteException {
        }

        @Override
        public void sendSessionModifyResponse(VideoProfile responseProfile) throws RemoteException {
        }

        @Override
        public void requestCameraCapabilities() throws RemoteException {
        }

        @Override
        public void requestCallDataUsage() throws RemoteException {
        }

        @Override
        public void setPauseImage(Uri uri) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

