/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.AppGlobals;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.IPackageManager;
import android.os.Trace;
import android.os.UserHandle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.IntentForwarderActivity;
import com.android.internal.app.ResolverListAdapter;
import com.android.internal.widget.PagerAdapter;
import com.android.internal.widget.ViewPager;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractMultiProfilePagerAdapter
extends PagerAdapter {
    private static final String TAG = "AbstractMultiProfilePagerAdapter";
    static final int PROFILE_PERSONAL = 0;
    static final int PROFILE_WORK = 1;
    private final Context mContext;
    private int mCurrentPage;
    private OnProfileSelectedListener mOnProfileSelectedListener;
    private Set<Integer> mLoadedPages;
    private final EmptyStateProvider mEmptyStateProvider;
    private final UserHandle mWorkProfileUserHandle;
    private final UserHandle mCloneUserHandle;
    private final QuietModeManager mQuietModeManager;

    AbstractMultiProfilePagerAdapter(Context context, int currentPage, EmptyStateProvider emptyStateProvider, QuietModeManager quietModeManager, UserHandle workProfileUserHandle, UserHandle cloneUserHandle) {
        this.mContext = Objects.requireNonNull(context);
        this.mCurrentPage = currentPage;
        this.mLoadedPages = new HashSet<Integer>();
        this.mWorkProfileUserHandle = workProfileUserHandle;
        this.mCloneUserHandle = cloneUserHandle;
        this.mEmptyStateProvider = emptyStateProvider;
        this.mQuietModeManager = quietModeManager;
    }

    private boolean isQuietModeEnabled(UserHandle workProfileUserHandle) {
        return this.mQuietModeManager.isQuietModeEnabled(workProfileUserHandle);
    }

    void setOnProfileSelectedListener(OnProfileSelectedListener listener) {
        this.mOnProfileSelectedListener = listener;
    }

    Context getContext() {
        return this.mContext;
    }

    void setupViewPager(ViewPager viewPager) {
        viewPager.setOnPageChangeListener(new ViewPager.SimpleOnPageChangeListener(){

            @Override
            public void onPageSelected(int position) {
                AbstractMultiProfilePagerAdapter.this.mCurrentPage = position;
                if (!AbstractMultiProfilePagerAdapter.this.mLoadedPages.contains(position)) {
                    AbstractMultiProfilePagerAdapter.this.rebuildActiveTab(true);
                    AbstractMultiProfilePagerAdapter.this.mLoadedPages.add(position);
                }
                if (AbstractMultiProfilePagerAdapter.this.mOnProfileSelectedListener != null) {
                    AbstractMultiProfilePagerAdapter.this.mOnProfileSelectedListener.onProfileSelected(position);
                }
            }

            @Override
            public void onPageScrollStateChanged(int state) {
                if (AbstractMultiProfilePagerAdapter.this.mOnProfileSelectedListener != null) {
                    AbstractMultiProfilePagerAdapter.this.mOnProfileSelectedListener.onProfilePageStateChanged(state);
                }
            }
        });
        viewPager.setAdapter(this);
        viewPager.setCurrentItem(this.mCurrentPage);
        this.mLoadedPages.add(this.mCurrentPage);
    }

    void clearInactiveProfileCache() {
        if (this.mLoadedPages.size() == 1) {
            return;
        }
        this.mLoadedPages.remove(1 - this.mCurrentPage);
    }

    @Override
    public ViewGroup instantiateItem(ViewGroup container, int position) {
        ProfileDescriptor profileDescriptor = this.getItem(position);
        container.addView(profileDescriptor.rootView);
        return profileDescriptor.rootView;
    }

    @Override
    public void destroyItem(ViewGroup container, int position, Object view) {
        container.removeView((View)view);
    }

    @Override
    public int getCount() {
        return this.getItemCount();
    }

    protected int getCurrentPage() {
        return this.mCurrentPage;
    }

    @VisibleForTesting
    public UserHandle getCurrentUserHandle() {
        return this.getActiveListAdapter().mResolverListController.getUserHandle();
    }

    @Override
    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    @Override
    public CharSequence getPageTitle(int position) {
        return null;
    }

    public UserHandle getCloneUserHandle() {
        return this.mCloneUserHandle;
    }

    abstract ProfileDescriptor getItem(int var1);

    abstract int getItemCount();

    abstract void setupListAdapter(int var1);

    @VisibleForTesting
    public abstract Object getAdapterForIndex(int var1);

    abstract ResolverListAdapter getListAdapterForUserHandle(UserHandle var1);

    @VisibleForTesting
    public abstract ResolverListAdapter getActiveListAdapter();

    @VisibleForTesting
    public abstract ResolverListAdapter getInactiveListAdapter();

    public abstract ResolverListAdapter getPersonalListAdapter();

    public abstract ResolverListAdapter getWorkListAdapter();

    abstract Object getCurrentRootAdapter();

    abstract ViewGroup getActiveAdapterView();

    abstract ViewGroup getInactiveAdapterView();

    boolean rebuildActiveTab(boolean doPostProcessing) {
        Trace.beginSection("MultiProfilePagerAdapter#rebuildActiveTab");
        boolean result = this.rebuildTab(this.getActiveListAdapter(), doPostProcessing);
        Trace.endSection();
        return result;
    }

    boolean rebuildInactiveTab(boolean doPostProcessing) {
        Trace.beginSection("MultiProfilePagerAdapter#rebuildInactiveTab");
        if (this.getItemCount() == 1) {
            Trace.endSection();
            return false;
        }
        boolean result = this.rebuildTab(this.getInactiveListAdapter(), doPostProcessing);
        Trace.endSection();
        return result;
    }

    private int userHandleToPageIndex(UserHandle userHandle) {
        if (userHandle.equals(this.getPersonalListAdapter().mResolverListController.getUserHandle())) {
            return 0;
        }
        return 1;
    }

    private boolean rebuildTab(ResolverListAdapter activeListAdapter, boolean doPostProcessing) {
        if (this.shouldSkipRebuild(activeListAdapter)) {
            activeListAdapter.postListReadyRunnable(doPostProcessing, true);
            return false;
        }
        return activeListAdapter.rebuildList(doPostProcessing);
    }

    private boolean shouldSkipRebuild(ResolverListAdapter activeListAdapter) {
        EmptyState emptyState = this.mEmptyStateProvider.getEmptyState(activeListAdapter);
        return emptyState != null && emptyState.shouldSkipDataRebuild();
    }

    void showEmptyResolverListEmptyState(ResolverListAdapter listAdapter) {
        EmptyState emptyState = this.mEmptyStateProvider.getEmptyState(listAdapter);
        if (emptyState == null) {
            return;
        }
        emptyState.onEmptyStateShown();
        View.OnClickListener clickListener = null;
        if (emptyState.getButtonClickListener() != null) {
            clickListener = v -> emptyState.getButtonClickListener().onClick(() -> {
                ProfileDescriptor descriptor = this.getItem(this.userHandleToPageIndex(listAdapter.getUserHandle()));
                this.showSpinner(descriptor.getEmptyStateView());
            });
        }
        this.showEmptyState(listAdapter, emptyState, clickListener);
    }

    protected void showEmptyState(ResolverListAdapter activeListAdapter, EmptyState emptyState, View.OnClickListener buttonOnClick) {
        ProfileDescriptor descriptor = this.getItem(this.userHandleToPageIndex(activeListAdapter.getUserHandle()));
        ((View)descriptor.rootView.findViewById(16909438)).setVisibility(8);
        ViewGroup emptyStateView = descriptor.getEmptyStateView();
        this.resetViewVisibilitiesForEmptyState(emptyStateView);
        emptyStateView.setVisibility(0);
        Object container = emptyStateView.findViewById(16909433);
        this.setupContainerPadding((View)container);
        TextView titleView = (TextView)emptyStateView.findViewById(16909437);
        String title = emptyState.getTitle();
        if (title != null) {
            titleView.setVisibility(0);
            titleView.setText(title);
        } else {
            titleView.setVisibility(8);
        }
        TextView subtitleView = (TextView)emptyStateView.findViewById(16909436);
        String subtitle = emptyState.getSubtitle();
        if (subtitle != null) {
            subtitleView.setVisibility(0);
            subtitleView.setText(subtitle);
        } else {
            subtitleView.setVisibility(8);
        }
        Object defaultEmptyText = emptyStateView.findViewById(16908292);
        ((View)defaultEmptyText).setVisibility(emptyState.useDefaultEmptyView() ? 0 : 8);
        Button button = (Button)emptyStateView.findViewById(16909432);
        button.setVisibility(buttonOnClick != null ? 0 : 8);
        button.setOnClickListener(buttonOnClick);
        activeListAdapter.markTabLoaded();
    }

    protected void setupContainerPadding(View container) {
    }

    private void showSpinner(View emptyStateView) {
        ((View)emptyStateView.findViewById(16909437)).setVisibility(4);
        ((View)emptyStateView.findViewById(16909432)).setVisibility(4);
        ((View)emptyStateView.findViewById(16909435)).setVisibility(0);
        ((View)emptyStateView.findViewById(16908292)).setVisibility(8);
    }

    private void resetViewVisibilitiesForEmptyState(View emptyStateView) {
        ((View)emptyStateView.findViewById(16909437)).setVisibility(0);
        ((View)emptyStateView.findViewById(16909436)).setVisibility(0);
        ((View)emptyStateView.findViewById(16909432)).setVisibility(4);
        ((View)emptyStateView.findViewById(16909435)).setVisibility(8);
        ((View)emptyStateView.findViewById(16908292)).setVisibility(8);
    }

    protected void showListView(ResolverListAdapter activeListAdapter) {
        ProfileDescriptor descriptor = this.getItem(this.userHandleToPageIndex(activeListAdapter.getUserHandle()));
        ((View)descriptor.rootView.findViewById(16909438)).setVisibility(0);
        Object emptyStateView = descriptor.rootView.findViewById(16909431);
        ((View)emptyStateView).setVisibility(8);
    }

    boolean shouldShowEmptyStateScreen(ResolverListAdapter listAdapter) {
        int count = listAdapter.getUnfilteredCount();
        return count == 0 && listAdapter.getPlaceholderCount() == 0 || listAdapter.getUserHandle().equals(this.mWorkProfileUserHandle) && this.isQuietModeEnabled(this.mWorkProfileUserHandle);
    }

    public static interface EmptyStateProvider {
        default public EmptyState getEmptyState(ResolverListAdapter resolverListAdapter) {
            return null;
        }
    }

    public static interface QuietModeManager {
        public boolean isQuietModeEnabled(UserHandle var1);

        public void requestQuietModeEnabled(boolean var1, UserHandle var2);

        public void markWorkProfileEnabledBroadcastReceived();

        public boolean isWaitingToEnableWorkProfile();
    }

    public static interface OnProfileSelectedListener {
        public void onProfileSelected(int var1);

        public void onProfilePageStateChanged(int var1);
    }

    protected class ProfileDescriptor {
        final ViewGroup rootView;
        private final ViewGroup mEmptyStateView;

        ProfileDescriptor(ViewGroup rootView) {
            this.rootView = rootView;
            this.mEmptyStateView = (ViewGroup)rootView.findViewById(16909431);
        }

        protected ViewGroup getEmptyStateView() {
            return this.mEmptyStateView;
        }
    }

    public static interface EmptyState {
        default public String getTitle() {
            return null;
        }

        default public String getSubtitle() {
            return null;
        }

        default public ClickListener getButtonClickListener() {
            return null;
        }

        default public boolean useDefaultEmptyView() {
            return false;
        }

        default public boolean shouldSkipDataRebuild() {
            return false;
        }

        default public void onEmptyStateShown() {
        }

        public static interface TabControl {
            public void showSpinner();
        }

        public static interface ClickListener {
            public void onClick(TabControl var1);
        }
    }

    static interface OnSwitchOnWorkSelectedListener {
        public void onSwitchOnWorkSelected();
    }

    public static class CompositeEmptyStateProvider
    implements EmptyStateProvider {
        private final EmptyStateProvider[] mProviders;

        public CompositeEmptyStateProvider(EmptyStateProvider ... providers) {
            this.mProviders = providers;
        }

        @Override
        public EmptyState getEmptyState(ResolverListAdapter resolverListAdapter) {
            for (EmptyStateProvider provider : this.mProviders) {
                EmptyState emptyState = provider.getEmptyState(resolverListAdapter);
                if (emptyState == null) continue;
                return emptyState;
            }
            return null;
        }
    }

    public static class CrossProfileIntentsChecker {
        private final ContentResolver mContentResolver;

        public CrossProfileIntentsChecker(ContentResolver contentResolver) {
            this.mContentResolver = contentResolver;
        }

        public boolean hasCrossProfileIntents(List<Intent> intents, int source, int target) {
            IPackageManager packageManager = AppGlobals.getPackageManager();
            return intents.stream().anyMatch(intent -> null != IntentForwarderActivity.canForward(intent, source, target, packageManager, this.mContentResolver));
        }
    }

    public static class MyUserIdProvider {
        public int getMyUserId() {
            return UserHandle.myUserId();
        }
    }

    static @interface Profile {
    }
}

