/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.LocaleManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.LocaleList;
import android.os.SystemProperties;
import android.os._Original_Build;
import android.provider.Settings;
import android.util.Log;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodManager;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.AppLocaleStore;
import com.android.internal.app.LocalePickerWithRegion;
import com.android.internal.app.LocaleStore;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;

public class AppLocaleCollector
implements LocalePickerWithRegion.LocaleCollectorBase {
    private static final String TAG = AppLocaleCollector.class.getSimpleName();
    private final Context mContext;
    private final String mAppPackageName;
    private LocaleStore.LocaleInfo mAppCurrentLocale;
    private Set<LocaleStore.LocaleInfo> mAllAppActiveLocales;
    private Set<LocaleStore.LocaleInfo> mImeLocales;
    private static final String PROP_APP_LANGUAGE_SUGGESTION = "android.app.language.suggestion.enhanced";
    private static final boolean ENABLED = true;

    public AppLocaleCollector(Context context, String appPackageName) {
        this.mContext = context;
        this.mAppPackageName = appPackageName;
    }

    @VisibleForTesting
    public LocaleStore.LocaleInfo getAppCurrentLocale() {
        return LocaleStore.getAppActivatedLocaleInfo(this.mContext, this.mAppPackageName, true);
    }

    @VisibleForTesting
    public Set<LocaleStore.LocaleInfo> getAllAppActiveLocales() {
        PackageManager pm = this.mContext.getPackageManager();
        LocaleManager lm = this.mContext.getSystemService(LocaleManager.class);
        HashSet<LocaleStore.LocaleInfo> result = new HashSet<LocaleStore.LocaleInfo>();
        if (pm != null && lm != null) {
            HashMap<String, LocaleStore.LocaleInfo> map = new HashMap<String, LocaleStore.LocaleInfo>();
            for (ApplicationInfo appInfo : pm.getInstalledApplications(PackageManager.ApplicationInfoFlags.of(0L))) {
                LocaleStore.LocaleInfo localeInfo2 = LocaleStore.getAppActivatedLocaleInfo(this.mContext, appInfo.packageName, false);
                if (localeInfo2 == null || localeInfo2.getLocale().getCountry().length() <= 0) continue;
                map.put(localeInfo2.getId(), localeInfo2);
            }
            map.forEach((language, localeInfo) -> result.add((LocaleStore.LocaleInfo)localeInfo));
        }
        return result;
    }

    @VisibleForTesting
    public Set<LocaleStore.LocaleInfo> getActiveImeLocales() {
        InputMethodInfo activeIme;
        Set<LocaleStore.LocaleInfo> activeImeLocales = null;
        InputMethodManager imm = this.mContext.getSystemService(InputMethodManager.class);
        if (imm != null && (activeIme = this.getActiveIme(imm)) != null) {
            activeImeLocales = LocaleStore.transformImeLanguageTagToLocaleInfo(imm.getEnabledInputMethodSubtypeList(activeIme, true));
        }
        if (activeImeLocales == null) {
            return Set.of();
        }
        return activeImeLocales.stream().filter(info -> info.getLocale().getCountry().length() > 0).collect(Collectors.toSet());
    }

    private InputMethodInfo getActiveIme(InputMethodManager imm) {
        InputMethodInfo activeIme = null;
        List<InputMethodInfo> infoList = imm.getEnabledInputMethodList();
        String imeId = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), "default_input_method", this.mContext.getUserId());
        if (infoList != null && imeId != null) {
            for (InputMethodInfo method : infoList) {
                if (!method.getId().equals(imeId)) continue;
                activeIme = method;
            }
        }
        return activeIme;
    }

    @VisibleForTesting
    public AppLocaleStore.AppLocaleResult getAppSupportedLocales() {
        return AppLocaleStore.getAppSupportedLocales(this.mContext, this.mAppPackageName);
    }

    @VisibleForTesting
    public Set<LocaleStore.LocaleInfo> getSystemSupportedLocale(Set<String> langTagsToIgnore, LocaleStore.LocaleInfo parent, boolean translatedOnly) {
        return LocaleStore.getLevelLocales(this.mContext, langTagsToIgnore, parent, translatedOnly);
    }

    @VisibleForTesting
    public Set<LocaleStore.LocaleInfo> getSystemCurrentLocales() {
        Set<LocaleStore.LocaleInfo> sysLocales = LocaleStore.getSystemCurrentLocales();
        return sysLocales.stream().filter(info -> info.getLocale().getCountry().length() > 0).collect(Collectors.toSet());
    }

    @Override
    public HashSet<String> getIgnoredLocaleList(boolean translatedOnly) {
        HashSet<String> langTagsToIgnore = new HashSet<String>();
        if (this.mAppCurrentLocale != null) {
            langTagsToIgnore.add(this.mAppCurrentLocale.getLocale().toLanguageTag());
        }
        if (SystemProperties.getBoolean(PROP_APP_LANGUAGE_SUGGESTION, true)) {
            this.mAllAppActiveLocales.forEach(info -> langTagsToIgnore.add(info.getLocale().toLanguageTag()));
            this.mImeLocales.forEach(info -> langTagsToIgnore.add(info.getLocale().toLanguageTag()));
        }
        LocaleList systemLangList = LocaleList.getDefault();
        for (int i = 0; i < systemLangList.size(); ++i) {
            langTagsToIgnore.add(systemLangList.get(i).toLanguageTag());
        }
        return langTagsToIgnore;
    }

    @Override
    public Set<LocaleStore.LocaleInfo> getSupportedLocaleList(LocaleStore.LocaleInfo parent, boolean translatedOnly, boolean isForCountryMode) {
        if (this.mAppCurrentLocale == null) {
            this.mAppCurrentLocale = this.getAppCurrentLocale();
        }
        if (this.mAllAppActiveLocales == null) {
            this.mAllAppActiveLocales = this.getAllAppActiveLocales();
        }
        if (this.mImeLocales == null) {
            this.mImeLocales = this.getActiveImeLocales();
        }
        AppLocaleStore.AppLocaleResult result = this.getAppSupportedLocales();
        HashSet<String> langTagsToIgnore = this.getIgnoredLocaleList(translatedOnly);
        HashSet<LocaleStore.LocaleInfo> appLocaleList = new HashSet<LocaleStore.LocaleInfo>();
        boolean shouldShowList = result.mLocaleStatus == AppLocaleStore.AppLocaleResult.LocaleStatus.GET_SUPPORTED_LANGUAGE_FROM_LOCAL_CONFIG || result.mLocaleStatus == AppLocaleStore.AppLocaleResult.LocaleStatus.GET_SUPPORTED_LANGUAGE_FROM_ASSET;
        Set<LocaleStore.LocaleInfo> systemLocaleList = isForCountryMode ? this.getSystemSupportedLocale(langTagsToIgnore, parent, translatedOnly) : this.getSystemSupportedLocale(langTagsToIgnore, null, translatedOnly);
        if (this.mAppCurrentLocale != null && !isForCountryMode) {
            appLocaleList.add(this.mAppCurrentLocale);
        }
        if (!isForCountryMode) {
            Set<LocaleStore.LocaleInfo> localeInfoSet = this.filterSupportedLocales(this.getSystemCurrentLocales(), result.mAppSupportedLocales);
            for (LocaleStore.LocaleInfo localeInfo : localeInfoSet) {
                boolean isCurrentLocale = this.mAppCurrentLocale != null && localeInfo.getLocale().equals(this.mAppCurrentLocale.getLocale());
                boolean existsInApp = this.addSystemSuggestionFlag(localeInfo, this.mAllAppActiveLocales);
                boolean existsInIme = this.addSystemSuggestionFlag(localeInfo, this.mImeLocales);
                if (isCurrentLocale || existsInApp || existsInIme) continue;
                appLocaleList.add(localeInfo);
            }
        }
        Set<LocaleStore.LocaleInfo> suggestedSet = null;
        if (shouldShowList) {
            appLocaleList.addAll(this.filterSupportedLocales(systemLocaleList, result.mAppSupportedLocales));
            suggestedSet = this.getSuggestedLocales(appLocaleList);
        }
        if (!isForCountryMode && SystemProperties.getBoolean(PROP_APP_LANGUAGE_SUGGESTION, true)) {
            Set<LocaleStore.LocaleInfo> localeSet = this.filterSupportedLocales(this.mAllAppActiveLocales, result.mAppSupportedLocales);
            if (suggestedSet != null) {
                localeSet = this.filterSameLanguageAndCountry(localeSet, suggestedSet);
                localeSet = this.addImeSuggestionFlag(localeSet);
            }
            appLocaleList.addAll(localeSet);
            suggestedSet.addAll(localeSet);
            localeSet = this.filterSupportedLocales(this.mImeLocales, result.mAppSupportedLocales);
            if (suggestedSet != null) {
                localeSet = this.filterSameLanguageAndCountry(localeSet, suggestedSet);
            }
            appLocaleList.addAll(localeSet);
            suggestedSet.addAll(localeSet);
        }
        if (!isForCountryMode && shouldShowList) {
            appLocaleList.add(LocaleStore.getSystemDefaultLocaleInfo(this.mAppCurrentLocale == null));
        }
        if (_Original_Build.isDebuggable()) {
            Log.d(TAG, "App locale list: " + appLocaleList);
        }
        return appLocaleList;
    }

    @Override
    public boolean hasSpecificPackageName() {
        return true;
    }

    private Set<LocaleStore.LocaleInfo> getSuggestedLocales(Set<LocaleStore.LocaleInfo> localeSet) {
        return localeSet.stream().filter(localeInfo -> localeInfo.isSuggested()).collect(Collectors.toSet());
    }

    private boolean addSystemSuggestionFlag(LocaleStore.LocaleInfo localeInfo, Set<LocaleStore.LocaleInfo> appLocaleSet) {
        for (LocaleStore.LocaleInfo info : appLocaleSet) {
            if (!info.getLocale().equals(localeInfo.getLocale())) continue;
            info.extendSuggestionOfType(64);
            return true;
        }
        return false;
    }

    private Set<LocaleStore.LocaleInfo> addImeSuggestionFlag(Set<LocaleStore.LocaleInfo> localeSet) {
        for (LocaleStore.LocaleInfo localeInfo : localeSet) {
            for (LocaleStore.LocaleInfo imeLocale : this.mImeLocales) {
                if (!imeLocale.getLocale().equals(localeInfo.getLocale())) continue;
                localeInfo.extendSuggestionOfType(32);
            }
        }
        return localeSet;
    }

    private Set<LocaleStore.LocaleInfo> filterSameLanguageAndCountry(Set<LocaleStore.LocaleInfo> newLocaleList, Set<LocaleStore.LocaleInfo> existingLocaleList) {
        HashSet<LocaleStore.LocaleInfo> result = new HashSet<LocaleStore.LocaleInfo>(newLocaleList.size());
        for (LocaleStore.LocaleInfo appLocaleInfo : newLocaleList) {
            boolean same = false;
            Locale appLocale = appLocaleInfo.getLocale();
            for (LocaleStore.LocaleInfo localeInfo : existingLocaleList) {
                Locale suggested = localeInfo.getLocale();
                if (!appLocale.getLanguage().equals(suggested.getLanguage()) || !appLocale.getCountry().equals(suggested.getCountry())) continue;
                same = true;
                break;
            }
            if (same) continue;
            result.add(appLocaleInfo);
        }
        return result;
    }

    private Set<LocaleStore.LocaleInfo> filterSupportedLocales(Set<LocaleStore.LocaleInfo> suggestedLocales, HashSet<Locale> appSupportedLocales) {
        HashSet<LocaleStore.LocaleInfo> filteredList = new HashSet<LocaleStore.LocaleInfo>();
        block0: for (LocaleStore.LocaleInfo li : suggestedLocales) {
            if (appSupportedLocales.contains(li.getLocale())) {
                filteredList.add(li);
                continue;
            }
            for (Locale l : appSupportedLocales) {
                if (!LocaleList.matchesLanguageAndScript(li.getLocale(), l)) continue;
                filteredList.add(li);
                continue block0;
            }
        }
        return filteredList;
    }
}

