/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.hardware.soundtrigger.SoundTrigger;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.service.voice.HotwordDetectedResult;
import android.service.voice.HotwordDetectionServiceFailure;
import android.service.voice.HotwordRejectedResult;
import android.service.voice.SoundTriggerFailure;
import android.service.voice.VisualQueryDetectionServiceFailure;

public interface IHotwordRecognitionStatusCallback
extends IInterface {
    public static final String DESCRIPTOR = "com.android.internal.app.IHotwordRecognitionStatusCallback";

    public void onKeyphraseDetected(SoundTrigger.KeyphraseRecognitionEvent var1, HotwordDetectedResult var2) throws RemoteException;

    public void onGenericSoundTriggerDetected(SoundTrigger.GenericRecognitionEvent var1) throws RemoteException;

    public void onRejected(HotwordRejectedResult var1) throws RemoteException;

    public void onHotwordDetectionServiceFailure(HotwordDetectionServiceFailure var1) throws RemoteException;

    public void onVisualQueryDetectionServiceFailure(VisualQueryDetectionServiceFailure var1) throws RemoteException;

    public void onSoundTriggerFailure(SoundTriggerFailure var1) throws RemoteException;

    public void onUnknownFailure(String var1) throws RemoteException;

    public void onRecognitionPaused() throws RemoteException;

    public void onRecognitionResumed() throws RemoteException;

    public void onStatusReported(int var1) throws RemoteException;

    public void onProcessRestarted() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IHotwordRecognitionStatusCallback {
        static final int TRANSACTION_onKeyphraseDetected = 1;
        static final int TRANSACTION_onGenericSoundTriggerDetected = 2;
        static final int TRANSACTION_onRejected = 3;
        static final int TRANSACTION_onHotwordDetectionServiceFailure = 4;
        static final int TRANSACTION_onVisualQueryDetectionServiceFailure = 5;
        static final int TRANSACTION_onSoundTriggerFailure = 6;
        static final int TRANSACTION_onUnknownFailure = 7;
        static final int TRANSACTION_onRecognitionPaused = 8;
        static final int TRANSACTION_onRecognitionResumed = 9;
        static final int TRANSACTION_onStatusReported = 10;
        static final int TRANSACTION_onProcessRestarted = 11;

        public Stub() {
            this.attachInterface(this, IHotwordRecognitionStatusCallback.DESCRIPTOR);
        }

        public static IHotwordRecognitionStatusCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IHotwordRecognitionStatusCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IHotwordRecognitionStatusCallback) {
                return (IHotwordRecognitionStatusCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onKeyphraseDetected";
                }
                case 2: {
                    return "onGenericSoundTriggerDetected";
                }
                case 3: {
                    return "onRejected";
                }
                case 4: {
                    return "onHotwordDetectionServiceFailure";
                }
                case 5: {
                    return "onVisualQueryDetectionServiceFailure";
                }
                case 6: {
                    return "onSoundTriggerFailure";
                }
                case 7: {
                    return "onUnknownFailure";
                }
                case 8: {
                    return "onRecognitionPaused";
                }
                case 9: {
                    return "onRecognitionResumed";
                }
                case 10: {
                    return "onStatusReported";
                }
                case 11: {
                    return "onProcessRestarted";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IHotwordRecognitionStatusCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    SoundTrigger.KeyphraseRecognitionEvent _arg0 = data.readTypedObject(SoundTrigger.KeyphraseRecognitionEvent.CREATOR);
                    HotwordDetectedResult _arg1 = data.readTypedObject(HotwordDetectedResult.CREATOR);
                    data.enforceNoDataAvail();
                    this.onKeyphraseDetected(_arg0, _arg1);
                    break;
                }
                case 2: {
                    SoundTrigger.GenericRecognitionEvent _arg0 = data.readTypedObject(SoundTrigger.GenericRecognitionEvent.CREATOR);
                    data.enforceNoDataAvail();
                    this.onGenericSoundTriggerDetected(_arg0);
                    break;
                }
                case 3: {
                    HotwordRejectedResult _arg0 = data.readTypedObject(HotwordRejectedResult.CREATOR);
                    data.enforceNoDataAvail();
                    this.onRejected(_arg0);
                    break;
                }
                case 4: {
                    HotwordDetectionServiceFailure _arg0 = data.readTypedObject(HotwordDetectionServiceFailure.CREATOR);
                    data.enforceNoDataAvail();
                    this.onHotwordDetectionServiceFailure(_arg0);
                    break;
                }
                case 5: {
                    VisualQueryDetectionServiceFailure _arg0 = data.readTypedObject(VisualQueryDetectionServiceFailure.CREATOR);
                    data.enforceNoDataAvail();
                    this.onVisualQueryDetectionServiceFailure(_arg0);
                    break;
                }
                case 6: {
                    SoundTriggerFailure _arg0 = data.readTypedObject(SoundTriggerFailure.CREATOR);
                    data.enforceNoDataAvail();
                    this.onSoundTriggerFailure(_arg0);
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.onUnknownFailure(_arg0);
                    break;
                }
                case 8: {
                    this.onRecognitionPaused();
                    break;
                }
                case 9: {
                    this.onRecognitionResumed();
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onStatusReported(_arg0);
                    break;
                }
                case 11: {
                    this.onProcessRestarted();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 10;
        }

        private static class Proxy
        implements IHotwordRecognitionStatusCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IHotwordRecognitionStatusCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onKeyphraseDetected(SoundTrigger.KeyphraseRecognitionEvent recognitionEvent, HotwordDetectedResult result) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IHotwordRecognitionStatusCallback.DESCRIPTOR);
                    _data.writeTypedObject(recognitionEvent, 0);
                    _data.writeTypedObject(result, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onGenericSoundTriggerDetected(SoundTrigger.GenericRecognitionEvent recognitionEvent) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IHotwordRecognitionStatusCallback.DESCRIPTOR);
                    _data.writeTypedObject(recognitionEvent, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRejected(HotwordRejectedResult result) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IHotwordRecognitionStatusCallback.DESCRIPTOR);
                    _data.writeTypedObject(result, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onHotwordDetectionServiceFailure(HotwordDetectionServiceFailure hotwordDetectionServiceFailure) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IHotwordRecognitionStatusCallback.DESCRIPTOR);
                    _data.writeTypedObject(hotwordDetectionServiceFailure, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onVisualQueryDetectionServiceFailure(VisualQueryDetectionServiceFailure visualQueryDetectionServiceFailure) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IHotwordRecognitionStatusCallback.DESCRIPTOR);
                    _data.writeTypedObject(visualQueryDetectionServiceFailure, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSoundTriggerFailure(SoundTriggerFailure soundTriggerFailure) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IHotwordRecognitionStatusCallback.DESCRIPTOR);
                    _data.writeTypedObject(soundTriggerFailure, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUnknownFailure(String errorMessage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IHotwordRecognitionStatusCallback.DESCRIPTOR);
                    _data.writeString(errorMessage);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onRecognitionPaused() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IHotwordRecognitionStatusCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onRecognitionResumed() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IHotwordRecognitionStatusCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStatusReported(int status) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IHotwordRecognitionStatusCallback.DESCRIPTOR);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onProcessRestarted() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IHotwordRecognitionStatusCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IHotwordRecognitionStatusCallback {
        @Override
        public void onKeyphraseDetected(SoundTrigger.KeyphraseRecognitionEvent recognitionEvent, HotwordDetectedResult result) throws RemoteException {
        }

        @Override
        public void onGenericSoundTriggerDetected(SoundTrigger.GenericRecognitionEvent recognitionEvent) throws RemoteException {
        }

        @Override
        public void onRejected(HotwordRejectedResult result) throws RemoteException {
        }

        @Override
        public void onHotwordDetectionServiceFailure(HotwordDetectionServiceFailure hotwordDetectionServiceFailure) throws RemoteException {
        }

        @Override
        public void onVisualQueryDetectionServiceFailure(VisualQueryDetectionServiceFailure visualQueryDetectionServiceFailure) throws RemoteException {
        }

        @Override
        public void onSoundTriggerFailure(SoundTriggerFailure soundTriggerFailure) throws RemoteException {
        }

        @Override
        public void onUnknownFailure(String errorMessage) throws RemoteException {
        }

        @Override
        public void onRecognitionPaused() throws RemoteException {
        }

        @Override
        public void onRecognitionResumed() throws RemoteException {
        }

        @Override
        public void onStatusReported(int status) throws RemoteException {
        }

        @Override
        public void onProcessRestarted() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

