/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.annotation.EnforcePermission;
import android.annotation.RequiresPermission;
import android.app.ActivityThread;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Intent;
import android.hardware.soundtrigger.KeyphraseMetadata;
import android.hardware.soundtrigger.SoundTrigger;
import android.media.AudioFormat;
import android.media.permission.Identity;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.PermissionEnforcer;
import android.os.PersistableBundle;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.SharedMemory;
import android.service.voice.IMicrophoneHotwordDetectionVoiceInteractionCallback;
import android.service.voice.IVisualQueryDetectionVoiceInteractionCallback;
import android.service.voice.IVoiceInteractionSession;
import com.android.internal.app.IHotwordRecognitionStatusCallback;
import com.android.internal.app.IVisualQueryDetectionAttentionListener;
import com.android.internal.app.IVoiceActionCheckCallback;
import com.android.internal.app.IVoiceInteractionSessionListener;
import com.android.internal.app.IVoiceInteractionSessionShowCallback;
import com.android.internal.app.IVoiceInteractionSoundTriggerSession;
import com.android.internal.app.IVoiceInteractor;
import java.util.ArrayList;
import java.util.List;

public interface IVoiceInteractionManagerService
extends IInterface {
    public void showSession(Bundle var1, int var2, String var3) throws RemoteException;

    public boolean deliverNewSession(IBinder var1, IVoiceInteractionSession var2, IVoiceInteractor var3) throws RemoteException;

    public boolean showSessionFromSession(IBinder var1, Bundle var2, int var3, String var4) throws RemoteException;

    public boolean hideSessionFromSession(IBinder var1) throws RemoteException;

    public int startVoiceActivity(IBinder var1, Intent var2, String var3, String var4) throws RemoteException;

    public int startAssistantActivity(IBinder var1, Intent var2, String var3, String var4, Bundle var5) throws RemoteException;

    public void setKeepAwake(IBinder var1, boolean var2) throws RemoteException;

    public void closeSystemDialogs(IBinder var1) throws RemoteException;

    public void finish(IBinder var1) throws RemoteException;

    public void setDisabledShowContext(int var1) throws RemoteException;

    public int getDisabledShowContext() throws RemoteException;

    public int getUserDisabledShowContext() throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/com/android/internal/app/IVoiceInteractionManagerService.aidl:74:1:74:69")
    public SoundTrigger.KeyphraseSoundModel getKeyphraseSoundModel(int var1, String var2) throws RemoteException;

    public int updateKeyphraseSoundModel(SoundTrigger.KeyphraseSoundModel var1) throws RemoteException;

    public int deleteKeyphraseSoundModel(int var1, String var2) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_VOICE_KEYPHRASES")
    @EnforcePermission(value="android.permission.MANAGE_VOICE_KEYPHRASES")
    public void setModelDatabaseForTestEnabled(boolean var1, IBinder var2) throws RemoteException;

    public boolean isEnrolledForKeyphrase(int var1, String var2) throws RemoteException;

    public KeyphraseMetadata getEnrolledKeyphraseMetadata(String var1, String var2) throws RemoteException;

    public ComponentName getActiveServiceComponentName() throws RemoteException;

    @EnforcePermission(value="android.permission.ACCESS_VOICE_INTERACTION_SERVICE")
    public boolean showSessionForActiveService(Bundle var1, int var2, String var3, IVoiceInteractionSessionShowCallback var4, IBinder var5) throws RemoteException;

    @EnforcePermission(value="android.permission.ACCESS_VOICE_INTERACTION_SERVICE")
    public void hideCurrentSession() throws RemoteException;

    @EnforcePermission(value="android.permission.ACCESS_VOICE_INTERACTION_SERVICE")
    public void launchVoiceAssistFromKeyguard() throws RemoteException;

    @EnforcePermission(value="android.permission.ACCESS_VOICE_INTERACTION_SERVICE")
    public boolean isSessionRunning() throws RemoteException;

    @EnforcePermission(value="android.permission.ACCESS_VOICE_INTERACTION_SERVICE")
    public boolean activeServiceSupportsAssist() throws RemoteException;

    @EnforcePermission(value="android.permission.ACCESS_VOICE_INTERACTION_SERVICE")
    public boolean activeServiceSupportsLaunchFromKeyguard() throws RemoteException;

    @EnforcePermission(value="android.permission.ACCESS_VOICE_INTERACTION_SERVICE")
    public void onLockscreenShown() throws RemoteException;

    @EnforcePermission(value="android.permission.ACCESS_VOICE_INTERACTION_SERVICE")
    public void registerVoiceInteractionSessionListener(IVoiceInteractionSessionListener var1) throws RemoteException;

    @EnforcePermission(value="android.permission.ACCESS_VOICE_INTERACTION_SERVICE")
    public void getActiveServiceSupportedActions(List<String> var1, IVoiceActionCheckCallback var2) throws RemoteException;

    public void setUiHints(Bundle var1) throws RemoteException;

    public void requestDirectActions(IBinder var1, int var2, IBinder var3, RemoteCallback var4, RemoteCallback var5) throws RemoteException;

    public void performDirectAction(IBinder var1, String var2, Bundle var3, int var4, IBinder var5, RemoteCallback var6, RemoteCallback var7) throws RemoteException;

    @EnforcePermission(value="android.permission.ACCESS_VOICE_INTERACTION_SERVICE")
    public void setDisabled(boolean var1) throws RemoteException;

    public IVoiceInteractionSoundTriggerSession createSoundTriggerSessionAsOriginator(Identity var1, IBinder var2, SoundTrigger.ModuleProperties var3) throws RemoteException;

    public List<SoundTrigger.ModuleProperties> listModuleProperties(Identity var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_HOTWORD_DETECTION")
    public void updateState(PersistableBundle var1, SharedMemory var2, IBinder var3) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_HOTWORD_DETECTION")
    public void initAndVerifyDetector(Identity var1, PersistableBundle var2, SharedMemory var3, IBinder var4, IHotwordRecognitionStatusCallback var5, int var6) throws RemoteException;

    public void destroyDetector(IBinder var1) throws RemoteException;

    public void shutdownHotwordDetectionService() throws RemoteException;

    @EnforcePermission(value="android.permission.ACCESS_VOICE_INTERACTION_SERVICE")
    public void enableVisualQueryDetection(IVisualQueryDetectionAttentionListener var1) throws RemoteException;

    @EnforcePermission(value="android.permission.ACCESS_VOICE_INTERACTION_SERVICE")
    public void disableVisualQueryDetection() throws RemoteException;

    public void startPerceiving(IVisualQueryDetectionVoiceInteractionCallback var1) throws RemoteException;

    public void stopPerceiving() throws RemoteException;

    public void startListeningFromMic(AudioFormat var1, IMicrophoneHotwordDetectionVoiceInteractionCallback var2) throws RemoteException;

    public void stopListeningFromMic() throws RemoteException;

    public void startListeningFromExternalSource(ParcelFileDescriptor var1, AudioFormat var2, PersistableBundle var3, IBinder var4, IMicrophoneHotwordDetectionVoiceInteractionCallback var5) throws RemoteException;

    public void triggerHardwareRecognitionEventForTest(SoundTrigger.KeyphraseRecognitionEvent var1, IHotwordRecognitionStatusCallback var2) throws RemoteException;

    public void startListeningVisibleActivityChanged(IBinder var1) throws RemoteException;

    public void stopListeningVisibleActivityChanged(IBinder var1) throws RemoteException;

    public void setSessionWindowVisible(IBinder var1, boolean var2) throws RemoteException;

    public void notifyActivityEventChanged(IBinder var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IVoiceInteractionManagerService {
        private final PermissionEnforcer mEnforcer;
        public static final String DESCRIPTOR = "com.android.internal.app.IVoiceInteractionManagerService";
        static final int TRANSACTION_showSession = 1;
        static final int TRANSACTION_deliverNewSession = 2;
        static final int TRANSACTION_showSessionFromSession = 3;
        static final int TRANSACTION_hideSessionFromSession = 4;
        static final int TRANSACTION_startVoiceActivity = 5;
        static final int TRANSACTION_startAssistantActivity = 6;
        static final int TRANSACTION_setKeepAwake = 7;
        static final int TRANSACTION_closeSystemDialogs = 8;
        static final int TRANSACTION_finish = 9;
        static final int TRANSACTION_setDisabledShowContext = 10;
        static final int TRANSACTION_getDisabledShowContext = 11;
        static final int TRANSACTION_getUserDisabledShowContext = 12;
        static final int TRANSACTION_getKeyphraseSoundModel = 13;
        static final int TRANSACTION_updateKeyphraseSoundModel = 14;
        static final int TRANSACTION_deleteKeyphraseSoundModel = 15;
        static final int TRANSACTION_setModelDatabaseForTestEnabled = 16;
        static final int TRANSACTION_isEnrolledForKeyphrase = 17;
        static final int TRANSACTION_getEnrolledKeyphraseMetadata = 18;
        static final int TRANSACTION_getActiveServiceComponentName = 19;
        static final int TRANSACTION_showSessionForActiveService = 20;
        static final int TRANSACTION_hideCurrentSession = 21;
        static final int TRANSACTION_launchVoiceAssistFromKeyguard = 22;
        static final int TRANSACTION_isSessionRunning = 23;
        static final int TRANSACTION_activeServiceSupportsAssist = 24;
        static final int TRANSACTION_activeServiceSupportsLaunchFromKeyguard = 25;
        static final int TRANSACTION_onLockscreenShown = 26;
        static final int TRANSACTION_registerVoiceInteractionSessionListener = 27;
        static final int TRANSACTION_getActiveServiceSupportedActions = 28;
        static final int TRANSACTION_setUiHints = 29;
        static final int TRANSACTION_requestDirectActions = 30;
        static final int TRANSACTION_performDirectAction = 31;
        static final int TRANSACTION_setDisabled = 32;
        static final int TRANSACTION_createSoundTriggerSessionAsOriginator = 33;
        static final int TRANSACTION_listModuleProperties = 34;
        static final int TRANSACTION_updateState = 35;
        static final int TRANSACTION_initAndVerifyDetector = 36;
        static final int TRANSACTION_destroyDetector = 37;
        static final int TRANSACTION_shutdownHotwordDetectionService = 38;
        static final int TRANSACTION_enableVisualQueryDetection = 39;
        static final int TRANSACTION_disableVisualQueryDetection = 40;
        static final int TRANSACTION_startPerceiving = 41;
        static final int TRANSACTION_stopPerceiving = 42;
        static final int TRANSACTION_startListeningFromMic = 43;
        static final int TRANSACTION_stopListeningFromMic = 44;
        static final int TRANSACTION_startListeningFromExternalSource = 45;
        static final int TRANSACTION_triggerHardwareRecognitionEventForTest = 46;
        static final int TRANSACTION_startListeningVisibleActivityChanged = 47;
        static final int TRANSACTION_stopListeningVisibleActivityChanged = 48;
        static final int TRANSACTION_setSessionWindowVisible = 49;
        static final int TRANSACTION_notifyActivityEventChanged = 50;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentActivityThread().getSystemContext()));
        }

        public static IVoiceInteractionManagerService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IVoiceInteractionManagerService) {
                return (IVoiceInteractionManagerService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "showSession";
                }
                case 2: {
                    return "deliverNewSession";
                }
                case 3: {
                    return "showSessionFromSession";
                }
                case 4: {
                    return "hideSessionFromSession";
                }
                case 5: {
                    return "startVoiceActivity";
                }
                case 6: {
                    return "startAssistantActivity";
                }
                case 7: {
                    return "setKeepAwake";
                }
                case 8: {
                    return "closeSystemDialogs";
                }
                case 9: {
                    return "finish";
                }
                case 10: {
                    return "setDisabledShowContext";
                }
                case 11: {
                    return "getDisabledShowContext";
                }
                case 12: {
                    return "getUserDisabledShowContext";
                }
                case 13: {
                    return "getKeyphraseSoundModel";
                }
                case 14: {
                    return "updateKeyphraseSoundModel";
                }
                case 15: {
                    return "deleteKeyphraseSoundModel";
                }
                case 16: {
                    return "setModelDatabaseForTestEnabled";
                }
                case 17: {
                    return "isEnrolledForKeyphrase";
                }
                case 18: {
                    return "getEnrolledKeyphraseMetadata";
                }
                case 19: {
                    return "getActiveServiceComponentName";
                }
                case 20: {
                    return "showSessionForActiveService";
                }
                case 21: {
                    return "hideCurrentSession";
                }
                case 22: {
                    return "launchVoiceAssistFromKeyguard";
                }
                case 23: {
                    return "isSessionRunning";
                }
                case 24: {
                    return "activeServiceSupportsAssist";
                }
                case 25: {
                    return "activeServiceSupportsLaunchFromKeyguard";
                }
                case 26: {
                    return "onLockscreenShown";
                }
                case 27: {
                    return "registerVoiceInteractionSessionListener";
                }
                case 28: {
                    return "getActiveServiceSupportedActions";
                }
                case 29: {
                    return "setUiHints";
                }
                case 30: {
                    return "requestDirectActions";
                }
                case 31: {
                    return "performDirectAction";
                }
                case 32: {
                    return "setDisabled";
                }
                case 33: {
                    return "createSoundTriggerSessionAsOriginator";
                }
                case 34: {
                    return "listModuleProperties";
                }
                case 35: {
                    return "updateState";
                }
                case 36: {
                    return "initAndVerifyDetector";
                }
                case 37: {
                    return "destroyDetector";
                }
                case 38: {
                    return "shutdownHotwordDetectionService";
                }
                case 39: {
                    return "enableVisualQueryDetection";
                }
                case 40: {
                    return "disableVisualQueryDetection";
                }
                case 41: {
                    return "startPerceiving";
                }
                case 42: {
                    return "stopPerceiving";
                }
                case 43: {
                    return "startListeningFromMic";
                }
                case 44: {
                    return "stopListeningFromMic";
                }
                case 45: {
                    return "startListeningFromExternalSource";
                }
                case 46: {
                    return "triggerHardwareRecognitionEventForTest";
                }
                case 47: {
                    return "startListeningVisibleActivityChanged";
                }
                case 48: {
                    return "stopListeningVisibleActivityChanged";
                }
                case 49: {
                    return "setSessionWindowVisible";
                }
                case 50: {
                    return "notifyActivityEventChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    Bundle _arg0 = data.readTypedObject(Bundle.CREATOR);
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.showSession(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    IBinder _arg0 = data.readStrongBinder();
                    IVoiceInteractionSession _arg1 = IVoiceInteractionSession.Stub.asInterface(data.readStrongBinder());
                    IVoiceInteractor _arg2 = IVoiceInteractor.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.deliverNewSession(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 3: {
                    IBinder _arg0 = data.readStrongBinder();
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.showSessionFromSession(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 4: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    boolean _result = this.hideSessionFromSession(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 5: {
                    IBinder _arg0 = data.readStrongBinder();
                    Intent _arg1 = data.readTypedObject(Intent.CREATOR);
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.startVoiceActivity(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 6: {
                    IBinder _arg0 = data.readStrongBinder();
                    Intent _arg1 = data.readTypedObject(Intent.CREATOR);
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    Bundle _arg4 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.startAssistantActivity(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 7: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setKeepAwake(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.closeSystemDialogs(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.finish(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setDisabledShowContext(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    int _result = this.getDisabledShowContext();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 12: {
                    int _result = this.getUserDisabledShowContext();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    SoundTrigger.KeyphraseSoundModel _result = this.getKeyphraseSoundModel(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 14: {
                    SoundTrigger.KeyphraseSoundModel _arg0 = data.readTypedObject(SoundTrigger.KeyphraseSoundModel.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.updateKeyphraseSoundModel(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.deleteKeyphraseSoundModel(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 16: {
                    boolean _arg0 = data.readBoolean();
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.setModelDatabaseForTestEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isEnrolledForKeyphrase(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 18: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    KeyphraseMetadata _result = this.getEnrolledKeyphraseMetadata(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 19: {
                    ComponentName _result = this.getActiveServiceComponentName();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 20: {
                    Bundle _arg0 = data.readTypedObject(Bundle.CREATOR);
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    IVoiceInteractionSessionShowCallback _arg3 = IVoiceInteractionSessionShowCallback.Stub.asInterface(data.readStrongBinder());
                    IBinder _arg4 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    boolean _result = this.showSessionForActiveService(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 21: {
                    this.hideCurrentSession();
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    this.launchVoiceAssistFromKeyguard();
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    boolean _result = this.isSessionRunning();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 24: {
                    boolean _result = this.activeServiceSupportsAssist();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 25: {
                    boolean _result = this.activeServiceSupportsLaunchFromKeyguard();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 26: {
                    this.onLockscreenShown();
                    reply.writeNoException();
                    break;
                }
                case 27: {
                    IVoiceInteractionSessionListener _arg0 = IVoiceInteractionSessionListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerVoiceInteractionSessionListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    ArrayList<String> _arg0 = data.createStringArrayList();
                    IVoiceActionCheckCallback _arg1 = IVoiceActionCheckCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getActiveServiceSupportedActions(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    Bundle _arg0 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.setUiHints(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    IBinder _arg2 = data.readStrongBinder();
                    RemoteCallback _arg3 = data.readTypedObject(RemoteCallback.CREATOR);
                    RemoteCallback _arg4 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.requestDirectActions(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 31: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    int _arg3 = data.readInt();
                    IBinder _arg4 = data.readStrongBinder();
                    RemoteCallback _arg5 = data.readTypedObject(RemoteCallback.CREATOR);
                    RemoteCallback _arg6 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.performDirectAction(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    break;
                }
                case 32: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setDisabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 33: {
                    Identity _arg0 = data.readTypedObject(Identity.CREATOR);
                    IBinder _arg1 = data.readStrongBinder();
                    SoundTrigger.ModuleProperties _arg2 = data.readTypedObject(SoundTrigger.ModuleProperties.CREATOR);
                    data.enforceNoDataAvail();
                    IVoiceInteractionSoundTriggerSession _result = this.createSoundTriggerSessionAsOriginator(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 34: {
                    Identity _arg0 = data.readTypedObject(Identity.CREATOR);
                    data.enforceNoDataAvail();
                    List<SoundTrigger.ModuleProperties> _result = this.listModuleProperties(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 35: {
                    PersistableBundle _arg0 = data.readTypedObject(PersistableBundle.CREATOR);
                    SharedMemory _arg1 = data.readTypedObject(SharedMemory.CREATOR);
                    IBinder _arg2 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.updateState(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 36: {
                    Identity _arg0 = data.readTypedObject(Identity.CREATOR);
                    PersistableBundle _arg1 = data.readTypedObject(PersistableBundle.CREATOR);
                    SharedMemory _arg2 = data.readTypedObject(SharedMemory.CREATOR);
                    IBinder _arg3 = data.readStrongBinder();
                    IHotwordRecognitionStatusCallback _arg4 = IHotwordRecognitionStatusCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg5 = data.readInt();
                    data.enforceNoDataAvail();
                    this.initAndVerifyDetector(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    break;
                }
                case 37: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.destroyDetector(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 38: {
                    this.shutdownHotwordDetectionService();
                    reply.writeNoException();
                    break;
                }
                case 39: {
                    IVisualQueryDetectionAttentionListener _arg0 = IVisualQueryDetectionAttentionListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.enableVisualQueryDetection(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 40: {
                    this.disableVisualQueryDetection();
                    reply.writeNoException();
                    break;
                }
                case 41: {
                    IVisualQueryDetectionVoiceInteractionCallback _arg0 = IVisualQueryDetectionVoiceInteractionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.startPerceiving(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 42: {
                    this.stopPerceiving();
                    reply.writeNoException();
                    break;
                }
                case 43: {
                    AudioFormat _arg0 = data.readTypedObject(AudioFormat.CREATOR);
                    IMicrophoneHotwordDetectionVoiceInteractionCallback _arg1 = IMicrophoneHotwordDetectionVoiceInteractionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.startListeningFromMic(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 44: {
                    this.stopListeningFromMic();
                    reply.writeNoException();
                    break;
                }
                case 45: {
                    ParcelFileDescriptor _arg0 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    AudioFormat _arg1 = data.readTypedObject(AudioFormat.CREATOR);
                    PersistableBundle _arg2 = data.readTypedObject(PersistableBundle.CREATOR);
                    IBinder _arg3 = data.readStrongBinder();
                    IMicrophoneHotwordDetectionVoiceInteractionCallback _arg4 = IMicrophoneHotwordDetectionVoiceInteractionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.startListeningFromExternalSource(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 46: {
                    SoundTrigger.KeyphraseRecognitionEvent _arg0 = data.readTypedObject(SoundTrigger.KeyphraseRecognitionEvent.CREATOR);
                    IHotwordRecognitionStatusCallback _arg1 = IHotwordRecognitionStatusCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.triggerHardwareRecognitionEventForTest(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 47: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.startListeningVisibleActivityChanged(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 48: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.stopListeningVisibleActivityChanged(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 49: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setSessionWindowVisible(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 50: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyActivityEventChanged(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void setModelDatabaseForTestEnabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_VOICE_KEYPHRASES", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void showSessionForActiveService_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.ACCESS_VOICE_INTERACTION_SERVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void hideCurrentSession_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.ACCESS_VOICE_INTERACTION_SERVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void launchVoiceAssistFromKeyguard_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.ACCESS_VOICE_INTERACTION_SERVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isSessionRunning_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.ACCESS_VOICE_INTERACTION_SERVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void activeServiceSupportsAssist_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.ACCESS_VOICE_INTERACTION_SERVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void activeServiceSupportsLaunchFromKeyguard_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.ACCESS_VOICE_INTERACTION_SERVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void onLockscreenShown_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.ACCESS_VOICE_INTERACTION_SERVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void registerVoiceInteractionSessionListener_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.ACCESS_VOICE_INTERACTION_SERVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getActiveServiceSupportedActions_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.ACCESS_VOICE_INTERACTION_SERVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setDisabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.ACCESS_VOICE_INTERACTION_SERVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void updateState_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_HOTWORD_DETECTION", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void initAndVerifyDetector_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_HOTWORD_DETECTION", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void enableVisualQueryDetection_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.ACCESS_VOICE_INTERACTION_SERVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void disableVisualQueryDetection_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.ACCESS_VOICE_INTERACTION_SERVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 49;
        }

        private static class Proxy
        implements IVoiceInteractionManagerService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showSession(Bundle sessionArgs, int flags, String attributionTag) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(sessionArgs, 0);
                    _data.writeInt(flags);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean deliverNewSession(IBinder token, IVoiceInteractionSession session, IVoiceInteractor interactor) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeStrongInterface(session);
                    _data.writeStrongInterface(interactor);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean showSessionFromSession(IBinder token, Bundle sessionArgs, int flags, String attributionTag) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(sessionArgs, 0);
                    _data.writeInt(flags);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hideSessionFromSession(IBinder token) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int startVoiceActivity(IBinder token, Intent intent, String resolvedType, String attributionTag) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(intent, 0);
                    _data.writeString(resolvedType);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int startAssistantActivity(IBinder token, Intent intent, String resolvedType, String attributionTag, Bundle bundle) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(intent, 0);
                    _data.writeString(resolvedType);
                    _data.writeString(attributionTag);
                    _data.writeTypedObject(bundle, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setKeepAwake(IBinder token, boolean keepAwake) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeBoolean(keepAwake);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void closeSystemDialogs(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finish(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDisabledShowContext(int flags) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDisabledShowContext() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getUserDisabledShowContext() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SoundTrigger.KeyphraseSoundModel getKeyphraseSoundModel(int keyphraseId, String bcp47Locale) throws RemoteException {
                SoundTrigger.KeyphraseSoundModel _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(keyphraseId);
                    _data.writeString(bcp47Locale);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SoundTrigger.KeyphraseSoundModel.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int updateKeyphraseSoundModel(SoundTrigger.KeyphraseSoundModel model) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(model, 0);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int deleteKeyphraseSoundModel(int keyphraseId, String bcp47Locale) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(keyphraseId);
                    _data.writeString(bcp47Locale);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setModelDatabaseForTestEnabled(boolean enabled, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isEnrolledForKeyphrase(int keyphraseId, String bcp47Locale) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(keyphraseId);
                    _data.writeString(bcp47Locale);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public KeyphraseMetadata getEnrolledKeyphraseMetadata(String keyphrase, String bcp47Locale) throws RemoteException {
                KeyphraseMetadata _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(keyphrase);
                    _data.writeString(bcp47Locale);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(KeyphraseMetadata.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ComponentName getActiveServiceComponentName() throws RemoteException {
                ComponentName _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ComponentName.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean showSessionForActiveService(Bundle args, int sourceFlags, String attributionTag, IVoiceInteractionSessionShowCallback showCallback, IBinder activityToken) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(args, 0);
                    _data.writeInt(sourceFlags);
                    _data.writeString(attributionTag);
                    _data.writeStrongInterface(showCallback);
                    _data.writeStrongBinder(activityToken);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hideCurrentSession() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void launchVoiceAssistFromKeyguard() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSessionRunning() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean activeServiceSupportsAssist() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean activeServiceSupportsLaunchFromKeyguard() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLockscreenShown() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerVoiceInteractionSessionListener(IVoiceInteractionSessionListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getActiveServiceSupportedActions(List<String> voiceActions, IVoiceActionCheckCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringList(voiceActions);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUiHints(Bundle hints) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(hints, 0);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestDirectActions(IBinder token, int taskId, IBinder assistToken, RemoteCallback cancellationCallback, RemoteCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(taskId);
                    _data.writeStrongBinder(assistToken);
                    _data.writeTypedObject(cancellationCallback, 0);
                    _data.writeTypedObject(callback, 0);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void performDirectAction(IBinder token, String actionId, Bundle arguments, int taskId, IBinder assistToken, RemoteCallback cancellationCallback, RemoteCallback resultCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeString(actionId);
                    _data.writeTypedObject(arguments, 0);
                    _data.writeInt(taskId);
                    _data.writeStrongBinder(assistToken);
                    _data.writeTypedObject(cancellationCallback, 0);
                    _data.writeTypedObject(resultCallback, 0);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDisabled(boolean disabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(disabled);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IVoiceInteractionSoundTriggerSession createSoundTriggerSessionAsOriginator(Identity originatorIdentity, IBinder client, SoundTrigger.ModuleProperties moduleProperties) throws RemoteException {
                IVoiceInteractionSoundTriggerSession _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(originatorIdentity, 0);
                    _data.writeStrongBinder(client);
                    _data.writeTypedObject(moduleProperties, 0);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                    _result = IVoiceInteractionSoundTriggerSession.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SoundTrigger.ModuleProperties> listModuleProperties(Identity originatorIdentity) throws RemoteException {
                ArrayList<SoundTrigger.ModuleProperties> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(originatorIdentity, 0);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(SoundTrigger.ModuleProperties.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateState(PersistableBundle options, SharedMemory sharedMemory, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(options, 0);
                    _data.writeTypedObject(sharedMemory, 0);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void initAndVerifyDetector(Identity originatorIdentity, PersistableBundle options, SharedMemory sharedMemory, IBinder token, IHotwordRecognitionStatusCallback callback, int detectorType) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(originatorIdentity, 0);
                    _data.writeTypedObject(options, 0);
                    _data.writeTypedObject(sharedMemory, 0);
                    _data.writeStrongBinder(token);
                    _data.writeStrongInterface(callback);
                    _data.writeInt(detectorType);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void destroyDetector(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void shutdownHotwordDetectionService() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableVisualQueryDetection(IVisualQueryDetectionAttentionListener Listener2) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(Listener2);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableVisualQueryDetection() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startPerceiving(IVisualQueryDetectionVoiceInteractionCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopPerceiving() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startListeningFromMic(AudioFormat audioFormat, IMicrophoneHotwordDetectionVoiceInteractionCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(audioFormat, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopListeningFromMic() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startListeningFromExternalSource(ParcelFileDescriptor audioStream, AudioFormat audioFormat, PersistableBundle options, IBinder token, IMicrophoneHotwordDetectionVoiceInteractionCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(audioStream, 0);
                    _data.writeTypedObject(audioFormat, 0);
                    _data.writeTypedObject(options, 0);
                    _data.writeStrongBinder(token);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void triggerHardwareRecognitionEventForTest(SoundTrigger.KeyphraseRecognitionEvent event, IHotwordRecognitionStatusCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(event, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startListeningVisibleActivityChanged(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopListeningVisibleActivityChanged(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSessionWindowVisible(IBinder token, boolean visible) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeBoolean(visible);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyActivityEventChanged(IBinder activityToken, int type) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(activityToken);
                    _data.writeInt(type);
                    boolean bl = this.mRemote.transact(50, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IVoiceInteractionManagerService {
        @Override
        public void showSession(Bundle sessionArgs, int flags, String attributionTag) throws RemoteException {
        }

        @Override
        public boolean deliverNewSession(IBinder token, IVoiceInteractionSession session, IVoiceInteractor interactor) throws RemoteException {
            return false;
        }

        @Override
        public boolean showSessionFromSession(IBinder token, Bundle sessionArgs, int flags, String attributionTag) throws RemoteException {
            return false;
        }

        @Override
        public boolean hideSessionFromSession(IBinder token) throws RemoteException {
            return false;
        }

        @Override
        public int startVoiceActivity(IBinder token, Intent intent, String resolvedType, String attributionTag) throws RemoteException {
            return 0;
        }

        @Override
        public int startAssistantActivity(IBinder token, Intent intent, String resolvedType, String attributionTag, Bundle bundle) throws RemoteException {
            return 0;
        }

        @Override
        public void setKeepAwake(IBinder token, boolean keepAwake) throws RemoteException {
        }

        @Override
        public void closeSystemDialogs(IBinder token) throws RemoteException {
        }

        @Override
        public void finish(IBinder token) throws RemoteException {
        }

        @Override
        public void setDisabledShowContext(int flags) throws RemoteException {
        }

        @Override
        public int getDisabledShowContext() throws RemoteException {
            return 0;
        }

        @Override
        public int getUserDisabledShowContext() throws RemoteException {
            return 0;
        }

        @Override
        public SoundTrigger.KeyphraseSoundModel getKeyphraseSoundModel(int keyphraseId, String bcp47Locale) throws RemoteException {
            return null;
        }

        @Override
        public int updateKeyphraseSoundModel(SoundTrigger.KeyphraseSoundModel model) throws RemoteException {
            return 0;
        }

        @Override
        public int deleteKeyphraseSoundModel(int keyphraseId, String bcp47Locale) throws RemoteException {
            return 0;
        }

        @Override
        public void setModelDatabaseForTestEnabled(boolean enabled, IBinder token) throws RemoteException {
        }

        @Override
        public boolean isEnrolledForKeyphrase(int keyphraseId, String bcp47Locale) throws RemoteException {
            return false;
        }

        @Override
        public KeyphraseMetadata getEnrolledKeyphraseMetadata(String keyphrase, String bcp47Locale) throws RemoteException {
            return null;
        }

        @Override
        public ComponentName getActiveServiceComponentName() throws RemoteException {
            return null;
        }

        @Override
        public boolean showSessionForActiveService(Bundle args, int sourceFlags, String attributionTag, IVoiceInteractionSessionShowCallback showCallback, IBinder activityToken) throws RemoteException {
            return false;
        }

        @Override
        public void hideCurrentSession() throws RemoteException {
        }

        @Override
        public void launchVoiceAssistFromKeyguard() throws RemoteException {
        }

        @Override
        public boolean isSessionRunning() throws RemoteException {
            return false;
        }

        @Override
        public boolean activeServiceSupportsAssist() throws RemoteException {
            return false;
        }

        @Override
        public boolean activeServiceSupportsLaunchFromKeyguard() throws RemoteException {
            return false;
        }

        @Override
        public void onLockscreenShown() throws RemoteException {
        }

        @Override
        public void registerVoiceInteractionSessionListener(IVoiceInteractionSessionListener listener) throws RemoteException {
        }

        @Override
        public void getActiveServiceSupportedActions(List<String> voiceActions, IVoiceActionCheckCallback callback) throws RemoteException {
        }

        @Override
        public void setUiHints(Bundle hints) throws RemoteException {
        }

        @Override
        public void requestDirectActions(IBinder token, int taskId, IBinder assistToken, RemoteCallback cancellationCallback, RemoteCallback callback) throws RemoteException {
        }

        @Override
        public void performDirectAction(IBinder token, String actionId, Bundle arguments, int taskId, IBinder assistToken, RemoteCallback cancellationCallback, RemoteCallback resultCallback) throws RemoteException {
        }

        @Override
        public void setDisabled(boolean disabled) throws RemoteException {
        }

        @Override
        public IVoiceInteractionSoundTriggerSession createSoundTriggerSessionAsOriginator(Identity originatorIdentity, IBinder client, SoundTrigger.ModuleProperties moduleProperties) throws RemoteException {
            return null;
        }

        @Override
        public List<SoundTrigger.ModuleProperties> listModuleProperties(Identity originatorIdentity) throws RemoteException {
            return null;
        }

        @Override
        public void updateState(PersistableBundle options, SharedMemory sharedMemory, IBinder token) throws RemoteException {
        }

        @Override
        public void initAndVerifyDetector(Identity originatorIdentity, PersistableBundle options, SharedMemory sharedMemory, IBinder token, IHotwordRecognitionStatusCallback callback, int detectorType) throws RemoteException {
        }

        @Override
        public void destroyDetector(IBinder token) throws RemoteException {
        }

        @Override
        public void shutdownHotwordDetectionService() throws RemoteException {
        }

        @Override
        public void enableVisualQueryDetection(IVisualQueryDetectionAttentionListener Listener2) throws RemoteException {
        }

        @Override
        public void disableVisualQueryDetection() throws RemoteException {
        }

        @Override
        public void startPerceiving(IVisualQueryDetectionVoiceInteractionCallback callback) throws RemoteException {
        }

        @Override
        public void stopPerceiving() throws RemoteException {
        }

        @Override
        public void startListeningFromMic(AudioFormat audioFormat, IMicrophoneHotwordDetectionVoiceInteractionCallback callback) throws RemoteException {
        }

        @Override
        public void stopListeningFromMic() throws RemoteException {
        }

        @Override
        public void startListeningFromExternalSource(ParcelFileDescriptor audioStream, AudioFormat audioFormat, PersistableBundle options, IBinder token, IMicrophoneHotwordDetectionVoiceInteractionCallback callback) throws RemoteException {
        }

        @Override
        public void triggerHardwareRecognitionEventForTest(SoundTrigger.KeyphraseRecognitionEvent event, IHotwordRecognitionStatusCallback callback) throws RemoteException {
        }

        @Override
        public void startListeningVisibleActivityChanged(IBinder token) throws RemoteException {
        }

        @Override
        public void stopListeningVisibleActivityChanged(IBinder token) throws RemoteException {
        }

        @Override
        public void setSessionWindowVisible(IBinder token, boolean visible) throws RemoteException {
        }

        @Override
        public void notifyActivityEventChanged(IBinder activityToken, int type) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

