/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.Activity;
import android.app.ActivityOptions;
import android.app.ActivityThread;
import android.app.AppGlobals;
import android.app.admin.DevicePolicyManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.graphics.drawable.Drawable;
import android.metrics.LogMaker;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.telecom.TelecomManager;
import android.util.Log;
import android.util.Slog;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.ChooserActivity;
import com.android.internal.app.ResolverActivity;
import com.android.internal.logging.MetricsLogger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class IntentForwarderActivity
extends Activity {
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static String TAG = "IntentForwarderActivity";
    public static String FORWARD_INTENT_TO_PARENT = "com.android.internal.app.ForwardIntentToParent";
    public static String FORWARD_INTENT_TO_MANAGED_PROFILE = "com.android.internal.app.ForwardIntentToManagedProfile";
    public static final String EXTRA_SKIP_USER_CONFIRMATION = "com.android.internal.app.EXTRA_SKIP_USER_CONFIRMATION";
    private static final Set<String> ALLOWED_TEXT_MESSAGE_SCHEMES = new HashSet<String>(Arrays.asList("sms", "smsto", "mms", "mmsto"));
    private static final String TEL_SCHEME = "tel";
    private static final ComponentName RESOLVER_COMPONENT_NAME = new ComponentName("android", ResolverActivity.class.getName());
    private Injector mInjector;
    private MetricsLogger mMetricsLogger;
    protected ExecutorService mExecutorService;

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.mExecutorService.shutdown();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        UserInfo managedProfile;
        int targetUserId;
        String userMessage;
        super.onCreate(savedInstanceState);
        this.mInjector = this.createInjector();
        this.mExecutorService = Executors.newSingleThreadExecutor();
        Intent intentReceived = this.getIntent();
        String className = intentReceived.getComponent().getClassName();
        if (className.equals(FORWARD_INTENT_TO_PARENT)) {
            userMessage = this.getForwardToPersonalMessage();
            targetUserId = this.getProfileParent();
            managedProfile = null;
            this.getMetricsLogger().write(new LogMaker(1661).setSubtype(1));
        } else if (className.equals(FORWARD_INTENT_TO_MANAGED_PROFILE)) {
            userMessage = this.getForwardToWorkMessage();
            managedProfile = this.getManagedProfile();
            targetUserId = managedProfile == null ? -10000 : managedProfile.id;
            this.getMetricsLogger().write(new LogMaker(1661).setSubtype(2));
        } else {
            Slog.wtf(TAG, IntentForwarderActivity.class.getName() + " cannot be called directly");
            userMessage = null;
            targetUserId = -10000;
            managedProfile = null;
        }
        if (targetUserId == -10000) {
            this.finish();
            return;
        }
        if ("android.intent.action.CHOOSER".equals(intentReceived.getAction())) {
            this.launchChooserActivityWithCorrectTab(intentReceived, className);
            return;
        }
        int callingUserId = this.getUserId();
        Intent newIntent = IntentForwarderActivity.canForward(intentReceived, this.getUserId(), targetUserId, this.mInjector.getIPackageManager(), this.getContentResolver());
        if (newIntent == null) {
            Slog.wtf(TAG, "the intent: " + intentReceived + " cannot be forwarded from user " + callingUserId + " to user " + targetUserId);
            this.finish();
            return;
        }
        newIntent.prepareToLeaveUser(callingUserId);
        CompletableFuture<ResolveInfo> targetResolveInfoFuture = this.mInjector.resolveActivityAsUser(newIntent, 65536, targetUserId);
        ((CompletableFuture)targetResolveInfoFuture.thenApplyAsync(targetResolveInfo -> {
            if (this.isResolverActivityResolveInfo((ResolveInfo)targetResolveInfo)) {
                this.launchResolverActivityWithCorrectTab(intentReceived, className, newIntent, callingUserId, targetUserId);
            } else if (className.equals(FORWARD_INTENT_TO_PARENT)) {
                this.startActivityAsCaller(newIntent, targetUserId);
            }
            return targetResolveInfo;
        }, (Executor)this.mExecutorService)).thenAcceptAsync(result -> {
            if (className.equals(FORWARD_INTENT_TO_PARENT)) {
                this.maybeShowDisclosure(intentReceived, (ResolveInfo)result, userMessage);
                this.finish();
            } else if (className.equals(FORWARD_INTENT_TO_MANAGED_PROFILE)) {
                this.maybeShowUserConsentMiniResolver((ResolveInfo)result, newIntent, managedProfile);
            }
        }, this.getApplicationContext().getMainExecutor());
    }

    private void maybeShowUserConsentMiniResolver(ResolveInfo target, Intent launchIntent, UserInfo managedProfile) {
        boolean intentToLaunchProfileOwner;
        if (target == null || this.isIntentForwarderResolveInfo(target) || !this.isDeviceProvisioned()) {
            this.finish();
            return;
        }
        int targetUserId = managedProfile == null ? -10000 : managedProfile.id;
        String callingPackage = this.getCallingPackage();
        boolean privilegedCallerAskedToSkipUserConsent = launchIntent.getBooleanExtra(EXTRA_SKIP_USER_CONFIRMATION, false) && callingPackage != null && 0 == this.getPackageManager().checkPermission("android.permission.INTERACT_ACROSS_USERS", callingPackage);
        DevicePolicyManager devicePolicyManager = this.getSystemService(DevicePolicyManager.class);
        ComponentName profileOwnerName = devicePolicyManager.getProfileOwnerAsUser(targetUserId);
        boolean bl = intentToLaunchProfileOwner = profileOwnerName != null && profileOwnerName.getPackageName().equals(target.getComponentInfo().packageName);
        if (privilegedCallerAskedToSkipUserConsent || intentToLaunchProfileOwner) {
            Log.i("IntentForwarderActivity", String.format("Skipping user consent for redirection into the managed profile for intent [%s], privilegedCallerAskedToSkipUserConsent=[%s], intentToLaunchProfileOwner=[%s]", launchIntent, privilegedCallerAskedToSkipUserConsent, intentToLaunchProfileOwner));
            this.startActivityAsCaller(launchIntent, targetUserId);
            this.finish();
            return;
        }
        Log.i("IntentForwarderActivity", String.format("Showing user consent for redirection into the managed profile for intent [%s] and  calling package [%s]", launchIntent, callingPackage));
        int layoutId = 17367212;
        this.setContentView(layoutId);
        ((View)this.findViewById(16909643)).setElevation(0.0f);
        PackageManager packageManagerForTargetUser = this.createContextAsUser(UserHandle.of(targetUserId), 0).getPackageManager();
        ImageView icon = (ImageView)this.findViewById(16908294);
        icon.setImageDrawable(this.getAppIcon(target, launchIntent, targetUserId, packageManagerForTargetUser));
        Object buttonContainer = this.findViewById(16908848);
        ((View)buttonContainer).setPadding(0, 0, 0, ((View)buttonContainer).getPaddingBottom());
        ((TextView)this.findViewById(16909328)).setText(this.getOpenInWorkMessage(launchIntent, target.loadLabel(packageManagerForTargetUser)));
        ((Button)this.findViewById(16909707)).setText(0x1040000);
        ((View)this.findViewById(16909707)).setOnClickListener(v -> this.finish());
        ((Button)this.findViewById(16908850)).setText(this.getOpenInWorkButtonString(launchIntent));
        ((View)this.findViewById(16908850)).setOnClickListener(v -> {
            this.startActivityAsCaller(launchIntent, ActivityOptions.makeCustomAnimation(this.getApplicationContext(), 17432591, 17432691).toBundle(), false, targetUserId);
            this.finish();
        });
        Object telephonyInfo = this.findViewById(16909247);
        if ((this.isDialerIntent(launchIntent) || this.isTextMessageIntent(launchIntent)) && devicePolicyManager.getManagedSubscriptionsPolicy().getPolicyType() == 1) {
            ((View)telephonyInfo).setVisibility(0);
            ((TextView)this.findViewById(16909249)).setText(this.getWorkTelephonyInfoSectionMessage(launchIntent));
        } else {
            ((View)telephonyInfo).setVisibility(8);
        }
    }

    private Drawable getAppIcon(ResolveInfo target, Intent launchIntent, int targetUserId, PackageManager packageManagerForTargetUser) {
        if (this.isDialerIntent(launchIntent)) {
            TelecomManager telecomManager = this.getApplicationContext().getSystemService(TelecomManager.class);
            String defaultDialerPackageName = telecomManager.getDefaultDialerPackage(UserHandle.of(targetUserId));
            try {
                return packageManagerForTargetUser.getApplicationInfo(defaultDialerPackageName, 0).loadIcon(packageManagerForTargetUser);
            }
            catch (PackageManager.NameNotFoundException e) {
                Slog.w(TAG, "Cannot load icon for default dialer package");
            }
        }
        return target.loadIcon(packageManagerForTargetUser);
    }

    private int getOpenInWorkButtonString(Intent launchIntent) {
        if (this.isDialerIntent(launchIntent)) {
            return 17040806;
        }
        if (this.isTextMessageIntent(launchIntent)) {
            return 17040813;
        }
        return 17041811;
    }

    private String getOpenInWorkMessage(Intent launchIntent, CharSequence targetLabel) {
        if (this.isDialerIntent(launchIntent)) {
            return this.getSystemService(DevicePolicyManager.class).getResources().getString("Core.MINIRESOLVER_CALL_FROM_WORK", () -> this.getString(17040807));
        }
        if (this.isTextMessageIntent(launchIntent)) {
            return this.getSystemService(DevicePolicyManager.class).getResources().getString("Core.MINIRESOLVER_SWITCH_TO_WORK", () -> this.getString(17040814));
        }
        return this.getSystemService(DevicePolicyManager.class).getResources().getString("Core.MINIRESOLVER_OPEN_WORK", () -> this.getString(17040811, targetLabel), targetLabel);
    }

    private String getWorkTelephonyInfoSectionMessage(Intent launchIntent) {
        if (this.isDialerIntent(launchIntent)) {
            return this.getSystemService(DevicePolicyManager.class).getResources().getString("Core.MINIRESOLVER_WORK_TELEPHONY_INFORMATION", () -> this.getString(17040808));
        }
        if (this.isTextMessageIntent(launchIntent)) {
            return this.getSystemService(DevicePolicyManager.class).getResources().getString("Core.MINIRESOLVER_WORK_TELEPHONY_INFORMATION", () -> this.getString(17040812));
        }
        return "";
    }

    private String getForwardToPersonalMessage() {
        return this.getSystemService(DevicePolicyManager.class).getResources().getString("Core.FORWARD_INTENT_TO_PERSONAL", () -> this.getString(17040380));
    }

    private String getForwardToWorkMessage() {
        return this.getSystemService(DevicePolicyManager.class).getResources().getString("Core.FORWARD_INTENT_TO_WORK", () -> this.getString(17040381));
    }

    private boolean isIntentForwarderResolveInfo(ResolveInfo resolveInfo) {
        if (resolveInfo == null) {
            return false;
        }
        ActivityInfo activityInfo = resolveInfo.activityInfo;
        if (activityInfo == null) {
            return false;
        }
        if (!"android".equals(activityInfo.packageName)) {
            return false;
        }
        return activityInfo.name.equals(FORWARD_INTENT_TO_PARENT) || activityInfo.name.equals(FORWARD_INTENT_TO_MANAGED_PROFILE);
    }

    private boolean isResolverActivityResolveInfo(ResolveInfo resolveInfo) {
        return resolveInfo != null && resolveInfo.activityInfo != null && RESOLVER_COMPONENT_NAME.equals(resolveInfo.activityInfo.getComponentName());
    }

    private void maybeShowDisclosure(Intent intentReceived, ResolveInfo resolveInfo, String message) {
        if (this.shouldShowDisclosure(resolveInfo, intentReceived) && message != null) {
            this.mInjector.showToast(message, 1);
        }
    }

    private void startActivityAsCaller(Intent newIntent, int userId) {
        try {
            this.startActivityAsCaller(newIntent, null, false, userId);
        }
        catch (RuntimeException e) {
            Slog.wtf(TAG, "Unable to launch as UID " + this.getLaunchedFromUid() + " package " + this.getLaunchedFromPackage() + ", while running in " + ActivityThread.currentProcessName(), e);
        }
    }

    private void launchChooserActivityWithCorrectTab(Intent intentReceived, String className) {
        int selectedProfile = this.findSelectedProfile(className);
        IntentForwarderActivity.sanitizeIntent(intentReceived);
        intentReceived.putExtra("com.android.internal.app.ResolverActivity.EXTRA_SELECTED_PROFILE", selectedProfile);
        Intent innerIntent = intentReceived.getParcelableExtra("android.intent.extra.INTENT", Intent.class);
        if (innerIntent == null) {
            Slog.wtf(TAG, "Cannot start a chooser intent with no extra android.intent.extra.INTENT");
            return;
        }
        IntentForwarderActivity.sanitizeIntent(innerIntent);
        this.startActivityAsCaller(intentReceived, null, false, this.getUserId());
        this.finish();
    }

    private void launchResolverActivityWithCorrectTab(Intent intentReceived, String className, Intent newIntent, int callingUserId, int targetUserId) {
        ResolveInfo callingResolveInfo = this.mInjector.resolveActivityAsUser(newIntent, 65536, callingUserId).join();
        int userId = this.isIntentForwarderResolveInfo(callingResolveInfo) ? targetUserId : callingUserId;
        int selectedProfile = this.findSelectedProfile(className);
        IntentForwarderActivity.sanitizeIntent(intentReceived);
        intentReceived.putExtra("com.android.internal.app.ResolverActivity.EXTRA_SELECTED_PROFILE", selectedProfile);
        intentReceived.putExtra("com.android.internal.app.ResolverActivity.EXTRA_CALLING_USER", UserHandle.of(callingUserId));
        this.startActivityAsCaller(intentReceived, null, false, userId);
        this.finish();
    }

    private int findSelectedProfile(String className) {
        if (className.equals(FORWARD_INTENT_TO_PARENT)) {
            return 0;
        }
        if (className.equals(FORWARD_INTENT_TO_MANAGED_PROFILE)) {
            return 1;
        }
        return -1;
    }

    private boolean shouldShowDisclosure(ResolveInfo ri, Intent intent) {
        if (!this.isDeviceProvisioned()) {
            return false;
        }
        if (ri == null || ri.activityInfo == null) {
            return true;
        }
        if (ri.activityInfo.applicationInfo.isSystemApp() && (this.isDialerIntent(intent) || this.isTextMessageIntent(intent))) {
            return false;
        }
        return !this.isTargetResolverOrChooserActivity(ri.activityInfo);
    }

    private boolean isDeviceProvisioned() {
        return Settings.Global.getInt(this.getContentResolver(), "device_provisioned", 0) != 0;
    }

    private boolean isTextMessageIntent(Intent intent) {
        return ("android.intent.action.SENDTO".equals(intent.getAction()) || this.isViewActionIntent(intent)) && ALLOWED_TEXT_MESSAGE_SCHEMES.contains(intent.getScheme());
    }

    private boolean isDialerIntent(Intent intent) {
        return "android.intent.action.DIAL".equals(intent.getAction()) || "android.intent.action.CALL".equals(intent.getAction()) || "android.intent.action.CALL_PRIVILEGED".equals(intent.getAction()) || "android.intent.action.CALL_EMERGENCY".equals(intent.getAction()) || this.isViewActionIntent(intent) && TEL_SCHEME.equals(intent.getScheme());
    }

    private boolean isViewActionIntent(Intent intent) {
        return "android.intent.action.VIEW".equals(intent.getAction()) && intent.hasCategory("android.intent.category.BROWSABLE");
    }

    private boolean isTargetResolverOrChooserActivity(ActivityInfo activityInfo) {
        if (!"android".equals(activityInfo.packageName)) {
            return false;
        }
        return ResolverActivity.class.getName().equals(activityInfo.name) || ChooserActivity.class.getName().equals(activityInfo.name);
    }

    static Intent canForward(Intent incomingIntent, int sourceUserId, int targetUserId, IPackageManager packageManager, ContentResolver contentResolver) {
        Intent forwardIntent = new Intent(incomingIntent);
        forwardIntent.addFlags(0x3000000);
        IntentForwarderActivity.sanitizeIntent(forwardIntent);
        Intent intentToCheck = forwardIntent;
        if ("android.intent.action.CHOOSER".equals(forwardIntent.getAction())) {
            return null;
        }
        if (forwardIntent.getSelector() != null) {
            intentToCheck = forwardIntent.getSelector();
        }
        String resolvedType = intentToCheck.resolveTypeIfNeeded(contentResolver);
        IntentForwarderActivity.sanitizeIntent(intentToCheck);
        try {
            if (packageManager.canForwardTo(intentToCheck, resolvedType, sourceUserId, targetUserId)) {
                return forwardIntent;
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "PackageManagerService is dead?");
        }
        return null;
    }

    private UserInfo getManagedProfile() {
        List<UserInfo> relatedUsers = this.mInjector.getUserManager().getProfiles(UserHandle.myUserId());
        for (UserInfo userInfo : relatedUsers) {
            if (!userInfo.isManagedProfile()) continue;
            return userInfo;
        }
        Slog.wtf(TAG, FORWARD_INTENT_TO_MANAGED_PROFILE + " has been called, but there is no managed profile");
        return null;
    }

    private int getProfileParent() {
        UserInfo parent = this.mInjector.getUserManager().getProfileParent(UserHandle.myUserId());
        if (parent == null) {
            Slog.wtf(TAG, FORWARD_INTENT_TO_PARENT + " has been called, but there is no parent");
            return -10000;
        }
        return parent.id;
    }

    private static void sanitizeIntent(Intent intent) {
        intent.setPackage(null);
        intent.setComponent(null);
    }

    protected MetricsLogger getMetricsLogger() {
        if (this.mMetricsLogger == null) {
            this.mMetricsLogger = new MetricsLogger();
        }
        return this.mMetricsLogger;
    }

    @VisibleForTesting
    protected Injector createInjector() {
        return new InjectorImpl();
    }

    public static interface Injector {
        public IPackageManager getIPackageManager();

        public UserManager getUserManager();

        public PackageManager getPackageManager();

        public CompletableFuture<ResolveInfo> resolveActivityAsUser(Intent var1, int var2, int var3);

        public void showToast(String var1, int var2);
    }

    private class InjectorImpl
    implements Injector {
        private InjectorImpl() {
        }

        @Override
        public IPackageManager getIPackageManager() {
            return AppGlobals.getPackageManager();
        }

        @Override
        public UserManager getUserManager() {
            return IntentForwarderActivity.this.getSystemService(UserManager.class);
        }

        @Override
        public PackageManager getPackageManager() {
            return IntentForwarderActivity.this.getPackageManager();
        }

        @Override
        public CompletableFuture<ResolveInfo> resolveActivityAsUser(Intent intent, int flags, int userId) {
            return CompletableFuture.supplyAsync(() -> this.getPackageManager().resolveActivityAsUser(intent, flags, userId));
        }

        @Override
        public void showToast(String message, int duration) {
            Toast.makeText((Context)IntentForwarderActivity.this, message, duration).show();
        }
    }
}

