/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.LocaleManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.os.LocaleList;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.inputmethod.InputMethodSubtype;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.LocaleHelper;
import com.android.internal.app.LocalePicker;
import com.android.layoutlib.bridge.android.AndroidLocale;
import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IllformedLocaleException;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class LocaleStore {
    private static final int TIER_LANGUAGE = 1;
    private static final int TIER_REGION = 2;
    private static final int TIER_NUMBERING = 3;
    private static final HashMap<String, LocaleInfo> sLocaleCache = new HashMap();
    private static final String TAG = LocaleStore.class.getSimpleName();
    private static boolean sFullyInitialized = false;

    private static Set<String> getSimCountries(Context context) {
        HashSet<String> result = new HashSet<String>();
        TelephonyManager tm = context.getSystemService(TelephonyManager.class);
        if (tm != null) {
            String iso = tm.getSimCountryIso().toUpperCase(Locale.US);
            if (!iso.isEmpty()) {
                result.add(iso);
            }
            if (!(iso = tm.getNetworkCountryIso().toUpperCase(Locale.US)).isEmpty()) {
                result.add(iso);
            }
        }
        return result;
    }

    public static void updateSimCountries(Context context) {
        Set<String> simCountries = LocaleStore.getSimCountries(context);
        for (LocaleInfo li : sLocaleCache.values()) {
            if (!simCountries.contains(li.getLocale().getCountry())) continue;
            li.mSuggestionFlags |= 1;
        }
    }

    public static LocaleInfo getAppActivatedLocaleInfo(Context context, String appPackageName, boolean isAppSelected) {
        if (appPackageName == null) {
            return null;
        }
        LocaleManager localeManager = context.getSystemService(LocaleManager.class);
        try {
            Locale locale;
            LocaleList localeList = localeManager == null ? null : localeManager.getApplicationLocales(appPackageName);
            Locale locale2 = locale = localeList == null ? null : localeList.get(0);
            if (locale != null) {
                LocaleInfo cacheInfo = LocaleStore.getLocaleInfo(locale, sLocaleCache);
                LocaleInfo localeInfo = new LocaleInfo(cacheInfo);
                localeInfo.mSuggestionFlags = isAppSelected ? (localeInfo.mSuggestionFlags |= 4) : (localeInfo.mSuggestionFlags |= 0x10);
                return localeInfo;
            }
        }
        catch (IllegalArgumentException e) {
            Log.d(TAG, "IllegalArgumentException ", e);
        }
        return null;
    }

    public static Set<LocaleInfo> transformImeLanguageTagToLocaleInfo(List<InputMethodSubtype> list) {
        HashSet<LocaleInfo> imeLocales = new HashSet<LocaleInfo>();
        for (InputMethodSubtype subtype : list) {
            Locale locale = Locale.forLanguageTag(subtype.getLanguageTag());
            LocaleInfo cacheInfo = LocaleStore.getLocaleInfo(locale, sLocaleCache);
            LocaleInfo localeInfo = new LocaleInfo(cacheInfo);
            localeInfo.mSuggestionFlags |= 0x20;
            imeLocales.add(localeInfo);
        }
        return imeLocales;
    }

    public static Set<LocaleInfo> getSystemCurrentLocales() {
        HashSet<LocaleInfo> localeList = new HashSet<LocaleInfo>();
        LocaleList systemLangList = LocaleList.getDefault();
        for (int i = 0; i < systemLangList.size(); ++i) {
            Locale sysLocale = LocaleStore.getLocaleWithOnlyNumberingSystem(systemLangList.get(i));
            LocaleInfo cacheInfo = LocaleStore.getLocaleInfo(sysLocale, sLocaleCache);
            LocaleInfo localeInfo = new LocaleInfo(cacheInfo);
            localeInfo.mSuggestionFlags |= 0x40;
            localeList.add(localeInfo);
        }
        return localeList;
    }

    public static LocaleInfo getSystemDefaultLocaleInfo(boolean hasAppLanguage) {
        LocaleInfo systemDefaultInfo = new LocaleInfo("");
        systemDefaultInfo.mSuggestionFlags |= 8;
        if (hasAppLanguage) {
            systemDefaultInfo.mSuggestionFlags |= 4;
        }
        systemDefaultInfo.mIsTranslated = true;
        return systemDefaultInfo;
    }

    private static void addSuggestedLocalesForRegion(Locale locale) {
        if (locale == null) {
            return;
        }
        String country = locale.getCountry();
        if (country.isEmpty()) {
            return;
        }
        for (LocaleInfo li : sLocaleCache.values()) {
            if (!country.equals(li.getLocale().getCountry())) continue;
            li.mSuggestionFlags |= 1;
        }
    }

    @UnsupportedAppUsage
    public static void fillCache(Context context) {
        if (sFullyInitialized) {
            return;
        }
        Set<String> simCountries = LocaleStore.getSimCountries(context);
        boolean isInDeveloperMode = Settings.Global.getInt(context.getContentResolver(), "development_settings_enabled", 0) != 0;
        HashSet<Locale> numberSystemLocaleList = new HashSet<Locale>();
        for (String localeId : LocalePicker.getSupportedLocales(context)) {
            if (Locale.forLanguageTag(localeId).getUnicodeLocaleType("nu") == null) continue;
            numberSystemLocaleList.add(Locale.forLanguageTag(localeId));
        }
        for (String localeId : LocalePicker.getSupportedLocales(context)) {
            String parentId;
            if (localeId.isEmpty()) {
                throw new IllformedLocaleException("Bad locale entry in locale_config.xml");
            }
            LocaleInfo li = new LocaleInfo(localeId);
            if (LocaleList.isPseudoLocale(li.getLocale())) {
                if (!isInDeveloperMode) continue;
                li.setTranslated(true);
                li.mIsPseudo = true;
                li.mSuggestionFlags |= 1;
            }
            if (simCountries.contains(li.getLocale().getCountry())) {
                li.mSuggestionFlags |= 1;
            }
            numberSystemLocaleList.forEach(l -> {
                if (li.getLocale().stripExtensions().equals(l.stripExtensions())) {
                    li.mHasNumberingSystems = true;
                }
            });
            sLocaleCache.put(li.getId(), li);
            Locale parent = li.getParent();
            if (parent == null || sLocaleCache.containsKey(parentId = parent.toLanguageTag())) continue;
            sLocaleCache.put(parentId, new LocaleInfo(parent));
        }
        HashSet<String> localizedLocales = new HashSet<String>();
        for (String localeId : LocalePicker.getSystemAssetLocales()) {
            LocaleInfo li = new LocaleInfo(localeId);
            String country = li.getLocale().getCountry();
            if (!country.isEmpty()) {
                LocaleInfo cachedLocale = null;
                if (sLocaleCache.containsKey(li.getId())) {
                    cachedLocale = sLocaleCache.get(li.getId());
                } else {
                    String langScriptCtry = li.getLangScriptKey() + "-" + country;
                    if (sLocaleCache.containsKey(langScriptCtry)) {
                        cachedLocale = sLocaleCache.get(langScriptCtry);
                    }
                }
                if (cachedLocale != null) {
                    cachedLocale.mSuggestionFlags |= 2;
                }
            }
            localizedLocales.add(li.getLangScriptKey());
        }
        for (LocaleInfo li : sLocaleCache.values()) {
            li.setTranslated(localizedLocales.contains(li.getLangScriptKey()));
        }
        LocaleStore.addSuggestedLocalesForRegion(AndroidLocale.getDefault());
        sFullyInitialized = true;
    }

    private static boolean isShallIgnore(Set<String> ignorables, LocaleInfo li, boolean translatedOnly) {
        if (ignorables.stream().anyMatch(tag -> Locale.forLanguageTag(tag).stripExtensions().equals(li.getLocale().stripExtensions()))) {
            return true;
        }
        if (li.mIsPseudo) {
            return false;
        }
        if (translatedOnly && !li.isTranslated()) {
            return true;
        }
        return li.getParent() == null;
    }

    private static int getLocaleTier(LocaleInfo parent) {
        if (parent == null) {
            return 1;
        }
        if (parent.getLocale().getCountry().isEmpty()) {
            return 2;
        }
        return 3;
    }

    @UnsupportedAppUsage
    public static Set<LocaleInfo> getLevelLocales(Context context, Set<String> ignorables, LocaleInfo parent, boolean translatedOnly) {
        return LocaleStore.getLevelLocales(context, ignorables, parent, translatedOnly, null);
    }

    public static Set<LocaleInfo> getLevelLocales(Context context, Set<String> ignorables, LocaleInfo parent, boolean translatedOnly, LocaleList explicitLocales) {
        if (context != null) {
            LocaleStore.fillCache(context);
        }
        HashMap<String, LocaleInfo> supportedLcoaleInfos = explicitLocales == null ? sLocaleCache : LocaleStore.convertExplicitLocales(explicitLocales, sLocaleCache.values());
        return LocaleStore.getTierLocales(ignorables, parent, translatedOnly, supportedLcoaleInfos);
    }

    private static Set<LocaleInfo> getTierLocales(Set<String> ignorables, LocaleInfo parent, boolean translatedOnly, HashMap<String, LocaleInfo> supportedLocaleInfos) {
        boolean hasTargetParent = parent != null;
        String parentId = hasTargetParent ? parent.getId() : null;
        HashSet<LocaleInfo> result = new HashSet<LocaleInfo>();
        for (LocaleInfo li : supportedLocaleInfos.values()) {
            if (LocaleStore.isShallIgnore(ignorables, li, translatedOnly)) continue;
            switch (LocaleStore.getLocaleTier(parent)) {
                case 1: {
                    if (li.isSuggestionOfType(1)) {
                        result.add(li);
                        break;
                    }
                    Locale locale = li.getParent();
                    LocaleInfo localeInfo = LocaleStore.getLocaleInfo(locale, supportedLocaleInfos);
                    LocaleStore.addLocaleInfoToMap(locale, localeInfo, supportedLocaleInfos);
                    result.add(localeInfo);
                    break;
                }
                case 2: {
                    if (!parentId.equals(li.getParent().toLanguageTag())) break;
                    Locale locale = li.getLocale().stripExtensions();
                    LocaleInfo localeInfo = LocaleStore.getLocaleInfo(locale, supportedLocaleInfos);
                    LocaleStore.addLocaleInfoToMap(locale, localeInfo, supportedLocaleInfos);
                    result.add(localeInfo);
                    break;
                }
                case 3: {
                    if (!parent.getLocale().stripExtensions().equals(li.getLocale().stripExtensions())) break;
                    result.add(li);
                }
            }
        }
        return result;
    }

    public static HashMap<String, LocaleInfo> convertExplicitLocales(LocaleList explicitLocales, Collection<LocaleInfo> localeinfo) {
        LocaleList localeList = LocaleStore.matchLocaleFromSupportedLocaleList(explicitLocales, localeinfo);
        HashMap<String, LocaleInfo> localeInfos = new HashMap<String, LocaleInfo>();
        for (int i = 0; i < localeList.size(); ++i) {
            String parentId;
            Locale locale = localeList.get(i);
            if (locale.toString().isEmpty()) {
                throw new IllformedLocaleException("Bad locale entry");
            }
            LocaleInfo li = new LocaleInfo(locale);
            if (localeInfos.containsKey(li.getId())) continue;
            localeInfos.put(li.getId(), li);
            Locale parent = li.getParent();
            if (parent == null || localeInfos.containsKey(parentId = parent.toLanguageTag())) continue;
            localeInfos.put(parentId, new LocaleInfo(parent));
        }
        return localeInfos;
    }

    private static LocaleList matchLocaleFromSupportedLocaleList(LocaleList explicitLocales, Collection<LocaleInfo> localeInfos) {
        if (localeInfos == null) {
            return explicitLocales;
        }
        Locale[] resultLocales = new Locale[explicitLocales.size()];
        for (int i = 0; i < explicitLocales.size(); ++i) {
            Locale locale = explicitLocales.get(i);
            if (!TextUtils.isEmpty(locale.getCountry())) {
                for (LocaleInfo localeInfo : localeInfos) {
                    if (!LocaleList.matchesLanguageAndScript(locale, localeInfo.getLocale()) || !TextUtils.equals(locale.getCountry(), localeInfo.getLocale().getCountry())) continue;
                    resultLocales[i] = localeInfo.getLocale();
                    break;
                }
            }
            if (resultLocales[i] != null) continue;
            resultLocales[i] = locale;
        }
        return new LocaleList(resultLocales);
    }

    @UnsupportedAppUsage
    public static LocaleInfo getLocaleInfo(Locale locale) {
        LocaleInfo localeInfo = LocaleStore.getLocaleInfo(locale, sLocaleCache);
        LocaleStore.addLocaleInfoToMap(locale, localeInfo, sLocaleCache);
        return localeInfo;
    }

    private static LocaleInfo getLocaleInfo(Locale locale, HashMap<String, LocaleInfo> localeInfos) {
        LocaleInfo result;
        String id2 = locale.toLanguageTag();
        if (!localeInfos.containsKey(id2)) {
            Locale filteredLocale = LocaleStore.getLocaleWithOnlyNumberingSystem(locale);
            if (localeInfos.containsKey(filteredLocale.toLanguageTag())) {
                LocaleInfo result2 = new LocaleInfo(locale);
                LocaleInfo localeInfo = localeInfos.get(filteredLocale.toLanguageTag());
                result2.mIsPseudo = localeInfo.mIsPseudo;
                result2.mIsTranslated = localeInfo.mIsTranslated;
                result2.mHasNumberingSystems = localeInfo.mHasNumberingSystems;
                result2.mSuggestionFlags = localeInfo.mSuggestionFlags;
                return result2;
            }
            result = new LocaleInfo(locale);
        } else {
            result = localeInfos.get(id2);
        }
        return result;
    }

    private static Locale getLocaleWithOnlyNumberingSystem(Locale locale) {
        return new Locale.Builder().setLocale(locale.stripExtensions()).setUnicodeLocaleKeyword("nu", locale.getUnicodeLocaleType("nu")).build();
    }

    private static void addLocaleInfoToMap(Locale locale, LocaleInfo localeInfo, HashMap<String, LocaleInfo> map) {
        Locale localeWithNumberingSystem;
        if (!map.containsKey(locale.toLanguageTag()) && !map.containsKey((localeWithNumberingSystem = LocaleStore.getLocaleWithOnlyNumberingSystem(locale)).toLanguageTag())) {
            map.put(locale.toLanguageTag(), localeInfo);
        }
    }

    @UnsupportedAppUsage
    @VisibleForTesting
    public static LocaleInfo fromLocale(Locale locale) {
        return new LocaleInfo(locale);
    }

    public static class LocaleInfo
    implements Serializable {
        public static final int SUGGESTION_TYPE_NONE = 0;
        public static final int SUGGESTION_TYPE_SIM = 1;
        public static final int SUGGESTION_TYPE_CFG = 2;
        public static final int SUGGESTION_TYPE_CURRENT = 4;
        public static final int SUGGESTION_TYPE_SYSTEM_LANGUAGE = 8;
        public static final int SUGGESTION_TYPE_OTHER_APP_LANGUAGE = 16;
        public static final int SUGGESTION_TYPE_IME_LANGUAGE = 32;
        public static final int SUGGESTION_TYPE_SYSTEM_AVAILABLE_LANGUAGE = 64;
        private final Locale mLocale;
        private final Locale mParent;
        private final String mId;
        private boolean mIsTranslated;
        private boolean mIsPseudo;
        private boolean mIsChecked;
        @VisibleForTesting
        public int mSuggestionFlags;
        private String mFullNameNative;
        private String mFullCountryNameNative;
        private String mLangScriptKey;
        private boolean mHasNumberingSystems;

        private LocaleInfo(Locale locale) {
            this.mLocale = locale;
            this.mId = locale.toLanguageTag();
            this.mParent = LocaleInfo.getParent(locale);
            this.mHasNumberingSystems = false;
            this.mIsChecked = false;
            this.mSuggestionFlags = 0;
            this.mIsTranslated = false;
            this.mIsPseudo = false;
        }

        private LocaleInfo(String localeId) {
            this(Locale.forLanguageTag(localeId));
        }

        private LocaleInfo(LocaleInfo localeInfo) {
            this.mLocale = localeInfo.getLocale();
            this.mId = localeInfo.getId();
            this.mParent = localeInfo.getParent();
            this.mHasNumberingSystems = localeInfo.mHasNumberingSystems;
            this.mIsChecked = localeInfo.getChecked();
            this.mSuggestionFlags = localeInfo.mSuggestionFlags;
            this.mIsTranslated = localeInfo.isTranslated();
            this.mIsPseudo = localeInfo.mIsPseudo;
        }

        private static Locale getParent(Locale locale) {
            if (locale.getCountry().isEmpty()) {
                return null;
            }
            return new Locale.Builder().setLocale(locale).setRegion("").setExtension('u', "").build();
        }

        public boolean hasNumberingSystems() {
            return this.mHasNumberingSystems;
        }

        public String toString() {
            return this.mId;
        }

        @UnsupportedAppUsage
        public Locale getLocale() {
            return this.mLocale;
        }

        @UnsupportedAppUsage
        public Locale getParent() {
            return this.mParent;
        }

        @UnsupportedAppUsage
        public String getId() {
            return this.mId;
        }

        public boolean isTranslated() {
            return this.mIsTranslated;
        }

        public void setTranslated(boolean isTranslated) {
            this.mIsTranslated = isTranslated;
        }

        public boolean isSuggested() {
            if (!this.mIsTranslated) {
                return false;
            }
            return this.mSuggestionFlags != 0;
        }

        public boolean isSuggestionOfType(int suggestionMask) {
            if (!this.mIsTranslated) {
                return false;
            }
            return (this.mSuggestionFlags & suggestionMask) == suggestionMask;
        }

        public void extendSuggestionOfType(int suggestionMask) {
            if (!this.mIsTranslated) {
                return;
            }
            this.mSuggestionFlags |= suggestionMask;
        }

        @UnsupportedAppUsage
        public String getFullNameNative() {
            if (this.mFullNameNative == null) {
                Locale locale = this.mLocale.stripExtensions();
                this.mFullNameNative = LocaleHelper.getDisplayName(locale, locale, true);
            }
            return this.mFullNameNative;
        }

        public String getFullCountryNameNative() {
            if (this.mFullCountryNameNative == null) {
                this.mFullCountryNameNative = LocaleHelper.getDisplayCountry(this.mLocale, this.mLocale);
            }
            return this.mFullCountryNameNative;
        }

        String getFullCountryNameInUiLanguage() {
            return LocaleHelper.getDisplayCountry(this.mLocale);
        }

        @UnsupportedAppUsage
        public String getFullNameInUiLanguage() {
            Locale locale = this.mLocale.stripExtensions();
            return LocaleHelper.getDisplayName(locale, true);
        }

        private String getLangScriptKey() {
            if (this.mLangScriptKey == null) {
                Locale baseLocale = new Locale.Builder().setLocale(this.mLocale).setExtension('u', "").build();
                Locale parentWithScript = LocaleInfo.getParent(LocaleHelper.addLikelySubtags(baseLocale));
                this.mLangScriptKey = parentWithScript == null ? this.mLocale.toLanguageTag() : parentWithScript.toLanguageTag();
            }
            return this.mLangScriptKey;
        }

        String getLabel(boolean countryMode) {
            if (countryMode) {
                return this.getFullCountryNameNative();
            }
            return this.getFullNameNative();
        }

        String getNumberingSystem() {
            return LocaleHelper.getDisplayNumberingSystemKeyValue(this.mLocale, this.mLocale);
        }

        String getContentDescription(boolean countryMode) {
            if (countryMode) {
                return this.getFullCountryNameInUiLanguage();
            }
            return this.getFullNameInUiLanguage();
        }

        public boolean getChecked() {
            return this.mIsChecked;
        }

        public void setChecked(boolean checked) {
            this.mIsChecked = checked;
        }

        public boolean isAppCurrentLocale() {
            return (this.mSuggestionFlags & 4) > 0;
        }

        public boolean isSystemLocale() {
            return (this.mSuggestionFlags & 8) > 0;
        }

        public boolean isInCurrentSystemLocales() {
            return (this.mSuggestionFlags & 0x40) > 0;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface SuggestionType {
        }
    }
}

