/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.annotation.IntRange;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.annotations.Immutable;
import com.android.internal.util.AnnotationValidations;

@Immutable
public class MessageSamplingConfig
implements Parcelable {
    private final int mSampledOpCode;
    private final int mAcceptableLeftDistance;
    private final long mExpirationTimeSinceBootMillis;
    public static final Parcelable.Creator<MessageSamplingConfig> CREATOR = new Parcelable.Creator<MessageSamplingConfig>(){

        public MessageSamplingConfig[] newArray(int size) {
            return new MessageSamplingConfig[size];
        }

        @Override
        public MessageSamplingConfig createFromParcel(Parcel in) {
            return new MessageSamplingConfig(in);
        }
    };

    public MessageSamplingConfig(int sampledOpCode, int acceptableLeftDistance, long expirationTimeSinceBootMillis) {
        this.mSampledOpCode = sampledOpCode;
        AnnotationValidations.validate(IntRange.class, null, this.mSampledOpCode, "from", -1L, "to", 135L);
        this.mAcceptableLeftDistance = acceptableLeftDistance;
        AnnotationValidations.validate(IntRange.class, null, this.mAcceptableLeftDistance, "from", 0L, "to", 135L);
        this.mExpirationTimeSinceBootMillis = expirationTimeSinceBootMillis;
        AnnotationValidations.validate(IntRange.class, null, this.mExpirationTimeSinceBootMillis, "from", 0L);
    }

    public int getSampledOpCode() {
        return this.mSampledOpCode;
    }

    public int getAcceptableLeftDistance() {
        return this.mAcceptableLeftDistance;
    }

    public long getExpirationTimeSinceBootMillis() {
        return this.mExpirationTimeSinceBootMillis;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mSampledOpCode);
        dest.writeInt(this.mAcceptableLeftDistance);
        dest.writeLong(this.mExpirationTimeSinceBootMillis);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    MessageSamplingConfig(Parcel in) {
        int sampledOpCode = in.readInt();
        int acceptableLeftDistance = in.readInt();
        long expirationTimeSinceBootMillis = in.readLong();
        this.mSampledOpCode = sampledOpCode;
        AnnotationValidations.validate(IntRange.class, null, this.mSampledOpCode, "from", -1L, "to", 135L);
        this.mAcceptableLeftDistance = acceptableLeftDistance;
        AnnotationValidations.validate(IntRange.class, null, this.mAcceptableLeftDistance, "from", 0L, "to", 135L);
        this.mExpirationTimeSinceBootMillis = expirationTimeSinceBootMillis;
        AnnotationValidations.validate(IntRange.class, null, this.mExpirationTimeSinceBootMillis, "from", 0L);
    }

    @Deprecated
    private void __metadata() {
    }
}

