/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.admin.DevicePolicyEventLogger;
import android.app.admin.DevicePolicyManager;
import android.content.Context;
import android.os.UserHandle;
import com.android.internal.app.AbstractMultiProfilePagerAdapter;
import com.android.internal.app.ResolverListAdapter;

public class NoCrossProfileEmptyStateProvider
implements AbstractMultiProfilePagerAdapter.EmptyStateProvider {
    private final UserHandle mPersonalProfileUserHandle;
    private final AbstractMultiProfilePagerAdapter.EmptyState mNoWorkToPersonalEmptyState;
    private final AbstractMultiProfilePagerAdapter.EmptyState mNoPersonalToWorkEmptyState;
    private final AbstractMultiProfilePagerAdapter.CrossProfileIntentsChecker mCrossProfileIntentsChecker;
    private final UserHandle mTabOwnerUserHandleForLaunch;

    public NoCrossProfileEmptyStateProvider(UserHandle personalUserHandle, AbstractMultiProfilePagerAdapter.EmptyState noWorkToPersonalEmptyState, AbstractMultiProfilePagerAdapter.EmptyState noPersonalToWorkEmptyState, AbstractMultiProfilePagerAdapter.CrossProfileIntentsChecker crossProfileIntentsChecker, UserHandle preselectedTabOwnerUserHandle) {
        this.mPersonalProfileUserHandle = personalUserHandle;
        this.mNoWorkToPersonalEmptyState = noWorkToPersonalEmptyState;
        this.mNoPersonalToWorkEmptyState = noPersonalToWorkEmptyState;
        this.mCrossProfileIntentsChecker = crossProfileIntentsChecker;
        this.mTabOwnerUserHandleForLaunch = preselectedTabOwnerUserHandle;
    }

    @Override
    public AbstractMultiProfilePagerAdapter.EmptyState getEmptyState(ResolverListAdapter resolverListAdapter) {
        boolean shouldShowBlocker;
        boolean bl = shouldShowBlocker = !this.mTabOwnerUserHandleForLaunch.equals(resolverListAdapter.getUserHandle()) && !this.mCrossProfileIntentsChecker.hasCrossProfileIntents(resolverListAdapter.getIntents(), this.mTabOwnerUserHandleForLaunch.getIdentifier(), resolverListAdapter.getUserHandle().getIdentifier());
        if (!shouldShowBlocker) {
            return null;
        }
        if (resolverListAdapter.getUserHandle().equals(this.mPersonalProfileUserHandle)) {
            return this.mNoWorkToPersonalEmptyState;
        }
        return this.mNoPersonalToWorkEmptyState;
    }

    public static class DevicePolicyBlockerEmptyState
    implements AbstractMultiProfilePagerAdapter.EmptyState {
        private final Context mContext;
        private final String mDevicePolicyStringTitleId;
        private final int mDefaultTitleResource;
        private final String mDevicePolicyStringSubtitleId;
        private final int mDefaultSubtitleResource;
        private final int mEventId;
        private final String mEventCategory;

        public DevicePolicyBlockerEmptyState(Context context, String devicePolicyStringTitleId, int defaultTitleResource, String devicePolicyStringSubtitleId, int defaultSubtitleResource, int devicePolicyEventId, String devicePolicyEventCategory) {
            this.mContext = context;
            this.mDevicePolicyStringTitleId = devicePolicyStringTitleId;
            this.mDefaultTitleResource = defaultTitleResource;
            this.mDevicePolicyStringSubtitleId = devicePolicyStringSubtitleId;
            this.mDefaultSubtitleResource = defaultSubtitleResource;
            this.mEventId = devicePolicyEventId;
            this.mEventCategory = devicePolicyEventCategory;
        }

        @Override
        public String getTitle() {
            return this.mContext.getSystemService(DevicePolicyManager.class).getResources().getString(this.mDevicePolicyStringTitleId, () -> this.mContext.getString(this.mDefaultTitleResource));
        }

        @Override
        public String getSubtitle() {
            return this.mContext.getSystemService(DevicePolicyManager.class).getResources().getString(this.mDevicePolicyStringSubtitleId, () -> this.mContext.getString(this.mDefaultSubtitleResource));
        }

        @Override
        public void onEmptyStateShown() {
            DevicePolicyEventLogger.createEvent(this.mEventId).setStrings(this.mEventCategory).write();
        }

        @Override
        public boolean shouldSkipDataRebuild() {
            return true;
        }
    }
}

