/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.Context;
import android.content.res.Configuration;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.android.internal.app.LocaleHelper;
import com.android.internal.app.LocaleStore;
import com.android.layoutlib.bridge.android.AndroidLocale;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;

public class SuggestedLocaleAdapter
extends BaseAdapter
implements Filterable {
    protected static final int TYPE_HEADER_SUGGESTED = 0;
    protected static final int TYPE_HEADER_ALL_OTHERS = 1;
    protected static final int TYPE_LOCALE = 2;
    protected static final int TYPE_SYSTEM_LANGUAGE_FOR_APP_LANGUAGE_PICKER = 3;
    protected static final int TYPE_CURRENT_LOCALE = 4;
    protected static final int MIN_REGIONS_FOR_SUGGESTIONS = 6;
    protected static final int APP_LANGUAGE_PICKER_TYPE_COUNT = 5;
    protected static final int SYSTEM_LANGUAGE_TYPE_COUNT = 3;
    protected static final int SYSTEM_LANGUAGE_WITHOUT_HEADER_TYPE_COUNT = 1;
    protected ArrayList<LocaleStore.LocaleInfo> mLocaleOptions;
    protected ArrayList<LocaleStore.LocaleInfo> mOriginalLocaleOptions;
    protected int mSuggestionCount;
    protected final boolean mCountryMode;
    protected boolean mIsNumberingMode;
    protected LayoutInflater mInflater;
    protected Locale mDisplayLocale = null;
    protected Context mContextOverride = null;
    private boolean mHasSpecificAppPackageName;

    public SuggestedLocaleAdapter(Set<LocaleStore.LocaleInfo> localeOptions, boolean countryMode) {
        this(localeOptions, countryMode, false);
    }

    public SuggestedLocaleAdapter(Set<LocaleStore.LocaleInfo> localeOptions, boolean countryMode, boolean hasSpecificAppPackageName) {
        this.mCountryMode = countryMode;
        this.mLocaleOptions = new ArrayList(localeOptions.size());
        this.mHasSpecificAppPackageName = hasSpecificAppPackageName;
        for (LocaleStore.LocaleInfo li : localeOptions) {
            if (li.isSuggested()) {
                ++this.mSuggestionCount;
            }
            this.mLocaleOptions.add(li);
        }
    }

    public void setNumberingSystemMode(boolean isNumberSystemMode) {
        this.mIsNumberingMode = isNumberSystemMode;
    }

    public boolean getIsForNumberingSystem() {
        return this.mIsNumberingMode;
    }

    @Override
    public boolean areAllItemsEnabled() {
        return false;
    }

    @Override
    public boolean isEnabled(int position) {
        return this.getItemViewType(position) == 2 || this.getItemViewType(position) == 3 || this.getItemViewType(position) == 4;
    }

    @Override
    public int getItemViewType(int position) {
        if (!this.showHeaders()) {
            LocaleStore.LocaleInfo item = (LocaleStore.LocaleInfo)this.getItem(position);
            if (item.isSystemLocale()) {
                return 3;
            }
            if (item.isAppCurrentLocale()) {
                return 4;
            }
            return 2;
        }
        if (position == 0) {
            return 0;
        }
        if (position == this.mSuggestionCount + 1) {
            return 1;
        }
        LocaleStore.LocaleInfo item = (LocaleStore.LocaleInfo)this.getItem(position);
        if (item == null) {
            throw new NullPointerException("Non header locale cannot be null");
        }
        if (item.isSystemLocale()) {
            return 3;
        }
        if (item.isAppCurrentLocale()) {
            return 4;
        }
        return 2;
    }

    @Override
    public int getViewTypeCount() {
        if (this.mHasSpecificAppPackageName && this.showHeaders()) {
            return 5;
        }
        if (this.showHeaders()) {
            return 3;
        }
        return 1;
    }

    @Override
    public int getCount() {
        if (this.showHeaders()) {
            return this.mLocaleOptions.size() + 2;
        }
        return this.mLocaleOptions.size();
    }

    @Override
    public Object getItem(int position) {
        if (this.isHeaderPosition(position)) {
            return null;
        }
        int offset = 0;
        if (this.showHeaders()) {
            offset = position > this.mSuggestionCount ? -2 : -1;
        }
        return this.mLocaleOptions.get(position + offset);
    }

    private boolean isHeaderPosition(int position) {
        return this.showHeaders() && (position == 0 || position == this.mSuggestionCount + 1);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    public void setDisplayLocale(Context context, Locale locale) {
        if (locale == null) {
            this.mDisplayLocale = null;
            this.mContextOverride = null;
        } else if (!locale.equals(this.mDisplayLocale)) {
            this.mDisplayLocale = locale;
            Configuration configOverride = new Configuration();
            configOverride.setLocale(locale);
            this.mContextOverride = context.createConfigurationContext(configOverride);
        }
    }

    protected void setTextTo(TextView textView, int resId) {
        if (this.mContextOverride == null) {
            textView.setText(resId);
        } else {
            textView.setText(this.mContextOverride.getText(resId));
        }
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        if (convertView == null && this.mInflater == null) {
            this.mInflater = LayoutInflater.from(parent.getContext());
        }
        int itemType = this.getItemViewType(position);
        View itemView = this.getNewViewIfNeeded(convertView, parent, itemType, position);
        switch (itemType) {
            case 0: 
            case 1: {
                TextView textView = (TextView)itemView;
                if (itemType == 0) {
                    if (this.mCountryMode && !this.mIsNumberingMode) {
                        this.setTextTo(textView, 17040580);
                    } else {
                        this.setTextTo(textView, 17040582);
                    }
                } else if (this.mCountryMode && !this.mIsNumberingMode) {
                    this.setTextTo(textView, 17041416);
                } else {
                    this.setTextTo(textView, 17040581);
                }
                textView.setTextLocale(this.mDisplayLocale != null ? this.mDisplayLocale : AndroidLocale.getDefault());
                break;
            }
            case 3: {
                LocaleStore.LocaleInfo info = (LocaleStore.LocaleInfo)this.getItem(position);
                if (info == null) {
                    throw new NullPointerException("Non header locale cannot be null.");
                }
                TextView title = info.isAppCurrentLocale() ? (TextView)itemView.findViewById(16909182) : (TextView)itemView.findViewById(16909202);
                title.setText(17041658);
                break;
            }
            case 4: {
                this.updateTextView(itemView, (TextView)itemView.findViewById(16909182), position);
                break;
            }
            default: {
                this.updateTextView(itemView, (TextView)itemView.findViewById(16909202), position);
            }
        }
        return itemView;
    }

    private View getNewViewIfNeeded(View convertView, ViewGroup parent, int itemType, int position) {
        View updatedView = convertView;
        switch (itemType) {
            case 0: 
            case 1: {
                boolean shouldReuseView;
                boolean bl = shouldReuseView = convertView instanceof TextView && convertView.findViewById(16909181) != null;
                if (shouldReuseView) break;
                updatedView = this.mInflater.inflate(17367197, parent, false);
                break;
            }
            case 3: {
                boolean shouldReuseView;
                if (((LocaleStore.LocaleInfo)this.getItem(position)).isAppCurrentLocale()) {
                    boolean shouldReuseView2;
                    boolean bl = shouldReuseView2 = convertView instanceof LinearLayout && convertView.findViewById(16909182) != null;
                    if (shouldReuseView2) break;
                    updatedView = this.mInflater.inflate(17367097, parent, false);
                    this.addStateDescriptionIntoCurrentLocaleItem(updatedView);
                    break;
                }
                boolean bl = shouldReuseView = convertView instanceof TextView && convertView.findViewById(16909202) != null;
                if (shouldReuseView) break;
                updatedView = this.mInflater.inflate(17367196, parent, false);
                break;
            }
            case 4: {
                boolean shouldReuseView;
                boolean bl = shouldReuseView = convertView instanceof LinearLayout && convertView.findViewById(16909182) != null;
                if (shouldReuseView) break;
                updatedView = this.mInflater.inflate(17367097, parent, false);
                this.addStateDescriptionIntoCurrentLocaleItem(updatedView);
                break;
            }
            default: {
                boolean shouldReuseView;
                boolean bl = shouldReuseView = convertView instanceof TextView && convertView.findViewById(16909202) != null;
                if (shouldReuseView) break;
                updatedView = this.mInflater.inflate(17367196, parent, false);
            }
        }
        return updatedView;
    }

    protected boolean showHeaders() {
        if (this.mCountryMode && this.mLocaleOptions.size() < 6) {
            return false;
        }
        return this.mSuggestionCount != 0 && this.mSuggestionCount != this.mLocaleOptions.size();
    }

    public void sort(LocaleHelper.LocaleInfoComparator comp) {
        Collections.sort(this.mLocaleOptions, comp);
    }

    @Override
    public Filter getFilter() {
        return new FilterByNativeAndUiNames();
    }

    private void updateTextView(View convertView, TextView text, int position) {
        LocaleStore.LocaleInfo item = (LocaleStore.LocaleInfo)this.getItem(position);
        text.setText(this.mIsNumberingMode ? item.getNumberingSystem() : item.getLabel(this.mCountryMode));
        text.setTextLocale(item.getLocale());
        text.setContentDescription(this.mIsNumberingMode ? item.getNumberingSystem() : item.getContentDescription(this.mCountryMode));
        if (this.mCountryMode) {
            int layoutDir = TextUtils.getLayoutDirectionFromLocale(item.getParent());
            convertView.setLayoutDirection(layoutDir);
            text.setTextDirection(layoutDir == 1 ? 4 : 3);
        }
    }

    private void addStateDescriptionIntoCurrentLocaleItem(View root) {
        String description = root.getContext().getResources().getString(17039808);
        root.setStateDescription(description);
    }

    class FilterByNativeAndUiNames
    extends Filter {
        FilterByNativeAndUiNames() {
        }

        @Override
        protected Filter.FilterResults performFiltering(CharSequence prefix) {
            Filter.FilterResults results = new Filter.FilterResults();
            if (SuggestedLocaleAdapter.this.mOriginalLocaleOptions == null) {
                SuggestedLocaleAdapter.this.mOriginalLocaleOptions = new ArrayList<LocaleStore.LocaleInfo>(SuggestedLocaleAdapter.this.mLocaleOptions);
            }
            ArrayList<LocaleStore.LocaleInfo> values = new ArrayList<LocaleStore.LocaleInfo>(SuggestedLocaleAdapter.this.mOriginalLocaleOptions);
            if (prefix == null || prefix.length() == 0) {
                results.values = values;
                results.count = values.size();
            } else {
                Locale locale = AndroidLocale.getDefault();
                String prefixString = LocaleHelper.normalizeForSearch(prefix.toString(), locale);
                int count = values.size();
                ArrayList<LocaleStore.LocaleInfo> newValues = new ArrayList<LocaleStore.LocaleInfo>();
                for (int i = 0; i < count; ++i) {
                    LocaleStore.LocaleInfo value = values.get(i);
                    String nameToCheck = LocaleHelper.normalizeForSearch(value.getFullNameInUiLanguage(), locale);
                    String nativeNameToCheck = LocaleHelper.normalizeForSearch(value.getFullNameNative(), locale);
                    if (!this.wordMatches(nativeNameToCheck, prefixString) && !this.wordMatches(nameToCheck, prefixString)) continue;
                    newValues.add(value);
                }
                results.values = newValues;
                results.count = newValues.size();
            }
            return results;
        }

        boolean wordMatches(String valueText, String prefixString) {
            String[] words;
            if (valueText.startsWith(prefixString)) {
                return true;
            }
            for (String word : words = valueText.split(" ")) {
                if (!word.startsWith(prefixString)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
            SuggestedLocaleAdapter.this.mLocaleOptions = (ArrayList)results.values;
            SuggestedLocaleAdapter.this.mSuggestionCount = 0;
            for (LocaleStore.LocaleInfo li : SuggestedLocaleAdapter.this.mLocaleOptions) {
                if (!li.isSuggested()) continue;
                ++SuggestedLocaleAdapter.this.mSuggestionCount;
            }
            if (results.count > 0) {
                SuggestedLocaleAdapter.this.notifyDataSetChanged();
            } else {
                SuggestedLocaleAdapter.this.notifyDataSetInvalidated();
            }
        }
    }
}

