/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.Context;
import android.os.LocaleList;
import com.android.internal.app.LocalePicker;
import com.android.internal.app.LocalePickerWithRegion;
import com.android.internal.app.LocaleStore;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class SystemLocaleCollector
implements LocalePickerWithRegion.LocaleCollectorBase {
    private final Context mContext;
    private LocaleList mExplicitLocales;

    SystemLocaleCollector(Context context) {
        this(context, null);
    }

    SystemLocaleCollector(Context context, LocaleList explicitLocales) {
        this.mContext = context;
        this.mExplicitLocales = explicitLocales;
    }

    @Override
    public HashSet<String> getIgnoredLocaleList(boolean translatedOnly) {
        HashSet<String> ignoreList = new HashSet<String>();
        if (!translatedOnly) {
            LocaleList userLocales = LocalePicker.getLocales();
            String[] langTags = userLocales.toLanguageTags().split(",");
            Collections.addAll(ignoreList, langTags);
        }
        return ignoreList;
    }

    @Override
    public Set<LocaleStore.LocaleInfo> getSupportedLocaleList(LocaleStore.LocaleInfo parent, boolean translatedOnly, boolean isForCountryMode) {
        HashSet<String> langTagsToIgnore = this.getIgnoredLocaleList(translatedOnly);
        Set<LocaleStore.LocaleInfo> localeList = isForCountryMode ? LocaleStore.getLevelLocales(this.mContext, langTagsToIgnore, parent, translatedOnly, this.mExplicitLocales) : LocaleStore.getLevelLocales(this.mContext, langTagsToIgnore, null, translatedOnly, this.mExplicitLocales);
        return localeList;
    }

    @Override
    public boolean hasSpecificPackageName() {
        return false;
    }
}

