/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.admin.DevicePolicyEventLogger;
import android.app.admin.DevicePolicyManager;
import android.content.Context;
import android.os.UserHandle;
import com.android.internal.app.AbstractMultiProfilePagerAdapter;
import com.android.internal.app.ResolverListAdapter;

public class WorkProfilePausedEmptyStateProvider
implements AbstractMultiProfilePagerAdapter.EmptyStateProvider {
    private final UserHandle mWorkProfileUserHandle;
    private final AbstractMultiProfilePagerAdapter.QuietModeManager mQuietModeManager;
    private final String mMetricsCategory;
    private final AbstractMultiProfilePagerAdapter.OnSwitchOnWorkSelectedListener mOnSwitchOnWorkSelectedListener;
    private final Context mContext;

    public WorkProfilePausedEmptyStateProvider(Context context, UserHandle workProfileUserHandle, AbstractMultiProfilePagerAdapter.QuietModeManager quietModeManager, AbstractMultiProfilePagerAdapter.OnSwitchOnWorkSelectedListener onSwitchOnWorkSelectedListener, String metricsCategory) {
        this.mContext = context;
        this.mWorkProfileUserHandle = workProfileUserHandle;
        this.mQuietModeManager = quietModeManager;
        this.mMetricsCategory = metricsCategory;
        this.mOnSwitchOnWorkSelectedListener = onSwitchOnWorkSelectedListener;
    }

    @Override
    public AbstractMultiProfilePagerAdapter.EmptyState getEmptyState(ResolverListAdapter resolverListAdapter) {
        if (!resolverListAdapter.getUserHandle().equals(this.mWorkProfileUserHandle) || !this.mQuietModeManager.isQuietModeEnabled(this.mWorkProfileUserHandle) || resolverListAdapter.getCount() == 0) {
            return null;
        }
        String title = this.mContext.getSystemService(DevicePolicyManager.class).getResources().getString("Core.RESOLVER_WORK_PAUSED_TITLE", () -> this.mContext.getString(17041447));
        return new WorkProfileOffEmptyState(title, tab -> {
            tab.showSpinner();
            if (this.mOnSwitchOnWorkSelectedListener != null) {
                this.mOnSwitchOnWorkSelectedListener.onSwitchOnWorkSelected();
            }
            this.mQuietModeManager.requestQuietModeEnabled(false, this.mWorkProfileUserHandle);
        }, this.mMetricsCategory);
    }

    public static class WorkProfileOffEmptyState
    implements AbstractMultiProfilePagerAdapter.EmptyState {
        private final String mTitle;
        private final AbstractMultiProfilePagerAdapter.EmptyState.ClickListener mOnClick;
        private final String mMetricsCategory;

        public WorkProfileOffEmptyState(String title, AbstractMultiProfilePagerAdapter.EmptyState.ClickListener onClick, String metricsCategory) {
            this.mTitle = title;
            this.mOnClick = onClick;
            this.mMetricsCategory = metricsCategory;
        }

        @Override
        public String getTitle() {
            return this.mTitle;
        }

        @Override
        public AbstractMultiProfilePagerAdapter.EmptyState.ClickListener getButtonClickListener() {
            return this.mOnClick;
        }

        @Override
        public void onEmptyStateShown() {
            DevicePolicyEventLogger.createEvent(157).setStrings(this.mMetricsCategory).write();
        }
    }
}

