/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.dynamicanimation.animation;

import android.animation.AnimationHandler;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.os.Looper;
import android.util.AndroidRuntimeException;
import android.util.FloatProperty;
import android.view.View;
import com.android.internal.dynamicanimation.animation.FloatValueHolder;
import java.util.ArrayList;

public abstract class DynamicAnimation<T extends DynamicAnimation<T>>
implements AnimationHandler.AnimationFrameCallback {
    public static final ViewProperty TRANSLATION_X = new ViewProperty("translationX"){

        @Override
        public void setValue(View view, float value) {
            view.setTranslationX(value);
        }

        @Override
        public Float get(View view) {
            return Float.valueOf(view.getTranslationX());
        }
    };
    public static final ViewProperty TRANSLATION_Y = new ViewProperty("translationY"){

        @Override
        public void setValue(View view, float value) {
            view.setTranslationY(value);
        }

        @Override
        public Float get(View view) {
            return Float.valueOf(view.getTranslationY());
        }
    };
    public static final ViewProperty TRANSLATION_Z = new ViewProperty("translationZ"){

        @Override
        public void setValue(View view, float value) {
            view.setTranslationZ(value);
        }

        @Override
        public Float get(View view) {
            return Float.valueOf(view.getTranslationZ());
        }
    };
    public static final ViewProperty SCALE_X = new ViewProperty("scaleX"){

        @Override
        public void setValue(View view, float value) {
            view.setScaleX(value);
        }

        @Override
        public Float get(View view) {
            return Float.valueOf(view.getScaleX());
        }
    };
    public static final ViewProperty SCALE_Y = new ViewProperty("scaleY"){

        @Override
        public void setValue(View view, float value) {
            view.setScaleY(value);
        }

        @Override
        public Float get(View view) {
            return Float.valueOf(view.getScaleY());
        }
    };
    public static final ViewProperty ROTATION = new ViewProperty("rotation"){

        @Override
        public void setValue(View view, float value) {
            view.setRotation(value);
        }

        @Override
        public Float get(View view) {
            return Float.valueOf(view.getRotation());
        }
    };
    public static final ViewProperty ROTATION_X = new ViewProperty("rotationX"){

        @Override
        public void setValue(View view, float value) {
            view.setRotationX(value);
        }

        @Override
        public Float get(View view) {
            return Float.valueOf(view.getRotationX());
        }
    };
    public static final ViewProperty ROTATION_Y = new ViewProperty("rotationY"){

        @Override
        public void setValue(View view, float value) {
            view.setRotationY(value);
        }

        @Override
        public Float get(View view) {
            return Float.valueOf(view.getRotationY());
        }
    };
    public static final ViewProperty X = new ViewProperty("x"){

        @Override
        public void setValue(View view, float value) {
            view.setX(value);
        }

        @Override
        public Float get(View view) {
            return Float.valueOf(view.getX());
        }
    };
    public static final ViewProperty Y = new ViewProperty("y"){

        @Override
        public void setValue(View view, float value) {
            view.setY(value);
        }

        @Override
        public Float get(View view) {
            return Float.valueOf(view.getY());
        }
    };
    public static final ViewProperty Z = new ViewProperty("z"){

        @Override
        public void setValue(View view, float value) {
            view.setZ(value);
        }

        @Override
        public Float get(View view) {
            return Float.valueOf(view.getZ());
        }
    };
    public static final ViewProperty ALPHA = new ViewProperty("alpha"){

        @Override
        public void setValue(View view, float value) {
            view.setAlpha(value);
        }

        @Override
        public Float get(View view) {
            return Float.valueOf(view.getAlpha());
        }
    };
    public static final ViewProperty SCROLL_X = new ViewProperty("scrollX"){

        @Override
        public void setValue(View view, float value) {
            view.setScrollX((int)value);
        }

        @Override
        public Float get(View view) {
            return Float.valueOf(view.getScrollX());
        }
    };
    public static final ViewProperty SCROLL_Y = new ViewProperty("scrollY"){

        @Override
        public void setValue(View view, float value) {
            view.setScrollY((int)value);
        }

        @Override
        public Float get(View view) {
            return Float.valueOf(view.getScrollY());
        }
    };
    @SuppressLint(value={"MinMaxConstant"})
    public static final float MIN_VISIBLE_CHANGE_PIXELS = 1.0f;
    @SuppressLint(value={"MinMaxConstant"})
    public static final float MIN_VISIBLE_CHANGE_ROTATION_DEGREES = 0.1f;
    @SuppressLint(value={"MinMaxConstant"})
    public static final float MIN_VISIBLE_CHANGE_ALPHA = 0.00390625f;
    @SuppressLint(value={"MinMaxConstant"})
    public static final float MIN_VISIBLE_CHANGE_SCALE = 0.002f;
    private static final float UNSET = Float.MAX_VALUE;
    private static final float THRESHOLD_MULTIPLIER = 0.75f;
    float mVelocity = 0.0f;
    float mValue = Float.MAX_VALUE;
    boolean mStartValueIsSet = false;
    final Object mTarget;
    final FloatProperty mProperty;
    boolean mRunning = false;
    float mMaxValue = Float.MAX_VALUE;
    float mMinValue = -this.mMaxValue;
    private long mLastFrameTime = 0L;
    private float mMinVisibleChange;
    private final ArrayList<OnAnimationEndListener> mEndListeners = new ArrayList();
    private final ArrayList<OnAnimationUpdateListener> mUpdateListeners = new ArrayList();
    private AnimationHandler mAnimationHandler;

    DynamicAnimation(final FloatValueHolder floatValueHolder) {
        this.mTarget = null;
        this.mProperty = new FloatProperty("FloatValueHolder"){

            @Override
            public Float get(Object object) {
                return Float.valueOf(floatValueHolder.getValue());
            }

            public void setValue(Object object, float value) {
                floatValueHolder.setValue(value);
            }
        };
        this.mMinVisibleChange = 1.0f;
    }

    <K> DynamicAnimation(K object, FloatProperty<K> property) {
        this.mTarget = object;
        this.mProperty = property;
        this.mMinVisibleChange = this.mProperty == ROTATION || this.mProperty == ROTATION_X || this.mProperty == ROTATION_Y ? 0.1f : (this.mProperty == ALPHA ? 0.00390625f : (this.mProperty == SCALE_X || this.mProperty == SCALE_Y ? 0.002f : 1.0f));
    }

    public T setStartValue(float startValue) {
        this.mValue = startValue;
        this.mStartValueIsSet = true;
        return (T)this;
    }

    public T setStartVelocity(float startVelocity) {
        this.mVelocity = startVelocity;
        return (T)this;
    }

    public T setMaxValue(float max) {
        this.mMaxValue = max;
        return (T)this;
    }

    public T setMinValue(float min) {
        this.mMinValue = min;
        return (T)this;
    }

    public T addEndListener(OnAnimationEndListener listener) {
        if (!this.mEndListeners.contains(listener)) {
            this.mEndListeners.add(listener);
        }
        return (T)this;
    }

    public void removeEndListener(OnAnimationEndListener listener) {
        DynamicAnimation.removeEntry(this.mEndListeners, listener);
    }

    public T addUpdateListener(OnAnimationUpdateListener listener) {
        if (this.isRunning()) {
            throw new UnsupportedOperationException("Error: Update listeners must be added beforethe animation.");
        }
        if (!this.mUpdateListeners.contains(listener)) {
            this.mUpdateListeners.add(listener);
        }
        return (T)this;
    }

    public void removeUpdateListener(OnAnimationUpdateListener listener) {
        DynamicAnimation.removeEntry(this.mUpdateListeners, listener);
    }

    public T setMinimumVisibleChange(float minimumVisibleChange) {
        if (minimumVisibleChange <= 0.0f) {
            throw new IllegalArgumentException("Minimum visible change must be positive.");
        }
        this.mMinVisibleChange = minimumVisibleChange;
        this.setValueThreshold(minimumVisibleChange * 0.75f);
        return (T)this;
    }

    public float getMinimumVisibleChange() {
        return this.mMinVisibleChange;
    }

    private static <T> void removeNullEntries(ArrayList<T> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            if (list.get(i) != null) continue;
            list.remove(i);
        }
    }

    private static <T> void removeEntry(ArrayList<T> list, T entry) {
        int id2 = list.indexOf(entry);
        if (id2 >= 0) {
            list.set(id2, null);
        }
    }

    public void start() {
        if (!this.isCurrentThread()) {
            throw new AndroidRuntimeException("Animations may only be started on the same thread as the animation handler");
        }
        if (!this.mRunning) {
            this.startAnimationInternal();
        }
    }

    boolean isCurrentThread() {
        return Thread.currentThread() == Looper.myLooper().getThread();
    }

    public void cancel() {
        if (!this.isCurrentThread()) {
            throw new AndroidRuntimeException("Animations may only be canceled from the same thread as the animation handler");
        }
        if (this.mRunning) {
            this.endAnimationInternal(true);
        }
    }

    public boolean isRunning() {
        return this.mRunning;
    }

    private void startAnimationInternal() {
        if (!this.mRunning) {
            this.mRunning = true;
            if (!this.mStartValueIsSet) {
                this.mValue = this.getPropertyValue();
            }
            if (this.mValue > this.mMaxValue || this.mValue < this.mMinValue) {
                throw new IllegalArgumentException("Starting value need to be in between min value and max value");
            }
            this.getAnimationHandler().addAnimationFrameCallback(this, 0L);
        }
    }

    @Override
    public boolean doAnimationFrame(long frameTime) {
        if (this.mLastFrameTime == 0L) {
            this.mLastFrameTime = frameTime;
            this.setPropertyValue(this.mValue);
            return false;
        }
        long deltaT = frameTime - this.mLastFrameTime;
        this.mLastFrameTime = frameTime;
        float durationScale = ValueAnimator.getDurationScale();
        deltaT = durationScale == 0.0f ? Integer.MAX_VALUE : (long)((float)deltaT / durationScale);
        boolean finished = this.updateValueAndVelocity(deltaT);
        this.mValue = Math.min(this.mValue, this.mMaxValue);
        this.mValue = Math.max(this.mValue, this.mMinValue);
        this.setPropertyValue(this.mValue);
        if (finished) {
            this.endAnimationInternal(false);
        }
        return finished;
    }

    @Override
    public void commitAnimationFrame(long frameTime) {
        this.doAnimationFrame(frameTime);
    }

    abstract boolean updateValueAndVelocity(long var1);

    private void endAnimationInternal(boolean canceled) {
        this.mRunning = false;
        this.getAnimationHandler().removeCallback(this);
        this.mLastFrameTime = 0L;
        this.mStartValueIsSet = false;
        for (int i = 0; i < this.mEndListeners.size(); ++i) {
            if (this.mEndListeners.get(i) == null) continue;
            this.mEndListeners.get(i).onAnimationEnd(this, canceled, this.mValue, this.mVelocity);
        }
        DynamicAnimation.removeNullEntries(this.mEndListeners);
    }

    void setPropertyValue(float value) {
        this.mProperty.setValue(this.mTarget, value);
        for (int i = 0; i < this.mUpdateListeners.size(); ++i) {
            if (this.mUpdateListeners.get(i) == null) continue;
            this.mUpdateListeners.get(i).onAnimationUpdate(this, this.mValue, this.mVelocity);
        }
        DynamicAnimation.removeNullEntries(this.mUpdateListeners);
    }

    float getValueThreshold() {
        return this.mMinVisibleChange * 0.75f;
    }

    private float getPropertyValue() {
        return ((Float)this.mProperty.get(this.mTarget)).floatValue();
    }

    public AnimationHandler getAnimationHandler() {
        return this.mAnimationHandler != null ? this.mAnimationHandler : AnimationHandler.getInstance();
    }

    abstract float getAcceleration(float var1, float var2);

    abstract boolean isAtEquilibrium(float var1, float var2);

    abstract void setValueThreshold(float var1);

    public static abstract class ViewProperty
    extends FloatProperty<View> {
        private ViewProperty(String name) {
            super(name);
        }
    }

    public static interface OnAnimationEndListener {
        public void onAnimationEnd(DynamicAnimation var1, boolean var2, float var3, float var4);
    }

    public static interface OnAnimationUpdateListener {
        public void onAnimationUpdate(DynamicAnimation var1, float var2, float var3);
    }

    static class MassState {
        float mValue;
        float mVelocity;

        MassState() {
        }
    }
}

