/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.graphics.drawable;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RenderNode;
import android.graphics.drawable.Drawable;
import android.util.ArraySet;
import android.util.Log;
import android.util.LongSparseArray;
import android.view.ViewRootImpl;
import android.view.ViewTreeObserver;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;

public class BackgroundBlurDrawable
extends Drawable {
    private static final String TAG = BackgroundBlurDrawable.class.getSimpleName();
    private static final boolean DEBUG = Log.isLoggable(TAG, 3);
    private final Aggregator mAggregator;
    private final RenderNode mRenderNode;
    private final Paint mPaint = new Paint();
    private final Path mRectPath = new Path();
    private final float[] mTmpRadii = new float[8];
    private boolean mVisible = true;
    private int mBlurRadius;
    private float mCornerRadiusTL;
    private float mCornerRadiusTR;
    private float mCornerRadiusBL;
    private float mCornerRadiusBR;
    private float mAlpha = 1.0f;
    private final Rect mRect = new Rect();
    @VisibleForTesting
    public final RenderNode.PositionUpdateListener mPositionUpdateListener = new RenderNode.PositionUpdateListener(){

        @Override
        public void positionChanged(long frameNumber, int left, int top, int right, int bottom) {
            BackgroundBlurDrawable.this.mAggregator.onRenderNodePositionChanged(frameNumber, () -> BackgroundBlurDrawable.this.mRect.set(left, top, right, bottom));
        }

        @Override
        public void positionLost(long frameNumber) {
            BackgroundBlurDrawable.this.mAggregator.onRenderNodePositionChanged(frameNumber, () -> BackgroundBlurDrawable.this.mRect.setEmpty());
        }
    };

    private BackgroundBlurDrawable(Aggregator aggregator) {
        this.mAggregator = aggregator;
        this.mPaint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.SRC));
        this.mPaint.setColor(0);
        this.mPaint.setAntiAlias(true);
        this.mRenderNode = new RenderNode("BackgroundBlurDrawable");
        this.mRenderNode.addPositionUpdateListener(this.mPositionUpdateListener);
    }

    @Override
    public void draw(Canvas canvas) {
        if (this.mRectPath.isEmpty() || !this.isVisible() || this.getAlpha() == 0) {
            return;
        }
        canvas.drawPath(this.mRectPath, this.mPaint);
        canvas.drawRenderNode(this.mRenderNode);
    }

    public void setColor(int color2) {
        this.mPaint.setColor(color2);
    }

    @Override
    public boolean setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        if (changed) {
            this.mVisible = visible;
            this.mAggregator.onBlurDrawableUpdated(this);
        }
        return changed;
    }

    @Override
    public void setAlpha(int alpha) {
        if (this.mAlpha != (float)alpha / 255.0f) {
            this.mAlpha = (float)alpha / 255.0f;
            this.invalidateSelf();
            this.mAggregator.onBlurDrawableUpdated(this);
        }
    }

    public void setBlurRadius(int blurRadius) {
        if (this.mBlurRadius != blurRadius) {
            this.mBlurRadius = blurRadius;
            this.invalidateSelf();
            this.mAggregator.onBlurDrawableUpdated(this);
        }
    }

    public void setCornerRadius(float cornerRadius) {
        this.setCornerRadius(cornerRadius, cornerRadius, cornerRadius, cornerRadius);
    }

    public void setCornerRadius(float cornerRadiusTL, float cornerRadiusTR, float cornerRadiusBL, float cornerRadiusBR) {
        if (this.mCornerRadiusTL != cornerRadiusTL || this.mCornerRadiusTR != cornerRadiusTR || this.mCornerRadiusBL != cornerRadiusBL || this.mCornerRadiusBR != cornerRadiusBR) {
            this.mCornerRadiusTL = cornerRadiusTL;
            this.mCornerRadiusTR = cornerRadiusTR;
            this.mCornerRadiusBL = cornerRadiusBL;
            this.mCornerRadiusBR = cornerRadiusBR;
            this.updatePath();
            this.invalidateSelf();
            this.mAggregator.onBlurDrawableUpdated(this);
        }
    }

    @Override
    public void setBounds(int left, int top, int right, int bottom) {
        super.setBounds(left, top, right, bottom);
        this.mRenderNode.setPosition(left, top, right, bottom);
        this.updatePath();
    }

    private void updatePath() {
        this.mTmpRadii[0] = this.mTmpRadii[1] = this.mCornerRadiusTL;
        this.mTmpRadii[2] = this.mTmpRadii[3] = this.mCornerRadiusTR;
        this.mTmpRadii[4] = this.mTmpRadii[5] = this.mCornerRadiusBL;
        this.mTmpRadii[6] = this.mTmpRadii[7] = this.mCornerRadiusBR;
        this.mRectPath.reset();
        if (this.getAlpha() == 0 || !this.isVisible()) {
            return;
        }
        Rect bounds = this.getBounds();
        this.mRectPath.addRoundRect(bounds.left, bounds.top, bounds.right, bounds.bottom, this.mTmpRadii, Path.Direction.CW);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        throw new IllegalArgumentException("not implemented");
    }

    @Override
    public int getOpacity() {
        return -3;
    }

    public String toString() {
        return "BackgroundBlurDrawable{blurRadius=" + this.mBlurRadius + ", corners={" + this.mCornerRadiusTL + "," + this.mCornerRadiusTR + "," + this.mCornerRadiusBL + "," + this.mCornerRadiusBR + "}, alpha=" + this.mAlpha + ", visible=" + this.mVisible + "}";
    }

    public static class Aggregator {
        private final Object mRtLock = new Object();
        private final ArraySet<BackgroundBlurDrawable> mDrawables = new ArraySet();
        @GuardedBy(value={"mRtLock"})
        private final LongSparseArray<ArraySet<Runnable>> mFrameRtUpdates = new LongSparseArray();
        private long mLastFrameNumber = 0L;
        private BlurRegion[] mLastFrameBlurRegions = null;
        private final ViewRootImpl mViewRoot;
        private BlurRegion[] mTmpBlurRegionsForFrame = new BlurRegion[0];
        private boolean mHasUiUpdates;
        private ViewTreeObserver.OnPreDrawListener mOnPreDrawListener;

        public Aggregator(ViewRootImpl viewRoot) {
            this.mViewRoot = viewRoot;
        }

        public BackgroundBlurDrawable createBackgroundBlurDrawable(Context context) {
            BackgroundBlurDrawable drawable2 = new BackgroundBlurDrawable(this);
            drawable2.setBlurRadius(context.getResources().getDimensionPixelSize(17105183));
            return drawable2;
        }

        void onBlurDrawableUpdated(BackgroundBlurDrawable drawable2) {
            boolean shouldBeDrawn = drawable2.mAlpha != 0.0f && drawable2.mBlurRadius > 0 && drawable2.mVisible;
            boolean isDrawn = this.mDrawables.contains(drawable2);
            if (shouldBeDrawn) {
                this.mHasUiUpdates = true;
                if (!isDrawn) {
                    this.mDrawables.add(drawable2);
                    if (DEBUG) {
                        Log.d(TAG, "Add " + drawable2);
                    }
                } else if (DEBUG) {
                    Log.d(TAG, "Update " + drawable2);
                }
            } else if (!shouldBeDrawn && isDrawn) {
                this.mHasUiUpdates = true;
                this.mDrawables.remove(drawable2);
                if (DEBUG) {
                    Log.d(TAG, "Remove " + drawable2);
                }
            }
            if (this.mOnPreDrawListener == null && this.mViewRoot.getView() != null && this.hasRegions()) {
                this.registerPreDrawListener();
            }
        }

        private void registerPreDrawListener() {
            this.mOnPreDrawListener = () -> {
                boolean hasUiUpdates = this.hasUpdates();
                if (hasUiUpdates || this.hasRegions()) {
                    BlurRegion[] blurRegionsForNextFrame = this.getBlurRegionsCopyForRT();
                    this.mViewRoot.registerRtFrameCallback(frame -> {
                        Object object = this.mRtLock;
                        synchronized (object) {
                            this.mLastFrameNumber = frame;
                            this.mLastFrameBlurRegions = blurRegionsForNextFrame;
                            this.handleDispatchBlurTransactionLocked(frame, blurRegionsForNextFrame, hasUiUpdates);
                        }
                    });
                }
                if (!this.hasRegions() && this.mViewRoot.getView() != null) {
                    this.mViewRoot.getView().getViewTreeObserver().removeOnPreDrawListener(this.mOnPreDrawListener);
                    this.mOnPreDrawListener = null;
                }
                return true;
            };
            this.mViewRoot.getView().getViewTreeObserver().addOnPreDrawListener(this.mOnPreDrawListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onRenderNodePositionChanged(long frameNumber, Runnable update) {
            Object object = this.mRtLock;
            synchronized (object) {
                ArraySet<Runnable> frameRtUpdates = this.mFrameRtUpdates.get(frameNumber);
                if (frameRtUpdates == null) {
                    frameRtUpdates = new ArraySet();
                    this.mFrameRtUpdates.put(frameNumber, frameRtUpdates);
                }
                frameRtUpdates.add(update);
                if (this.mLastFrameNumber == frameNumber) {
                    this.handleDispatchBlurTransactionLocked(frameNumber, this.mLastFrameBlurRegions, true);
                }
            }
        }

        public boolean hasUpdates() {
            return this.mHasUiUpdates;
        }

        public boolean hasRegions() {
            return this.mDrawables.size() > 0;
        }

        public BlurRegion[] getBlurRegionsCopyForRT() {
            if (this.mHasUiUpdates) {
                this.mTmpBlurRegionsForFrame = new BlurRegion[this.mDrawables.size()];
                for (int i = 0; i < this.mDrawables.size(); ++i) {
                    this.mTmpBlurRegionsForFrame[i] = new BlurRegion(this.mDrawables.valueAt(i));
                }
                this.mHasUiUpdates = false;
            }
            return this.mTmpBlurRegionsForFrame;
        }

        @GuardedBy(value={"mRtLock"})
        @VisibleForTesting
        public float[][] getBlurRegionsForFrameLocked(long frameNumber, BlurRegion[] blurRegionsForFrame, boolean forceUpdate) {
            int i;
            if (!(forceUpdate || this.mFrameRtUpdates.size() != 0 && this.mFrameRtUpdates.keyAt(0) <= frameNumber)) {
                return null;
            }
            while (this.mFrameRtUpdates.size() != 0 && this.mFrameRtUpdates.keyAt(0) <= frameNumber) {
                ArraySet<Runnable> frameUpdates = this.mFrameRtUpdates.valueAt(0);
                this.mFrameRtUpdates.removeAt(0);
                for (i = 0; i < frameUpdates.size(); ++i) {
                    frameUpdates.valueAt(i).run();
                }
            }
            if (DEBUG) {
                Log.d(TAG, "Dispatching " + blurRegionsForFrame.length + " blur regions:");
            }
            float[][] blurRegionsArray = new float[blurRegionsForFrame.length][];
            for (i = 0; i < blurRegionsArray.length; ++i) {
                blurRegionsArray[i] = blurRegionsForFrame[i].toFloatArray();
                if (!DEBUG) continue;
                Log.d(TAG, blurRegionsForFrame[i].toString());
            }
            return blurRegionsArray;
        }

        @GuardedBy(value={"mRtLock"})
        private void handleDispatchBlurTransactionLocked(long frameNumber, BlurRegion[] blurRegions, boolean forceUpdate) {
            float[][] blurRegionsArray = this.getBlurRegionsForFrameLocked(frameNumber, blurRegions, forceUpdate);
            if (blurRegionsArray != null) {
                this.mViewRoot.dispatchBlurRegions(blurRegionsArray, frameNumber);
            }
        }
    }

    public static class BlurRegion {
        public final int blurRadius;
        public final float cornerRadiusTL;
        public final float cornerRadiusTR;
        public final float cornerRadiusBL;
        public final float cornerRadiusBR;
        public final float alpha;
        public final Rect rect;

        BlurRegion(BackgroundBlurDrawable drawable2) {
            this.alpha = drawable2.mAlpha;
            this.blurRadius = drawable2.mBlurRadius;
            this.cornerRadiusTL = drawable2.mCornerRadiusTL;
            this.cornerRadiusTR = drawable2.mCornerRadiusTR;
            this.cornerRadiusBL = drawable2.mCornerRadiusBL;
            this.cornerRadiusBR = drawable2.mCornerRadiusBR;
            this.rect = drawable2.mRect;
        }

        float[] toFloatArray() {
            float[] floatArray = new float[]{this.blurRadius, this.alpha, this.rect.left, this.rect.top, this.rect.right, this.rect.bottom, this.cornerRadiusTL, this.cornerRadiusTR, this.cornerRadiusBL, this.cornerRadiusBR};
            return floatArray;
        }

        public String toString() {
            return "BlurRegion{blurRadius=" + this.blurRadius + ", corners={" + this.cornerRadiusTL + "," + this.cornerRadiusTR + "," + this.cornerRadiusBL + "," + this.cornerRadiusBR + "}, alpha=" + this.alpha + ", rect=" + this.rect + "}";
        }
    }
}

