/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.graphics.palette;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Rect;
import android.os.AsyncTask;
import android.util.Log;
import com.android.internal.graphics.palette.ColorCutQuantizer;
import com.android.internal.graphics.palette.Quantizer;
import java.util.Collections;
import java.util.List;

public class Palette {
    static final int DEFAULT_RESIZE_BITMAP_AREA = 12544;
    static final int DEFAULT_CALCULATE_NUMBER_COLORS = 16;
    static final String LOG_TAG = "Palette";
    private final List<Swatch> mSwatches;
    private final Swatch mDominantSwatch;
    static final Filter DEFAULT_FILTER = new Filter(){
        private static final float BLACK_MAX_LIGHTNESS = 0.05f;
        private static final float WHITE_MIN_LIGHTNESS = 0.95f;

        @Override
        public boolean isAllowed(int rgb, float[] hsl) {
            return !this.isWhite(hsl) && !this.isBlack(hsl) && !this.isNearRedILine(hsl);
        }

        private boolean isBlack(float[] hslColor) {
            return hslColor[2] <= 0.05f;
        }

        private boolean isWhite(float[] hslColor) {
            return hslColor[2] >= 0.95f;
        }

        private boolean isNearRedILine(float[] hslColor) {
            return hslColor[0] >= 10.0f && hslColor[0] <= 37.0f && hslColor[1] <= 0.82f;
        }
    };

    public static Builder from(Bitmap bitmap, Quantizer quantizer) {
        return new Builder(bitmap, quantizer);
    }

    public static Palette from(List<Swatch> swatches) {
        return new Builder(swatches).generate();
    }

    Palette(List<Swatch> swatches) {
        this.mSwatches = swatches;
        this.mDominantSwatch = this.findDominantSwatch();
    }

    public List<Swatch> getSwatches() {
        return Collections.unmodifiableList(this.mSwatches);
    }

    public Swatch getDominantSwatch() {
        return this.mDominantSwatch;
    }

    private Swatch findDominantSwatch() {
        int maxPop = Integer.MIN_VALUE;
        Swatch maxSwatch = null;
        int count = this.mSwatches.size();
        for (int i = 0; i < count; ++i) {
            Swatch swatch = this.mSwatches.get(i);
            if (swatch.getPopulation() <= maxPop) continue;
            maxSwatch = swatch;
            maxPop = swatch.getPopulation();
        }
        return maxSwatch;
    }

    public static class Builder {
        private final List<Swatch> mSwatches;
        private final Bitmap mBitmap;
        private Quantizer mQuantizer = new ColorCutQuantizer();
        private int mMaxColors = 16;
        private int mResizeArea = 12544;
        private int mResizeMaxDimension = -1;
        private Rect mRegion;

        public Builder(Bitmap bitmap, Quantizer quantizer) {
            if (bitmap == null || bitmap.isRecycled()) {
                throw new IllegalArgumentException("Bitmap is not valid");
            }
            this.mSwatches = null;
            this.mBitmap = bitmap;
            this.mQuantizer = quantizer == null ? new ColorCutQuantizer() : quantizer;
        }

        public Builder(List<Swatch> swatches) {
            if (swatches == null || swatches.isEmpty()) {
                throw new IllegalArgumentException("List of Swatches is not valid");
            }
            this.mSwatches = swatches;
            this.mBitmap = null;
            this.mQuantizer = null;
        }

        public Builder maximumColorCount(int colors) {
            this.mMaxColors = colors;
            return this;
        }

        @Deprecated
        public Builder resizeBitmapSize(int maxDimension) {
            this.mResizeMaxDimension = maxDimension;
            this.mResizeArea = -1;
            return this;
        }

        public Builder resizeBitmapArea(int area) {
            this.mResizeArea = area;
            this.mResizeMaxDimension = -1;
            return this;
        }

        public Builder setRegion(int left, int top, int right, int bottom) {
            if (this.mBitmap != null) {
                if (this.mRegion == null) {
                    this.mRegion = new Rect();
                }
                this.mRegion.set(0, 0, this.mBitmap.getWidth(), this.mBitmap.getHeight());
                if (!this.mRegion.intersect(left, top, right, bottom)) {
                    throw new IllegalArgumentException("The given region must intersect with the Bitmap's dimensions.");
                }
            }
            return this;
        }

        public Builder clearRegion() {
            this.mRegion = null;
            return this;
        }

        public Palette generate() {
            List<Swatch> swatches;
            if (this.mBitmap != null) {
                Bitmap bitmap = this.scaleBitmapDown(this.mBitmap);
                Rect region = this.mRegion;
                if (bitmap != this.mBitmap && region != null) {
                    double scale = (double)bitmap.getWidth() / (double)this.mBitmap.getWidth();
                    region.left = (int)Math.floor((double)region.left * scale);
                    region.top = (int)Math.floor((double)region.top * scale);
                    region.right = Math.min((int)Math.ceil((double)region.right * scale), bitmap.getWidth());
                    region.bottom = Math.min((int)Math.ceil((double)region.bottom * scale), bitmap.getHeight());
                }
                this.mQuantizer.quantize(this.getPixelsFromBitmap(bitmap), this.mMaxColors);
                if (bitmap != this.mBitmap) {
                    bitmap.recycle();
                }
                swatches = this.mQuantizer.getQuantizedColors();
            } else if (this.mSwatches != null) {
                swatches = this.mSwatches;
            } else {
                throw new AssertionError();
            }
            Palette p = new Palette(swatches);
            return p;
        }

        @Deprecated
        public AsyncTask<Bitmap, Void, Palette> generate(final PaletteAsyncListener listener) {
            assert (listener != null);
            return new AsyncTask<Bitmap, Void, Palette>(){

                protected Palette doInBackground(Bitmap ... params) {
                    try {
                        return this.generate();
                    }
                    catch (Exception e) {
                        Log.e(Palette.LOG_TAG, "Exception thrown during async generate", e);
                        return null;
                    }
                }

                @Override
                protected void onPostExecute(Palette colorExtractor) {
                    listener.onGenerated(colorExtractor);
                }
            }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, this.mBitmap);
        }

        private int[] getPixelsFromBitmap(Bitmap bitmap) {
            int bitmapWidth = bitmap.getWidth();
            int bitmapHeight = bitmap.getHeight();
            int[] pixels = new int[bitmapWidth * bitmapHeight];
            bitmap.getPixels(pixels, 0, bitmapWidth, 0, 0, bitmapWidth, bitmapHeight);
            if (this.mRegion == null) {
                return pixels;
            }
            int regionWidth = this.mRegion.width();
            int regionHeight = this.mRegion.height();
            int[] subsetPixels = new int[regionWidth * regionHeight];
            for (int row = 0; row < regionHeight; ++row) {
                System.arraycopy(pixels, (row + this.mRegion.top) * bitmapWidth + this.mRegion.left, subsetPixels, row * regionWidth, regionWidth);
            }
            return subsetPixels;
        }

        private Bitmap scaleBitmapDown(Bitmap bitmap) {
            int maxDimension;
            double scaleRatio = -1.0;
            if (this.mResizeArea > 0) {
                int bitmapArea = bitmap.getWidth() * bitmap.getHeight();
                if (bitmapArea > this.mResizeArea) {
                    scaleRatio = Math.sqrt((double)this.mResizeArea / (double)bitmapArea);
                }
            } else if (this.mResizeMaxDimension > 0 && (maxDimension = Math.max(bitmap.getWidth(), bitmap.getHeight())) > this.mResizeMaxDimension) {
                scaleRatio = (double)this.mResizeMaxDimension / (double)maxDimension;
            }
            if (scaleRatio <= 0.0) {
                return bitmap;
            }
            return Bitmap.createScaledBitmap(bitmap, (int)Math.ceil((double)bitmap.getWidth() * scaleRatio), (int)Math.ceil((double)bitmap.getHeight() * scaleRatio), false);
        }
    }

    public static class Swatch {
        private final Color mColor;
        private final int mPopulation;

        public Swatch(int colorInt, int population) {
            this.mColor = Color.valueOf(colorInt);
            this.mPopulation = population;
        }

        public int getInt() {
            return this.mColor.toArgb();
        }

        public int getPopulation() {
            return this.mPopulation;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [" + this.mColor + ']' + " [Population: " + this.mPopulation + ']';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Swatch swatch = (Swatch)o;
            return this.mPopulation == swatch.mPopulation && this.mColor.toArgb() == swatch.mColor.toArgb();
        }

        public int hashCode() {
            return 31 * this.mColor.toArgb() + this.mPopulation;
        }
    }

    public static interface Filter {
        public boolean isAllowed(int var1, float[] var2);
    }

    public static interface PaletteAsyncListener {
        public void onGenerated(Palette var1);
    }
}

