/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.annotation.EnforcePermission;
import android.annotation.RequiresPermission;
import android.app.ActivityThread;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PermissionEnforcer;
import android.os.RemoteException;
import android.view.inputmethod.ImeTracker;

public interface IImeTracker
extends IInterface {
    public static final String DESCRIPTOR = "com.android.internal.inputmethod.IImeTracker";

    public ImeTracker.Token onRequestShow(String var1, int var2, int var3, int var4) throws RemoteException;

    public ImeTracker.Token onRequestHide(String var1, int var2, int var3, int var4) throws RemoteException;

    public void onProgress(IBinder var1, int var2) throws RemoteException;

    public void onFailed(ImeTracker.Token var1, int var2) throws RemoteException;

    public void onCancelled(ImeTracker.Token var1, int var2) throws RemoteException;

    public void onShown(ImeTracker.Token var1) throws RemoteException;

    public void onHidden(ImeTracker.Token var1) throws RemoteException;

    @RequiresPermission(value="android.permission.TEST_INPUT_METHOD")
    @EnforcePermission(value="android.permission.TEST_INPUT_METHOD")
    public boolean hasPendingImeVisibilityRequests() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IImeTracker {
        private final PermissionEnforcer mEnforcer;
        static final int TRANSACTION_onRequestShow = 1;
        static final int TRANSACTION_onRequestHide = 2;
        static final int TRANSACTION_onProgress = 3;
        static final int TRANSACTION_onFailed = 4;
        static final int TRANSACTION_onCancelled = 5;
        static final int TRANSACTION_onShown = 6;
        static final int TRANSACTION_onHidden = 7;
        static final int TRANSACTION_hasPendingImeVisibilityRequests = 8;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, IImeTracker.DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentActivityThread().getSystemContext()));
        }

        public static IImeTracker asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IImeTracker.DESCRIPTOR);
            if (iin != null && iin instanceof IImeTracker) {
                return (IImeTracker)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onRequestShow";
                }
                case 2: {
                    return "onRequestHide";
                }
                case 3: {
                    return "onProgress";
                }
                case 4: {
                    return "onFailed";
                }
                case 5: {
                    return "onCancelled";
                }
                case 6: {
                    return "onShown";
                }
                case 7: {
                    return "onHidden";
                }
                case 8: {
                    return "hasPendingImeVisibilityRequests";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IImeTracker.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    ImeTracker.Token _result = this.onRequestShow(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    ImeTracker.Token _result = this.onRequestHide(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 3: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onProgress(_arg0, _arg1);
                    break;
                }
                case 4: {
                    ImeTracker.Token _arg0 = data.readTypedObject(ImeTracker.Token.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onFailed(_arg0, _arg1);
                    break;
                }
                case 5: {
                    ImeTracker.Token _arg0 = data.readTypedObject(ImeTracker.Token.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onCancelled(_arg0, _arg1);
                    break;
                }
                case 6: {
                    ImeTracker.Token _arg0 = data.readTypedObject(ImeTracker.Token.CREATOR);
                    data.enforceNoDataAvail();
                    this.onShown(_arg0);
                    break;
                }
                case 7: {
                    ImeTracker.Token _arg0 = data.readTypedObject(ImeTracker.Token.CREATOR);
                    data.enforceNoDataAvail();
                    this.onHidden(_arg0);
                    break;
                }
                case 8: {
                    boolean _result = this.hasPendingImeVisibilityRequests();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void hasPendingImeVisibilityRequests_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.TEST_INPUT_METHOD", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 7;
        }

        private static class Proxy
        implements IImeTracker {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IImeTracker.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ImeTracker.Token onRequestShow(String tag, int uid, int origin, int reason) throws RemoteException {
                ImeTracker.Token _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IImeTracker.DESCRIPTOR);
                    _data.writeString(tag);
                    _data.writeInt(uid);
                    _data.writeInt(origin);
                    _data.writeInt(reason);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ImeTracker.Token.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ImeTracker.Token onRequestHide(String tag, int uid, int origin, int reason) throws RemoteException {
                ImeTracker.Token _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IImeTracker.DESCRIPTOR);
                    _data.writeString(tag);
                    _data.writeInt(uid);
                    _data.writeInt(origin);
                    _data.writeInt(reason);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ImeTracker.Token.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onProgress(IBinder binder, int phase) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImeTracker.DESCRIPTOR);
                    _data.writeStrongBinder(binder);
                    _data.writeInt(phase);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailed(ImeTracker.Token statsToken, int phase) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImeTracker.DESCRIPTOR);
                    _data.writeTypedObject(statsToken, 0);
                    _data.writeInt(phase);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCancelled(ImeTracker.Token statsToken, int phase) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImeTracker.DESCRIPTOR);
                    _data.writeTypedObject(statsToken, 0);
                    _data.writeInt(phase);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onShown(ImeTracker.Token statsToken) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImeTracker.DESCRIPTOR);
                    _data.writeTypedObject(statsToken, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onHidden(ImeTracker.Token statsToken) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImeTracker.DESCRIPTOR);
                    _data.writeTypedObject(statsToken, 0);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasPendingImeVisibilityRequests() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IImeTracker.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IImeTracker {
        @Override
        public ImeTracker.Token onRequestShow(String tag, int uid, int origin, int reason) throws RemoteException {
            return null;
        }

        @Override
        public ImeTracker.Token onRequestHide(String tag, int uid, int origin, int reason) throws RemoteException {
            return null;
        }

        @Override
        public void onProgress(IBinder binder, int phase) throws RemoteException {
        }

        @Override
        public void onFailed(ImeTracker.Token statsToken, int phase) throws RemoteException {
        }

        @Override
        public void onCancelled(ImeTracker.Token statsToken, int phase) throws RemoteException {
        }

        @Override
        public void onShown(ImeTracker.Token statsToken) throws RemoteException {
        }

        @Override
        public void onHidden(ImeTracker.Token statsToken) throws RemoteException {
        }

        @Override
        public boolean hasPendingImeVisibilityRequests() throws RemoteException {
            return false;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

