/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.os.BadParcelableException;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.view.InputChannel;
import android.view.MotionEvent;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ImeTracker;
import android.view.inputmethod.InputBinding;
import android.view.inputmethod.InputMethodSubtype;
import android.window.ImeOnBackInvokedDispatcher;
import com.android.internal.inputmethod.IInlineSuggestionsRequestCallback;
import com.android.internal.inputmethod.IInputMethodPrivilegedOperations;
import com.android.internal.inputmethod.IInputMethodSession;
import com.android.internal.inputmethod.IInputMethodSessionCallback;
import com.android.internal.inputmethod.IRemoteInputConnection;
import com.android.internal.inputmethod.InlineSuggestionsRequestInfo;
import java.util.ArrayList;
import java.util.List;

public interface IInputMethod
extends IInterface {
    public static final String DESCRIPTOR = "com.android.internal.inputmethod.IInputMethod";

    public void initializeInternal(InitParams var1) throws RemoteException;

    public void onCreateInlineSuggestionsRequest(InlineSuggestionsRequestInfo var1, IInlineSuggestionsRequestCallback var2) throws RemoteException;

    public void bindInput(InputBinding var1) throws RemoteException;

    public void unbindInput() throws RemoteException;

    public void startInput(StartInputParams var1) throws RemoteException;

    public void onNavButtonFlagsChanged(int var1) throws RemoteException;

    public void createSession(InputChannel var1, IInputMethodSessionCallback var2) throws RemoteException;

    public void setSessionEnabled(IInputMethodSession var1, boolean var2) throws RemoteException;

    public void showSoftInput(IBinder var1, ImeTracker.Token var2, int var3, ResultReceiver var4) throws RemoteException;

    public void hideSoftInput(IBinder var1, ImeTracker.Token var2, int var3, ResultReceiver var4) throws RemoteException;

    public void updateEditorToolType(int var1) throws RemoteException;

    public void changeInputMethodSubtype(InputMethodSubtype var1) throws RemoteException;

    public void canStartStylusHandwriting(int var1) throws RemoteException;

    public void startStylusHandwriting(int var1, InputChannel var2, List<MotionEvent> var3) throws RemoteException;

    public void initInkWindow() throws RemoteException;

    public void finishStylusHandwriting() throws RemoteException;

    public void removeStylusHandwritingWindow() throws RemoteException;

    public void setStylusWindowIdleTimeoutForTest(long var1) throws RemoteException;

    public static class StartInputParams
    implements Parcelable {
        public IBinder startInputToken;
        public IRemoteInputConnection remoteInputConnection;
        public EditorInfo editorInfo;
        public boolean restarting = false;
        public int navigationBarFlags = 0;
        public ImeOnBackInvokedDispatcher imeDispatcher;
        public static final Parcelable.Creator<StartInputParams> CREATOR = new Parcelable.Creator<StartInputParams>(){

            @Override
            public StartInputParams createFromParcel(Parcel _aidl_source) {
                StartInputParams _aidl_out = new StartInputParams();
                _aidl_out.readFromParcel(_aidl_source);
                return _aidl_out;
            }

            public StartInputParams[] newArray(int _aidl_size) {
                return new StartInputParams[_aidl_size];
            }
        };

        @Override
        public void writeToParcel(Parcel _aidl_parcel, int _aidl_flag) {
            int _aidl_start_pos = _aidl_parcel.dataPosition();
            _aidl_parcel.writeInt(0);
            _aidl_parcel.writeStrongBinder(this.startInputToken);
            _aidl_parcel.writeStrongInterface(this.remoteInputConnection);
            _aidl_parcel.writeTypedObject(this.editorInfo, _aidl_flag);
            _aidl_parcel.writeBoolean(this.restarting);
            _aidl_parcel.writeInt(this.navigationBarFlags);
            _aidl_parcel.writeTypedObject(this.imeDispatcher, _aidl_flag);
            int _aidl_end_pos = _aidl_parcel.dataPosition();
            _aidl_parcel.setDataPosition(_aidl_start_pos);
            _aidl_parcel.writeInt(_aidl_end_pos - _aidl_start_pos);
            _aidl_parcel.setDataPosition(_aidl_end_pos);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFromParcel(Parcel _aidl_parcel) {
            int _aidl_start_pos = _aidl_parcel.dataPosition();
            int _aidl_parcelable_size = _aidl_parcel.readInt();
            try {
                if (_aidl_parcelable_size < 4) {
                    throw new BadParcelableException("Parcelable too small");
                }
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.startInputToken = _aidl_parcel.readStrongBinder();
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.remoteInputConnection = IRemoteInputConnection.Stub.asInterface(_aidl_parcel.readStrongBinder());
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.editorInfo = _aidl_parcel.readTypedObject(EditorInfo.CREATOR);
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.restarting = _aidl_parcel.readBoolean();
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.navigationBarFlags = _aidl_parcel.readInt();
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.imeDispatcher = _aidl_parcel.readTypedObject(ImeOnBackInvokedDispatcher.CREATOR);
            }
            finally {
                if (_aidl_start_pos > Integer.MAX_VALUE - _aidl_parcelable_size) {
                    throw new BadParcelableException("Overflow in the size of parcelable");
                }
                _aidl_parcel.setDataPosition(_aidl_start_pos + _aidl_parcelable_size);
            }
        }

        @Override
        public int describeContents() {
            int _mask = 0;
            _mask |= this.describeContents(this.editorInfo);
            return _mask |= this.describeContents(this.imeDispatcher);
        }

        private int describeContents(Object _v) {
            if (_v == null) {
                return 0;
            }
            if (_v instanceof Parcelable) {
                return ((Parcelable)_v).describeContents();
            }
            return 0;
        }
    }

    public static class InitParams
    implements Parcelable {
        public IBinder token;
        public IInputMethodPrivilegedOperations privilegedOperations;
        public int navigationBarFlags = 0;
        public static final Parcelable.Creator<InitParams> CREATOR = new Parcelable.Creator<InitParams>(){

            @Override
            public InitParams createFromParcel(Parcel _aidl_source) {
                InitParams _aidl_out = new InitParams();
                _aidl_out.readFromParcel(_aidl_source);
                return _aidl_out;
            }

            public InitParams[] newArray(int _aidl_size) {
                return new InitParams[_aidl_size];
            }
        };

        @Override
        public void writeToParcel(Parcel _aidl_parcel, int _aidl_flag) {
            int _aidl_start_pos = _aidl_parcel.dataPosition();
            _aidl_parcel.writeInt(0);
            _aidl_parcel.writeStrongBinder(this.token);
            _aidl_parcel.writeStrongInterface(this.privilegedOperations);
            _aidl_parcel.writeInt(this.navigationBarFlags);
            int _aidl_end_pos = _aidl_parcel.dataPosition();
            _aidl_parcel.setDataPosition(_aidl_start_pos);
            _aidl_parcel.writeInt(_aidl_end_pos - _aidl_start_pos);
            _aidl_parcel.setDataPosition(_aidl_end_pos);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFromParcel(Parcel _aidl_parcel) {
            int _aidl_start_pos = _aidl_parcel.dataPosition();
            int _aidl_parcelable_size = _aidl_parcel.readInt();
            try {
                if (_aidl_parcelable_size < 4) {
                    throw new BadParcelableException("Parcelable too small");
                }
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.token = _aidl_parcel.readStrongBinder();
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.privilegedOperations = IInputMethodPrivilegedOperations.Stub.asInterface(_aidl_parcel.readStrongBinder());
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.navigationBarFlags = _aidl_parcel.readInt();
            }
            finally {
                if (_aidl_start_pos > Integer.MAX_VALUE - _aidl_parcelable_size) {
                    throw new BadParcelableException("Overflow in the size of parcelable");
                }
                _aidl_parcel.setDataPosition(_aidl_start_pos + _aidl_parcelable_size);
            }
        }

        @Override
        public int describeContents() {
            int _mask = 0;
            return _mask;
        }
    }

    public static abstract class Stub
    extends Binder
    implements IInputMethod {
        static final int TRANSACTION_initializeInternal = 1;
        static final int TRANSACTION_onCreateInlineSuggestionsRequest = 2;
        static final int TRANSACTION_bindInput = 3;
        static final int TRANSACTION_unbindInput = 4;
        static final int TRANSACTION_startInput = 5;
        static final int TRANSACTION_onNavButtonFlagsChanged = 6;
        static final int TRANSACTION_createSession = 7;
        static final int TRANSACTION_setSessionEnabled = 8;
        static final int TRANSACTION_showSoftInput = 9;
        static final int TRANSACTION_hideSoftInput = 10;
        static final int TRANSACTION_updateEditorToolType = 11;
        static final int TRANSACTION_changeInputMethodSubtype = 12;
        static final int TRANSACTION_canStartStylusHandwriting = 13;
        static final int TRANSACTION_startStylusHandwriting = 14;
        static final int TRANSACTION_initInkWindow = 15;
        static final int TRANSACTION_finishStylusHandwriting = 16;
        static final int TRANSACTION_removeStylusHandwritingWindow = 17;
        static final int TRANSACTION_setStylusWindowIdleTimeoutForTest = 18;

        public Stub() {
            this.attachInterface(this, IInputMethod.DESCRIPTOR);
        }

        public static IInputMethod asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IInputMethod.DESCRIPTOR);
            if (iin != null && iin instanceof IInputMethod) {
                return (IInputMethod)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "initializeInternal";
                }
                case 2: {
                    return "onCreateInlineSuggestionsRequest";
                }
                case 3: {
                    return "bindInput";
                }
                case 4: {
                    return "unbindInput";
                }
                case 5: {
                    return "startInput";
                }
                case 6: {
                    return "onNavButtonFlagsChanged";
                }
                case 7: {
                    return "createSession";
                }
                case 8: {
                    return "setSessionEnabled";
                }
                case 9: {
                    return "showSoftInput";
                }
                case 10: {
                    return "hideSoftInput";
                }
                case 11: {
                    return "updateEditorToolType";
                }
                case 12: {
                    return "changeInputMethodSubtype";
                }
                case 13: {
                    return "canStartStylusHandwriting";
                }
                case 14: {
                    return "startStylusHandwriting";
                }
                case 15: {
                    return "initInkWindow";
                }
                case 16: {
                    return "finishStylusHandwriting";
                }
                case 17: {
                    return "removeStylusHandwritingWindow";
                }
                case 18: {
                    return "setStylusWindowIdleTimeoutForTest";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IInputMethod.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    InitParams _arg0 = data.readTypedObject(InitParams.CREATOR);
                    data.enforceNoDataAvail();
                    this.initializeInternal(_arg0);
                    break;
                }
                case 2: {
                    InlineSuggestionsRequestInfo _arg0 = data.readTypedObject(InlineSuggestionsRequestInfo.CREATOR);
                    IInlineSuggestionsRequestCallback _arg1 = IInlineSuggestionsRequestCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.onCreateInlineSuggestionsRequest(_arg0, _arg1);
                    break;
                }
                case 3: {
                    InputBinding _arg0 = data.readTypedObject(InputBinding.CREATOR);
                    data.enforceNoDataAvail();
                    this.bindInput(_arg0);
                    break;
                }
                case 4: {
                    this.unbindInput();
                    break;
                }
                case 5: {
                    StartInputParams _arg0 = data.readTypedObject(StartInputParams.CREATOR);
                    data.enforceNoDataAvail();
                    this.startInput(_arg0);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onNavButtonFlagsChanged(_arg0);
                    break;
                }
                case 7: {
                    InputChannel _arg0 = data.readTypedObject(InputChannel.CREATOR);
                    IInputMethodSessionCallback _arg1 = IInputMethodSessionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.createSession(_arg0, _arg1);
                    break;
                }
                case 8: {
                    IInputMethodSession _arg0 = IInputMethodSession.Stub.asInterface(data.readStrongBinder());
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setSessionEnabled(_arg0, _arg1);
                    break;
                }
                case 9: {
                    IBinder _arg0 = data.readStrongBinder();
                    ImeTracker.Token _arg1 = data.readTypedObject(ImeTracker.Token.CREATOR);
                    int _arg2 = data.readInt();
                    ResultReceiver _arg3 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.showSoftInput(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 10: {
                    IBinder _arg0 = data.readStrongBinder();
                    ImeTracker.Token _arg1 = data.readTypedObject(ImeTracker.Token.CREATOR);
                    int _arg2 = data.readInt();
                    ResultReceiver _arg3 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.hideSoftInput(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.updateEditorToolType(_arg0);
                    break;
                }
                case 12: {
                    InputMethodSubtype _arg0 = data.readTypedObject(InputMethodSubtype.CREATOR);
                    data.enforceNoDataAvail();
                    this.changeInputMethodSubtype(_arg0);
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.canStartStylusHandwriting(_arg0);
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    InputChannel _arg1 = data.readTypedObject(InputChannel.CREATOR);
                    ArrayList<MotionEvent> _arg2 = data.createTypedArrayList(MotionEvent.CREATOR);
                    data.enforceNoDataAvail();
                    this.startStylusHandwriting(_arg0, _arg1, _arg2);
                    break;
                }
                case 15: {
                    this.initInkWindow();
                    break;
                }
                case 16: {
                    this.finishStylusHandwriting();
                    break;
                }
                case 17: {
                    this.removeStylusHandwritingWindow();
                    break;
                }
                case 18: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.setStylusWindowIdleTimeoutForTest(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 17;
        }

        private static class Proxy
        implements IInputMethod {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IInputMethod.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void initializeInternal(InitParams params) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethod.DESCRIPTOR);
                    _data.writeTypedObject(params, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCreateInlineSuggestionsRequest(InlineSuggestionsRequestInfo requestInfo, IInlineSuggestionsRequestCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethod.DESCRIPTOR);
                    _data.writeTypedObject(requestInfo, 0);
                    _data.writeStrongInterface(cb);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void bindInput(InputBinding binding) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethod.DESCRIPTOR);
                    _data.writeTypedObject(binding, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void unbindInput() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethod.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startInput(StartInputParams params) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethod.DESCRIPTOR);
                    _data.writeTypedObject(params, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNavButtonFlagsChanged(int navButtonFlags) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethod.DESCRIPTOR);
                    _data.writeInt(navButtonFlags);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createSession(InputChannel channel, IInputMethodSessionCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethod.DESCRIPTOR);
                    _data.writeTypedObject(channel, 0);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSessionEnabled(IInputMethodSession session, boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethod.DESCRIPTOR);
                    _data.writeStrongInterface(session);
                    _data.writeBoolean(enabled);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showSoftInput(IBinder showInputToken, ImeTracker.Token statsToken, int flags, ResultReceiver resultReceiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethod.DESCRIPTOR);
                    _data.writeStrongBinder(showInputToken);
                    _data.writeTypedObject(statsToken, 0);
                    _data.writeInt(flags);
                    _data.writeTypedObject(resultReceiver, 0);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hideSoftInput(IBinder hideInputToken, ImeTracker.Token statsToken, int flags, ResultReceiver resultReceiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethod.DESCRIPTOR);
                    _data.writeStrongBinder(hideInputToken);
                    _data.writeTypedObject(statsToken, 0);
                    _data.writeInt(flags);
                    _data.writeTypedObject(resultReceiver, 0);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateEditorToolType(int toolType) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethod.DESCRIPTOR);
                    _data.writeInt(toolType);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void changeInputMethodSubtype(InputMethodSubtype subtype) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethod.DESCRIPTOR);
                    _data.writeTypedObject(subtype, 0);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void canStartStylusHandwriting(int requestId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethod.DESCRIPTOR);
                    _data.writeInt(requestId);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startStylusHandwriting(int requestId, InputChannel channel, List<MotionEvent> events) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethod.DESCRIPTOR);
                    _data.writeInt(requestId);
                    _data.writeTypedObject(channel, 0);
                    _data.writeTypedList(events, 0);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void initInkWindow() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethod.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(15, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void finishStylusHandwriting() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethod.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(16, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void removeStylusHandwritingWindow() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethod.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(17, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setStylusWindowIdleTimeoutForTest(long timeout) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethod.DESCRIPTOR);
                    _data.writeLong(timeout);
                    boolean bl = this.mRemote.transact(18, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IInputMethod {
        @Override
        public void initializeInternal(InitParams params) throws RemoteException {
        }

        @Override
        public void onCreateInlineSuggestionsRequest(InlineSuggestionsRequestInfo requestInfo, IInlineSuggestionsRequestCallback cb) throws RemoteException {
        }

        @Override
        public void bindInput(InputBinding binding) throws RemoteException {
        }

        @Override
        public void unbindInput() throws RemoteException {
        }

        @Override
        public void startInput(StartInputParams params) throws RemoteException {
        }

        @Override
        public void onNavButtonFlagsChanged(int navButtonFlags) throws RemoteException {
        }

        @Override
        public void createSession(InputChannel channel, IInputMethodSessionCallback callback) throws RemoteException {
        }

        @Override
        public void setSessionEnabled(IInputMethodSession session, boolean enabled) throws RemoteException {
        }

        @Override
        public void showSoftInput(IBinder showInputToken, ImeTracker.Token statsToken, int flags, ResultReceiver resultReceiver) throws RemoteException {
        }

        @Override
        public void hideSoftInput(IBinder hideInputToken, ImeTracker.Token statsToken, int flags, ResultReceiver resultReceiver) throws RemoteException {
        }

        @Override
        public void updateEditorToolType(int toolType) throws RemoteException {
        }

        @Override
        public void changeInputMethodSubtype(InputMethodSubtype subtype) throws RemoteException {
        }

        @Override
        public void canStartStylusHandwriting(int requestId) throws RemoteException {
        }

        @Override
        public void startStylusHandwriting(int requestId, InputChannel channel, List<MotionEvent> events) throws RemoteException {
        }

        @Override
        public void initInkWindow() throws RemoteException {
        }

        @Override
        public void finishStylusHandwriting() throws RemoteException {
        }

        @Override
        public void removeStylusHandwritingWindow() throws RemoteException {
        }

        @Override
        public void setStylusWindowIdleTimeoutForTest(long timeout) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

