/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.android.internal.inputmethod.InputBindResult;

public interface IInputMethodClient
extends IInterface {
    public static final String DESCRIPTOR = "com.android.internal.inputmethod.IInputMethodClient";

    public void onBindMethod(InputBindResult var1) throws RemoteException;

    public void onBindAccessibilityService(InputBindResult var1, int var2) throws RemoteException;

    public void onUnbindMethod(int var1, int var2) throws RemoteException;

    public void onUnbindAccessibilityService(int var1, int var2) throws RemoteException;

    public void setActive(boolean var1, boolean var2) throws RemoteException;

    public void setInteractive(boolean var1, boolean var2) throws RemoteException;

    public void scheduleStartInputIfNecessary(boolean var1) throws RemoteException;

    public void reportFullscreenMode(boolean var1) throws RemoteException;

    public void updateVirtualDisplayToScreenMatrix(int var1, float[] var2) throws RemoteException;

    public void setImeTraceEnabled(boolean var1) throws RemoteException;

    public void throwExceptionFromSystem(String var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInputMethodClient {
        static final int TRANSACTION_onBindMethod = 1;
        static final int TRANSACTION_onBindAccessibilityService = 2;
        static final int TRANSACTION_onUnbindMethod = 3;
        static final int TRANSACTION_onUnbindAccessibilityService = 4;
        static final int TRANSACTION_setActive = 5;
        static final int TRANSACTION_setInteractive = 6;
        static final int TRANSACTION_scheduleStartInputIfNecessary = 7;
        static final int TRANSACTION_reportFullscreenMode = 8;
        static final int TRANSACTION_updateVirtualDisplayToScreenMatrix = 9;
        static final int TRANSACTION_setImeTraceEnabled = 10;
        static final int TRANSACTION_throwExceptionFromSystem = 11;

        public Stub() {
            this.attachInterface(this, IInputMethodClient.DESCRIPTOR);
        }

        public static IInputMethodClient asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IInputMethodClient.DESCRIPTOR);
            if (iin != null && iin instanceof IInputMethodClient) {
                return (IInputMethodClient)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onBindMethod";
                }
                case 2: {
                    return "onBindAccessibilityService";
                }
                case 3: {
                    return "onUnbindMethod";
                }
                case 4: {
                    return "onUnbindAccessibilityService";
                }
                case 5: {
                    return "setActive";
                }
                case 6: {
                    return "setInteractive";
                }
                case 7: {
                    return "scheduleStartInputIfNecessary";
                }
                case 8: {
                    return "reportFullscreenMode";
                }
                case 9: {
                    return "updateVirtualDisplayToScreenMatrix";
                }
                case 10: {
                    return "setImeTraceEnabled";
                }
                case 11: {
                    return "throwExceptionFromSystem";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IInputMethodClient.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    InputBindResult _arg0 = data.readTypedObject(InputBindResult.CREATOR);
                    data.enforceNoDataAvail();
                    this.onBindMethod(_arg0);
                    break;
                }
                case 2: {
                    InputBindResult _arg0 = data.readTypedObject(InputBindResult.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onBindAccessibilityService(_arg0, _arg1);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onUnbindMethod(_arg0, _arg1);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onUnbindAccessibilityService(_arg0, _arg1);
                    break;
                }
                case 5: {
                    boolean _arg0 = data.readBoolean();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setActive(_arg0, _arg1);
                    break;
                }
                case 6: {
                    boolean _arg0 = data.readBoolean();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setInteractive(_arg0, _arg1);
                    break;
                }
                case 7: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.scheduleStartInputIfNecessary(_arg0);
                    break;
                }
                case 8: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.reportFullscreenMode(_arg0);
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    float[] _arg1 = data.createFloatArray();
                    data.enforceNoDataAvail();
                    this.updateVirtualDisplayToScreenMatrix(_arg0, _arg1);
                    break;
                }
                case 10: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setImeTraceEnabled(_arg0);
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.throwExceptionFromSystem(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 10;
        }

        private static class Proxy
        implements IInputMethodClient {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IInputMethodClient.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBindMethod(InputBindResult res) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodClient.DESCRIPTOR);
                    _data.writeTypedObject(res, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBindAccessibilityService(InputBindResult res, int id2) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodClient.DESCRIPTOR);
                    _data.writeTypedObject(res, 0);
                    _data.writeInt(id2);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUnbindMethod(int sequence, int unbindReason) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodClient.DESCRIPTOR);
                    _data.writeInt(sequence);
                    _data.writeInt(unbindReason);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUnbindAccessibilityService(int sequence, int id2) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodClient.DESCRIPTOR);
                    _data.writeInt(sequence);
                    _data.writeInt(id2);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setActive(boolean active, boolean fullscreen) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodClient.DESCRIPTOR);
                    _data.writeBoolean(active);
                    _data.writeBoolean(fullscreen);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInteractive(boolean active, boolean fullscreen) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodClient.DESCRIPTOR);
                    _data.writeBoolean(active);
                    _data.writeBoolean(fullscreen);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void scheduleStartInputIfNecessary(boolean fullscreen) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodClient.DESCRIPTOR);
                    _data.writeBoolean(fullscreen);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportFullscreenMode(boolean fullscreen) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodClient.DESCRIPTOR);
                    _data.writeBoolean(fullscreen);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateVirtualDisplayToScreenMatrix(int bindSequence, float[] matrixValues) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodClient.DESCRIPTOR);
                    _data.writeInt(bindSequence);
                    _data.writeFloatArray(matrixValues);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setImeTraceEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodClient.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void throwExceptionFromSystem(String message) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodClient.DESCRIPTOR);
                    _data.writeString(message);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IInputMethodClient {
        @Override
        public void onBindMethod(InputBindResult res) throws RemoteException {
        }

        @Override
        public void onBindAccessibilityService(InputBindResult res, int id2) throws RemoteException {
        }

        @Override
        public void onUnbindMethod(int sequence, int unbindReason) throws RemoteException {
        }

        @Override
        public void onUnbindAccessibilityService(int sequence, int id2) throws RemoteException {
        }

        @Override
        public void setActive(boolean active, boolean fullscreen) throws RemoteException {
        }

        @Override
        public void setInteractive(boolean active, boolean fullscreen) throws RemoteException {
        }

        @Override
        public void scheduleStartInputIfNecessary(boolean fullscreen) throws RemoteException {
        }

        @Override
        public void reportFullscreenMode(boolean fullscreen) throws RemoteException {
        }

        @Override
        public void updateVirtualDisplayToScreenMatrix(int bindSequence, float[] matrixValues) throws RemoteException {
        }

        @Override
        public void setImeTraceEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public void throwExceptionFromSystem(String message) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

