/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.net.Uri;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.inputmethod.ImeTracker;
import android.view.inputmethod.InputMethodSubtype;
import com.android.internal.infra.AndroidFuture;

public interface IInputMethodPrivilegedOperations
extends IInterface {
    public static final String DESCRIPTOR = "com.android.internal.inputmethod.IInputMethodPrivilegedOperations";

    public void setImeWindowStatusAsync(int var1, int var2) throws RemoteException;

    public void reportStartInputAsync(IBinder var1) throws RemoteException;

    public void createInputContentUriToken(Uri var1, String var2, AndroidFuture var3) throws RemoteException;

    public void reportFullscreenModeAsync(boolean var1) throws RemoteException;

    public void setInputMethod(String var1, AndroidFuture var2) throws RemoteException;

    public void setInputMethodAndSubtype(String var1, InputMethodSubtype var2, AndroidFuture var3) throws RemoteException;

    public void hideMySoftInput(int var1, int var2, AndroidFuture var3) throws RemoteException;

    public void showMySoftInput(int var1, AndroidFuture var2) throws RemoteException;

    public void updateStatusIconAsync(String var1, int var2) throws RemoteException;

    public void switchToPreviousInputMethod(AndroidFuture var1) throws RemoteException;

    public void switchToNextInputMethod(boolean var1, AndroidFuture var2) throws RemoteException;

    public void shouldOfferSwitchingToNextInputMethod(AndroidFuture var1) throws RemoteException;

    public void notifyUserActionAsync() throws RemoteException;

    public void applyImeVisibilityAsync(IBinder var1, boolean var2, ImeTracker.Token var3) throws RemoteException;

    public void onStylusHandwritingReady(int var1, int var2) throws RemoteException;

    public void resetStylusHandwriting(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInputMethodPrivilegedOperations {
        static final int TRANSACTION_setImeWindowStatusAsync = 1;
        static final int TRANSACTION_reportStartInputAsync = 2;
        static final int TRANSACTION_createInputContentUriToken = 3;
        static final int TRANSACTION_reportFullscreenModeAsync = 4;
        static final int TRANSACTION_setInputMethod = 5;
        static final int TRANSACTION_setInputMethodAndSubtype = 6;
        static final int TRANSACTION_hideMySoftInput = 7;
        static final int TRANSACTION_showMySoftInput = 8;
        static final int TRANSACTION_updateStatusIconAsync = 9;
        static final int TRANSACTION_switchToPreviousInputMethod = 10;
        static final int TRANSACTION_switchToNextInputMethod = 11;
        static final int TRANSACTION_shouldOfferSwitchingToNextInputMethod = 12;
        static final int TRANSACTION_notifyUserActionAsync = 13;
        static final int TRANSACTION_applyImeVisibilityAsync = 14;
        static final int TRANSACTION_onStylusHandwritingReady = 15;
        static final int TRANSACTION_resetStylusHandwriting = 16;

        public Stub() {
            this.attachInterface(this, IInputMethodPrivilegedOperations.DESCRIPTOR);
        }

        public static IInputMethodPrivilegedOperations asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IInputMethodPrivilegedOperations.DESCRIPTOR);
            if (iin != null && iin instanceof IInputMethodPrivilegedOperations) {
                return (IInputMethodPrivilegedOperations)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setImeWindowStatusAsync";
                }
                case 2: {
                    return "reportStartInputAsync";
                }
                case 3: {
                    return "createInputContentUriToken";
                }
                case 4: {
                    return "reportFullscreenModeAsync";
                }
                case 5: {
                    return "setInputMethod";
                }
                case 6: {
                    return "setInputMethodAndSubtype";
                }
                case 7: {
                    return "hideMySoftInput";
                }
                case 8: {
                    return "showMySoftInput";
                }
                case 9: {
                    return "updateStatusIconAsync";
                }
                case 10: {
                    return "switchToPreviousInputMethod";
                }
                case 11: {
                    return "switchToNextInputMethod";
                }
                case 12: {
                    return "shouldOfferSwitchingToNextInputMethod";
                }
                case 13: {
                    return "notifyUserActionAsync";
                }
                case 14: {
                    return "applyImeVisibilityAsync";
                }
                case 15: {
                    return "onStylusHandwritingReady";
                }
                case 16: {
                    return "resetStylusHandwriting";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IInputMethodPrivilegedOperations.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setImeWindowStatusAsync(_arg0, _arg1);
                    break;
                }
                case 2: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.reportStartInputAsync(_arg0);
                    break;
                }
                case 3: {
                    Uri _arg0 = data.readTypedObject(Uri.CREATOR);
                    String _arg1 = data.readString();
                    AndroidFuture _arg2 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.createInputContentUriToken(_arg0, _arg1, _arg2);
                    break;
                }
                case 4: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.reportFullscreenModeAsync(_arg0);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    AndroidFuture _arg1 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.setInputMethod(_arg0, _arg1);
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    InputMethodSubtype _arg1 = data.readTypedObject(InputMethodSubtype.CREATOR);
                    AndroidFuture _arg2 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.setInputMethodAndSubtype(_arg0, _arg1, _arg2);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    AndroidFuture _arg2 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.hideMySoftInput(_arg0, _arg1, _arg2);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    AndroidFuture _arg1 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.showMySoftInput(_arg0, _arg1);
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.updateStatusIconAsync(_arg0, _arg1);
                    break;
                }
                case 10: {
                    AndroidFuture _arg0 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.switchToPreviousInputMethod(_arg0);
                    break;
                }
                case 11: {
                    boolean _arg0 = data.readBoolean();
                    AndroidFuture _arg1 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.switchToNextInputMethod(_arg0, _arg1);
                    break;
                }
                case 12: {
                    AndroidFuture _arg0 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.shouldOfferSwitchingToNextInputMethod(_arg0);
                    break;
                }
                case 13: {
                    this.notifyUserActionAsync();
                    break;
                }
                case 14: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    ImeTracker.Token _arg2 = data.readTypedObject(ImeTracker.Token.CREATOR);
                    data.enforceNoDataAvail();
                    this.applyImeVisibilityAsync(_arg0, _arg1, _arg2);
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onStylusHandwritingReady(_arg0, _arg1);
                    break;
                }
                case 16: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.resetStylusHandwriting(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 15;
        }

        private static class Proxy
        implements IInputMethodPrivilegedOperations {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IInputMethodPrivilegedOperations.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setImeWindowStatusAsync(int vis, int backDisposition) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodPrivilegedOperations.DESCRIPTOR);
                    _data.writeInt(vis);
                    _data.writeInt(backDisposition);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportStartInputAsync(IBinder startInputToken) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodPrivilegedOperations.DESCRIPTOR);
                    _data.writeStrongBinder(startInputToken);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createInputContentUriToken(Uri contentUri, String packageName, AndroidFuture future) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodPrivilegedOperations.DESCRIPTOR);
                    _data.writeTypedObject(contentUri, 0);
                    _data.writeString(packageName);
                    _data.writeTypedObject(future, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportFullscreenModeAsync(boolean fullscreen) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodPrivilegedOperations.DESCRIPTOR);
                    _data.writeBoolean(fullscreen);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInputMethod(String id2, AndroidFuture future) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodPrivilegedOperations.DESCRIPTOR);
                    _data.writeString(id2);
                    _data.writeTypedObject(future, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInputMethodAndSubtype(String id2, InputMethodSubtype subtype, AndroidFuture future) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodPrivilegedOperations.DESCRIPTOR);
                    _data.writeString(id2);
                    _data.writeTypedObject(subtype, 0);
                    _data.writeTypedObject(future, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hideMySoftInput(int flags, int reason, AndroidFuture future) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodPrivilegedOperations.DESCRIPTOR);
                    _data.writeInt(flags);
                    _data.writeInt(reason);
                    _data.writeTypedObject(future, 0);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showMySoftInput(int flags, AndroidFuture future) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodPrivilegedOperations.DESCRIPTOR);
                    _data.writeInt(flags);
                    _data.writeTypedObject(future, 0);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateStatusIconAsync(String packageName, int iconId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodPrivilegedOperations.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(iconId);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void switchToPreviousInputMethod(AndroidFuture future) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodPrivilegedOperations.DESCRIPTOR);
                    _data.writeTypedObject(future, 0);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void switchToNextInputMethod(boolean onlyCurrentIme, AndroidFuture future) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodPrivilegedOperations.DESCRIPTOR);
                    _data.writeBoolean(onlyCurrentIme);
                    _data.writeTypedObject(future, 0);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void shouldOfferSwitchingToNextInputMethod(AndroidFuture future) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodPrivilegedOperations.DESCRIPTOR);
                    _data.writeTypedObject(future, 0);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void notifyUserActionAsync() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodPrivilegedOperations.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void applyImeVisibilityAsync(IBinder showOrHideInputToken, boolean setVisible, ImeTracker.Token statsToken) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodPrivilegedOperations.DESCRIPTOR);
                    _data.writeStrongBinder(showOrHideInputToken);
                    _data.writeBoolean(setVisible);
                    _data.writeTypedObject(statsToken, 0);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStylusHandwritingReady(int requestId, int pid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodPrivilegedOperations.DESCRIPTOR);
                    _data.writeInt(requestId);
                    _data.writeInt(pid);
                    boolean bl = this.mRemote.transact(15, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetStylusHandwriting(int requestId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodPrivilegedOperations.DESCRIPTOR);
                    _data.writeInt(requestId);
                    boolean bl = this.mRemote.transact(16, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IInputMethodPrivilegedOperations {
        @Override
        public void setImeWindowStatusAsync(int vis, int backDisposition) throws RemoteException {
        }

        @Override
        public void reportStartInputAsync(IBinder startInputToken) throws RemoteException {
        }

        @Override
        public void createInputContentUriToken(Uri contentUri, String packageName, AndroidFuture future) throws RemoteException {
        }

        @Override
        public void reportFullscreenModeAsync(boolean fullscreen) throws RemoteException {
        }

        @Override
        public void setInputMethod(String id2, AndroidFuture future) throws RemoteException {
        }

        @Override
        public void setInputMethodAndSubtype(String id2, InputMethodSubtype subtype, AndroidFuture future) throws RemoteException {
        }

        @Override
        public void hideMySoftInput(int flags, int reason, AndroidFuture future) throws RemoteException {
        }

        @Override
        public void showMySoftInput(int flags, AndroidFuture future) throws RemoteException {
        }

        @Override
        public void updateStatusIconAsync(String packageName, int iconId) throws RemoteException {
        }

        @Override
        public void switchToPreviousInputMethod(AndroidFuture future) throws RemoteException {
        }

        @Override
        public void switchToNextInputMethod(boolean onlyCurrentIme, AndroidFuture future) throws RemoteException {
        }

        @Override
        public void shouldOfferSwitchingToNextInputMethod(AndroidFuture future) throws RemoteException {
        }

        @Override
        public void notifyUserActionAsync() throws RemoteException {
        }

        @Override
        public void applyImeVisibilityAsync(IBinder showOrHideInputToken, boolean setVisible, ImeTracker.Token statsToken) throws RemoteException {
        }

        @Override
        public void onStylusHandwritingReady(int requestId, int pid) throws RemoteException {
        }

        @Override
        public void resetStylusHandwriting(int requestId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

