/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.inputmethod.TextAttribute;
import com.android.internal.infra.AndroidFuture;
import com.android.internal.inputmethod.InputConnectionCommandHeader;

public interface IRemoteAccessibilityInputConnection
extends IInterface {
    public static final String DESCRIPTOR = "com.android.internal.inputmethod.IRemoteAccessibilityInputConnection";

    public void commitText(InputConnectionCommandHeader var1, CharSequence var2, int var3, TextAttribute var4) throws RemoteException;

    public void setSelection(InputConnectionCommandHeader var1, int var2, int var3) throws RemoteException;

    public void getSurroundingText(InputConnectionCommandHeader var1, int var2, int var3, int var4, AndroidFuture var5) throws RemoteException;

    public void deleteSurroundingText(InputConnectionCommandHeader var1, int var2, int var3) throws RemoteException;

    public void sendKeyEvent(InputConnectionCommandHeader var1, KeyEvent var2) throws RemoteException;

    public void performEditorAction(InputConnectionCommandHeader var1, int var2) throws RemoteException;

    public void performContextMenuAction(InputConnectionCommandHeader var1, int var2) throws RemoteException;

    public void getCursorCapsMode(InputConnectionCommandHeader var1, int var2, AndroidFuture var3) throws RemoteException;

    public void clearMetaKeyStates(InputConnectionCommandHeader var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRemoteAccessibilityInputConnection {
        static final int TRANSACTION_commitText = 1;
        static final int TRANSACTION_setSelection = 2;
        static final int TRANSACTION_getSurroundingText = 3;
        static final int TRANSACTION_deleteSurroundingText = 4;
        static final int TRANSACTION_sendKeyEvent = 5;
        static final int TRANSACTION_performEditorAction = 6;
        static final int TRANSACTION_performContextMenuAction = 7;
        static final int TRANSACTION_getCursorCapsMode = 8;
        static final int TRANSACTION_clearMetaKeyStates = 9;

        public Stub() {
            this.attachInterface(this, IRemoteAccessibilityInputConnection.DESCRIPTOR);
        }

        public static IRemoteAccessibilityInputConnection asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IRemoteAccessibilityInputConnection.DESCRIPTOR);
            if (iin != null && iin instanceof IRemoteAccessibilityInputConnection) {
                return (IRemoteAccessibilityInputConnection)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "commitText";
                }
                case 2: {
                    return "setSelection";
                }
                case 3: {
                    return "getSurroundingText";
                }
                case 4: {
                    return "deleteSurroundingText";
                }
                case 5: {
                    return "sendKeyEvent";
                }
                case 6: {
                    return "performEditorAction";
                }
                case 7: {
                    return "performContextMenuAction";
                }
                case 8: {
                    return "getCursorCapsMode";
                }
                case 9: {
                    return "clearMetaKeyStates";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IRemoteAccessibilityInputConnection.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    CharSequence _arg1 = data.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                    int _arg2 = data.readInt();
                    TextAttribute _arg3 = data.readTypedObject(TextAttribute.CREATOR);
                    data.enforceNoDataAvail();
                    this.commitText(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 2: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setSelection(_arg0, _arg1, _arg2);
                    break;
                }
                case 3: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    AndroidFuture _arg4 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.getSurroundingText(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 4: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.deleteSurroundingText(_arg0, _arg1, _arg2);
                    break;
                }
                case 5: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    KeyEvent _arg1 = data.readTypedObject(KeyEvent.CREATOR);
                    data.enforceNoDataAvail();
                    this.sendKeyEvent(_arg0, _arg1);
                    break;
                }
                case 6: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.performEditorAction(_arg0, _arg1);
                    break;
                }
                case 7: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.performContextMenuAction(_arg0, _arg1);
                    break;
                }
                case 8: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    int _arg1 = data.readInt();
                    AndroidFuture _arg2 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.getCursorCapsMode(_arg0, _arg1, _arg2);
                    break;
                }
                case 9: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.clearMetaKeyStates(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 8;
        }

        private static class Proxy
        implements IRemoteAccessibilityInputConnection {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IRemoteAccessibilityInputConnection.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void commitText(InputConnectionCommandHeader header, CharSequence text, int newCursorPosition, TextAttribute textAttribute) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteAccessibilityInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    if (text != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(text, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(newCursorPosition);
                    _data.writeTypedObject(textAttribute, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSelection(InputConnectionCommandHeader header, int start, int end) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteAccessibilityInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeInt(start);
                    _data.writeInt(end);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getSurroundingText(InputConnectionCommandHeader header, int beforeLength, int afterLength, int flags, AndroidFuture future) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteAccessibilityInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeInt(beforeLength);
                    _data.writeInt(afterLength);
                    _data.writeInt(flags);
                    _data.writeTypedObject(future, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteSurroundingText(InputConnectionCommandHeader header, int beforeLength, int afterLength) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteAccessibilityInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeInt(beforeLength);
                    _data.writeInt(afterLength);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendKeyEvent(InputConnectionCommandHeader header, KeyEvent event) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteAccessibilityInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeTypedObject(event, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void performEditorAction(InputConnectionCommandHeader header, int actionCode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteAccessibilityInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeInt(actionCode);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void performContextMenuAction(InputConnectionCommandHeader header, int id2) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteAccessibilityInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeInt(id2);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getCursorCapsMode(InputConnectionCommandHeader header, int reqModes, AndroidFuture future) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteAccessibilityInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeInt(reqModes);
                    _data.writeTypedObject(future, 0);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearMetaKeyStates(InputConnectionCommandHeader header, int states) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteAccessibilityInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeInt(states);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IRemoteAccessibilityInputConnection {
        @Override
        public void commitText(InputConnectionCommandHeader header, CharSequence text, int newCursorPosition, TextAttribute textAttribute) throws RemoteException {
        }

        @Override
        public void setSelection(InputConnectionCommandHeader header, int start, int end) throws RemoteException {
        }

        @Override
        public void getSurroundingText(InputConnectionCommandHeader header, int beforeLength, int afterLength, int flags, AndroidFuture future) throws RemoteException {
        }

        @Override
        public void deleteSurroundingText(InputConnectionCommandHeader header, int beforeLength, int afterLength) throws RemoteException {
        }

        @Override
        public void sendKeyEvent(InputConnectionCommandHeader header, KeyEvent event) throws RemoteException {
        }

        @Override
        public void performEditorAction(InputConnectionCommandHeader header, int actionCode) throws RemoteException {
        }

        @Override
        public void performContextMenuAction(InputConnectionCommandHeader header, int id2) throws RemoteException {
        }

        @Override
        public void getCursorCapsMode(InputConnectionCommandHeader header, int reqModes, AndroidFuture future) throws RemoteException {
        }

        @Override
        public void clearMetaKeyStates(InputConnectionCommandHeader header, int states) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

