/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.graphics.RectF;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputContentInfo;
import android.view.inputmethod.ParcelableHandwritingGesture;
import android.view.inputmethod.TextAttribute;
import com.android.internal.infra.AndroidFuture;
import com.android.internal.inputmethod.InputConnectionCommandHeader;

public interface IRemoteInputConnection
extends IInterface {
    public static final String DESCRIPTOR = "com.android.internal.inputmethod.IRemoteInputConnection";

    public void getTextBeforeCursor(InputConnectionCommandHeader var1, int var2, int var3, AndroidFuture var4) throws RemoteException;

    public void getTextAfterCursor(InputConnectionCommandHeader var1, int var2, int var3, AndroidFuture var4) throws RemoteException;

    public void getCursorCapsMode(InputConnectionCommandHeader var1, int var2, AndroidFuture var3) throws RemoteException;

    public void getExtractedText(InputConnectionCommandHeader var1, ExtractedTextRequest var2, int var3, AndroidFuture var4) throws RemoteException;

    public void deleteSurroundingText(InputConnectionCommandHeader var1, int var2, int var3) throws RemoteException;

    public void deleteSurroundingTextInCodePoints(InputConnectionCommandHeader var1, int var2, int var3) throws RemoteException;

    public void setComposingText(InputConnectionCommandHeader var1, CharSequence var2, int var3) throws RemoteException;

    public void setComposingTextWithTextAttribute(InputConnectionCommandHeader var1, CharSequence var2, int var3, TextAttribute var4) throws RemoteException;

    public void finishComposingText(InputConnectionCommandHeader var1) throws RemoteException;

    public void commitText(InputConnectionCommandHeader var1, CharSequence var2, int var3) throws RemoteException;

    public void commitTextWithTextAttribute(InputConnectionCommandHeader var1, CharSequence var2, int var3, TextAttribute var4) throws RemoteException;

    public void commitCompletion(InputConnectionCommandHeader var1, CompletionInfo var2) throws RemoteException;

    public void commitCorrection(InputConnectionCommandHeader var1, CorrectionInfo var2) throws RemoteException;

    public void setSelection(InputConnectionCommandHeader var1, int var2, int var3) throws RemoteException;

    public void performEditorAction(InputConnectionCommandHeader var1, int var2) throws RemoteException;

    public void performContextMenuAction(InputConnectionCommandHeader var1, int var2) throws RemoteException;

    public void beginBatchEdit(InputConnectionCommandHeader var1) throws RemoteException;

    public void endBatchEdit(InputConnectionCommandHeader var1) throws RemoteException;

    public void sendKeyEvent(InputConnectionCommandHeader var1, KeyEvent var2) throws RemoteException;

    public void clearMetaKeyStates(InputConnectionCommandHeader var1, int var2) throws RemoteException;

    public void performSpellCheck(InputConnectionCommandHeader var1) throws RemoteException;

    public void performPrivateCommand(InputConnectionCommandHeader var1, String var2, Bundle var3) throws RemoteException;

    public void performHandwritingGesture(InputConnectionCommandHeader var1, ParcelableHandwritingGesture var2, ResultReceiver var3) throws RemoteException;

    public void previewHandwritingGesture(InputConnectionCommandHeader var1, ParcelableHandwritingGesture var2, IBinder var3) throws RemoteException;

    public void setComposingRegion(InputConnectionCommandHeader var1, int var2, int var3) throws RemoteException;

    public void setComposingRegionWithTextAttribute(InputConnectionCommandHeader var1, int var2, int var3, TextAttribute var4) throws RemoteException;

    public void getSelectedText(InputConnectionCommandHeader var1, int var2, AndroidFuture var3) throws RemoteException;

    public void requestCursorUpdates(InputConnectionCommandHeader var1, int var2, int var3, AndroidFuture var4) throws RemoteException;

    public void requestCursorUpdatesWithFilter(InputConnectionCommandHeader var1, int var2, int var3, int var4, AndroidFuture var5) throws RemoteException;

    public void requestTextBoundsInfo(InputConnectionCommandHeader var1, RectF var2, ResultReceiver var3) throws RemoteException;

    public void commitContent(InputConnectionCommandHeader var1, InputContentInfo var2, int var3, Bundle var4, AndroidFuture var5) throws RemoteException;

    public void getSurroundingText(InputConnectionCommandHeader var1, int var2, int var3, int var4, AndroidFuture var5) throws RemoteException;

    public void setImeConsumesInput(InputConnectionCommandHeader var1, boolean var2) throws RemoteException;

    public void replaceText(InputConnectionCommandHeader var1, int var2, int var3, CharSequence var4, int var5, TextAttribute var6) throws RemoteException;

    public void cancelCancellationSignal(IBinder var1) throws RemoteException;

    public void forgetCancellationSignal(IBinder var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRemoteInputConnection {
        static final int TRANSACTION_getTextBeforeCursor = 1;
        static final int TRANSACTION_getTextAfterCursor = 2;
        static final int TRANSACTION_getCursorCapsMode = 3;
        static final int TRANSACTION_getExtractedText = 4;
        static final int TRANSACTION_deleteSurroundingText = 5;
        static final int TRANSACTION_deleteSurroundingTextInCodePoints = 6;
        static final int TRANSACTION_setComposingText = 7;
        static final int TRANSACTION_setComposingTextWithTextAttribute = 8;
        static final int TRANSACTION_finishComposingText = 9;
        static final int TRANSACTION_commitText = 10;
        static final int TRANSACTION_commitTextWithTextAttribute = 11;
        static final int TRANSACTION_commitCompletion = 12;
        static final int TRANSACTION_commitCorrection = 13;
        static final int TRANSACTION_setSelection = 14;
        static final int TRANSACTION_performEditorAction = 15;
        static final int TRANSACTION_performContextMenuAction = 16;
        static final int TRANSACTION_beginBatchEdit = 17;
        static final int TRANSACTION_endBatchEdit = 18;
        static final int TRANSACTION_sendKeyEvent = 19;
        static final int TRANSACTION_clearMetaKeyStates = 20;
        static final int TRANSACTION_performSpellCheck = 21;
        static final int TRANSACTION_performPrivateCommand = 22;
        static final int TRANSACTION_performHandwritingGesture = 23;
        static final int TRANSACTION_previewHandwritingGesture = 24;
        static final int TRANSACTION_setComposingRegion = 25;
        static final int TRANSACTION_setComposingRegionWithTextAttribute = 26;
        static final int TRANSACTION_getSelectedText = 27;
        static final int TRANSACTION_requestCursorUpdates = 28;
        static final int TRANSACTION_requestCursorUpdatesWithFilter = 29;
        static final int TRANSACTION_requestTextBoundsInfo = 30;
        static final int TRANSACTION_commitContent = 31;
        static final int TRANSACTION_getSurroundingText = 32;
        static final int TRANSACTION_setImeConsumesInput = 33;
        static final int TRANSACTION_replaceText = 34;
        static final int TRANSACTION_cancelCancellationSignal = 35;
        static final int TRANSACTION_forgetCancellationSignal = 36;

        public Stub() {
            this.attachInterface(this, IRemoteInputConnection.DESCRIPTOR);
        }

        public static IRemoteInputConnection asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IRemoteInputConnection.DESCRIPTOR);
            if (iin != null && iin instanceof IRemoteInputConnection) {
                return (IRemoteInputConnection)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getTextBeforeCursor";
                }
                case 2: {
                    return "getTextAfterCursor";
                }
                case 3: {
                    return "getCursorCapsMode";
                }
                case 4: {
                    return "getExtractedText";
                }
                case 5: {
                    return "deleteSurroundingText";
                }
                case 6: {
                    return "deleteSurroundingTextInCodePoints";
                }
                case 7: {
                    return "setComposingText";
                }
                case 8: {
                    return "setComposingTextWithTextAttribute";
                }
                case 9: {
                    return "finishComposingText";
                }
                case 10: {
                    return "commitText";
                }
                case 11: {
                    return "commitTextWithTextAttribute";
                }
                case 12: {
                    return "commitCompletion";
                }
                case 13: {
                    return "commitCorrection";
                }
                case 14: {
                    return "setSelection";
                }
                case 15: {
                    return "performEditorAction";
                }
                case 16: {
                    return "performContextMenuAction";
                }
                case 17: {
                    return "beginBatchEdit";
                }
                case 18: {
                    return "endBatchEdit";
                }
                case 19: {
                    return "sendKeyEvent";
                }
                case 20: {
                    return "clearMetaKeyStates";
                }
                case 21: {
                    return "performSpellCheck";
                }
                case 22: {
                    return "performPrivateCommand";
                }
                case 23: {
                    return "performHandwritingGesture";
                }
                case 24: {
                    return "previewHandwritingGesture";
                }
                case 25: {
                    return "setComposingRegion";
                }
                case 26: {
                    return "setComposingRegionWithTextAttribute";
                }
                case 27: {
                    return "getSelectedText";
                }
                case 28: {
                    return "requestCursorUpdates";
                }
                case 29: {
                    return "requestCursorUpdatesWithFilter";
                }
                case 30: {
                    return "requestTextBoundsInfo";
                }
                case 31: {
                    return "commitContent";
                }
                case 32: {
                    return "getSurroundingText";
                }
                case 33: {
                    return "setImeConsumesInput";
                }
                case 34: {
                    return "replaceText";
                }
                case 35: {
                    return "cancelCancellationSignal";
                }
                case 36: {
                    return "forgetCancellationSignal";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IRemoteInputConnection.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    AndroidFuture _arg3 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.getTextBeforeCursor(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 2: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    AndroidFuture _arg3 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.getTextAfterCursor(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 3: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    int _arg1 = data.readInt();
                    AndroidFuture _arg2 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.getCursorCapsMode(_arg0, _arg1, _arg2);
                    break;
                }
                case 4: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    ExtractedTextRequest _arg1 = data.readTypedObject(ExtractedTextRequest.CREATOR);
                    int _arg2 = data.readInt();
                    AndroidFuture _arg3 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.getExtractedText(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 5: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.deleteSurroundingText(_arg0, _arg1, _arg2);
                    break;
                }
                case 6: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.deleteSurroundingTextInCodePoints(_arg0, _arg1, _arg2);
                    break;
                }
                case 7: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    CharSequence _arg1 = data.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setComposingText(_arg0, _arg1, _arg2);
                    break;
                }
                case 8: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    CharSequence _arg1 = data.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                    int _arg2 = data.readInt();
                    TextAttribute _arg3 = data.readTypedObject(TextAttribute.CREATOR);
                    data.enforceNoDataAvail();
                    this.setComposingTextWithTextAttribute(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 9: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    data.enforceNoDataAvail();
                    this.finishComposingText(_arg0);
                    break;
                }
                case 10: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    CharSequence _arg1 = data.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.commitText(_arg0, _arg1, _arg2);
                    break;
                }
                case 11: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    CharSequence _arg1 = data.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                    int _arg2 = data.readInt();
                    TextAttribute _arg3 = data.readTypedObject(TextAttribute.CREATOR);
                    data.enforceNoDataAvail();
                    this.commitTextWithTextAttribute(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 12: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    CompletionInfo _arg1 = data.readTypedObject(CompletionInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.commitCompletion(_arg0, _arg1);
                    break;
                }
                case 13: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    CorrectionInfo _arg1 = data.readTypedObject(CorrectionInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.commitCorrection(_arg0, _arg1);
                    break;
                }
                case 14: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setSelection(_arg0, _arg1, _arg2);
                    break;
                }
                case 15: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.performEditorAction(_arg0, _arg1);
                    break;
                }
                case 16: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.performContextMenuAction(_arg0, _arg1);
                    break;
                }
                case 17: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    data.enforceNoDataAvail();
                    this.beginBatchEdit(_arg0);
                    break;
                }
                case 18: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    data.enforceNoDataAvail();
                    this.endBatchEdit(_arg0);
                    break;
                }
                case 19: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    KeyEvent _arg1 = data.readTypedObject(KeyEvent.CREATOR);
                    data.enforceNoDataAvail();
                    this.sendKeyEvent(_arg0, _arg1);
                    break;
                }
                case 20: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.clearMetaKeyStates(_arg0, _arg1);
                    break;
                }
                case 21: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    data.enforceNoDataAvail();
                    this.performSpellCheck(_arg0);
                    break;
                }
                case 22: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    String _arg1 = data.readString();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.performPrivateCommand(_arg0, _arg1, _arg2);
                    break;
                }
                case 23: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    ParcelableHandwritingGesture _arg1 = data.readTypedObject(ParcelableHandwritingGesture.CREATOR);
                    ResultReceiver _arg2 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.performHandwritingGesture(_arg0, _arg1, _arg2);
                    break;
                }
                case 24: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    ParcelableHandwritingGesture _arg1 = data.readTypedObject(ParcelableHandwritingGesture.CREATOR);
                    IBinder _arg2 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.previewHandwritingGesture(_arg0, _arg1, _arg2);
                    break;
                }
                case 25: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setComposingRegion(_arg0, _arg1, _arg2);
                    break;
                }
                case 26: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    TextAttribute _arg3 = data.readTypedObject(TextAttribute.CREATOR);
                    data.enforceNoDataAvail();
                    this.setComposingRegionWithTextAttribute(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 27: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    int _arg1 = data.readInt();
                    AndroidFuture _arg2 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.getSelectedText(_arg0, _arg1, _arg2);
                    break;
                }
                case 28: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    AndroidFuture _arg3 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.requestCursorUpdates(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 29: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    AndroidFuture _arg4 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.requestCursorUpdatesWithFilter(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 30: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    RectF _arg1 = data.readTypedObject(RectF.CREATOR);
                    ResultReceiver _arg2 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.requestTextBoundsInfo(_arg0, _arg1, _arg2);
                    break;
                }
                case 31: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    InputContentInfo _arg1 = data.readTypedObject(InputContentInfo.CREATOR);
                    int _arg2 = data.readInt();
                    Bundle _arg3 = data.readTypedObject(Bundle.CREATOR);
                    AndroidFuture _arg4 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.commitContent(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 32: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    AndroidFuture _arg4 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.getSurroundingText(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 33: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setImeConsumesInput(_arg0, _arg1);
                    break;
                }
                case 34: {
                    InputConnectionCommandHeader _arg0 = data.readTypedObject(InputConnectionCommandHeader.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    CharSequence _arg3 = data.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                    int _arg4 = data.readInt();
                    TextAttribute _arg5 = data.readTypedObject(TextAttribute.CREATOR);
                    data.enforceNoDataAvail();
                    this.replaceText(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    break;
                }
                case 35: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.cancelCancellationSignal(_arg0);
                    break;
                }
                case 36: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.forgetCancellationSignal(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 35;
        }

        private static class Proxy
        implements IRemoteInputConnection {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IRemoteInputConnection.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getTextBeforeCursor(InputConnectionCommandHeader header, int length, int flags, AndroidFuture future) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeInt(length);
                    _data.writeInt(flags);
                    _data.writeTypedObject(future, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getTextAfterCursor(InputConnectionCommandHeader header, int length, int flags, AndroidFuture future) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeInt(length);
                    _data.writeInt(flags);
                    _data.writeTypedObject(future, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getCursorCapsMode(InputConnectionCommandHeader header, int reqModes, AndroidFuture future) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeInt(reqModes);
                    _data.writeTypedObject(future, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getExtractedText(InputConnectionCommandHeader header, ExtractedTextRequest request, int flags, AndroidFuture future) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeTypedObject(request, 0);
                    _data.writeInt(flags);
                    _data.writeTypedObject(future, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteSurroundingText(InputConnectionCommandHeader header, int beforeLength, int afterLength) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeInt(beforeLength);
                    _data.writeInt(afterLength);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteSurroundingTextInCodePoints(InputConnectionCommandHeader header, int beforeLength, int afterLength) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeInt(beforeLength);
                    _data.writeInt(afterLength);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setComposingText(InputConnectionCommandHeader header, CharSequence text, int newCursorPosition) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    if (text != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(text, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(newCursorPosition);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setComposingTextWithTextAttribute(InputConnectionCommandHeader header, CharSequence text, int newCursorPosition, TextAttribute textAttribute) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    if (text != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(text, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(newCursorPosition);
                    _data.writeTypedObject(textAttribute, 0);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finishComposingText(InputConnectionCommandHeader header) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void commitText(InputConnectionCommandHeader header, CharSequence text, int newCursorPosition) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    if (text != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(text, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(newCursorPosition);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void commitTextWithTextAttribute(InputConnectionCommandHeader header, CharSequence text, int newCursorPosition, TextAttribute textAttribute) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    if (text != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(text, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(newCursorPosition);
                    _data.writeTypedObject(textAttribute, 0);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void commitCompletion(InputConnectionCommandHeader header, CompletionInfo completion) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeTypedObject(completion, 0);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void commitCorrection(InputConnectionCommandHeader header, CorrectionInfo correction) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeTypedObject(correction, 0);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSelection(InputConnectionCommandHeader header, int start, int end) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeInt(start);
                    _data.writeInt(end);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void performEditorAction(InputConnectionCommandHeader header, int actionCode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeInt(actionCode);
                    boolean bl = this.mRemote.transact(15, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void performContextMenuAction(InputConnectionCommandHeader header, int id2) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeInt(id2);
                    boolean bl = this.mRemote.transact(16, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void beginBatchEdit(InputConnectionCommandHeader header) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    boolean bl = this.mRemote.transact(17, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void endBatchEdit(InputConnectionCommandHeader header) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    boolean bl = this.mRemote.transact(18, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendKeyEvent(InputConnectionCommandHeader header, KeyEvent event) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeTypedObject(event, 0);
                    boolean bl = this.mRemote.transact(19, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearMetaKeyStates(InputConnectionCommandHeader header, int states) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeInt(states);
                    boolean bl = this.mRemote.transact(20, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void performSpellCheck(InputConnectionCommandHeader header) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    boolean bl = this.mRemote.transact(21, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void performPrivateCommand(InputConnectionCommandHeader header, String action, Bundle data) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeString(action);
                    _data.writeTypedObject(data, 0);
                    boolean bl = this.mRemote.transact(22, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void performHandwritingGesture(InputConnectionCommandHeader header, ParcelableHandwritingGesture gesture, ResultReceiver resultReceiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeTypedObject(gesture, 0);
                    _data.writeTypedObject(resultReceiver, 0);
                    boolean bl = this.mRemote.transact(23, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void previewHandwritingGesture(InputConnectionCommandHeader header, ParcelableHandwritingGesture gesture, IBinder cancellationSignal) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeTypedObject(gesture, 0);
                    _data.writeStrongBinder(cancellationSignal);
                    boolean bl = this.mRemote.transact(24, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setComposingRegion(InputConnectionCommandHeader header, int start, int end) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeInt(start);
                    _data.writeInt(end);
                    boolean bl = this.mRemote.transact(25, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setComposingRegionWithTextAttribute(InputConnectionCommandHeader header, int start, int end, TextAttribute textAttribute) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeInt(start);
                    _data.writeInt(end);
                    _data.writeTypedObject(textAttribute, 0);
                    boolean bl = this.mRemote.transact(26, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getSelectedText(InputConnectionCommandHeader header, int flags, AndroidFuture future) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeInt(flags);
                    _data.writeTypedObject(future, 0);
                    boolean bl = this.mRemote.transact(27, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestCursorUpdates(InputConnectionCommandHeader header, int cursorUpdateMode, int imeDisplayId, AndroidFuture future) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeInt(cursorUpdateMode);
                    _data.writeInt(imeDisplayId);
                    _data.writeTypedObject(future, 0);
                    boolean bl = this.mRemote.transact(28, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestCursorUpdatesWithFilter(InputConnectionCommandHeader header, int cursorUpdateMode, int cursorUpdateFilter, int imeDisplayId, AndroidFuture future) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeInt(cursorUpdateMode);
                    _data.writeInt(cursorUpdateFilter);
                    _data.writeInt(imeDisplayId);
                    _data.writeTypedObject(future, 0);
                    boolean bl = this.mRemote.transact(29, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestTextBoundsInfo(InputConnectionCommandHeader header, RectF bounds, ResultReceiver resultReceiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeTypedObject(bounds, 0);
                    _data.writeTypedObject(resultReceiver, 0);
                    boolean bl = this.mRemote.transact(30, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void commitContent(InputConnectionCommandHeader header, InputContentInfo inputContentInfo, int flags, Bundle opts, AndroidFuture future) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeTypedObject(inputContentInfo, 0);
                    _data.writeInt(flags);
                    _data.writeTypedObject(opts, 0);
                    _data.writeTypedObject(future, 0);
                    boolean bl = this.mRemote.transact(31, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getSurroundingText(InputConnectionCommandHeader header, int beforeLength, int afterLength, int flags, AndroidFuture future) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeInt(beforeLength);
                    _data.writeInt(afterLength);
                    _data.writeInt(flags);
                    _data.writeTypedObject(future, 0);
                    boolean bl = this.mRemote.transact(32, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setImeConsumesInput(InputConnectionCommandHeader header, boolean imeConsumesInput) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeBoolean(imeConsumesInput);
                    boolean bl = this.mRemote.transact(33, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void replaceText(InputConnectionCommandHeader header, int start, int end, CharSequence text, int newCursorPosition, TextAttribute textAttribute) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeTypedObject(header, 0);
                    _data.writeInt(start);
                    _data.writeInt(end);
                    if (text != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(text, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(newCursorPosition);
                    _data.writeTypedObject(textAttribute, 0);
                    boolean bl = this.mRemote.transact(34, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelCancellationSignal(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean bl = this.mRemote.transact(35, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forgetCancellationSignal(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRemoteInputConnection.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean bl = this.mRemote.transact(36, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IRemoteInputConnection {
        @Override
        public void getTextBeforeCursor(InputConnectionCommandHeader header, int length, int flags, AndroidFuture future) throws RemoteException {
        }

        @Override
        public void getTextAfterCursor(InputConnectionCommandHeader header, int length, int flags, AndroidFuture future) throws RemoteException {
        }

        @Override
        public void getCursorCapsMode(InputConnectionCommandHeader header, int reqModes, AndroidFuture future) throws RemoteException {
        }

        @Override
        public void getExtractedText(InputConnectionCommandHeader header, ExtractedTextRequest request, int flags, AndroidFuture future) throws RemoteException {
        }

        @Override
        public void deleteSurroundingText(InputConnectionCommandHeader header, int beforeLength, int afterLength) throws RemoteException {
        }

        @Override
        public void deleteSurroundingTextInCodePoints(InputConnectionCommandHeader header, int beforeLength, int afterLength) throws RemoteException {
        }

        @Override
        public void setComposingText(InputConnectionCommandHeader header, CharSequence text, int newCursorPosition) throws RemoteException {
        }

        @Override
        public void setComposingTextWithTextAttribute(InputConnectionCommandHeader header, CharSequence text, int newCursorPosition, TextAttribute textAttribute) throws RemoteException {
        }

        @Override
        public void finishComposingText(InputConnectionCommandHeader header) throws RemoteException {
        }

        @Override
        public void commitText(InputConnectionCommandHeader header, CharSequence text, int newCursorPosition) throws RemoteException {
        }

        @Override
        public void commitTextWithTextAttribute(InputConnectionCommandHeader header, CharSequence text, int newCursorPosition, TextAttribute textAttribute) throws RemoteException {
        }

        @Override
        public void commitCompletion(InputConnectionCommandHeader header, CompletionInfo completion) throws RemoteException {
        }

        @Override
        public void commitCorrection(InputConnectionCommandHeader header, CorrectionInfo correction) throws RemoteException {
        }

        @Override
        public void setSelection(InputConnectionCommandHeader header, int start, int end) throws RemoteException {
        }

        @Override
        public void performEditorAction(InputConnectionCommandHeader header, int actionCode) throws RemoteException {
        }

        @Override
        public void performContextMenuAction(InputConnectionCommandHeader header, int id2) throws RemoteException {
        }

        @Override
        public void beginBatchEdit(InputConnectionCommandHeader header) throws RemoteException {
        }

        @Override
        public void endBatchEdit(InputConnectionCommandHeader header) throws RemoteException {
        }

        @Override
        public void sendKeyEvent(InputConnectionCommandHeader header, KeyEvent event) throws RemoteException {
        }

        @Override
        public void clearMetaKeyStates(InputConnectionCommandHeader header, int states) throws RemoteException {
        }

        @Override
        public void performSpellCheck(InputConnectionCommandHeader header) throws RemoteException {
        }

        @Override
        public void performPrivateCommand(InputConnectionCommandHeader header, String action, Bundle data) throws RemoteException {
        }

        @Override
        public void performHandwritingGesture(InputConnectionCommandHeader header, ParcelableHandwritingGesture gesture, ResultReceiver resultReceiver) throws RemoteException {
        }

        @Override
        public void previewHandwritingGesture(InputConnectionCommandHeader header, ParcelableHandwritingGesture gesture, IBinder cancellationSignal) throws RemoteException {
        }

        @Override
        public void setComposingRegion(InputConnectionCommandHeader header, int start, int end) throws RemoteException {
        }

        @Override
        public void setComposingRegionWithTextAttribute(InputConnectionCommandHeader header, int start, int end, TextAttribute textAttribute) throws RemoteException {
        }

        @Override
        public void getSelectedText(InputConnectionCommandHeader header, int flags, AndroidFuture future) throws RemoteException {
        }

        @Override
        public void requestCursorUpdates(InputConnectionCommandHeader header, int cursorUpdateMode, int imeDisplayId, AndroidFuture future) throws RemoteException {
        }

        @Override
        public void requestCursorUpdatesWithFilter(InputConnectionCommandHeader header, int cursorUpdateMode, int cursorUpdateFilter, int imeDisplayId, AndroidFuture future) throws RemoteException {
        }

        @Override
        public void requestTextBoundsInfo(InputConnectionCommandHeader header, RectF bounds, ResultReceiver resultReceiver) throws RemoteException {
        }

        @Override
        public void commitContent(InputConnectionCommandHeader header, InputContentInfo inputContentInfo, int flags, Bundle opts, AndroidFuture future) throws RemoteException {
        }

        @Override
        public void getSurroundingText(InputConnectionCommandHeader header, int beforeLength, int afterLength, int flags, AndroidFuture future) throws RemoteException {
        }

        @Override
        public void setImeConsumesInput(InputConnectionCommandHeader header, boolean imeConsumesInput) throws RemoteException {
        }

        @Override
        public void replaceText(InputConnectionCommandHeader header, int start, int end, CharSequence text, int newCursorPosition, TextAttribute textAttribute) throws RemoteException {
        }

        @Override
        public void cancelCancellationSignal(IBinder token) throws RemoteException {
        }

        @Override
        public void forgetCancellationSignal(IBinder token) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

