/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.annotation.RequiresPermission;
import android.app.ActivityThread;
import android.util.Log;
import android.util.proto.ProtoOutputStream;
import android.view.inputmethod.InputMethodManager;
import android.view.inputmethod.InputMethodManagerGlobal;
import com.android.internal.inputmethod.ImeTracingClientImpl;
import com.android.internal.inputmethod.ImeTracingServerImpl;
import java.io.PrintWriter;

public abstract class ImeTracing {
    static final String TAG = "imeTracing";
    public static final String PROTO_ARG = "--proto-com-android-imetracing";
    public static final int IME_TRACING_FROM_CLIENT = 0;
    public static final int IME_TRACING_FROM_IMS = 1;
    public static final int IME_TRACING_FROM_IMMS = 2;
    private static ImeTracing sInstance;
    static boolean sEnabled;
    private final boolean mIsAvailable = InputMethodManagerGlobal.isImeTraceAvailable();
    protected boolean mDumpInProgress;
    protected final Object mDumpInProgressLock = new Object();

    public static ImeTracing getInstance() {
        if (sInstance == null) {
            sInstance = ImeTracing.isSystemProcess() ? new ImeTracingServerImpl() : new ImeTracingClientImpl();
        }
        return sInstance;
    }

    public void sendToService(byte[] protoDump, int source, String where) {
        InputMethodManagerGlobal.startProtoDump(protoDump, source, where, e -> Log.e(TAG, "Exception while sending ime-related dump to server", e));
    }

    @RequiresPermission(value="android.permission.CONTROL_UI_TRACING")
    public void startImeTrace() {
        InputMethodManagerGlobal.startImeTrace(e -> Log.e(TAG, "Could not start ime trace.", e));
    }

    @RequiresPermission(value="android.permission.CONTROL_UI_TRACING")
    public void stopImeTrace() {
        InputMethodManagerGlobal.stopImeTrace(e -> Log.e(TAG, "Could not stop ime trace.", e));
    }

    public abstract void addToBuffer(ProtoOutputStream var1, int var2);

    public abstract void triggerClientDump(String var1, InputMethodManager var2, byte[] var3);

    public abstract void triggerServiceDump(String var1, ServiceDumper var2, byte[] var3);

    public abstract void triggerManagerServiceDump(String var1);

    public void saveForBugreport(PrintWriter pw) {
    }

    public void setEnabled(boolean enabled) {
        sEnabled = enabled;
    }

    public boolean isEnabled() {
        return sEnabled;
    }

    public boolean isAvailable() {
        return this.mIsAvailable;
    }

    public abstract void startTrace(PrintWriter var1);

    public abstract void stopTrace(PrintWriter var1);

    private static boolean isSystemProcess() {
        return ActivityThread.isSystem();
    }

    protected void logAndPrintln(PrintWriter pw, String msg) {
        Log.i(TAG, msg);
        if (pw != null) {
            pw.println(msg);
            pw.flush();
        }
    }

    static {
        sEnabled = false;
    }

    @FunctionalInterface
    public static interface ServiceDumper {
        public void dumpToProto(ProtoOutputStream var1, byte[] var2);
    }
}

