/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.jank;

import android.hardware.display.DisplayManager;
import android.hardware.display.DisplayManagerGlobal;
import android.os.Handler;
import android.util.SparseArray;
import android.view.DisplayInfo;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class DisplayResolutionTracker {
    private static final String TAG = DisplayResolutionTracker.class.getSimpleName();
    public static final int RESOLUTION_UNKNOWN = 0;
    public static final int RESOLUTION_SD = 1;
    public static final int RESOLUTION_HD = 2;
    public static final int RESOLUTION_FHD = 3;
    public static final int RESOLUTION_QHD = 4;
    private final DisplayInterface mManager;
    private final SparseArray<Integer> mResolutions = new SparseArray();
    private final Object mLock = new Object();

    public DisplayResolutionTracker(Handler handler) {
        this(DisplayInterface.getDefault(handler));
    }

    @VisibleForTesting
    public DisplayResolutionTracker(DisplayInterface manager) {
        this.mManager = manager;
        this.mManager.registerDisplayListener(new DisplayManager.DisplayListener(){

            @Override
            public void onDisplayAdded(int displayId) {
                DisplayResolutionTracker.this.updateDisplay(displayId);
            }

            @Override
            public void onDisplayChanged(int displayId) {
                DisplayResolutionTracker.this.updateDisplay(displayId);
            }

            @Override
            public void onDisplayRemoved(int displayId) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDisplay(int displayId) {
        DisplayInfo info = this.mManager.getDisplayInfo(displayId);
        if (info == null) {
            return;
        }
        int resolution = DisplayResolutionTracker.getResolution(info);
        Object object = this.mLock;
        synchronized (object) {
            this.mResolutions.put(displayId, resolution);
        }
    }

    public int getResolution(int displayId) {
        return this.mResolutions.get(displayId, 0);
    }

    @VisibleForTesting
    public static int getResolution(DisplayInfo info) {
        int smaller = Math.min(info.logicalWidth, info.logicalHeight);
        int larger = Math.max(info.logicalWidth, info.logicalHeight);
        if (smaller < 720 || larger < 1280) {
            return 1;
        }
        if (smaller < 1080 || larger < 1920) {
            return 2;
        }
        if (smaller < 1440 || larger < 2560) {
            return 3;
        }
        return 4;
    }

    @VisibleForTesting
    public static interface DisplayInterface {
        public static DisplayInterface getDefault(final Handler handler) {
            final DisplayManagerGlobal manager = DisplayManagerGlobal.getInstance();
            return new DisplayInterface(){

                @Override
                public void registerDisplayListener(DisplayManager.DisplayListener listener) {
                    manager.registerDisplayListener(listener, handler, 5L);
                }

                @Override
                public DisplayInfo getDisplayInfo(int displayId) {
                    return manager.getDisplayInfo(displayId);
                }
            };
        }

        public void registerDisplayListener(DisplayManager.DisplayListener var1);

        public DisplayInfo getDisplayInfo(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Resolution {
    }
}

