/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.jank;

import android.annotation.RequiresPermission;
import android.app.ActivityThread;
import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerExecutor;
import android.os.HandlerThread;
import android.os.SystemClock;
import android.os._Original_Build;
import android.provider.DeviceConfig;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import android.view.Choreographer;
import android.view.SurfaceControl;
import android.view.View;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.jank.DisplayResolutionTracker;
import com.android.internal.jank.EventLogTags;
import com.android.internal.jank.FrameTracker;
import com.android.internal.jank.InteractionMonitorDebugOverlay;
import com.android.internal.lang.System_Delegate;
import com.android.internal.util.PerfettoTrigger;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Instant;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;

public class InteractionJankMonitor {
    private static final String TAG = InteractionJankMonitor.class.getSimpleName();
    private static final boolean DEBUG = false;
    private static final String ACTION_PREFIX = InteractionJankMonitor.class.getCanonicalName();
    private static final String DEFAULT_WORKER_NAME = TAG + "-Worker";
    private static final long DEFAULT_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(2L);
    static final long EXECUTOR_TASK_TIMEOUT = 500L;
    private static final String SETTINGS_ENABLED_KEY = "enabled";
    private static final String SETTINGS_SAMPLING_INTERVAL_KEY = "sampling_interval";
    private static final String SETTINGS_THRESHOLD_MISSED_FRAMES_KEY = "trace_threshold_missed_frames";
    private static final String SETTINGS_THRESHOLD_FRAME_TIME_MILLIS_KEY = "trace_threshold_frame_time_millis";
    private static final String SETTINGS_DEBUG_OVERLAY_ENABLED_KEY = "debug_overlay_enabled";
    private static final boolean DEFAULT_ENABLED = _Original_Build.IS_DEBUGGABLE;
    private static final int DEFAULT_SAMPLING_INTERVAL = 1;
    private static final int DEFAULT_TRACE_THRESHOLD_MISSED_FRAMES = 3;
    private static final int DEFAULT_TRACE_THRESHOLD_FRAME_TIME_MILLIS = 64;
    private static final boolean DEFAULT_DEBUG_OVERLAY_ENABLED = false;
    @VisibleForTesting
    public static final int MAX_LENGTH_OF_CUJ_NAME = 80;
    private static final int MAX_LENGTH_SESSION_NAME = 100;
    public static final String ACTION_SESSION_END = ACTION_PREFIX + ".ACTION_SESSION_END";
    public static final String ACTION_SESSION_CANCEL = ACTION_PREFIX + ".ACTION_SESSION_CANCEL";
    public static final int CUJ_NOTIFICATION_SHADE_EXPAND_COLLAPSE = 0;
    public static final int CUJ_NOTIFICATION_SHADE_SCROLL_FLING = 2;
    public static final int CUJ_NOTIFICATION_SHADE_ROW_EXPAND = 3;
    public static final int CUJ_NOTIFICATION_SHADE_ROW_SWIPE = 4;
    public static final int CUJ_NOTIFICATION_SHADE_QS_EXPAND_COLLAPSE = 5;
    public static final int CUJ_NOTIFICATION_SHADE_QS_SCROLL_SWIPE = 6;
    public static final int CUJ_LAUNCHER_APP_LAUNCH_FROM_RECENTS = 7;
    public static final int CUJ_LAUNCHER_APP_LAUNCH_FROM_ICON = 8;
    public static final int CUJ_LAUNCHER_APP_CLOSE_TO_HOME = 9;
    public static final int CUJ_LAUNCHER_APP_CLOSE_TO_PIP = 10;
    public static final int CUJ_LAUNCHER_QUICK_SWITCH = 11;
    public static final int CUJ_NOTIFICATION_HEADS_UP_APPEAR = 12;
    public static final int CUJ_NOTIFICATION_HEADS_UP_DISAPPEAR = 13;
    public static final int CUJ_NOTIFICATION_ADD = 14;
    public static final int CUJ_NOTIFICATION_REMOVE = 15;
    public static final int CUJ_NOTIFICATION_APP_START = 16;
    public static final int CUJ_LOCKSCREEN_PASSWORD_APPEAR = 17;
    public static final int CUJ_LOCKSCREEN_PATTERN_APPEAR = 18;
    public static final int CUJ_LOCKSCREEN_PIN_APPEAR = 19;
    public static final int CUJ_LOCKSCREEN_PASSWORD_DISAPPEAR = 20;
    public static final int CUJ_LOCKSCREEN_PATTERN_DISAPPEAR = 21;
    public static final int CUJ_LOCKSCREEN_PIN_DISAPPEAR = 22;
    public static final int CUJ_LOCKSCREEN_TRANSITION_FROM_AOD = 23;
    public static final int CUJ_LOCKSCREEN_TRANSITION_TO_AOD = 24;
    public static final int CUJ_LAUNCHER_OPEN_ALL_APPS = 25;
    public static final int CUJ_LAUNCHER_ALL_APPS_SCROLL = 26;
    public static final int CUJ_LAUNCHER_APP_LAUNCH_FROM_WIDGET = 27;
    public static final int CUJ_SETTINGS_PAGE_SCROLL = 28;
    public static final int CUJ_LOCKSCREEN_UNLOCK_ANIMATION = 29;
    public static final int CUJ_SHADE_APP_LAUNCH_FROM_HISTORY_BUTTON = 30;
    public static final int CUJ_SHADE_APP_LAUNCH_FROM_MEDIA_PLAYER = 31;
    public static final int CUJ_SHADE_APP_LAUNCH_FROM_QS_TILE = 32;
    public static final int CUJ_SHADE_APP_LAUNCH_FROM_SETTINGS_BUTTON = 33;
    public static final int CUJ_STATUS_BAR_APP_LAUNCH_FROM_CALL_CHIP = 34;
    public static final int CUJ_PIP_TRANSITION = 35;
    public static final int CUJ_WALLPAPER_TRANSITION = 36;
    public static final int CUJ_USER_SWITCH = 37;
    public static final int CUJ_SPLASHSCREEN_AVD = 38;
    public static final int CUJ_SPLASHSCREEN_EXIT_ANIM = 39;
    public static final int CUJ_SCREEN_OFF = 40;
    public static final int CUJ_SCREEN_OFF_SHOW_AOD = 41;
    public static final int CUJ_ONE_HANDED_ENTER_TRANSITION = 42;
    public static final int CUJ_ONE_HANDED_EXIT_TRANSITION = 43;
    public static final int CUJ_UNFOLD_ANIM = 44;
    public static final int CUJ_SUW_LOADING_TO_SHOW_INFO_WITH_ACTIONS = 45;
    public static final int CUJ_SUW_SHOW_FUNCTION_SCREEN_WITH_ACTIONS = 46;
    public static final int CUJ_SUW_LOADING_TO_NEXT_FLOW = 47;
    public static final int CUJ_SUW_LOADING_SCREEN_FOR_STATUS = 48;
    public static final int CUJ_SPLIT_SCREEN_ENTER = 49;
    public static final int CUJ_SPLIT_SCREEN_EXIT = 50;
    public static final int CUJ_LOCKSCREEN_LAUNCH_CAMERA = 51;
    public static final int CUJ_SPLIT_SCREEN_RESIZE = 52;
    public static final int CUJ_SETTINGS_SLIDER = 53;
    public static final int CUJ_TAKE_SCREENSHOT = 54;
    public static final int CUJ_VOLUME_CONTROL = 55;
    public static final int CUJ_BIOMETRIC_PROMPT_TRANSITION = 56;
    public static final int CUJ_SETTINGS_TOGGLE = 57;
    public static final int CUJ_SHADE_DIALOG_OPEN = 58;
    public static final int CUJ_USER_DIALOG_OPEN = 59;
    public static final int CUJ_TASKBAR_EXPAND = 60;
    public static final int CUJ_TASKBAR_COLLAPSE = 61;
    public static final int CUJ_SHADE_CLEAR_ALL = 62;
    public static final int CUJ_LAUNCHER_UNLOCK_ENTRANCE_ANIMATION = 63;
    public static final int CUJ_LOCKSCREEN_OCCLUSION = 64;
    public static final int CUJ_RECENTS_SCROLLING = 65;
    public static final int CUJ_LAUNCHER_APP_SWIPE_TO_RECENTS = 66;
    public static final int CUJ_LAUNCHER_CLOSE_ALL_APPS_SWIPE = 67;
    public static final int CUJ_LAUNCHER_CLOSE_ALL_APPS_TO_HOME = 68;
    public static final int CUJ_IME_INSETS_ANIMATION = 69;
    public static final int CUJ_LOCKSCREEN_CLOCK_MOVE_ANIMATION = 70;
    public static final int CUJ_LAUNCHER_OPEN_SEARCH_RESULT = 71;
    private static final int LAST_CUJ = 71;
    private static final int NO_STATSD_LOGGING = -1;
    @VisibleForTesting
    public static final int[] CUJ_TO_STATSD_INTERACTION_TYPE = new int[72];
    private final DeviceConfig.OnPropertiesChangedListener mPropertiesChangedListener = this::updateProperties;
    @GuardedBy(value={"mLock"})
    private final SparseArray<FrameTracker> mRunningTrackers;
    @GuardedBy(value={"mLock"})
    private final SparseArray<Runnable> mTimeoutActions;
    private final HandlerThread mWorker;
    private final DisplayResolutionTracker mDisplayResolutionTracker;
    private final Object mLock = new Object();
    private int mDebugBgColor = -16711681;
    private double mDebugYOffset = 0.1;
    private InteractionMonitorDebugOverlay mDebugOverlay;
    private volatile boolean mEnabled = DEFAULT_ENABLED;
    private int mSamplingInterval = 1;
    private int mTraceThresholdMissedFrames = 3;
    private int mTraceThresholdFrameTimeMillis = 64;

    public static InteractionJankMonitor getInstance() {
        return InstanceHolder.INSTANCE;
    }

    @VisibleForTesting
    @RequiresPermission(value="android.permission.READ_DEVICE_CONFIG")
    public InteractionJankMonitor(HandlerThread worker) {
        this.mRunningTrackers = new SparseArray();
        this.mTimeoutActions = new SparseArray();
        this.mWorker = worker;
        this.mWorker.start();
        this.mDisplayResolutionTracker = new DisplayResolutionTracker(worker.getThreadHandler());
        this.mSamplingInterval = 1;
        this.mEnabled = DEFAULT_ENABLED;
        Application context = ActivityThread.currentApplication();
        if (((Context)context).checkCallingOrSelfPermission("android.permission.READ_DEVICE_CONFIG") != 0) {
            return;
        }
        this.mWorker.getThreadHandler().post(() -> {
            try {
                this.mPropertiesChangedListener.onPropertiesChanged(DeviceConfig.getProperties("interaction_jank_monitor", new String[0]));
                DeviceConfig.addOnPropertiesChangedListener("interaction_jank_monitor", new HandlerExecutor(this.mWorker.getThreadHandler()), this.mPropertiesChangedListener);
            }
            catch (SecurityException ex) {
                Log.d(TAG, "Can't get properties: READ_DEVICE_CONFIG granted=" + context.checkCallingOrSelfPermission("android.permission.READ_DEVICE_CONFIG") + ", package=" + context.getPackageName());
            }
        });
    }

    @VisibleForTesting
    public FrameTracker createFrameTracker(Configuration config, Session session) {
        View view = config.mView;
        if (!config.hasValidView()) {
            boolean attached = false;
            boolean hasViewRoot = false;
            boolean hasRenderer = false;
            if (view != null) {
                attached = view.isAttachedToWindow();
                hasViewRoot = view.getViewRootImpl() != null;
                hasRenderer = view.getThreadedRenderer() != null;
            }
            Log.d(TAG, "create FrameTracker fails: view=" + view + ", attached=" + attached + ", hasViewRoot=" + hasViewRoot + ", hasRenderer=" + hasRenderer, new Throwable());
            return null;
        }
        FrameTracker.ThreadedRendererWrapper threadedRenderer = view == null ? null : new FrameTracker.ThreadedRendererWrapper(view.getThreadedRenderer());
        FrameTracker.ViewRootWrapper viewRoot = view == null ? null : new FrameTracker.ViewRootWrapper(view.getViewRootImpl());
        FrameTracker.SurfaceControlWrapper surfaceControl = new FrameTracker.SurfaceControlWrapper();
        FrameTracker.ChoreographerWrapper choreographer = new FrameTracker.ChoreographerWrapper(Choreographer.getInstance());
        FrameTracker.FrameTrackerListener eventsListener = (s, act) -> this.handleCujEvents(act, s);
        FrameTracker.FrameMetricsWrapper frameMetrics = new FrameTracker.FrameMetricsWrapper();
        return new FrameTracker(this, session, config.getHandler(), threadedRenderer, viewRoot, surfaceControl, choreographer, frameMetrics, new FrameTracker.StatsLogWrapper(this.mDisplayResolutionTracker), this.mTraceThresholdMissedFrames, this.mTraceThresholdFrameTimeMillis, eventsListener, config);
    }

    private void handleCujEvents(String action, Session session) {
        if (this.needRemoveTasks(action, session)) {
            this.getTracker(session.getCuj()).getHandler().runWithScissors(() -> {
                this.removeTimeout(session.getCuj());
                this.removeTracker(session.getCuj(), session.getReason());
            }, 500L);
        }
    }

    private boolean needRemoveTasks(String action, Session session) {
        boolean badEnd = action.equals(ACTION_SESSION_END) && session.getReason() != 0;
        boolean badCancel = action.equals(ACTION_SESSION_CANCEL) && session.getReason() != 16 && session.getReason() != 19;
        return badEnd || badCancel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTimeout(int cujType) {
        Object object = this.mLock;
        synchronized (object) {
            Runnable timeout = this.mTimeoutActions.get(cujType);
            if (timeout != null) {
                this.getTracker(cujType).getHandler().removeCallbacks(timeout);
                this.mTimeoutActions.remove(cujType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInstrumenting(int cujType) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mRunningTrackers.contains(cujType);
        }
    }

    public boolean begin(View v, int cujType) {
        try {
            return this.begin(Configuration.Builder.withView(cujType, v));
        }
        catch (IllegalArgumentException ex) {
            Log.d(TAG, "Build configuration failed!", ex);
            return false;
        }
    }

    public boolean begin(Configuration.Builder builder) {
        try {
            Configuration config = builder.build();
            this.postEventLogToWorkerThread((unixNanos, elapsedNanos, realtimeNanos) -> EventLogTags.writeJankCujEventsBeginRequest(config.mCujType, unixNanos, elapsedNanos, realtimeNanos, config.mTag));
            TrackerResult result = new TrackerResult();
            boolean success = config.getHandler().runWithScissors(() -> {
                result.mResult = this.beginInternal(config);
            }, 500L);
            if (!success) {
                Log.d(TAG, "begin failed due to timeout, CUJ=" + InteractionJankMonitor.getNameOfCuj(config.mCujType));
                return false;
            }
            return result.mResult;
        }
        catch (IllegalArgumentException ex) {
            Log.d(TAG, "Build configuration failed!", ex);
            return false;
        }
    }

    private boolean beginInternal(Configuration conf) {
        int cujType = conf.mCujType;
        if (!this.shouldMonitor(cujType)) {
            return false;
        }
        FrameTracker tracker = this.getTracker(cujType);
        if (tracker != null) {
            return false;
        }
        tracker = this.createFrameTracker(conf, new Session(cujType, conf.mTag));
        if (tracker == null) {
            return false;
        }
        this.putTracker(cujType, tracker);
        tracker.begin();
        this.scheduleTimeoutAction(cujType, conf.mTimeout, () -> this.cancel(cujType, 19));
        return true;
    }

    @VisibleForTesting
    public boolean shouldMonitor(int cujType) {
        boolean shouldSample;
        boolean bl = shouldSample = ThreadLocalRandom.current().nextInt() % this.mSamplingInterval == 0;
        return this.mEnabled && shouldSample;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void scheduleTimeoutAction(int cuj, long timeout, Runnable action) {
        Object object = this.mLock;
        synchronized (object) {
            this.mTimeoutActions.put(cuj, action);
            this.getTracker(cuj).getHandler().postDelayed(action, timeout);
        }
    }

    public boolean end(int cujType) {
        this.postEventLogToWorkerThread((unixNanos, elapsedNanos, realtimeNanos) -> EventLogTags.writeJankCujEventsEndRequest(cujType, unixNanos, elapsedNanos, realtimeNanos));
        FrameTracker tracker = this.getTracker(cujType);
        if (tracker == null) {
            return false;
        }
        try {
            TrackerResult result = new TrackerResult();
            boolean success = tracker.getHandler().runWithScissors(() -> {
                result.mResult = this.endInternal(cujType);
            }, 500L);
            if (!success) {
                Log.d(TAG, "end failed due to timeout, CUJ=" + InteractionJankMonitor.getNameOfCuj(cujType));
                return false;
            }
            return result.mResult;
        }
        catch (IllegalArgumentException ex) {
            Log.d(TAG, "Execute end task failed!", ex);
            return false;
        }
    }

    private boolean endInternal(int cujType) {
        this.removeTimeout(cujType);
        FrameTracker tracker = this.getTracker(cujType);
        if (tracker == null) {
            return false;
        }
        if (tracker.end(0)) {
            this.removeTracker(cujType, 0);
        }
        return true;
    }

    public boolean cancel(int cujType) {
        this.postEventLogToWorkerThread((unixNanos, elapsedNanos, realtimeNanos) -> EventLogTags.writeJankCujEventsCancelRequest(cujType, unixNanos, elapsedNanos, realtimeNanos));
        return this.cancel(cujType, 16);
    }

    @VisibleForTesting
    public boolean cancel(int cujType, int reason) {
        FrameTracker tracker = this.getTracker(cujType);
        if (tracker == null) {
            return false;
        }
        try {
            TrackerResult result = new TrackerResult();
            boolean success = tracker.getHandler().runWithScissors(() -> {
                result.mResult = this.cancelInternal(cujType, reason);
            }, 500L);
            if (!success) {
                Log.d(TAG, "cancel failed due to timeout, CUJ=" + InteractionJankMonitor.getNameOfCuj(cujType));
                return false;
            }
            return result.mResult;
        }
        catch (IllegalArgumentException ex) {
            Log.d(TAG, "Execute cancel task failed!", ex);
            return false;
        }
    }

    private boolean cancelInternal(int cujType, int reason) {
        this.removeTimeout(cujType);
        FrameTracker tracker = this.getTracker(cujType);
        if (tracker == null) {
            return false;
        }
        if (tracker.cancel(reason)) {
            this.removeTracker(cujType, reason);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putTracker(int cuj, FrameTracker tracker) {
        Object object = this.mLock;
        synchronized (object) {
            this.mRunningTrackers.put(cuj, tracker);
            if (this.mDebugOverlay != null) {
                this.mDebugOverlay.onTrackerAdded(cuj, tracker);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FrameTracker getTracker(int cuj) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mRunningTrackers.get(cuj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTracker(int cuj, int reason) {
        Object object = this.mLock;
        synchronized (object) {
            this.mRunningTrackers.remove(cuj);
            if (this.mDebugOverlay != null) {
                this.mDebugOverlay.onTrackerRemoved(cuj, reason, this.mRunningTrackers);
            }
        }
    }

    private void updateProperties(DeviceConfig.Properties properties) {
        boolean debugOverlayEnabled;
        this.mSamplingInterval = properties.getInt(SETTINGS_SAMPLING_INTERVAL_KEY, 1);
        this.mTraceThresholdMissedFrames = properties.getInt(SETTINGS_THRESHOLD_MISSED_FRAMES_KEY, 3);
        this.mTraceThresholdFrameTimeMillis = properties.getInt(SETTINGS_THRESHOLD_FRAME_TIME_MILLIS_KEY, 64);
        boolean bl = debugOverlayEnabled = _Original_Build.IS_DEBUGGABLE && properties.getBoolean(SETTINGS_DEBUG_OVERLAY_ENABLED_KEY, false);
        if (debugOverlayEnabled && this.mDebugOverlay == null) {
            this.mDebugOverlay = new InteractionMonitorDebugOverlay(this.mLock, this.mDebugBgColor, this.mDebugYOffset);
        } else if (!debugOverlayEnabled && this.mDebugOverlay != null) {
            this.mDebugOverlay.dispose();
            this.mDebugOverlay = null;
        }
        this.mEnabled = properties.getBoolean(SETTINGS_ENABLED_KEY, DEFAULT_ENABLED);
    }

    @VisibleForTesting
    public DeviceConfig.OnPropertiesChangedListener getPropertiesChangedListener() {
        return this.mPropertiesChangedListener;
    }

    @VisibleForTesting
    public void trigger(Session session) {
        this.mWorker.getThreadHandler().post(() -> PerfettoTrigger.trigger(session.getPerfettoTrigger()));
    }

    public static String getNameOfInteraction(int interactionType) {
        return InteractionJankMonitor.getNameOfCuj(InteractionJankMonitor.getCujTypeFromInteraction(interactionType));
    }

    private static int getCujTypeFromInteraction(int interactionType) {
        return interactionType - 1;
    }

    public void configDebugOverlay(int bgColor, double yOffset) {
        this.mDebugBgColor = bgColor;
        this.mDebugYOffset = yOffset;
    }

    private static String listNamesOfCujs(SparseArray<FrameTracker> trackers) {
        return null;
    }

    public static String getNameOfCuj(int cujType) {
        switch (cujType) {
            case 0: {
                return "NOTIFICATION_SHADE_EXPAND_COLLAPSE";
            }
            case 2: {
                return "NOTIFICATION_SHADE_SCROLL_FLING";
            }
            case 3: {
                return "NOTIFICATION_SHADE_ROW_EXPAND";
            }
            case 4: {
                return "NOTIFICATION_SHADE_ROW_SWIPE";
            }
            case 5: {
                return "NOTIFICATION_SHADE_QS_EXPAND_COLLAPSE";
            }
            case 6: {
                return "NOTIFICATION_SHADE_QS_SCROLL_SWIPE";
            }
            case 7: {
                return "LAUNCHER_APP_LAUNCH_FROM_RECENTS";
            }
            case 8: {
                return "LAUNCHER_APP_LAUNCH_FROM_ICON";
            }
            case 9: {
                return "LAUNCHER_APP_CLOSE_TO_HOME";
            }
            case 10: {
                return "LAUNCHER_APP_CLOSE_TO_PIP";
            }
            case 11: {
                return "LAUNCHER_QUICK_SWITCH";
            }
            case 12: {
                return "NOTIFICATION_HEADS_UP_APPEAR";
            }
            case 13: {
                return "NOTIFICATION_HEADS_UP_DISAPPEAR";
            }
            case 14: {
                return "NOTIFICATION_ADD";
            }
            case 15: {
                return "NOTIFICATION_REMOVE";
            }
            case 16: {
                return "NOTIFICATION_APP_START";
            }
            case 17: {
                return "LOCKSCREEN_PASSWORD_APPEAR";
            }
            case 18: {
                return "LOCKSCREEN_PATTERN_APPEAR";
            }
            case 19: {
                return "LOCKSCREEN_PIN_APPEAR";
            }
            case 20: {
                return "LOCKSCREEN_PASSWORD_DISAPPEAR";
            }
            case 21: {
                return "LOCKSCREEN_PATTERN_DISAPPEAR";
            }
            case 22: {
                return "LOCKSCREEN_PIN_DISAPPEAR";
            }
            case 23: {
                return "LOCKSCREEN_TRANSITION_FROM_AOD";
            }
            case 24: {
                return "LOCKSCREEN_TRANSITION_TO_AOD";
            }
            case 25: {
                return "LAUNCHER_OPEN_ALL_APPS";
            }
            case 26: {
                return "LAUNCHER_ALL_APPS_SCROLL";
            }
            case 27: {
                return "LAUNCHER_APP_LAUNCH_FROM_WIDGET";
            }
            case 28: {
                return "SETTINGS_PAGE_SCROLL";
            }
            case 29: {
                return "LOCKSCREEN_UNLOCK_ANIMATION";
            }
            case 30: {
                return "SHADE_APP_LAUNCH_FROM_HISTORY_BUTTON";
            }
            case 31: {
                return "SHADE_APP_LAUNCH_FROM_MEDIA_PLAYER";
            }
            case 32: {
                return "SHADE_APP_LAUNCH_FROM_QS_TILE";
            }
            case 33: {
                return "SHADE_APP_LAUNCH_FROM_SETTINGS_BUTTON";
            }
            case 34: {
                return "STATUS_BAR_APP_LAUNCH_FROM_CALL_CHIP";
            }
            case 35: {
                return "PIP_TRANSITION";
            }
            case 36: {
                return "WALLPAPER_TRANSITION";
            }
            case 37: {
                return "USER_SWITCH";
            }
            case 38: {
                return "SPLASHSCREEN_AVD";
            }
            case 39: {
                return "SPLASHSCREEN_EXIT_ANIM";
            }
            case 40: {
                return "SCREEN_OFF";
            }
            case 41: {
                return "SCREEN_OFF_SHOW_AOD";
            }
            case 42: {
                return "ONE_HANDED_ENTER_TRANSITION";
            }
            case 43: {
                return "ONE_HANDED_EXIT_TRANSITION";
            }
            case 44: {
                return "UNFOLD_ANIM";
            }
            case 45: {
                return "SUW_LOADING_TO_SHOW_INFO_WITH_ACTIONS";
            }
            case 46: {
                return "SUW_SHOW_FUNCTION_SCREEN_WITH_ACTIONS";
            }
            case 47: {
                return "SUW_LOADING_TO_NEXT_FLOW";
            }
            case 48: {
                return "SUW_LOADING_SCREEN_FOR_STATUS";
            }
            case 49: {
                return "SPLIT_SCREEN_ENTER";
            }
            case 50: {
                return "SPLIT_SCREEN_EXIT";
            }
            case 51: {
                return "LOCKSCREEN_LAUNCH_CAMERA";
            }
            case 52: {
                return "SPLIT_SCREEN_RESIZE";
            }
            case 53: {
                return "SETTINGS_SLIDER";
            }
            case 54: {
                return "TAKE_SCREENSHOT";
            }
            case 55: {
                return "VOLUME_CONTROL";
            }
            case 56: {
                return "BIOMETRIC_PROMPT_TRANSITION";
            }
            case 57: {
                return "SETTINGS_TOGGLE";
            }
            case 58: {
                return "SHADE_DIALOG_OPEN";
            }
            case 59: {
                return "USER_DIALOG_OPEN";
            }
            case 60: {
                return "TASKBAR_EXPAND";
            }
            case 61: {
                return "TASKBAR_COLLAPSE";
            }
            case 62: {
                return "SHADE_CLEAR_ALL";
            }
            case 63: {
                return "LAUNCHER_UNLOCK_ENTRANCE_ANIMATION";
            }
            case 64: {
                return "LOCKSCREEN_OCCLUSION";
            }
            case 65: {
                return "RECENTS_SCROLLING";
            }
            case 66: {
                return "LAUNCHER_APP_SWIPE_TO_RECENTS";
            }
            case 67: {
                return "LAUNCHER_CLOSE_ALL_APPS_SWIPE";
            }
            case 68: {
                return "LAUNCHER_CLOSE_ALL_APPS_TO_HOME";
            }
            case 69: {
                return "IME_INSETS_ANIMATION";
            }
            case 70: {
                return "LOCKSCREEN_CLOCK_MOVE_ANIMATION";
            }
            case 71: {
                return "LAUNCHER_OPEN_SEARCH_RESULT";
            }
        }
        return "UNKNOWN";
    }

    private void postEventLogToWorkerThread(TimeFunction logFunction) {
        Instant now = Instant.now();
        long unixNanos = TimeUnit.NANOSECONDS.convert(now.getEpochSecond(), TimeUnit.SECONDS) + (long)now.getNano();
        long elapsedNanos = SystemClock.elapsedRealtimeNanos();
        long realtimeNanos = SystemClock.uptimeNanos();
        this.mWorker.getThreadHandler().post(() -> logFunction.invoke(unixNanos, elapsedNanos, realtimeNanos));
    }

    static {
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[0] = 1;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[1] = -1;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[2] = 3;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[3] = 4;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[4] = 5;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[5] = 6;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[6] = 7;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[7] = 8;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[8] = 9;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[9] = 10;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[10] = 11;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[11] = 12;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[12] = 13;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[13] = 14;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[14] = 15;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[15] = 16;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[16] = 17;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[17] = 18;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[18] = 19;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[19] = 20;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[20] = 21;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[21] = 22;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[22] = 23;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[23] = 24;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[24] = 25;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[25] = 26;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[26] = 27;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[27] = 28;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[28] = 29;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[29] = 30;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[30] = 31;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[31] = 32;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[32] = 33;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[33] = 34;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[34] = 35;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[35] = 36;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[36] = 37;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[37] = 38;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[38] = 39;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[39] = 40;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[40] = 41;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[41] = 42;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[42] = 43;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[43] = 44;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[44] = 45;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[45] = 46;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[46] = 47;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[47] = 48;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[48] = 49;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[49] = 50;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[50] = 51;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[51] = 52;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[52] = 53;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[53] = 54;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[54] = 55;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[55] = 56;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[56] = 57;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[57] = 58;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[58] = 59;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[59] = 60;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[60] = 61;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[61] = 62;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[62] = 63;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[63] = 64;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[64] = 65;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[65] = 66;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[66] = 67;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[67] = 68;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[68] = 69;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[69] = 70;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[70] = 71;
        InteractionJankMonitor.CUJ_TO_STATSD_INTERACTION_TYPE[71] = 72;
    }

    private static class InstanceHolder {
        public static final InteractionJankMonitor INSTANCE = new InteractionJankMonitor(new HandlerThread(DEFAULT_WORKER_NAME));

        private InstanceHolder() {
        }
    }

    public static class Configuration {
        private final View mView;
        private final Context mContext;
        private final long mTimeout;
        private final String mTag;
        private final boolean mSurfaceOnly;
        private final SurfaceControl mSurfaceControl;
        private final int mCujType;
        private final boolean mDeferMonitor;
        private final Handler mHandler;

        private Configuration(int cuj, View view, String tag, long timeout, boolean surfaceOnly, Context context, SurfaceControl surfaceControl, boolean deferMonitor) {
            this.mCujType = cuj;
            this.mTag = tag;
            this.mTimeout = timeout;
            this.mView = view;
            this.mSurfaceOnly = surfaceOnly;
            this.mContext = context != null ? context : (view != null ? view.getContext().getApplicationContext() : null);
            this.mSurfaceControl = surfaceControl;
            this.mDeferMonitor = deferMonitor;
            this.validate();
            this.mHandler = this.mSurfaceOnly ? this.mContext.getMainThreadHandler() : this.mView.getHandler();
        }

        private void validate() {
            boolean shouldThrow = false;
            StringBuilder msg = new StringBuilder();
            if (this.mTag == null) {
                shouldThrow = true;
                msg.append("Invalid tag; ");
            }
            if (this.mTimeout < 0L) {
                shouldThrow = true;
                msg.append("Invalid timeout value; ");
            }
            if (this.mSurfaceOnly) {
                if (this.mContext == null) {
                    shouldThrow = true;
                    msg.append("Must pass in a context if only instrument surface; ");
                }
                if (this.mSurfaceControl == null || !this.mSurfaceControl.isValid()) {
                    shouldThrow = true;
                    msg.append("Must pass in a valid surface control if only instrument surface; ");
                }
            } else if (!this.hasValidView()) {
                shouldThrow = true;
                boolean attached = false;
                boolean hasViewRoot = false;
                boolean hasRenderer = false;
                if (this.mView != null) {
                    attached = this.mView.isAttachedToWindow();
                    hasViewRoot = this.mView.getViewRootImpl() != null;
                    hasRenderer = this.mView.getThreadedRenderer() != null;
                }
                String err = "invalid view: view=" + this.mView + ", attached=" + attached + ", hasViewRoot=" + hasViewRoot + ", hasRenderer=" + hasRenderer;
                msg.append(err);
            }
            if (shouldThrow) {
                throw new IllegalArgumentException(msg.toString());
            }
        }

        boolean hasValidView() {
            return this.mSurfaceOnly || this.mView != null && this.mView.isAttachedToWindow() && this.mView.getViewRootImpl() != null && this.mView.getThreadedRenderer() != null;
        }

        public boolean isSurfaceOnly() {
            return this.mSurfaceOnly;
        }

        public SurfaceControl getSurfaceControl() {
            return this.mSurfaceControl;
        }

        @VisibleForTesting
        public View getView() {
            return this.mView;
        }

        public boolean shouldDeferMonitor() {
            return this.mDeferMonitor;
        }

        @VisibleForTesting
        public Handler getHandler() {
            return this.mHandler;
        }

        @VisibleForTesting
        public int getDisplayId() {
            return (this.mSurfaceOnly ? this.mContext : this.mView.getContext()).getDisplayId();
        }

        public static class Builder {
            private View mAttrView = null;
            private Context mAttrContext = null;
            private long mAttrTimeout = DEFAULT_TIMEOUT_MS;
            private String mAttrTag = "";
            private boolean mAttrSurfaceOnly;
            private SurfaceControl mAttrSurfaceControl;
            private int mAttrCujType;
            private boolean mAttrDeferMonitor = true;

            public static Builder withSurface(int cuj, Context context, SurfaceControl surfaceControl) {
                return new Builder(cuj).setContext(context).setSurfaceControl(surfaceControl).setSurfaceOnly(true);
            }

            public static Builder withView(int cuj, View view) {
                return new Builder(cuj).setView(view).setContext(view.getContext());
            }

            private Builder(int cuj) {
                this.mAttrCujType = cuj;
            }

            private Builder setView(View view) {
                this.mAttrView = view;
                return this;
            }

            public Builder setTimeout(long timeout) {
                this.mAttrTimeout = timeout;
                return this;
            }

            public Builder setTag(String tag) {
                this.mAttrTag = tag;
                return this;
            }

            private Builder setSurfaceOnly(boolean surfaceOnly) {
                this.mAttrSurfaceOnly = surfaceOnly;
                return this;
            }

            private Builder setContext(Context context) {
                this.mAttrContext = context;
                return this;
            }

            private Builder setSurfaceControl(SurfaceControl surfaceControl) {
                this.mAttrSurfaceControl = surfaceControl;
                return this;
            }

            public Builder setDeferMonitorForAnimationStart(boolean defer) {
                this.mAttrDeferMonitor = defer;
                return this;
            }

            public Configuration build() throws IllegalArgumentException {
                return new Configuration(this.mAttrCujType, this.mAttrView, this.mAttrTag, this.mAttrTimeout, this.mAttrSurfaceOnly, this.mAttrContext, this.mAttrSurfaceControl, this.mAttrDeferMonitor);
            }
        }
    }

    public static class Session {
        private final int mCujType;
        private final long mTimeStamp;
        private int mReason = -1;
        private final String mName;

        public Session(int cujType, String postfix) {
            this.mCujType = cujType;
            this.mTimeStamp = System_Delegate.nanoTime();
            this.mName = this.generateSessionName(InteractionJankMonitor.getNameOfCuj(cujType), postfix);
        }

        private String generateSessionName(String cujName, String cujPostfix) {
            boolean hasPostfix;
            boolean bl = hasPostfix = !TextUtils.isEmpty(cujPostfix);
            if (cujName.length() > 80) {
                throw new IllegalArgumentException(TextUtils.formatSimple("The length of cuj name <%s> exceeds %d", cujName, 80));
            }
            if (hasPostfix) {
                int remaining = 100 - cujName.length();
                if (cujPostfix.length() > remaining) {
                    cujPostfix = cujPostfix.substring(0, remaining - 3).concat("...");
                }
            }
            return hasPostfix ? TextUtils.formatSimple("J<%s::%s>", cujName, cujPostfix) : TextUtils.formatSimple("J<%s>", cujName);
        }

        public int getCuj() {
            return this.mCujType;
        }

        public int getStatsdInteractionType() {
            return CUJ_TO_STATSD_INTERACTION_TYPE[this.mCujType];
        }

        public boolean logToStatsd() {
            return this.getStatsdInteractionType() != -1;
        }

        public String getPerfettoTrigger() {
            return String.format(Locale.US, "com.android.telemetry.interaction-jank-monitor-%d", this.mCujType);
        }

        public String getName() {
            return this.mName;
        }

        public long getTimeStamp() {
            return this.mTimeStamp;
        }

        public void setReason(int reason) {
            this.mReason = reason;
        }

        public int getReason() {
            return this.mReason;
        }
    }

    @FunctionalInterface
    private static interface TimeFunction {
        public void invoke(long var1, long var3, long var5);
    }

    private static class TrackerResult {
        private boolean mResult;

        private TrackerResult() {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CujType {
    }
}

