/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.jank;

import android.app.ActivityThread;
import android.app.Application;
import android.content.Context;
import android.graphics.Paint;
import android.graphics.RecordingCanvas;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Trace;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.WindowCallbacks;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.jank.FrameTracker;
import com.android.internal.jank.InteractionJankMonitor;

class InteractionMonitorDebugOverlay
implements WindowCallbacks {
    private static final int REASON_STILL_RUNNING = -1000;
    private final Object mLock;
    @GuardedBy(value={"mLock"})
    private final SparseIntArray mRunningCujs = new SparseIntArray();
    private Handler mHandler = null;
    private FrameTracker.ViewRootWrapper mViewRoot = null;
    private final Paint mDebugPaint;
    private final Paint.FontMetrics mDebugFontMetrics;
    private final int mBgColor;
    private final double mYOffset;
    private final String mPackageName;
    private static final String TRACK_NAME = "InteractionJankMonitor";

    InteractionMonitorDebugOverlay(Object lock, int bgColor, double yOffset) {
        this.mLock = lock;
        this.mBgColor = bgColor;
        this.mYOffset = yOffset;
        this.mDebugPaint = new Paint();
        this.mDebugPaint.setAntiAlias(false);
        this.mDebugFontMetrics = new Paint.FontMetrics();
        Application context = ActivityThread.currentApplication();
        this.mPackageName = ((Context)context).getPackageName();
    }

    void dispose() {
        if (this.mViewRoot != null && this.mHandler != null) {
            this.mHandler.runWithScissors(() -> this.mViewRoot.removeWindowCallbacks(this), 500L);
            this.forceRedraw();
        }
        this.mHandler = null;
        this.mViewRoot = null;
        Trace.asyncTraceForTrackEnd(4096L, TRACK_NAME, 0);
    }

    private boolean attachViewRootIfNeeded(FrameTracker tracker) {
        FrameTracker.ViewRootWrapper viewRoot = tracker.getViewRoot();
        if (this.mViewRoot == null && viewRoot != null) {
            Trace.asyncTraceForTrackBegin(4096L, TRACK_NAME, "DEBUG_OVERLAY_DRAW", 0);
            this.mHandler = tracker.getHandler();
            this.mViewRoot = viewRoot;
            this.mHandler.runWithScissors(() -> viewRoot.addWindowCallbacks(this), 500L);
            this.forceRedraw();
            return true;
        }
        return false;
    }

    private float getWidthOfLongestCujName(int cujFontSize) {
        this.mDebugPaint.setTextSize(cujFontSize);
        float maxLength = 0.0f;
        for (int i = 0; i < this.mRunningCujs.size(); ++i) {
            String cujName = InteractionJankMonitor.getNameOfCuj(this.mRunningCujs.keyAt(i));
            float textLength = this.mDebugPaint.measureText(cujName);
            if (!(textLength > maxLength)) continue;
            maxLength = textLength;
        }
        return maxLength;
    }

    private float getTextHeight(int textSize) {
        this.mDebugPaint.setTextSize(textSize);
        this.mDebugPaint.getFontMetrics(this.mDebugFontMetrics);
        return this.mDebugFontMetrics.descent - this.mDebugFontMetrics.ascent;
    }

    private int dipToPx(int dip) {
        if (this.mViewRoot != null) {
            return this.mViewRoot.dipToPx(dip);
        }
        return dip;
    }

    private void forceRedraw() {
        if (this.mViewRoot != null && this.mHandler != null) {
            this.mHandler.runWithScissors(() -> {
                this.mViewRoot.requestInvalidateRootRenderNode();
                this.mViewRoot.getView().invalidate();
            }, 500L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onTrackerRemoved(int removedCuj, int reason, SparseArray<FrameTracker> runningTrackers) {
        Object object = this.mLock;
        synchronized (object) {
            this.mRunningCujs.put(removedCuj, reason);
            if (this.mRunningCujs.indexOfValue(-1000) < 0) {
                this.mRunningCujs.clear();
                this.dispose();
            } else {
                int i;
                boolean needsNewViewRoot = true;
                if (this.mViewRoot != null) {
                    for (i = 0; i < runningTrackers.size(); ++i) {
                        if (!this.mViewRoot.equals(runningTrackers.valueAt(i).getViewRoot())) continue;
                        needsNewViewRoot = false;
                        break;
                    }
                }
                if (needsNewViewRoot) {
                    this.dispose();
                    for (i = 0; i < runningTrackers.size() && !this.attachViewRootIfNeeded(runningTrackers.valueAt(i)); ++i) {
                    }
                } else {
                    this.forceRedraw();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onTrackerAdded(int addedCuj, FrameTracker tracker) {
        Object object = this.mLock;
        synchronized (object) {
            this.mRunningCujs.put(addedCuj, -1000);
            this.attachViewRootIfNeeded(tracker);
            this.forceRedraw();
        }
    }

    @Override
    public void onWindowSizeIsChanging(Rect newBounds, boolean fullscreen, Rect systemInsets, Rect stableInsets) {
    }

    @Override
    public void onWindowDragResizeStart(Rect initialBounds, boolean fullscreen, Rect systemInsets, Rect stableInsets) {
    }

    @Override
    public void onWindowDragResizeEnd() {
    }

    @Override
    public boolean onContentDrawn(int offsetX, int offsetY, int sizeX, int sizeY) {
        return false;
    }

    @Override
    public void onRequestDraw(boolean reportNextDraw) {
    }

    @Override
    public void onPostDraw(RecordingCanvas canvas) {
        int padding = this.dipToPx(5);
        int h = canvas.getHeight();
        int w = canvas.getWidth();
        int dy = (int)((double)h * this.mYOffset);
        int packageNameFontSize = this.dipToPx(12);
        int cujFontSize = this.dipToPx(18);
        float cujNameTextHeight = this.getTextHeight(cujFontSize);
        float packageNameTextHeight = this.getTextHeight(packageNameFontSize);
        float maxLength = this.getWidthOfLongestCujName(cujFontSize);
        int dx = (int)(((float)w - maxLength) / 2.0f);
        canvas.translate(dx, dy);
        this.mDebugPaint.setColor(this.mBgColor);
        canvas.drawRect(-padding * 2, -padding, (float)(padding * 2) + maxLength, (float)(padding * 2) + packageNameTextHeight + cujNameTextHeight * (float)this.mRunningCujs.size(), this.mDebugPaint);
        this.mDebugPaint.setTextSize(packageNameFontSize);
        this.mDebugPaint.setColor(-16777216);
        this.mDebugPaint.setStrikeThruText(false);
        canvas.translate(0.0f, packageNameTextHeight);
        canvas.drawText("package:" + this.mPackageName, 0.0f, 0.0f, this.mDebugPaint);
        this.mDebugPaint.setTextSize(cujFontSize);
        for (int i = 0; i < this.mRunningCujs.size(); ++i) {
            int status = this.mRunningCujs.valueAt(i);
            if (status == -1000) {
                this.mDebugPaint.setColor(-16777216);
                this.mDebugPaint.setStrikeThruText(false);
            } else if (status == 0) {
                this.mDebugPaint.setColor(-7829368);
                this.mDebugPaint.setStrikeThruText(false);
            } else {
                this.mDebugPaint.setColor(-65536);
                this.mDebugPaint.setStrikeThruText(true);
            }
            String cujName = InteractionJankMonitor.getNameOfCuj(this.mRunningCujs.keyAt(i));
            canvas.translate(0.0f, cujNameTextHeight);
            canvas.drawText(cujName, 0.0f, 0.0f, this.mDebugPaint);
        }
    }
}

