/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.net;

import android.app.PendingIntent;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.net.IpPrefix;
import android.net.LinkAddress;
import android.net.Network;
import android.net.ProxyInfo;
import android.net.RouteInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class VpnConfig
implements Parcelable {
    public static final String SERVICE_INTERFACE = "android.net.VpnService";
    public static final String DIALOGS_PACKAGE = "com.android.vpndialogs";
    public static final String LEGACY_VPN = "[Legacy VPN]";
    public String user;
    public String interfaze;
    public String session;
    public int mtu = -1;
    public List<LinkAddress> addresses = new ArrayList<LinkAddress>();
    public List<RouteInfo> routes = new ArrayList<RouteInfo>();
    public List<String> dnsServers;
    public List<String> searchDomains;
    public List<String> allowedApplications;
    public List<String> disallowedApplications;
    public PendingIntent configureIntent;
    public long startTime = -1L;
    public boolean legacy;
    public boolean blocking;
    public boolean allowBypass;
    public boolean allowIPv4;
    public boolean allowIPv6;
    public boolean isMetered = true;
    public boolean requiresInternetValidation = false;
    public boolean excludeLocalRoutes = false;
    public Network[] underlyingNetworks;
    public ProxyInfo proxyInfo;
    public static final Parcelable.Creator<VpnConfig> CREATOR = new Parcelable.Creator<VpnConfig>(){

        @Override
        public VpnConfig createFromParcel(Parcel in) {
            VpnConfig config = new VpnConfig();
            config.user = in.readString();
            config.interfaze = in.readString();
            config.session = in.readString();
            config.mtu = in.readInt();
            in.readTypedList(config.addresses, LinkAddress.CREATOR);
            in.readTypedList(config.routes, RouteInfo.CREATOR);
            config.dnsServers = in.createStringArrayList();
            config.searchDomains = in.createStringArrayList();
            config.allowedApplications = in.createStringArrayList();
            config.disallowedApplications = in.createStringArrayList();
            config.configureIntent = in.readParcelable(null, PendingIntent.class);
            config.startTime = in.readLong();
            config.legacy = in.readInt() != 0;
            config.blocking = in.readInt() != 0;
            config.allowBypass = in.readInt() != 0;
            config.allowIPv4 = in.readInt() != 0;
            config.allowIPv6 = in.readInt() != 0;
            config.isMetered = in.readInt() != 0;
            config.requiresInternetValidation = in.readInt() != 0;
            config.excludeLocalRoutes = in.readInt() != 0;
            config.underlyingNetworks = in.createTypedArray(Network.CREATOR);
            config.proxyInfo = in.readParcelable(null, ProxyInfo.class);
            return config;
        }

        public VpnConfig[] newArray(int size) {
            return new VpnConfig[size];
        }
    };

    public static Intent getIntentForConfirmation() {
        Intent intent = new Intent();
        ComponentName componentName = ComponentName.unflattenFromString(Resources.getSystem().getString(17039870));
        intent.setClassName(componentName.getPackageName(), componentName.getClassName());
        return intent;
    }

    public static PendingIntent getIntentForStatusPanel(Context context) {
        Intent intent = new Intent();
        intent.setClassName(DIALOGS_PACKAGE, "com.android.vpndialogs.ManageDialog");
        intent.addFlags(0x50800000);
        return PendingIntent.getActivityAsUser(context, 0, intent, 0x4000000, null, UserHandle.CURRENT);
    }

    public static CharSequence getVpnLabel(Context context, String packageName) throws PackageManager.NameNotFoundException {
        PackageManager pm = context.getPackageManager();
        Intent intent = new Intent(SERVICE_INTERFACE);
        intent.setPackage(packageName);
        List<ResolveInfo> services = pm.queryIntentServices(intent, 0);
        if (services != null && services.size() == 1) {
            return services.get(0).loadLabel(pm);
        }
        return pm.getApplicationInfo(packageName, 0).loadLabel(pm);
    }

    @UnsupportedAppUsage
    public VpnConfig() {
    }

    public VpnConfig(VpnConfig other) {
        this.user = other.user;
        this.interfaze = other.interfaze;
        this.session = other.session;
        this.mtu = other.mtu;
        this.addresses = VpnConfig.copyOf(other.addresses);
        this.routes = VpnConfig.copyOf(other.routes);
        this.dnsServers = VpnConfig.copyOf(other.dnsServers);
        this.searchDomains = VpnConfig.copyOf(other.searchDomains);
        this.allowedApplications = VpnConfig.copyOf(other.allowedApplications);
        this.disallowedApplications = VpnConfig.copyOf(other.disallowedApplications);
        this.configureIntent = other.configureIntent;
        this.startTime = other.startTime;
        this.legacy = other.legacy;
        this.blocking = other.blocking;
        this.allowBypass = other.allowBypass;
        this.allowIPv4 = other.allowIPv4;
        this.allowIPv6 = other.allowIPv6;
        this.isMetered = other.isMetered;
        this.requiresInternetValidation = other.requiresInternetValidation;
        this.excludeLocalRoutes = other.excludeLocalRoutes;
        this.underlyingNetworks = other.underlyingNetworks != null ? Arrays.copyOf(other.underlyingNetworks, other.underlyingNetworks.length) : null;
        this.proxyInfo = other.proxyInfo;
    }

    private static <T> List<T> copyOf(List<T> list) {
        return list != null ? new ArrayList<T>(list) : null;
    }

    public void addLegacyRoutes(String routesStr) {
        String[] routes;
        if (routesStr.trim().equals("")) {
            return;
        }
        for (String route : routes = routesStr.trim().split(" ")) {
            RouteInfo info = new RouteInfo(new IpPrefix(route), null, null, 1);
            this.routes.add(info);
        }
    }

    public void addLegacyAddresses(String addressesStr) {
        String[] addresses;
        if (addressesStr.trim().equals("")) {
            return;
        }
        for (String address : addresses = addressesStr.trim().split(" ")) {
            LinkAddress addr = new LinkAddress(address);
            this.addresses.add(addr);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.user);
        out.writeString(this.interfaze);
        out.writeString(this.session);
        out.writeInt(this.mtu);
        out.writeTypedList(this.addresses);
        out.writeTypedList(this.routes);
        out.writeStringList(this.dnsServers);
        out.writeStringList(this.searchDomains);
        out.writeStringList(this.allowedApplications);
        out.writeStringList(this.disallowedApplications);
        out.writeParcelable(this.configureIntent, flags);
        out.writeLong(this.startTime);
        out.writeInt(this.legacy ? 1 : 0);
        out.writeInt(this.blocking ? 1 : 0);
        out.writeInt(this.allowBypass ? 1 : 0);
        out.writeInt(this.allowIPv4 ? 1 : 0);
        out.writeInt(this.allowIPv6 ? 1 : 0);
        out.writeInt(this.isMetered ? 1 : 0);
        out.writeInt(this.requiresInternetValidation ? 1 : 0);
        out.writeInt(this.excludeLocalRoutes ? 1 : 0);
        out.writeTypedArray(this.underlyingNetworks, flags);
        out.writeParcelable(this.proxyInfo, flags);
    }

    public String toString() {
        return "VpnConfig" + "{ user=" + this.user + ", interface=" + this.interfaze + ", session=" + this.session + ", mtu=" + this.mtu + ", addresses=" + VpnConfig.toString(this.addresses) + ", routes=" + VpnConfig.toString(this.routes) + ", dns=" + VpnConfig.toString(this.dnsServers) + ", searchDomains=" + VpnConfig.toString(this.searchDomains) + ", allowedApps=" + VpnConfig.toString(this.allowedApplications) + ", disallowedApps=" + VpnConfig.toString(this.disallowedApplications) + ", configureIntent=" + this.configureIntent + ", startTime=" + this.startTime + ", legacy=" + this.legacy + ", blocking=" + this.blocking + ", allowBypass=" + this.allowBypass + ", allowIPv4=" + this.allowIPv4 + ", allowIPv6=" + this.allowIPv6 + ", isMetered=" + this.isMetered + ", requiresInternetValidation=" + this.requiresInternetValidation + ", excludeLocalRoutes=" + this.excludeLocalRoutes + ", underlyingNetworks=" + Arrays.toString(this.underlyingNetworks) + ", proxyInfo=" + this.proxyInfo + "}";
    }

    static <T> String toString(List<T> ls) {
        if (ls == null) {
            return "null";
        }
        return Arrays.toString(ls.toArray());
    }
}

