/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.net.vcn.util;

import android.os.ParcelUuid;
import android.os.PersistableBundle;
import com.android.internal.net.ipsec.ike.utils.HexDump;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class PersistableBundleUtils {
    private static final String LIST_KEY_FORMAT = "LIST_ITEM_%d";
    private static final String COLLECTION_SIZE_KEY = "COLLECTION_LENGTH";
    private static final String MAP_KEY_FORMAT = "MAP_KEY_%d";
    private static final String MAP_VALUE_FORMAT = "MAP_VALUE_%d";
    private static final String PARCEL_UUID_KEY = "PARCEL_UUID";
    private static final String BYTE_ARRAY_KEY = "BYTE_ARRAY_KEY";
    private static final String INTEGER_KEY = "INTEGER_KEY";
    private static final String STRING_KEY = "STRING_KEY";
    public static final Serializer<Integer> INTEGER_SERIALIZER = i -> {
        PersistableBundle result = new PersistableBundle();
        result.putInt(INTEGER_KEY, (int)i);
        return result;
    };
    public static final Deserializer<Integer> INTEGER_DESERIALIZER = bundle -> {
        Objects.requireNonNull(bundle, "PersistableBundle is null");
        return bundle.getInt(INTEGER_KEY);
    };
    public static final Serializer<String> STRING_SERIALIZER = i -> {
        PersistableBundle result = new PersistableBundle();
        result.putString(STRING_KEY, (String)i);
        return result;
    };
    public static final Deserializer<String> STRING_DESERIALIZER = bundle -> {
        Objects.requireNonNull(bundle, "PersistableBundle is null");
        return bundle.getString(STRING_KEY);
    };

    public static PersistableBundle fromParcelUuid(ParcelUuid uuid) {
        PersistableBundle result = new PersistableBundle();
        result.putString(PARCEL_UUID_KEY, uuid.toString());
        return result;
    }

    public static ParcelUuid toParcelUuid(PersistableBundle bundle) {
        return ParcelUuid.fromString(bundle.getString(PARCEL_UUID_KEY));
    }

    public static <T> PersistableBundle fromList(List<T> in, Serializer<T> serializer) {
        PersistableBundle result = new PersistableBundle();
        result.putInt(COLLECTION_SIZE_KEY, in.size());
        for (int i = 0; i < in.size(); ++i) {
            String key = String.format(LIST_KEY_FORMAT, i);
            result.putPersistableBundle(key, serializer.toPersistableBundle(in.get(i)));
        }
        return result;
    }

    public static <T> List<T> toList(PersistableBundle in, Deserializer<T> deserializer) {
        int listLength = in.getInt(COLLECTION_SIZE_KEY);
        ArrayList<T> result = new ArrayList<T>(listLength);
        for (int i = 0; i < listLength; ++i) {
            String key = String.format(LIST_KEY_FORMAT, i);
            PersistableBundle item = in.getPersistableBundle(key);
            result.add(deserializer.fromPersistableBundle(item));
        }
        return result;
    }

    public static PersistableBundle fromByteArray(byte[] array2) {
        PersistableBundle result = new PersistableBundle();
        result.putString(BYTE_ARRAY_KEY, HexDump.toHexString(array2));
        return result;
    }

    public static byte[] toByteArray(PersistableBundle bundle) {
        Objects.requireNonNull(bundle, "PersistableBundle is null");
        String hex = bundle.getString(BYTE_ARRAY_KEY);
        if (hex == null || hex.length() % 2 != 0) {
            throw new IllegalArgumentException("PersistableBundle contains invalid byte array");
        }
        return HexDump.hexStringToByteArray(hex);
    }

    public static <K, V> PersistableBundle fromMap(Map<K, V> in, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        PersistableBundle result = new PersistableBundle();
        result.putInt(COLLECTION_SIZE_KEY, in.size());
        int i = 0;
        for (Map.Entry<K, V> entry : in.entrySet()) {
            String keyKey = String.format(MAP_KEY_FORMAT, i);
            String valueKey = String.format(MAP_VALUE_FORMAT, i);
            result.putPersistableBundle(keyKey, keySerializer.toPersistableBundle(entry.getKey()));
            result.putPersistableBundle(valueKey, valueSerializer.toPersistableBundle(entry.getValue()));
            ++i;
        }
        return result;
    }

    public static <K, V> LinkedHashMap<K, V> toMap(PersistableBundle in, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        int mapSize = in.getInt(COLLECTION_SIZE_KEY);
        LinkedHashMap<K, V> result = new LinkedHashMap<K, V>(mapSize);
        for (int i = 0; i < mapSize; ++i) {
            String keyKey = String.format(MAP_KEY_FORMAT, i);
            String valueKey = String.format(MAP_VALUE_FORMAT, i);
            PersistableBundle keyBundle = in.getPersistableBundle(keyKey);
            PersistableBundle valueBundle = in.getPersistableBundle(valueKey);
            K key = keyDeserializer.fromPersistableBundle(keyBundle);
            V value = valueDeserializer.fromPersistableBundle(valueBundle);
            result.put(key, value);
        }
        return result;
    }

    public static byte[] toDiskStableBytes(PersistableBundle bundle) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        bundle.writeToStream(outputStream);
        return outputStream.toByteArray();
    }

    public static PersistableBundle fromDiskStableBytes(byte[] bytes) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        return PersistableBundle.readFromStream(inputStream);
    }

    public static PersistableBundle minimizeBundle(PersistableBundle bundle, String ... keys) {
        PersistableBundle minimized = new PersistableBundle();
        if (bundle == null) {
            return minimized;
        }
        for (String key : keys) {
            Object value;
            if (!bundle.containsKey(key) || (value = bundle.get(key)) == null) continue;
            if (value instanceof Boolean) {
                minimized.putBoolean(key, (Boolean)value);
                continue;
            }
            if (value instanceof boolean[]) {
                minimized.putBooleanArray(key, (boolean[])value);
                continue;
            }
            if (value instanceof Double) {
                minimized.putDouble(key, (Double)value);
                continue;
            }
            if (value instanceof double[]) {
                minimized.putDoubleArray(key, (double[])value);
                continue;
            }
            if (value instanceof Integer) {
                minimized.putInt(key, (Integer)value);
                continue;
            }
            if (value instanceof int[]) {
                minimized.putIntArray(key, (int[])value);
                continue;
            }
            if (value instanceof Long) {
                minimized.putLong(key, (Long)value);
                continue;
            }
            if (value instanceof long[]) {
                minimized.putLongArray(key, (long[])value);
                continue;
            }
            if (value instanceof String) {
                minimized.putString(key, (String)value);
                continue;
            }
            if (value instanceof String[]) {
                minimized.putStringArray(key, (String[])value);
                continue;
            }
            if (!(value instanceof PersistableBundle)) continue;
            minimized.putPersistableBundle(key, (PersistableBundle)value);
        }
        return minimized;
    }

    public static int getHashCode(PersistableBundle bundle) {
        if (bundle == null) {
            return -1;
        }
        int iterativeHashcode = 0;
        TreeSet<String> treeSet = new TreeSet<String>(bundle.keySet());
        for (String key : treeSet) {
            Object val = bundle.get(key);
            if (val instanceof PersistableBundle) {
                iterativeHashcode = Objects.hash(iterativeHashcode, key, PersistableBundleUtils.getHashCode((PersistableBundle)val));
                continue;
            }
            iterativeHashcode = Objects.hash(iterativeHashcode, key, val);
        }
        return iterativeHashcode;
    }

    public static boolean isEqual(PersistableBundle left, PersistableBundle right) {
        if (Objects.equals(left, right)) {
            return true;
        }
        if (Objects.isNull(left) != Objects.isNull(right)) {
            return false;
        }
        if (!left.keySet().equals(right.keySet())) {
            return false;
        }
        for (String key : left.keySet()) {
            Object rightVal;
            Object leftVal = left.get(key);
            if (Objects.equals(leftVal, rightVal = right.get(key))) continue;
            if (Objects.isNull(leftVal) != Objects.isNull(rightVal)) {
                return false;
            }
            if (!Objects.equals(leftVal.getClass(), rightVal.getClass())) {
                return false;
            }
            if (!(leftVal instanceof PersistableBundle ? !PersistableBundleUtils.isEqual((PersistableBundle)leftVal, (PersistableBundle)rightVal) : (leftVal.getClass().isArray() ? (leftVal instanceof boolean[] ? !Arrays.equals((boolean[])leftVal, (boolean[])rightVal) : (leftVal instanceof double[] ? !Arrays.equals((double[])leftVal, (double[])rightVal) : (leftVal instanceof int[] ? !Arrays.equals((int[])leftVal, (int[])rightVal) : (leftVal instanceof long[] ? !Arrays.equals((long[])leftVal, (long[])rightVal) : !Arrays.equals((Object[])leftVal, (Object[])rightVal))))) : !Objects.equals(leftVal, rightVal)))) continue;
            return false;
        }
        return true;
    }

    public static interface Serializer<T> {
        public PersistableBundle toPersistableBundle(T var1);
    }

    public static interface Deserializer<T> {
        public T fromPersistableBundle(PersistableBundle var1);
    }

    public static class PersistableBundleWrapper {
        private final PersistableBundle mBundle;

        public PersistableBundleWrapper(PersistableBundle bundle) {
            this.mBundle = Objects.requireNonNull(bundle, "Bundle was null");
        }

        public int getInt(String key, int defaultValue) {
            return this.mBundle.getInt(key, defaultValue);
        }

        public int[] getIntArray(String key, int[] defaultValue) {
            int[] value = this.mBundle.getIntArray(key);
            return value == null ? defaultValue : value;
        }

        public int hashCode() {
            return PersistableBundleUtils.getHashCode(this.mBundle);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PersistableBundleWrapper)) {
                return false;
            }
            PersistableBundleWrapper other = (PersistableBundleWrapper)obj;
            return PersistableBundleUtils.isEqual(this.mBundle, other.mBundle);
        }

        public String toString() {
            return this.mBundle.toString();
        }
    }

    public static class LockingReadWriteHelper {
        private final ReadWriteLock mDiskLock = new ReentrantReadWriteLock();
        private final String mPath;

        public LockingReadWriteHelper(String path) {
            this.mPath = Objects.requireNonNull(path, "fileName was null");
        }

        public PersistableBundle readFromDisk() throws IOException {
            try {
                PersistableBundle persistableBundle;
                this.mDiskLock.readLock().lock();
                File file = new File(this.mPath);
                if (!file.exists()) {
                    PersistableBundle persistableBundle2 = null;
                    return persistableBundle2;
                }
                try (FileInputStream fis = new FileInputStream(file);){
                    persistableBundle = PersistableBundle.readFromStream(fis);
                }
                return persistableBundle;
            }
            finally {
                this.mDiskLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeToDisk(PersistableBundle bundle) throws IOException {
            Objects.requireNonNull(bundle, "bundle was null");
            try {
                this.mDiskLock.writeLock().lock();
                File file = new File(this.mPath);
                if (!file.exists()) {
                    file.getParentFile().mkdirs();
                }
                try (FileOutputStream fos = new FileOutputStream(file);){
                    bundle.writeToStream(fos);
                }
            }
            finally {
                this.mDiskLock.writeLock().unlock();
            }
        }
    }
}

