/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;
import android.os.Parcel;
import android.os.ParcelFormatException;
import android.os.Process;
import android.os.StatFs;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.os._Original_Build;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.logging.EventLogTags;
import com.android.internal.os.BatteryStatsHistoryIterator;
import com.android.internal.os.Clock;
import com.android.internal.util.ParseUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class BatteryStatsHistory {
    private static final boolean DEBUG = false;
    private static final String TAG = "BatteryStatsHistory";
    private static final int VERSION = 209;
    private static final String HISTORY_DIR = "battery-history";
    private static final String FILE_SUFFIX = ".bin";
    private static final int MIN_FREE_SPACE = 0x6400000;
    static final int DELTA_TIME_MASK = 524287;
    static final int DELTA_TIME_LONG = 524287;
    static final int DELTA_TIME_INT = 524286;
    static final int DELTA_TIME_ABS = 524285;
    static final int DELTA_BATTERY_LEVEL_FLAG = 524288;
    static final int DELTA_STATE_FLAG = 0x100000;
    static final int DELTA_STATE2_FLAG = 0x200000;
    static final int DELTA_WAKELOCK_FLAG = 0x400000;
    static final int DELTA_EVENT_FLAG = 0x800000;
    static final int DELTA_BATTERY_CHARGE_FLAG = 0x1000000;
    static final int DELTA_STATE_MASK = -33554432;
    static final int STATE_BATTERY_MASK = -16777216;
    static final int STATE_BATTERY_STATUS_MASK = 7;
    static final int STATE_BATTERY_STATUS_SHIFT = 29;
    static final int STATE_BATTERY_HEALTH_MASK = 7;
    static final int STATE_BATTERY_HEALTH_SHIFT = 26;
    static final int STATE_BATTERY_PLUG_MASK = 3;
    static final int STATE_BATTERY_PLUG_SHIFT = 24;
    static final int BATTERY_LEVEL_DETAILS_FLAG = 1;
    static final int TAG_FIRST_OCCURRENCE_FLAG = 32768;
    static final int EXTENSION_MEASURED_ENERGY_HEADER_FLAG = 1;
    static final int EXTENSION_MEASURED_ENERGY_FLAG = 2;
    static final int EXTENSION_CPU_USAGE_HEADER_FLAG = 4;
    static final int EXTENSION_CPU_USAGE_FLAG = 8;
    private final Parcel mHistoryBuffer;
    private final File mSystemDir;
    private final HistoryStepDetailsCalculator mStepDetailsCalculator;
    private final File mHistoryDir;
    private final Clock mClock;
    private int mMaxHistoryFiles;
    private int mMaxHistoryBufferSize;
    private AtomicFile mActiveFile;
    private final List<Integer> mFileNumbers = new ArrayList<Integer>();
    private List<Parcel> mHistoryParcels = null;
    private int mCurrentFileIndex;
    private Parcel mCurrentParcel;
    private int mCurrentParcelEnd;
    private int mParcelIndex = 0;
    private final ReentrantLock mWriteLock = new ReentrantLock();
    private final BatteryStats.HistoryItem mHistoryCur = new BatteryStats.HistoryItem();
    private boolean mHaveBatteryLevel;
    private boolean mRecordingHistory;
    private static final int HISTORY_TAG_INDEX_LIMIT = 32766;
    private static final int MAX_HISTORY_TAG_STRING_LENGTH = 1024;
    private final HashMap<BatteryStats.HistoryTag, Integer> mHistoryTagPool = new HashMap();
    private SparseArray<BatteryStats.HistoryTag> mHistoryTags;
    private final BatteryStats.HistoryItem mHistoryLastWritten = new BatteryStats.HistoryItem();
    private final BatteryStats.HistoryItem mHistoryLastLastWritten = new BatteryStats.HistoryItem();
    private final BatteryStats.HistoryItem mHistoryAddTmp = new BatteryStats.HistoryItem();
    private int mNextHistoryTagIdx = 0;
    private int mNumHistoryTagChars = 0;
    private int mHistoryBufferLastPos = -1;
    private long mLastHistoryElapsedRealtimeMs = 0L;
    private long mTrackRunningHistoryElapsedRealtimeMs = 0L;
    private long mTrackRunningHistoryUptimeMs = 0L;
    private long mHistoryBaseTimeMs;
    private boolean mMeasuredEnergyHeaderWritten = false;
    private boolean mCpuUsageHeaderWritten = false;
    private final VarintParceler mVarintParceler = new VarintParceler();
    private byte mLastHistoryStepLevel = 0;
    private boolean mMutable = true;
    private final BatteryStatsHistory mWritableHistory;
    private boolean mCleanupEnabled = true;
    private TraceDelegate mTracer;
    private int mTraceLastState = 0;
    private int mTraceLastState2 = 0;

    public BatteryStatsHistory(File systemDir, int maxHistoryFiles, int maxHistoryBufferSize, HistoryStepDetailsCalculator stepDetailsCalculator, Clock clock) {
        this(Parcel.obtain(), systemDir, maxHistoryFiles, maxHistoryBufferSize, stepDetailsCalculator, clock, new TraceDelegate());
        this.initHistoryBuffer();
    }

    @VisibleForTesting
    public BatteryStatsHistory(Parcel historyBuffer, File systemDir, int maxHistoryFiles, int maxHistoryBufferSize, HistoryStepDetailsCalculator stepDetailsCalculator, Clock clock, TraceDelegate tracer) {
        this(historyBuffer, systemDir, maxHistoryFiles, maxHistoryBufferSize, stepDetailsCalculator, clock, tracer, null);
    }

    private BatteryStatsHistory(Parcel historyBuffer, File systemDir, int maxHistoryFiles, int maxHistoryBufferSize, HistoryStepDetailsCalculator stepDetailsCalculator, Clock clock, TraceDelegate tracer, BatteryStatsHistory writableHistory) {
        this.mHistoryBuffer = historyBuffer;
        this.mSystemDir = systemDir;
        this.mMaxHistoryFiles = maxHistoryFiles;
        this.mMaxHistoryBufferSize = maxHistoryBufferSize;
        this.mStepDetailsCalculator = stepDetailsCalculator;
        this.mTracer = tracer;
        this.mClock = clock;
        this.mWritableHistory = writableHistory;
        if (this.mWritableHistory != null) {
            this.mMutable = false;
        }
        this.mHistoryDir = new File(systemDir, HISTORY_DIR);
        this.mHistoryDir.mkdirs();
        if (!this.mHistoryDir.exists()) {
            Slog.wtf(TAG, "HistoryDir does not exist:" + this.mHistoryDir.getPath());
        }
        ArraySet dedup = new ArraySet();
        this.mHistoryDir.listFiles((dir, name) -> {
            int b = name.lastIndexOf(FILE_SUFFIX);
            if (b <= 0) {
                return false;
            }
            int c = ParseUtils.parseInt(name.substring(0, b), -1);
            if (c != -1) {
                dedup.add(c);
                return true;
            }
            return false;
        });
        if (!dedup.isEmpty()) {
            this.mFileNumbers.addAll(dedup);
            Collections.sort(this.mFileNumbers);
            this.setActiveFile(this.mFileNumbers.get(this.mFileNumbers.size() - 1));
        } else {
            this.mFileNumbers.add(0);
            this.setActiveFile(0);
        }
    }

    public BatteryStatsHistory(int maxHistoryFiles, int maxHistoryBufferSize, HistoryStepDetailsCalculator stepDetailsCalculator, Clock clock) {
        this.mMaxHistoryFiles = maxHistoryFiles;
        this.mMaxHistoryBufferSize = maxHistoryBufferSize;
        this.mStepDetailsCalculator = stepDetailsCalculator;
        this.mTracer = new TraceDelegate();
        this.mClock = clock;
        this.mHistoryBuffer = Parcel.obtain();
        this.mSystemDir = null;
        this.mHistoryDir = null;
        this.mWritableHistory = null;
        this.initHistoryBuffer();
    }

    private BatteryStatsHistory(Parcel parcel) {
        this.mClock = Clock.SYSTEM_CLOCK;
        this.mTracer = null;
        this.mSystemDir = null;
        this.mHistoryDir = null;
        this.mStepDetailsCalculator = null;
        this.mWritableHistory = null;
        this.mMutable = false;
        byte[] historyBlob = parcel.readBlob();
        this.mHistoryBuffer = Parcel.obtain();
        this.mHistoryBuffer.unmarshall(historyBlob, 0, historyBlob.length);
        this.readFromParcel(parcel, true);
    }

    private void initHistoryBuffer() {
        this.mHistoryBaseTimeMs = 0L;
        this.mLastHistoryElapsedRealtimeMs = 0L;
        this.mTrackRunningHistoryElapsedRealtimeMs = 0L;
        this.mTrackRunningHistoryUptimeMs = 0L;
        this.mMeasuredEnergyHeaderWritten = false;
        this.mCpuUsageHeaderWritten = false;
        this.mHistoryBuffer.setDataSize(0);
        this.mHistoryBuffer.setDataPosition(0);
        this.mHistoryBuffer.setDataCapacity(this.mMaxHistoryBufferSize / 2);
        this.mHistoryLastLastWritten.clear();
        this.mHistoryLastWritten.clear();
        this.mHistoryTagPool.clear();
        this.mNextHistoryTagIdx = 0;
        this.mNumHistoryTagChars = 0;
        this.mHistoryBufferLastPos = -1;
        if (this.mStepDetailsCalculator != null) {
            this.mStepDetailsCalculator.clear();
        }
    }

    public void setMaxHistoryFiles(int maxHistoryFiles) {
        this.mMaxHistoryFiles = maxHistoryFiles;
    }

    public void setMaxHistoryBufferSize(int maxHistoryBufferSize) {
        this.mMaxHistoryBufferSize = maxHistoryBufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BatteryStatsHistory copy() {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            Parcel historyBufferCopy = Parcel.obtain();
            historyBufferCopy.appendFrom(this.mHistoryBuffer, 0, this.mHistoryBuffer.dataSize());
            return new BatteryStatsHistory(historyBufferCopy, this.mSystemDir, 0, 0, null, null, null, this);
        }
    }

    public boolean isReadOnly() {
        return this.mActiveFile == null || this.mHistoryDir == null;
    }

    private void setActiveFile(int fileNumber) {
        this.mActiveFile = this.getFile(fileNumber);
    }

    private AtomicFile getFile(int num) {
        return new AtomicFile(new File(this.mHistoryDir, num + FILE_SUFFIX));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startNextFile() {
        if (this.mMaxHistoryFiles == 0) {
            Slog.wtf(TAG, "mMaxHistoryFiles should not be zero when writing history");
            return;
        }
        if (this.mFileNumbers.isEmpty()) {
            Slog.wtf(TAG, "mFileNumbers should never be empty");
            return;
        }
        int next = this.mFileNumbers.get(this.mFileNumbers.size() - 1) + 1;
        this.mFileNumbers.add(next);
        this.setActiveFile(next);
        try {
            this.mActiveFile.getBaseFile().createNewFile();
        }
        catch (IOException e) {
            Slog.e(TAG, "Could not create history file: " + this.mActiveFile.getBaseFile());
        }
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            this.cleanupLocked();
        }
    }

    @GuardedBy(value={"this"})
    private void setCleanupEnabledLocked(boolean enabled) {
        this.mCleanupEnabled = enabled;
        if (this.mCleanupEnabled) {
            this.cleanupLocked();
        }
    }

    @GuardedBy(value={"this"})
    private void cleanupLocked() {
        int oldest;
        if (!this.mCleanupEnabled || this.mHistoryDir == null) {
            return;
        }
        if (!this.hasFreeDiskSpace()) {
            oldest = this.mFileNumbers.remove(0);
            this.getFile(oldest).delete();
        }
        while (this.mFileNumbers.size() > this.mMaxHistoryFiles) {
            oldest = this.mFileNumbers.get(0);
            this.getFile(oldest).delete();
            this.mFileNumbers.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isResetEnabled() {
        BatteryStatsHistory batteryStatsHistory = this;
        synchronized (batteryStatsHistory) {
            return this.mCleanupEnabled;
        }
    }

    public void reset() {
        for (Integer i : this.mFileNumbers) {
            this.getFile(i).delete();
        }
        this.mFileNumbers.clear();
        this.mFileNumbers.add(0);
        this.setActiveFile(0);
        this.initHistoryBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BatteryStatsHistoryIterator iterate() {
        this.mCurrentFileIndex = 0;
        this.mCurrentParcel = null;
        this.mCurrentParcelEnd = 0;
        this.mParcelIndex = 0;
        this.mMutable = false;
        if (this.mWritableHistory != null) {
            BatteryStatsHistory batteryStatsHistory = this.mWritableHistory;
            synchronized (batteryStatsHistory) {
                this.mWritableHistory.setCleanupEnabledLocked(false);
            }
        }
        return new BatteryStatsHistoryIterator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void iteratorFinished() {
        this.mHistoryBuffer.setDataPosition(this.mHistoryBuffer.dataSize());
        if (this.mWritableHistory != null) {
            BatteryStatsHistory batteryStatsHistory = this.mWritableHistory;
            synchronized (batteryStatsHistory) {
                this.mWritableHistory.setCleanupEnabledLocked(true);
            }
        } else {
            this.mMutable = true;
        }
    }

    public Parcel getNextParcel() {
        Parcel p;
        if (this.mCurrentParcel != null) {
            if (this.mCurrentParcel.dataPosition() < this.mCurrentParcelEnd) {
                return this.mCurrentParcel;
            }
            if (this.mHistoryBuffer == this.mCurrentParcel) {
                return null;
            }
            if (this.mHistoryParcels == null || !this.mHistoryParcels.contains(this.mCurrentParcel)) {
                this.mCurrentParcel.recycle();
            }
        }
        while (this.mCurrentFileIndex < this.mFileNumbers.size() - 1) {
            AtomicFile file;
            this.mCurrentParcel = null;
            this.mCurrentParcelEnd = 0;
            p = Parcel.obtain();
            if (this.readFileToParcel(p, file = this.getFile(this.mFileNumbers.get(this.mCurrentFileIndex++)))) {
                int bufSize = p.readInt();
                int curPos = p.dataPosition();
                this.mCurrentParcelEnd = curPos + bufSize;
                this.mCurrentParcel = p;
                if (curPos >= this.mCurrentParcelEnd) continue;
                return this.mCurrentParcel;
            }
            p.recycle();
        }
        if (this.mHistoryParcels != null) {
            while (this.mParcelIndex < this.mHistoryParcels.size()) {
                if (!this.skipHead(p = this.mHistoryParcels.get(this.mParcelIndex++))) continue;
                int bufSize = p.readInt();
                int curPos = p.dataPosition();
                this.mCurrentParcelEnd = curPos + bufSize;
                this.mCurrentParcel = p;
                if (curPos >= this.mCurrentParcelEnd) continue;
                return this.mCurrentParcel;
            }
        }
        if (this.mHistoryBuffer.dataSize() <= 0) {
            return null;
        }
        this.mHistoryBuffer.setDataPosition(0);
        this.mCurrentParcel = this.mHistoryBuffer;
        this.mCurrentParcelEnd = this.mCurrentParcel.dataSize();
        return this.mCurrentParcel;
    }

    public boolean readFileToParcel(Parcel out, AtomicFile file) {
        byte[] raw2 = null;
        try {
            long start = SystemClock.uptimeMillis();
            raw2 = file.readFully();
        }
        catch (Exception e) {
            Slog.e(TAG, "Error reading file " + file.getBaseFile().getPath(), e);
            return false;
        }
        out.unmarshall(raw2, 0, raw2.length);
        out.setDataPosition(0);
        return this.skipHead(out);
    }

    private boolean skipHead(Parcel p) {
        p.setDataPosition(0);
        int version = p.readInt();
        if (version != 209) {
            return false;
        }
        p.readLong();
        return true;
    }

    public void writeSummaryToParcel(Parcel out, boolean inclHistory) {
        out.writeBoolean(inclHistory);
        if (inclHistory) {
            this.writeToParcel(out);
        }
        out.writeInt(this.mHistoryTagPool.size());
        for (Map.Entry<BatteryStats.HistoryTag, Integer> ent : this.mHistoryTagPool.entrySet()) {
            BatteryStats.HistoryTag tag = ent.getKey();
            out.writeInt(ent.getValue());
            out.writeString(tag.string);
            out.writeInt(tag.uid);
        }
    }

    public void readSummaryFromParcel(Parcel in) {
        boolean inclHistory = in.readBoolean();
        if (inclHistory) {
            this.readFromParcel(in);
        }
        this.mHistoryTagPool.clear();
        this.mNextHistoryTagIdx = 0;
        this.mNumHistoryTagChars = 0;
        int numTags = in.readInt();
        for (int i = 0; i < numTags; ++i) {
            int idx = in.readInt();
            String str = in.readString();
            int uid = in.readInt();
            BatteryStats.HistoryTag tag = new BatteryStats.HistoryTag();
            tag.string = str;
            tag.uid = uid;
            tag.poolIdx = idx;
            this.mHistoryTagPool.put(tag, idx);
            if (idx >= this.mNextHistoryTagIdx) {
                this.mNextHistoryTagIdx = idx + 1;
            }
            this.mNumHistoryTagChars += tag.string.length() + 1;
        }
    }

    public void writeToParcel(Parcel out) {
        this.writeHistoryBuffer(out);
        this.writeToParcel(out, false);
    }

    public void writeToBatteryUsageStatsParcel(Parcel out) {
        out.writeBlob(this.mHistoryBuffer.marshall());
        this.writeToParcel(out, true);
    }

    private void writeToParcel(Parcel out, boolean useBlobs) {
        long start = SystemClock.uptimeMillis();
        out.writeInt(this.mFileNumbers.size() - 1);
        for (int i = 0; i < this.mFileNumbers.size() - 1; ++i) {
            AtomicFile file = this.getFile(this.mFileNumbers.get(i));
            byte[] raw2 = new byte[]{};
            try {
                raw2 = file.readFully();
            }
            catch (Exception e) {
                Slog.e(TAG, "Error reading file " + file.getBaseFile().getPath(), e);
            }
            if (useBlobs) {
                out.writeBlob(raw2);
                continue;
            }
            out.writeByteArray(raw2);
        }
    }

    public static BatteryStatsHistory createFromBatteryUsageStatsParcel(Parcel in) {
        return new BatteryStatsHistory(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readSummary() {
        if (this.mActiveFile == null) {
            Slog.w(TAG, "readSummary: no history file associated with this instance");
            return false;
        }
        Parcel parcel = Parcel.obtain();
        try {
            byte[] raw2;
            long start = SystemClock.uptimeMillis();
            if (this.mActiveFile.exists() && (raw2 = this.mActiveFile.readFully()).length > 0) {
                parcel.unmarshall(raw2, 0, raw2.length);
                parcel.setDataPosition(0);
                this.readHistoryBuffer(parcel);
            }
        }
        catch (Exception e) {
            Slog.e(TAG, "Error reading battery history", e);
            this.reset();
            boolean bl = false;
            return bl;
        }
        finally {
            parcel.recycle();
        }
        return true;
    }

    public void readFromParcel(Parcel in) {
        this.readHistoryBuffer(in);
        this.readFromParcel(in, false);
    }

    private void readFromParcel(Parcel in, boolean useBlobs) {
        long start = SystemClock.uptimeMillis();
        this.mHistoryParcels = new ArrayList<Parcel>();
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            byte[] temp;
            byte[] byArray = temp = useBlobs ? in.readBlob() : in.createByteArray();
            if (temp == null || temp.length == 0) continue;
            Parcel p = Parcel.obtain();
            p.unmarshall(temp, 0, temp.length);
            p.setDataPosition(0);
            this.mHistoryParcels.add(p);
        }
    }

    private boolean hasFreeDiskSpace() {
        StatFs stats = new StatFs(this.mHistoryDir.getAbsolutePath());
        return stats.getAvailableBytes() > 0x6400000L;
    }

    @VisibleForTesting
    public List<Integer> getFilesNumbers() {
        return this.mFileNumbers;
    }

    @VisibleForTesting
    public AtomicFile getActiveFile() {
        return this.mActiveFile;
    }

    public int getHistoryUsedSize() {
        int i;
        int ret = 0;
        for (i = 0; i < this.mFileNumbers.size() - 1; ++i) {
            ret = (int)((long)ret + this.getFile(this.mFileNumbers.get(i)).getBaseFile().length());
        }
        ret += this.mHistoryBuffer.dataSize();
        if (this.mHistoryParcels != null) {
            for (i = 0; i < this.mHistoryParcels.size(); ++i) {
                ret += this.mHistoryParcels.get(i).dataSize();
            }
        }
        return ret;
    }

    public void setHistoryRecordingEnabled(boolean enabled) {
        this.mRecordingHistory = enabled;
    }

    public boolean isRecordingHistory() {
        return this.mRecordingHistory;
    }

    @VisibleForTesting
    public void forceRecordAllHistory() {
        this.mHaveBatteryLevel = true;
        this.mRecordingHistory = true;
    }

    public void startRecordingHistory(long elapsedRealtimeMs, long uptimeMs, boolean reset) {
        this.mRecordingHistory = true;
        this.mHistoryCur.currentTime = this.mClock.currentTimeMillis();
        this.writeHistoryItem(elapsedRealtimeMs, uptimeMs, this.mHistoryCur, reset ? (byte)7 : 5);
        this.mHistoryCur.currentTime = 0L;
    }

    public void continueRecordingHistory() {
        if (this.mHistoryBuffer.dataPosition() <= 0 && this.mFileNumbers.size() <= 1) {
            return;
        }
        this.mRecordingHistory = true;
        long elapsedRealtimeMs = this.mClock.elapsedRealtime();
        long uptimeMs = this.mClock.uptimeMillis();
        this.writeHistoryItem(elapsedRealtimeMs, uptimeMs, this.mHistoryCur, (byte)4);
        this.startRecordingHistory(elapsedRealtimeMs, uptimeMs, false);
    }

    public void setBatteryState(boolean charging, int status, int level, int chargeUah) {
        this.mHaveBatteryLevel = true;
        this.setChargingState(charging);
        this.mHistoryCur.batteryStatus = (byte)status;
        this.mHistoryCur.batteryLevel = (byte)level;
        this.mHistoryCur.batteryChargeUah = chargeUah;
    }

    public void setBatteryState(int status, int level, int health, int plugType, int temperature, int voltageMv, int chargeUah) {
        this.mHaveBatteryLevel = true;
        this.mHistoryCur.batteryStatus = (byte)status;
        this.mHistoryCur.batteryLevel = (byte)level;
        this.mHistoryCur.batteryHealth = (byte)health;
        this.mHistoryCur.batteryPlugType = (byte)plugType;
        this.mHistoryCur.batteryTemperature = (short)temperature;
        this.mHistoryCur.batteryVoltage = (char)voltageMv;
        this.mHistoryCur.batteryChargeUah = chargeUah;
    }

    public void setPluggedInState(boolean pluggedIn) {
        this.mHistoryCur.states = pluggedIn ? (this.mHistoryCur.states |= 0x80000) : (this.mHistoryCur.states &= 0xFFF7FFFF);
    }

    public void setChargingState(boolean charging) {
        this.mHistoryCur.states2 = charging ? (this.mHistoryCur.states2 |= 0x1000000) : (this.mHistoryCur.states2 &= 0xFEFFFFFF);
    }

    public void recordEvent(long elapsedRealtimeMs, long uptimeMs, int code, String name, int uid) {
        this.mHistoryCur.eventCode = code;
        this.mHistoryCur.eventTag = this.mHistoryCur.localEventTag;
        this.mHistoryCur.eventTag.string = name;
        this.mHistoryCur.eventTag.uid = uid;
        this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
    }

    public void recordCurrentTimeChange(long elapsedRealtimeMs, long uptimeMs, long currentTimeMs) {
        if (!this.mRecordingHistory) {
            return;
        }
        this.mHistoryCur.currentTime = currentTimeMs;
        this.writeHistoryItem(elapsedRealtimeMs, uptimeMs, this.mHistoryCur, (byte)5);
        this.mHistoryCur.currentTime = 0L;
    }

    public void recordShutdownEvent(long elapsedRealtimeMs, long uptimeMs, long currentTimeMs) {
        if (!this.mRecordingHistory) {
            return;
        }
        this.mHistoryCur.currentTime = currentTimeMs;
        this.writeHistoryItem(elapsedRealtimeMs, uptimeMs, this.mHistoryCur, (byte)8);
        this.mHistoryCur.currentTime = 0L;
    }

    public void recordBatteryState(long elapsedRealtimeMs, long uptimeMs, int batteryLevel, boolean isPlugged) {
        this.mHistoryCur.batteryLevel = (byte)batteryLevel;
        this.setPluggedInState(isPlugged);
        this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
    }

    public void recordEnergyConsumerDetails(long elapsedRealtimeMs, long uptimeMs, BatteryStats.EnergyConsumerDetails energyConsumerDetails) {
        this.mHistoryCur.energyConsumerDetails = energyConsumerDetails;
        this.mHistoryCur.states2 |= 0x20000;
        this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
    }

    public void recordWifiConsumedCharge(long elapsedRealtimeMs, long uptimeMs, double monitoredRailChargeMah) {
        this.mHistoryCur.wifiRailChargeMah += monitoredRailChargeMah;
        this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
    }

    public void recordWakelockStartEvent(long elapsedRealtimeMs, long uptimeMs, String historyName, int uid) {
        this.mHistoryCur.wakelockTag = this.mHistoryCur.localWakelockTag;
        this.mHistoryCur.wakelockTag.string = historyName;
        this.mHistoryCur.wakelockTag.uid = uid;
        this.recordStateStartEvent(elapsedRealtimeMs, uptimeMs, 0x40000000);
    }

    public boolean maybeUpdateWakelockTag(long elapsedRealtimeMs, long uptimeMs, String historyName, int uid) {
        if (this.mHistoryLastWritten.cmd != 0) {
            return false;
        }
        if (this.mHistoryLastWritten.wakelockTag != null) {
            this.mHistoryLastWritten.wakelockTag = null;
            this.mHistoryCur.wakelockTag = this.mHistoryCur.localWakelockTag;
            this.mHistoryCur.wakelockTag.string = historyName;
            this.mHistoryCur.wakelockTag.uid = uid;
            this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
        }
        return true;
    }

    public void recordWakelockStopEvent(long elapsedRealtimeMs, long uptimeMs, String historyName, int uid) {
        (this.mHistoryCur.wakelockTag = this.mHistoryCur.localWakelockTag).string = historyName != null ? historyName : "";
        this.mHistoryCur.wakelockTag.uid = uid;
        this.recordStateStopEvent(elapsedRealtimeMs, uptimeMs, 0x40000000);
    }

    public void recordStateStartEvent(long elapsedRealtimeMs, long uptimeMs, int stateFlags) {
        this.mHistoryCur.states |= stateFlags;
        this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
    }

    public void recordStateStopEvent(long elapsedRealtimeMs, long uptimeMs, int stateFlags) {
        this.mHistoryCur.states &= ~stateFlags;
        this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
    }

    public void recordStateChangeEvent(long elapsedRealtimeMs, long uptimeMs, int stateStartFlags, int stateStopFlags) {
        this.mHistoryCur.states = (this.mHistoryCur.states | stateStartFlags) & ~stateStopFlags;
        this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
    }

    public void recordState2StartEvent(long elapsedRealtimeMs, long uptimeMs, int stateFlags) {
        this.mHistoryCur.states2 |= stateFlags;
        this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
    }

    public void recordState2StopEvent(long elapsedRealtimeMs, long uptimeMs, int stateFlags) {
        this.mHistoryCur.states2 &= ~stateFlags;
        this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
    }

    public void recordWakeupEvent(long elapsedRealtimeMs, long uptimeMs, String reason) {
        this.mHistoryCur.wakeReasonTag = this.mHistoryCur.localWakeReasonTag;
        this.mHistoryCur.wakeReasonTag.string = reason;
        this.mHistoryCur.wakeReasonTag.uid = 0;
        this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
    }

    public void recordScreenBrightnessEvent(long elapsedRealtimeMs, long uptimeMs, int brightnessBin) {
        this.mHistoryCur.states = this.setBitField(this.mHistoryCur.states, brightnessBin, 0, 7);
        this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
    }

    public void recordGpsSignalQualityEvent(long elapsedRealtimeMs, long uptimeMs, int signalLevel) {
        this.mHistoryCur.states2 = this.setBitField(this.mHistoryCur.states2, signalLevel, 7, 128);
        this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
    }

    public void recordDeviceIdleEvent(long elapsedRealtimeMs, long uptimeMs, int mode) {
        this.mHistoryCur.states2 = this.setBitField(this.mHistoryCur.states2, mode, 25, 0x6000000);
        this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
    }

    public void recordPhoneStateChangeEvent(long elapsedRealtimeMs, long uptimeMs, int addStateFlag, int removeStateFlag, int state, int signalStrength) {
        this.mHistoryCur.states = (this.mHistoryCur.states | addStateFlag) & ~removeStateFlag;
        if (state != -1) {
            this.mHistoryCur.states = this.setBitField(this.mHistoryCur.states, state, 6, 448);
        }
        if (signalStrength != -1) {
            this.mHistoryCur.states = this.setBitField(this.mHistoryCur.states, signalStrength, 3, 56);
        }
        this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
    }

    public void recordDataConnectionTypeChangeEvent(long elapsedRealtimeMs, long uptimeMs, int dataConnectionType) {
        this.mHistoryCur.states = this.setBitField(this.mHistoryCur.states, dataConnectionType, 9, 15872);
        this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
    }

    public void recordWifiSupplicantStateChangeEvent(long elapsedRealtimeMs, long uptimeMs, int supplState) {
        this.mHistoryCur.states2 = this.setBitField(this.mHistoryCur.states2, supplState, 0, 15);
        this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
    }

    public void recordWifiSignalStrengthChangeEvent(long elapsedRealtimeMs, long uptimeMs, int strengthBin) {
        this.mHistoryCur.states2 = this.setBitField(this.mHistoryCur.states2, strengthBin, 4, 112);
        this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
    }

    private void recordTraceEvents(int code, BatteryStats.HistoryTag tag) {
        if (code == 0) {
            return;
        }
        int idx = code & 0xFFFF3FFF;
        String prefix = (code & 0x8000) != 0 ? "+" : ((code & 0x4000) != 0 ? "-" : "");
        String[] names = BatteryStats.HISTORY_EVENT_NAMES;
        if (idx < 0 || idx >= names.length) {
            return;
        }
        String track = "battery_stats." + names[idx];
        String name = prefix + names[idx] + "=" + tag.uid + ":\"" + tag.string + "\"";
        this.mTracer.traceInstantEvent(track, name);
    }

    public void recordCpuUsage(long elapsedRealtimeMs, long uptimeMs, BatteryStats.CpuUsageDetails cpuUsageDetails) {
        this.mHistoryCur.cpuUsageDetails = cpuUsageDetails;
        this.mHistoryCur.states2 |= 0x20000;
        this.writeHistoryItem(elapsedRealtimeMs, uptimeMs);
    }

    private void recordTraceCounters(int oldval, int newval, BatteryStats.BitDescription[] descriptions) {
        int diff = oldval ^ newval;
        if (diff == 0) {
            return;
        }
        for (int i = 0; i < descriptions.length; ++i) {
            BatteryStats.BitDescription bd = descriptions[i];
            if ((diff & bd.mask) == 0) continue;
            int value = bd.shift < 0 ? ((newval & bd.mask) != 0 ? 1 : 0) : (newval & bd.mask) >> bd.shift;
            this.mTracer.traceCounter("battery_stats." + bd.name, value);
        }
    }

    private int setBitField(int bits, int value, int shift, int mask) {
        int shiftedValue = value << shift;
        if ((shiftedValue & ~mask) != 0) {
            Slog.wtfStack(TAG, "Value " + Integer.toHexString(value) + " does not fit in the bit field: " + Integer.toHexString(mask));
            shiftedValue &= mask;
        }
        return bits & ~mask | shiftedValue;
    }

    public void writeHistoryItem(long elapsedRealtimeMs, long uptimeMs) {
        long diffElapsedMs;
        long diffUptimeMs;
        if (this.mTrackRunningHistoryElapsedRealtimeMs != 0L && (diffUptimeMs = uptimeMs - this.mTrackRunningHistoryUptimeMs) < (diffElapsedMs = elapsedRealtimeMs - this.mTrackRunningHistoryElapsedRealtimeMs) - 20L) {
            long wakeElapsedTimeMs = elapsedRealtimeMs - (diffElapsedMs - diffUptimeMs);
            this.mHistoryAddTmp.setTo(this.mHistoryLastWritten);
            this.mHistoryAddTmp.wakelockTag = null;
            this.mHistoryAddTmp.wakeReasonTag = null;
            this.mHistoryAddTmp.eventCode = 0;
            this.mHistoryAddTmp.states &= Integer.MAX_VALUE;
            this.writeHistoryItem(wakeElapsedTimeMs, uptimeMs, this.mHistoryAddTmp);
        }
        this.mHistoryCur.states |= Integer.MIN_VALUE;
        this.mTrackRunningHistoryElapsedRealtimeMs = elapsedRealtimeMs;
        this.mTrackRunningHistoryUptimeMs = uptimeMs;
        this.writeHistoryItem(elapsedRealtimeMs, uptimeMs, this.mHistoryCur);
    }

    private void writeHistoryItem(long elapsedRealtimeMs, long uptimeMs, BatteryStats.HistoryItem cur) {
        int dataSize;
        if (this.mTracer != null && this.mTracer.tracingEnabled()) {
            this.recordTraceEvents(cur.eventCode, cur.eventTag);
            this.recordTraceCounters(this.mTraceLastState, cur.states, BatteryStats.HISTORY_STATE_DESCRIPTIONS);
            this.recordTraceCounters(this.mTraceLastState2, cur.states2, BatteryStats.HISTORY_STATE2_DESCRIPTIONS);
            this.mTraceLastState = cur.states;
            this.mTraceLastState2 = cur.states2;
        }
        if (!this.mHaveBatteryLevel || !this.mRecordingHistory) {
            return;
        }
        if (!this.mMutable) {
            throw new ConcurrentModificationException("Battery history is not writable");
        }
        long timeDiffMs = this.mHistoryBaseTimeMs + elapsedRealtimeMs - this.mHistoryLastWritten.time;
        int diffStates = this.mHistoryLastWritten.states ^ cur.states;
        int diffStates2 = this.mHistoryLastWritten.states2 ^ cur.states2;
        int lastDiffStates = this.mHistoryLastWritten.states ^ this.mHistoryLastLastWritten.states;
        int lastDiffStates2 = this.mHistoryLastWritten.states2 ^ this.mHistoryLastLastWritten.states2;
        if (!(this.mHistoryBufferLastPos < 0 || this.mHistoryLastWritten.cmd != 0 || timeDiffMs >= 1000L || (diffStates & lastDiffStates) != 0 || (diffStates2 & lastDiffStates2) != 0 || this.mHistoryLastWritten.tagsFirstOccurrence || cur.tagsFirstOccurrence || this.mHistoryLastWritten.wakelockTag != null && cur.wakelockTag != null || this.mHistoryLastWritten.wakeReasonTag != null && cur.wakeReasonTag != null || this.mHistoryLastWritten.stepDetails != null || this.mHistoryLastWritten.eventCode != 0 && cur.eventCode != 0 || this.mHistoryLastWritten.batteryLevel != cur.batteryLevel || this.mHistoryLastWritten.batteryStatus != cur.batteryStatus || this.mHistoryLastWritten.batteryHealth != cur.batteryHealth || this.mHistoryLastWritten.batteryPlugType != cur.batteryPlugType || this.mHistoryLastWritten.batteryTemperature != cur.batteryTemperature || this.mHistoryLastWritten.batteryVoltage != cur.batteryVoltage || this.mHistoryLastWritten.energyConsumerDetails != null || this.mHistoryLastWritten.cpuUsageDetails != null)) {
            this.mHistoryBuffer.setDataSize(this.mHistoryBufferLastPos);
            this.mHistoryBuffer.setDataPosition(this.mHistoryBufferLastPos);
            this.mHistoryBufferLastPos = -1;
            elapsedRealtimeMs = this.mHistoryLastWritten.time - this.mHistoryBaseTimeMs;
            if (this.mHistoryLastWritten.wakelockTag != null) {
                cur.wakelockTag = cur.localWakelockTag;
                cur.wakelockTag.setTo(this.mHistoryLastWritten.wakelockTag);
            }
            if (this.mHistoryLastWritten.wakeReasonTag != null) {
                cur.wakeReasonTag = cur.localWakeReasonTag;
                cur.wakeReasonTag.setTo(this.mHistoryLastWritten.wakeReasonTag);
            }
            if (this.mHistoryLastWritten.eventCode != 0) {
                cur.eventCode = this.mHistoryLastWritten.eventCode;
                cur.eventTag = cur.localEventTag;
                cur.eventTag.setTo(this.mHistoryLastWritten.eventTag);
            }
            this.mHistoryLastWritten.setTo(this.mHistoryLastLastWritten);
        }
        if ((dataSize = this.mHistoryBuffer.dataSize()) >= this.mMaxHistoryBufferSize) {
            if (this.mMaxHistoryBufferSize == 0) {
                Slog.wtf(TAG, "mMaxHistoryBufferSize should not be zero when writing history");
                this.mMaxHistoryBufferSize = 1024;
            }
            long start = SystemClock.uptimeMillis();
            this.writeHistory();
            this.startNextFile();
            this.mHistoryBuffer.setDataSize(0);
            this.mHistoryBuffer.setDataPosition(0);
            this.mHistoryBuffer.setDataCapacity(this.mMaxHistoryBufferSize / 2);
            this.mHistoryBufferLastPos = -1;
            this.mHistoryLastWritten.clear();
            this.mHistoryLastLastWritten.clear();
            for (Map.Entry<BatteryStats.HistoryTag, Integer> entry : this.mHistoryTagPool.entrySet()) {
                entry.setValue(entry.getValue() | 0x8000);
            }
            this.mMeasuredEnergyHeaderWritten = false;
            this.mCpuUsageHeaderWritten = false;
            BatteryStats.HistoryItem copy = new BatteryStats.HistoryItem();
            copy.setTo(cur);
            this.startRecordingHistory(elapsedRealtimeMs, uptimeMs, false);
            this.writeHistoryItem(elapsedRealtimeMs, uptimeMs, copy, (byte)0);
            return;
        }
        if (dataSize == 0) {
            BatteryStats.HistoryItem copy = new BatteryStats.HistoryItem();
            copy.setTo(cur);
            copy.currentTime = this.mClock.currentTimeMillis();
            copy.wakelockTag = null;
            copy.wakeReasonTag = null;
            copy.eventCode = 0;
            copy.eventTag = null;
            copy.tagsFirstOccurrence = false;
            copy.energyConsumerDetails = null;
            copy.cpuUsageDetails = null;
            this.writeHistoryItem(elapsedRealtimeMs, uptimeMs, copy, (byte)7);
        }
        this.writeHistoryItem(elapsedRealtimeMs, uptimeMs, cur, (byte)0);
    }

    private void writeHistoryItem(long elapsedRealtimeMs, long uptimeMs, BatteryStats.HistoryItem cur, byte cmd) {
        if (!this.mMutable) {
            throw new ConcurrentModificationException("Battery history is not writable");
        }
        this.mHistoryBufferLastPos = this.mHistoryBuffer.dataPosition();
        this.mHistoryLastLastWritten.setTo(this.mHistoryLastWritten);
        boolean hasTags = this.mHistoryLastWritten.tagsFirstOccurrence || cur.tagsFirstOccurrence;
        this.mHistoryLastWritten.setTo(this.mHistoryBaseTimeMs + elapsedRealtimeMs, cmd, cur);
        if (this.mHistoryLastWritten.time < this.mHistoryLastLastWritten.time - 60000L) {
            Slog.wtf(TAG, "Significantly earlier event written to battery history: time=" + this.mHistoryLastWritten.time + " previous=" + this.mHistoryLastLastWritten.time);
        }
        this.mHistoryLastWritten.tagsFirstOccurrence = hasTags;
        this.writeHistoryDelta(this.mHistoryBuffer, this.mHistoryLastWritten, this.mHistoryLastLastWritten);
        this.mLastHistoryElapsedRealtimeMs = elapsedRealtimeMs;
        cur.wakelockTag = null;
        cur.wakeReasonTag = null;
        cur.eventCode = 0;
        cur.eventTag = null;
        cur.tagsFirstOccurrence = false;
        cur.energyConsumerDetails = null;
        cur.cpuUsageDetails = null;
    }

    public void writeHistoryDelta(Parcel dest, BatteryStats.HistoryItem cur, BatteryStats.HistoryItem last) {
        boolean batteryChargeChanged;
        boolean state2IntChanged;
        int stateInt;
        boolean stateIntChanged;
        boolean batteryLevelIntChanged;
        if (last == null || cur.cmd != 0) {
            dest.writeInt(524285);
            cur.writeToParcel(dest, 0);
            return;
        }
        int extensionFlags = 0;
        long deltaTime = cur.time - last.time;
        int lastBatteryLevelInt = this.buildBatteryLevelInt(last);
        int lastStateInt = this.buildStateInt(last);
        int deltaTimeToken = deltaTime < 0L || deltaTime > Integer.MAX_VALUE ? 524287 : (deltaTime >= 524285L ? 524286 : (int)deltaTime);
        int firstToken = deltaTimeToken | cur.states & 0xFE000000;
        int batteryLevelInt = this.buildBatteryLevelInt(cur);
        if (cur.batteryLevel < this.mLastHistoryStepLevel || this.mLastHistoryStepLevel == 0) {
            cur.stepDetails = this.mStepDetailsCalculator.getHistoryStepDetails();
            if (cur.stepDetails != null) {
                batteryLevelInt |= 1;
                this.mLastHistoryStepLevel = cur.batteryLevel;
            }
        } else {
            cur.stepDetails = null;
            this.mLastHistoryStepLevel = cur.batteryLevel;
        }
        boolean bl = batteryLevelIntChanged = batteryLevelInt != lastBatteryLevelInt;
        if (batteryLevelIntChanged) {
            firstToken |= 0x80000;
        }
        boolean bl2 = stateIntChanged = (stateInt = this.buildStateInt(cur)) != lastStateInt;
        if (stateIntChanged) {
            firstToken |= 0x100000;
        }
        if (cur.energyConsumerDetails != null) {
            extensionFlags |= 2;
            if (!this.mMeasuredEnergyHeaderWritten) {
                extensionFlags |= 1;
            }
        }
        if (cur.cpuUsageDetails != null) {
            extensionFlags |= 8;
            if (!this.mCpuUsageHeaderWritten) {
                extensionFlags |= 4;
            }
        }
        cur.states2 = extensionFlags != 0 ? (cur.states2 |= 0x20000) : (cur.states2 &= 0xFFFDFFFF);
        boolean bl3 = state2IntChanged = cur.states2 != last.states2 || extensionFlags != 0;
        if (state2IntChanged) {
            firstToken |= 0x200000;
        }
        if (cur.wakelockTag != null || cur.wakeReasonTag != null) {
            firstToken |= 0x400000;
        }
        if (cur.eventCode != 0) {
            firstToken |= 0x800000;
        }
        boolean bl4 = batteryChargeChanged = cur.batteryChargeUah != last.batteryChargeUah;
        if (batteryChargeChanged) {
            firstToken |= 0x1000000;
        }
        dest.writeInt(firstToken);
        if (deltaTimeToken >= 524286) {
            if (deltaTimeToken == 524286) {
                dest.writeInt((int)deltaTime);
            } else {
                dest.writeLong(deltaTime);
            }
        }
        if (batteryLevelIntChanged) {
            dest.writeInt(batteryLevelInt);
        }
        if (stateIntChanged) {
            dest.writeInt(stateInt);
        }
        if (state2IntChanged) {
            dest.writeInt(cur.states2);
        }
        if (cur.wakelockTag != null || cur.wakeReasonTag != null) {
            int wakeLockIndex = cur.wakelockTag != null ? this.writeHistoryTag(cur.wakelockTag) : 65535;
            int wakeReasonIndex = cur.wakeReasonTag != null ? this.writeHistoryTag(cur.wakeReasonTag) : 65535;
            dest.writeInt(wakeReasonIndex << 16 | wakeLockIndex);
            if (cur.wakelockTag != null && (wakeLockIndex & 0x8000) != 0) {
                cur.wakelockTag.writeToParcel(dest, 0);
                cur.tagsFirstOccurrence = true;
            }
            if (cur.wakeReasonTag != null && (wakeReasonIndex & 0x8000) != 0) {
                cur.wakeReasonTag.writeToParcel(dest, 0);
                cur.tagsFirstOccurrence = true;
            }
        }
        if (cur.eventCode != 0) {
            int index = this.writeHistoryTag(cur.eventTag);
            int codeAndIndex = this.setBitField(cur.eventCode & 0xFFFF, index, 16, -65536);
            dest.writeInt(codeAndIndex);
            if ((index & 0x8000) != 0) {
                cur.eventTag.writeToParcel(dest, 0);
                cur.tagsFirstOccurrence = true;
            }
        }
        if (cur.stepDetails != null) {
            cur.stepDetails.writeToParcel(dest);
        }
        if (batteryChargeChanged) {
            dest.writeInt(cur.batteryChargeUah);
        }
        dest.writeDouble(cur.modemRailChargeMah);
        dest.writeDouble(cur.wifiRailChargeMah);
        if (extensionFlags != 0) {
            dest.writeInt(extensionFlags);
            if (cur.energyConsumerDetails != null) {
                if (!this.mMeasuredEnergyHeaderWritten) {
                    BatteryStats.EnergyConsumerDetails.EnergyConsumer[] consumers = cur.energyConsumerDetails.consumers;
                    dest.writeInt(consumers.length);
                    BatteryStats.EnergyConsumerDetails.EnergyConsumer[] energyConsumerArray = consumers;
                    int n = energyConsumerArray.length;
                    for (int i = 0; i < n; ++i) {
                        BatteryStats.EnergyConsumerDetails.EnergyConsumer consumer = energyConsumerArray[i];
                        dest.writeInt(consumer.type);
                        dest.writeInt(consumer.ordinal);
                        dest.writeString(consumer.name);
                    }
                    this.mMeasuredEnergyHeaderWritten = true;
                }
                this.mVarintParceler.writeLongArray(dest, cur.energyConsumerDetails.chargeUC);
            }
            if (cur.cpuUsageDetails != null) {
                if (!this.mCpuUsageHeaderWritten) {
                    dest.writeInt(cur.cpuUsageDetails.cpuBracketDescriptions.length);
                    for (String desc : cur.cpuUsageDetails.cpuBracketDescriptions) {
                        dest.writeString(desc);
                    }
                    this.mCpuUsageHeaderWritten = true;
                }
                dest.writeInt(cur.cpuUsageDetails.uid);
                this.mVarintParceler.writeLongArray(dest, cur.cpuUsageDetails.cpuUsageMs);
            }
        }
    }

    private int buildBatteryLevelInt(BatteryStats.HistoryItem h) {
        int bits = 0;
        bits = this.setBitField(bits, h.batteryLevel, 25, -33554432);
        bits = this.setBitField(bits, h.batteryTemperature, 15, 33521664);
        bits = this.setBitField(bits, h.batteryVoltage, 1, 32766);
        return bits;
    }

    private int buildStateInt(BatteryStats.HistoryItem h) {
        int plugType = 0;
        if ((h.batteryPlugType & 1) != 0) {
            plugType = 1;
        } else if ((h.batteryPlugType & 2) != 0) {
            plugType = 2;
        } else if ((h.batteryPlugType & 4) != 0) {
            plugType = 3;
        }
        return (h.batteryStatus & 7) << 29 | (h.batteryHealth & 7) << 26 | (plugType & 3) << 24 | h.states & 0xFFFFFF;
    }

    private int writeHistoryTag(BatteryStats.HistoryTag tag) {
        Integer idxObj;
        int stringLength;
        if (tag.string == null) {
            Slog.wtfStack(TAG, "writeHistoryTag called with null name");
        }
        if ((stringLength = tag.string.length()) > 1024) {
            Slog.e(TAG, "Long battery history tag: " + tag.string);
            tag.string = tag.string.substring(0, 1024);
        }
        if ((idxObj = this.mHistoryTagPool.get(tag)) != null) {
            int idx = idxObj;
            if ((idx & 0x8000) != 0) {
                this.mHistoryTagPool.put(tag, idx & 0xFFFF7FFF);
            }
            return idx;
        }
        if (this.mNextHistoryTagIdx < 32766) {
            int idx = this.mNextHistoryTagIdx++;
            BatteryStats.HistoryTag key = new BatteryStats.HistoryTag();
            key.setTo(tag);
            tag.poolIdx = idx;
            this.mHistoryTagPool.put(key, idx);
            this.mNumHistoryTagChars += stringLength + 1;
            if (this.mHistoryTags != null) {
                this.mHistoryTags.put(idx, key);
            }
            return idx | 0x8000;
        }
        return 65534;
    }

    public void commitCurrentHistoryBatchLocked() {
        this.mHistoryLastWritten.cmd = (byte)-1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHistory() {
        if (this.isReadOnly()) {
            Slog.w(TAG, "writeHistory: this instance instance is read-only");
            return;
        }
        Parcel p = Parcel.obtain();
        try {
            long start = SystemClock.uptimeMillis();
            this.writeHistoryBuffer(p);
            this.writeParcelToFileLocked(p, this.mActiveFile);
        }
        finally {
            p.recycle();
        }
    }

    public void readHistoryBuffer(Parcel in) throws ParcelFormatException {
        int version = in.readInt();
        if (version != 209) {
            Slog.w("BatteryStats", "readHistoryBuffer: version got " + version + ", expected " + 209 + "; erasing old stats");
            return;
        }
        long historyBaseTime = in.readLong();
        this.mHistoryBuffer.setDataSize(0);
        this.mHistoryBuffer.setDataPosition(0);
        int bufSize = in.readInt();
        int curPos = in.dataPosition();
        if (bufSize >= this.mMaxHistoryBufferSize * 100) {
            throw new ParcelFormatException("File corrupt: history data buffer too large " + bufSize);
        }
        if ((bufSize & 0xFFFFFFFC) != bufSize) {
            throw new ParcelFormatException("File corrupt: history data buffer not aligned " + bufSize);
        }
        this.mHistoryBuffer.appendFrom(in, curPos, bufSize);
        in.setDataPosition(curPos + bufSize);
        this.mHistoryBaseTimeMs = historyBaseTime;
        if (this.mHistoryBaseTimeMs > 0L) {
            long elapsedRealtimeMs;
            this.mLastHistoryElapsedRealtimeMs = elapsedRealtimeMs = this.mClock.elapsedRealtime();
            this.mHistoryBaseTimeMs = this.mHistoryBaseTimeMs - elapsedRealtimeMs + 1L;
        }
    }

    private void writeHistoryBuffer(Parcel out) {
        out.writeInt(209);
        out.writeLong(this.mHistoryBaseTimeMs + this.mLastHistoryElapsedRealtimeMs);
        out.writeInt(this.mHistoryBuffer.dataSize());
        out.appendFrom(this.mHistoryBuffer, 0, this.mHistoryBuffer.dataSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeParcelToFileLocked(Parcel p, AtomicFile file) {
        FileOutputStream fos = null;
        this.mWriteLock.lock();
        try {
            long startTimeMs = SystemClock.uptimeMillis();
            fos = file.startWrite();
            fos.write(p.marshall());
            fos.flush();
            file.finishWrite(fos);
            EventLogTags.writeCommitSysConfigFile("batterystats", SystemClock.uptimeMillis() - startTimeMs);
        }
        catch (IOException e) {
            Slog.w(TAG, "Error writing battery statistics", e);
            file.failWrite(fos);
        }
        finally {
            this.mWriteLock.unlock();
        }
    }

    public int getHistoryStringPoolSize() {
        return this.mHistoryTagPool.size();
    }

    public int getHistoryStringPoolBytes() {
        return this.mNumHistoryTagChars;
    }

    public String getHistoryTagPoolString(int index) {
        this.ensureHistoryTagArray();
        BatteryStats.HistoryTag historyTag = this.mHistoryTags.get(index);
        return historyTag != null ? historyTag.string : null;
    }

    public int getHistoryTagPoolUid(int index) {
        this.ensureHistoryTagArray();
        BatteryStats.HistoryTag historyTag = this.mHistoryTags.get(index);
        return historyTag != null ? historyTag.uid : -1;
    }

    private void ensureHistoryTagArray() {
        if (this.mHistoryTags != null) {
            return;
        }
        this.mHistoryTags = new SparseArray(this.mHistoryTagPool.size());
        for (Map.Entry<BatteryStats.HistoryTag, Integer> entry : this.mHistoryTagPool.entrySet()) {
            this.mHistoryTags.put((int)(entry.getValue() & 0xFFFF7FFF), entry.getKey());
        }
    }

    @VisibleForTesting
    public static class TraceDelegate {
        private final boolean mShouldSetProperty = _Original_Build.IS_USERDEBUG && Process.myUid() == 1000;

        public boolean tracingEnabled() {
            return Trace.isTagEnabled(131072L) || this.mShouldSetProperty;
        }

        public void traceCounter(String name, int value) {
            Trace.traceCounter(131072L, name, value);
            if (this.mShouldSetProperty) {
                SystemProperties.set("debug.tracing." + name, Integer.toString(value));
            }
        }

        public void traceInstantEvent(String track, String name) {
            Trace.instantForTrack(131072L, track, name);
        }
    }

    public static interface HistoryStepDetailsCalculator {
        public BatteryStats.HistoryStepDetails getHistoryStepDetails();

        public void clear();
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static class VarintParceler {
        public void writeLongArray(Parcel parcel, long[] values) {
            int out = 0;
            int shift = 0;
            for (long value : values) {
                boolean done = false;
                while (!done) {
                    byte b;
                    if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        b = (byte)value;
                        done = true;
                    } else {
                        b = (byte)((int)value & 0x7F | 0x80);
                        value >>>= 7;
                    }
                    if (shift == 32) {
                        parcel.writeInt(out);
                        shift = 0;
                        out = 0;
                    }
                    out |= (b & 0xFF) << shift;
                    shift += 8;
                }
            }
            if (shift != 0) {
                parcel.writeInt(out);
            }
        }

        public void readLongArray(Parcel parcel, long[] values) {
            int in = parcel.readInt();
            int available = 4;
            for (int i = 0; i < values.length; ++i) {
                int shift;
                long result = 0L;
                for (shift = 0; shift < 64; shift += 7) {
                    if (available == 0) {
                        in = parcel.readInt();
                        available = 4;
                    }
                    byte b = (byte)in;
                    in >>= 8;
                    --available;
                    result |= (long)(b & 0x7F) << shift;
                    if ((b & 0x80) != 0) continue;
                    values[i] = result;
                    break;
                }
                if (shift < 64) continue;
                throw new ParcelFormatException("Invalid varint format");
            }
        }
    }
}

