/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;
import android.os.Parcel;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.os.BatteryStatsHistory;
import java.util.Iterator;

public class BatteryStatsHistoryIterator
implements Iterator<BatteryStats.HistoryItem>,
AutoCloseable {
    private static final boolean DEBUG = false;
    private static final String TAG = "BatteryStatsHistoryItr";
    private final BatteryStatsHistory mBatteryStatsHistory;
    private final BatteryStats.HistoryStepDetails mReadHistoryStepDetails = new BatteryStats.HistoryStepDetails();
    private final SparseArray<BatteryStats.HistoryTag> mHistoryTags = new SparseArray();
    private BatteryStats.EnergyConsumerDetails mEnergyConsumerDetails;
    private BatteryStats.CpuUsageDetails mCpuUsageDetails;
    private final BatteryStatsHistory.VarintParceler mVarintParceler = new BatteryStatsHistory.VarintParceler();
    private final BatteryStats.HistoryItem mHistoryItem = new BatteryStats.HistoryItem();
    private static final int MAX_ENERGY_CONSUMER_COUNT = 100;
    private static final int MAX_CPU_BRACKET_COUNT = 100;

    public BatteryStatsHistoryIterator(BatteryStatsHistory history) {
        this.mBatteryStatsHistory = history;
        this.mHistoryItem.clear();
    }

    @Override
    public boolean hasNext() {
        Parcel p = this.mBatteryStatsHistory.getNextParcel();
        if (p == null) {
            this.close();
            return false;
        }
        return true;
    }

    @Override
    public BatteryStats.HistoryItem next() {
        Parcel p = this.mBatteryStatsHistory.getNextParcel();
        if (p == null) {
            this.close();
            return null;
        }
        long lastRealtimeMs = this.mHistoryItem.time;
        long lastWalltimeMs = this.mHistoryItem.currentTime;
        try {
            this.readHistoryDelta(p, this.mHistoryItem);
        }
        catch (Throwable t) {
            Slog.wtf(TAG, "Corrupted battery history", t);
            return null;
        }
        if (this.mHistoryItem.cmd != 5 && this.mHistoryItem.cmd != 7 && lastWalltimeMs != 0L) {
            this.mHistoryItem.currentTime = lastWalltimeMs + (this.mHistoryItem.time - lastRealtimeMs);
        }
        return this.mHistoryItem;
    }

    private void readHistoryDelta(Parcel src, BatteryStats.HistoryItem cur) {
        int batteryLevelInt;
        int firstToken = src.readInt();
        int deltaTimeToken = firstToken & 0x7FFFF;
        cur.cmd = 0;
        cur.numReadInts = 1;
        if (deltaTimeToken < 524285) {
            cur.time += (long)deltaTimeToken;
        } else {
            if (deltaTimeToken == 524285) {
                cur.readFromParcel(src);
                return;
            }
            if (deltaTimeToken == 524286) {
                int delta = src.readInt();
                cur.time += (long)delta;
                ++cur.numReadInts;
            } else {
                long delta = src.readLong();
                cur.time += delta;
                cur.numReadInts += 2;
            }
        }
        if ((firstToken & 0x80000) != 0) {
            batteryLevelInt = src.readInt();
            BatteryStatsHistoryIterator.readBatteryLevelInt(batteryLevelInt, cur);
            ++cur.numReadInts;
        } else {
            batteryLevelInt = 0;
        }
        if ((firstToken & 0x100000) != 0) {
            int stateInt = src.readInt();
            cur.states = firstToken & 0xFE000000 | stateInt & 0xFFFFFF;
            cur.batteryStatus = (byte)(stateInt >> 29 & 7);
            cur.batteryHealth = (byte)(stateInt >> 26 & 7);
            cur.batteryPlugType = (byte)(stateInt >> 24 & 3);
            switch (cur.batteryPlugType) {
                case 1: {
                    cur.batteryPlugType = 1;
                    break;
                }
                case 2: {
                    cur.batteryPlugType = (byte)2;
                    break;
                }
                case 3: {
                    cur.batteryPlugType = (byte)4;
                }
            }
            ++cur.numReadInts;
        } else {
            cur.states = firstToken & 0xFE000000 | cur.states & 0xFFFFFF;
        }
        if ((firstToken & 0x200000) != 0) {
            cur.states2 = src.readInt();
        }
        if ((firstToken & 0x400000) != 0) {
            int indexes = src.readInt();
            int wakeLockIndex = indexes & 0xFFFF;
            int wakeReasonIndex = indexes >> 16 & 0xFFFF;
            cur.wakelockTag = this.readHistoryTag(src, wakeLockIndex, cur.localWakelockTag) ? cur.localWakelockTag : null;
            cur.wakeReasonTag = this.readHistoryTag(src, wakeReasonIndex, cur.localWakeReasonTag) ? cur.localWakeReasonTag : null;
            ++cur.numReadInts;
        } else {
            cur.wakelockTag = null;
            cur.wakeReasonTag = null;
        }
        if ((firstToken & 0x800000) != 0) {
            cur.eventTag = cur.localEventTag;
            int codeAndIndex = src.readInt();
            cur.eventCode = codeAndIndex & 0xFFFF;
            int index = codeAndIndex >> 16 & 0xFFFF;
            cur.eventTag = this.readHistoryTag(src, index, cur.localEventTag) ? cur.localEventTag : null;
            ++cur.numReadInts;
        } else {
            cur.eventCode = 0;
        }
        if ((batteryLevelInt & 1) != 0) {
            cur.stepDetails = this.mReadHistoryStepDetails;
            cur.stepDetails.readFromParcel(src);
        } else {
            cur.stepDetails = null;
        }
        if ((firstToken & 0x1000000) != 0) {
            cur.batteryChargeUah = src.readInt();
        }
        cur.modemRailChargeMah = src.readDouble();
        cur.wifiRailChargeMah = src.readDouble();
        if ((cur.states2 & 0x20000) != 0) {
            int i;
            int extensionFlags = src.readInt();
            if ((extensionFlags & 1) != 0) {
                int consumerCount;
                if (this.mEnergyConsumerDetails == null) {
                    this.mEnergyConsumerDetails = new BatteryStats.EnergyConsumerDetails();
                }
                if ((consumerCount = src.readInt()) > 100) {
                    throw new IllegalStateException("EnergyConsumer count too high: " + consumerCount + ". Max = " + 100);
                }
                this.mEnergyConsumerDetails.consumers = new BatteryStats.EnergyConsumerDetails.EnergyConsumer[consumerCount];
                this.mEnergyConsumerDetails.chargeUC = new long[consumerCount];
                for (i = 0; i < consumerCount; ++i) {
                    BatteryStats.EnergyConsumerDetails.EnergyConsumer consumer = new BatteryStats.EnergyConsumerDetails.EnergyConsumer();
                    consumer.type = src.readInt();
                    consumer.ordinal = src.readInt();
                    consumer.name = src.readString();
                    this.mEnergyConsumerDetails.consumers[i] = consumer;
                }
            }
            if ((extensionFlags & 2) != 0) {
                if (this.mEnergyConsumerDetails == null) {
                    throw new IllegalStateException("MeasuredEnergyDetails without a header");
                }
                this.mVarintParceler.readLongArray(src, this.mEnergyConsumerDetails.chargeUC);
                cur.energyConsumerDetails = this.mEnergyConsumerDetails;
            } else {
                cur.energyConsumerDetails = null;
            }
            if ((extensionFlags & 4) != 0) {
                this.mCpuUsageDetails = new BatteryStats.CpuUsageDetails();
                int cpuBracketCount = src.readInt();
                if (cpuBracketCount > 100) {
                    throw new IllegalStateException("Too many CPU brackets: " + cpuBracketCount + ". Max = " + 100);
                }
                this.mCpuUsageDetails.cpuBracketDescriptions = new String[cpuBracketCount];
                for (i = 0; i < cpuBracketCount; ++i) {
                    this.mCpuUsageDetails.cpuBracketDescriptions[i] = src.readString();
                }
                this.mCpuUsageDetails.cpuUsageMs = new long[this.mCpuUsageDetails.cpuBracketDescriptions.length];
            } else if (this.mCpuUsageDetails != null) {
                this.mCpuUsageDetails.cpuBracketDescriptions = null;
            }
            if ((extensionFlags & 8) != 0) {
                if (this.mCpuUsageDetails == null) {
                    throw new IllegalStateException("CpuUsageDetails without a header");
                }
                this.mCpuUsageDetails.uid = src.readInt();
                this.mVarintParceler.readLongArray(src, this.mCpuUsageDetails.cpuUsageMs);
                cur.cpuUsageDetails = this.mCpuUsageDetails;
            } else {
                cur.cpuUsageDetails = null;
            }
        } else {
            cur.energyConsumerDetails = null;
            cur.cpuUsageDetails = null;
        }
    }

    private boolean readHistoryTag(Parcel src, int index, BatteryStats.HistoryTag outTag) {
        if (index == 65535) {
            return false;
        }
        if ((index & 0x8000) != 0) {
            BatteryStats.HistoryTag tag = new BatteryStats.HistoryTag();
            tag.readFromParcel(src);
            tag.poolIdx = index & 0xFFFF7FFF;
            this.mHistoryTags.put(tag.poolIdx, tag);
            outTag.setTo(tag);
        } else {
            BatteryStats.HistoryTag historyTag = this.mHistoryTags.get(index);
            if (historyTag != null) {
                outTag.setTo(historyTag);
            } else {
                outTag.string = null;
                outTag.uid = 0;
            }
            outTag.poolIdx = index;
        }
        return true;
    }

    private static void readBatteryLevelInt(int batteryLevelInt, BatteryStats.HistoryItem out) {
        out.batteryLevel = (byte)((batteryLevelInt & 0xFE000000) >>> 25);
        out.batteryTemperature = (short)((batteryLevelInt & 0x1FF8000) >>> 15);
        out.batteryVoltage = (char)((batteryLevelInt & 0x7FFE) >>> 1);
    }

    @Override
    public void close() {
        this.mBatteryStatsHistory.iteratorFinished();
    }
}

