/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.SystemClock;
import android.util.EventLog;
import android.util.SparseIntArray;
import com.android.internal.os.BinderCallsStats;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.VMRuntime;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;

public class BinderInternal {
    private static final String TAG = "BinderInternal";
    static WeakReference<GcWatcher> sGcWatcher = new WeakReference<GcWatcher>(new GcWatcher());
    static ArrayList<Runnable> sGcWatchers = new ArrayList();
    static Runnable[] sTmpWatchers = new Runnable[1];
    static long sLastGcTime;
    static final BinderProxyLimitListenerDelegate sBinderProxyLimitListenerDelegate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addGcWatcher(Runnable watcher) {
        ArrayList<Runnable> arrayList = sGcWatchers;
        synchronized (arrayList) {
            sGcWatchers.add(watcher);
        }
    }

    public static void joinThreadPool() {
        OverrideMethod.invokeV("com.android.internal.os.BinderInternal#joinThreadPool()V", true, null);
    }

    public static long getLastGcTime() {
        return sLastGcTime;
    }

    @UnsupportedAppUsage
    public static IBinder getContextObject() {
        return (IBinder)OverrideMethod.invokeA("com.android.internal.os.BinderInternal#getContextObject()Landroid/os/IBinder;", true, null);
    }

    public static void disableBackgroundScheduling(boolean bl) {
        OverrideMethod.invokeV("com.android.internal.os.BinderInternal#disableBackgroundScheduling(Z)V", true, null);
    }

    public static void setMaxThreads(int n) {
        OverrideMethod.invokeV("com.android.internal.os.BinderInternal#setMaxThreads(I)V", true, null);
    }

    @UnsupportedAppUsage
    static void handleGc() {
        OverrideMethod.invokeV("com.android.internal.os.BinderInternal#handleGc()V", true, null);
    }

    public static void forceGc(String reason) {
        EventLog.writeEvent(2741, reason);
        VMRuntime.getRuntime().requestConcurrentGC();
    }

    static void forceBinderGc() {
        BinderInternal.forceGc("Binder");
    }

    public static void nSetBinderProxyCountEnabled(boolean bl) {
        OverrideMethod.invokeV("com.android.internal.os.BinderInternal#nSetBinderProxyCountEnabled(Z)V", true, null);
    }

    public static SparseIntArray nGetBinderProxyPerUidCounts() {
        return (SparseIntArray)OverrideMethod.invokeA("com.android.internal.os.BinderInternal#nGetBinderProxyPerUidCounts()Landroid/util/SparseIntArray;", true, null);
    }

    public static int nGetBinderProxyCount(int n) {
        return OverrideMethod.invokeI("com.android.internal.os.BinderInternal#nGetBinderProxyCount(I)I", true, null);
    }

    public static void nSetBinderProxyCountWatermarks(int n, int n2) {
        OverrideMethod.invokeV("com.android.internal.os.BinderInternal#nSetBinderProxyCountWatermarks(II)V", true, null);
    }

    public static void binderProxyLimitCallbackFromNative(int uid) {
        sBinderProxyLimitListenerDelegate.notifyClient(uid);
    }

    public static void setBinderProxyCountCallback(BinderProxyLimitListener listener, Handler handler) {
        Preconditions.checkNotNull(handler, "Must provide NonNull Handler to setBinderProxyCountCallback when setting BinderProxyLimitListener");
        sBinderProxyLimitListenerDelegate.setListener(listener, handler);
    }

    public static void clearBinderProxyCountCallback() {
        sBinderProxyLimitListenerDelegate.setListener(null, null);
    }

    static {
        sBinderProxyLimitListenerDelegate = new BinderProxyLimitListenerDelegate();
    }

    private static class BinderProxyLimitListenerDelegate {
        private BinderProxyLimitListener mBinderProxyLimitListener;
        private Handler mHandler;

        private BinderProxyLimitListenerDelegate() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setListener(BinderProxyLimitListener listener, Handler handler) {
            BinderProxyLimitListenerDelegate binderProxyLimitListenerDelegate = this;
            synchronized (binderProxyLimitListenerDelegate) {
                this.mBinderProxyLimitListener = listener;
                this.mHandler = handler;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void notifyClient(final int uid) {
            BinderProxyLimitListenerDelegate binderProxyLimitListenerDelegate = this;
            synchronized (binderProxyLimitListenerDelegate) {
                if (this.mBinderProxyLimitListener != null) {
                    this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            mBinderProxyLimitListener.onLimitReached(uid);
                        }
                    });
                }
            }
        }
    }

    public static interface BinderProxyLimitListener {
        public void onLimitReached(int var1);
    }

    static class GcWatcher {
        GcWatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            BinderInternal.handleGc();
            sLastGcTime = SystemClock.uptimeMillis();
            ArrayList<Runnable> arrayList = sGcWatchers;
            synchronized (arrayList) {
                sTmpWatchers = sGcWatchers.toArray(sTmpWatchers);
            }
            for (int i = 0; i < sTmpWatchers.length; ++i) {
                if (sTmpWatchers[i] == null) continue;
                sTmpWatchers[i].run();
            }
            sGcWatcher = new WeakReference<GcWatcher>(new GcWatcher());
        }
    }

    public static interface CallStatsObserver {
        public void noteCallStats(int var1, long var2, Collection<BinderCallsStats.CallStat> var4);

        public void noteBinderThreadNativeIds(int[] var1);
    }

    public static interface Observer {
        public CallSession callStarted(Binder var1, int var2, int var3);

        public void callEnded(CallSession var1, int var2, int var3, int var4);

        public void callThrewException(CallSession var1, Exception var2);
    }

    @FunctionalInterface
    public static interface WorkSourceProvider {
        public int resolveWorkSourceUid(int var1);
    }

    public static class CallSession {
        public Class<? extends Binder> binderClass;
        public int transactionCode;
        long cpuTimeStarted;
        long timeStarted;
        boolean exceptionThrown;
        public boolean recordedCall;
    }
}

