/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.Binder;
import android.os.Handler;
import android.os.SystemClock;
import android.util.ArrayMap;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.BackgroundThread;
import com.android.internal.os.BinderInternal;
import com.android.internal.os.BinderLatencyBuckets;
import com.android.internal.os.BinderTransactionNameResolver;
import com.android.internal.util.FrameworkStatsLog;
import java.util.Random;

public class BinderLatencyObserver {
    private static final String TAG = "BinderLatencyObserver";
    private static final int MAX_ATOM_SIZE_BYTES = 4064;
    private static final int LAST_HISTOGRAM_BUFFER_SIZE_BYTES = 1000;
    public static final int PERIODIC_SAMPLING_INTERVAL_DEFAULT = 10;
    public static final int SHARDING_MODULO_DEFAULT = 1;
    public static final int STATSD_PUSH_INTERVAL_MINUTES_DEFAULT = 360;
    public static final int BUCKET_COUNT_DEFAULT = 100;
    public static final int FIRST_BUCKET_SIZE_DEFAULT = 5;
    public static final float BUCKET_SCALE_FACTOR_DEFAULT = 1.125f;
    @GuardedBy(value={"mLock"})
    private final ArrayMap<LatencyDims, int[]> mLatencyHistograms = new ArrayMap();
    private final Object mLock = new Object();
    private int mPeriodicSamplingInterval = 10;
    private int mShardingModulo = 1;
    private int mShardingOffset;
    private int mBucketCount = 100;
    private int mFirstBucketSize = 5;
    private float mBucketScaleFactor = 1.125f;
    private int mStatsdPushIntervalMinutes = 360;
    private final Random mRandom;
    private final Handler mLatencyObserverHandler;
    private final int mProcessSource;
    private BinderLatencyBuckets mLatencyBuckets;
    private Runnable mLatencyObserverRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayMap<LatencyDims, int[]> histogramMap;
            BinderLatencyObserver.this.noteLatencyDelayed();
            Object object = BinderLatencyObserver.this.mLock;
            synchronized (object) {
                histogramMap = new ArrayMap<LatencyDims, int[]>(BinderLatencyObserver.this.mLatencyHistograms);
                BinderLatencyObserver.this.mLatencyHistograms.clear();
            }
            BinderTransactionNameResolver resolver = new BinderTransactionNameResolver();
            ProtoOutputStream proto = new ProtoOutputStream();
            int histogramsWritten = 0;
            for (LatencyDims dims : histogramMap.keySet()) {
                if (proto.getRawSize() + 1000 > BinderLatencyObserver.this.getMaxAtomSizeBytes()) {
                    if (histogramsWritten > 0) {
                        BinderLatencyObserver.this.writeAtomToStatsd(proto);
                    }
                    proto = new ProtoOutputStream();
                    histogramsWritten = 0;
                }
                String transactionName = resolver.getMethodName(dims.getBinderClass(), dims.getTransactionCode());
                BinderLatencyObserver.this.fillApiStatsProto(proto, dims, transactionName, histogramMap.get(dims));
                ++histogramsWritten;
            }
            if (histogramsWritten > 0) {
                BinderLatencyObserver.this.writeAtomToStatsd(proto);
            }
        }
    };

    private void fillApiStatsProto(ProtoOutputStream proto, LatencyDims dims, String transactionName, int[] histogram) {
        int firstNonEmptyBucket = 0;
        for (int i = 0; i < this.mBucketCount; ++i) {
            if (histogram[i] == 0) continue;
            firstNonEmptyBucket = i;
            break;
        }
        int lastNonEmptyBucket = this.mBucketCount - 1;
        for (int i = this.mBucketCount - 1; i >= 0; --i) {
            if (histogram[i] == 0) continue;
            lastNonEmptyBucket = i;
            break;
        }
        long apiStatsToken = proto.start(2246267895809L);
        long dimsToken = proto.start(0x10B00000001L);
        proto.write(0x10E00000001L, this.mProcessSource);
        proto.write(1138166333443L, dims.getBinderClass().getName());
        proto.write(1138166333445L, transactionName);
        proto.end(dimsToken);
        proto.write(1120986464258L, firstNonEmptyBucket);
        for (int i = firstNonEmptyBucket; i <= lastNonEmptyBucket; ++i) {
            proto.write(2220498092035L, histogram[i]);
        }
        proto.end(apiStatsToken);
    }

    protected int getMaxAtomSizeBytes() {
        return 4064;
    }

    protected void writeAtomToStatsd(ProtoOutputStream atom) {
        FrameworkStatsLog.write(342, atom.getBytes(), (float)this.mPeriodicSamplingInterval, this.mShardingModulo, this.mBucketCount, this.mFirstBucketSize, this.mBucketScaleFactor);
    }

    private void noteLatencyDelayed() {
        this.mLatencyObserverHandler.removeCallbacks(this.mLatencyObserverRunnable);
        this.mLatencyObserverHandler.postDelayed(this.mLatencyObserverRunnable, this.mStatsdPushIntervalMinutes * 60 * 1000);
    }

    public BinderLatencyObserver(Injector injector, int processSource) {
        this.mRandom = injector.getRandomGenerator();
        this.mLatencyObserverHandler = injector.getHandler();
        this.mLatencyBuckets = new BinderLatencyBuckets(this.mBucketCount, this.mFirstBucketSize, this.mBucketScaleFactor);
        this.mProcessSource = processSource;
        this.mShardingOffset = this.mRandom.nextInt(this.mShardingModulo);
        this.noteLatencyDelayed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callEnded(BinderInternal.CallSession s) {
        if (s == null || s.exceptionThrown || !this.shouldKeepSample()) {
            return;
        }
        LatencyDims dims = LatencyDims.create(s.binderClass, s.transactionCode);
        if (!this.shouldCollect(dims)) {
            return;
        }
        long elapsedTimeMicro = this.getElapsedRealtimeMicro();
        long callDuration = elapsedTimeMicro - s.timeStarted;
        int bucketIdx = this.mLatencyBuckets.sampleToBucket(callDuration > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)callDuration);
        Object object = this.mLock;
        synchronized (object) {
            int[] buckets = this.mLatencyHistograms.get(dims);
            if (buckets == null) {
                buckets = new int[this.mBucketCount];
                this.mLatencyHistograms.put(dims, buckets);
            }
            if (buckets[bucketIdx] < Integer.MAX_VALUE) {
                int n = bucketIdx;
                buckets[n] = buckets[n] + 1;
            }
        }
    }

    protected long getElapsedRealtimeMicro() {
        return SystemClock.elapsedRealtimeNanos() / 1000L;
    }

    protected boolean shouldCollect(LatencyDims dims) {
        return (dims.hashCode() + this.mShardingOffset) % this.mShardingModulo == 0;
    }

    protected boolean shouldKeepSample() {
        return this.mRandom.nextInt(this.mPeriodicSamplingInterval) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSamplingInterval(int samplingInterval) {
        if (samplingInterval <= 0) {
            Slog.w(TAG, "Ignored invalid sampling interval (value must be positive): " + samplingInterval);
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (samplingInterval != this.mPeriodicSamplingInterval) {
                this.mPeriodicSamplingInterval = samplingInterval;
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShardingModulo(int shardingModulo) {
        if (shardingModulo <= 0) {
            Slog.w(TAG, "Ignored invalid sharding modulo (value must be positive): " + shardingModulo);
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (shardingModulo != this.mShardingModulo) {
                this.mShardingModulo = shardingModulo;
                this.mShardingOffset = this.mRandom.nextInt(shardingModulo);
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPushInterval(int pushIntervalMinutes) {
        if (pushIntervalMinutes <= 0) {
            Slog.w(TAG, "Ignored invalid push interval (value must be positive): " + pushIntervalMinutes);
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (pushIntervalMinutes != this.mStatsdPushIntervalMinutes) {
                this.mStatsdPushIntervalMinutes = pushIntervalMinutes;
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHistogramBucketsParams(int bucketCount, int firstBucketSize, float bucketScaleFactor) {
        Object object = this.mLock;
        synchronized (object) {
            if (bucketCount != this.mBucketCount || firstBucketSize != this.mFirstBucketSize || bucketScaleFactor != this.mBucketScaleFactor) {
                this.mBucketCount = bucketCount;
                this.mFirstBucketSize = firstBucketSize;
                this.mBucketScaleFactor = bucketScaleFactor;
                this.mLatencyBuckets = new BinderLatencyBuckets(this.mBucketCount, this.mFirstBucketSize, this.mBucketScaleFactor);
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.mLock;
        synchronized (object) {
            this.mLatencyHistograms.clear();
        }
        this.noteLatencyDelayed();
    }

    @VisibleForTesting
    public ArrayMap<LatencyDims, int[]> getLatencyHistograms() {
        return this.mLatencyHistograms;
    }

    @VisibleForTesting
    public Runnable getStatsdPushRunnable() {
        return this.mLatencyObserverRunnable;
    }

    @VisibleForTesting
    public int getProcessSource() {
        return this.mProcessSource;
    }

    public static class LatencyDims {
        private Class<? extends Binder> mBinderClass;
        private int mTransactionCode;
        private int mHashCode = 0;

        public static LatencyDims create(Class<? extends Binder> binderClass, int transactionCode) {
            return new LatencyDims(binderClass, transactionCode);
        }

        private LatencyDims(Class<? extends Binder> binderClass, int transactionCode) {
            this.mBinderClass = binderClass;
            this.mTransactionCode = transactionCode;
        }

        public Class<? extends Binder> getBinderClass() {
            return this.mBinderClass;
        }

        public int getTransactionCode() {
            return this.mTransactionCode;
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof LatencyDims)) {
                return false;
            }
            LatencyDims o = (LatencyDims)other;
            return this.mTransactionCode == o.getTransactionCode() && this.mBinderClass == o.getBinderClass();
        }

        public int hashCode() {
            if (this.mHashCode != 0) {
                return this.mHashCode;
            }
            int hash = this.mTransactionCode;
            this.mHashCode = hash = 31 * hash + this.mBinderClass.getName().hashCode();
            return hash;
        }
    }

    public static class Injector {
        public Random getRandomGenerator() {
            return new Random();
        }

        public Handler getHandler() {
            return BackgroundThread.getHandler();
        }
    }
}

