/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BadParcelableException;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IBinaryTransparencyService
extends IInterface {
    public static final String DESCRIPTOR = "com.android.internal.os.IBinaryTransparencyService";

    public String getSignedImageInfo() throws RemoteException;

    public void recordMeasurementsForAllPackages() throws RemoteException;

    public List<ApexInfo> collectAllApexInfo(boolean var1) throws RemoteException;

    public List<AppInfo> collectAllUpdatedPreloadInfo(Bundle var1) throws RemoteException;

    public List<AppInfo> collectAllSilentInstalledMbaInfo(Bundle var1) throws RemoteException;

    public static class AppInfo
    implements Parcelable {
        public String packageName;
        public long longVersion = 0L;
        public String splitName;
        public byte[] digest;
        public int digestAlgorithm = 0;
        public String[] signerDigests;
        public int mbaStatus = 0;
        public String initiator;
        public String[] initiatorSignerDigests;
        public String installer;
        public String originator;
        public static final Parcelable.Creator<AppInfo> CREATOR = new Parcelable.Creator<AppInfo>(){

            @Override
            public AppInfo createFromParcel(Parcel _aidl_source) {
                AppInfo _aidl_out = new AppInfo();
                _aidl_out.readFromParcel(_aidl_source);
                return _aidl_out;
            }

            public AppInfo[] newArray(int _aidl_size) {
                return new AppInfo[_aidl_size];
            }
        };

        @Override
        public void writeToParcel(Parcel _aidl_parcel, int _aidl_flag) {
            int _aidl_start_pos = _aidl_parcel.dataPosition();
            _aidl_parcel.writeInt(0);
            _aidl_parcel.writeString(this.packageName);
            _aidl_parcel.writeLong(this.longVersion);
            _aidl_parcel.writeString(this.splitName);
            _aidl_parcel.writeByteArray(this.digest);
            _aidl_parcel.writeInt(this.digestAlgorithm);
            _aidl_parcel.writeStringArray(this.signerDigests);
            _aidl_parcel.writeInt(this.mbaStatus);
            _aidl_parcel.writeString(this.initiator);
            _aidl_parcel.writeStringArray(this.initiatorSignerDigests);
            _aidl_parcel.writeString(this.installer);
            _aidl_parcel.writeString(this.originator);
            int _aidl_end_pos = _aidl_parcel.dataPosition();
            _aidl_parcel.setDataPosition(_aidl_start_pos);
            _aidl_parcel.writeInt(_aidl_end_pos - _aidl_start_pos);
            _aidl_parcel.setDataPosition(_aidl_end_pos);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFromParcel(Parcel _aidl_parcel) {
            int _aidl_start_pos = _aidl_parcel.dataPosition();
            int _aidl_parcelable_size = _aidl_parcel.readInt();
            try {
                if (_aidl_parcelable_size < 4) {
                    throw new BadParcelableException("Parcelable too small");
                }
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.packageName = _aidl_parcel.readString();
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.longVersion = _aidl_parcel.readLong();
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.splitName = _aidl_parcel.readString();
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.digest = _aidl_parcel.createByteArray();
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.digestAlgorithm = _aidl_parcel.readInt();
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.signerDigests = _aidl_parcel.createStringArray();
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.mbaStatus = _aidl_parcel.readInt();
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.initiator = _aidl_parcel.readString();
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.initiatorSignerDigests = _aidl_parcel.createStringArray();
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.installer = _aidl_parcel.readString();
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.originator = _aidl_parcel.readString();
            }
            finally {
                if (_aidl_start_pos > Integer.MAX_VALUE - _aidl_parcelable_size) {
                    throw new BadParcelableException("Overflow in the size of parcelable");
                }
                _aidl_parcel.setDataPosition(_aidl_start_pos + _aidl_parcelable_size);
            }
        }

        @Override
        public int describeContents() {
            int _mask = 0;
            return _mask;
        }
    }

    public static class ApexInfo
    implements Parcelable {
        public String packageName;
        public long longVersion = 0L;
        public byte[] digest;
        public int digestAlgorithm = 0;
        public String[] signerDigests;
        public String moduleName;
        public static final Parcelable.Creator<ApexInfo> CREATOR = new Parcelable.Creator<ApexInfo>(){

            @Override
            public ApexInfo createFromParcel(Parcel _aidl_source) {
                ApexInfo _aidl_out = new ApexInfo();
                _aidl_out.readFromParcel(_aidl_source);
                return _aidl_out;
            }

            public ApexInfo[] newArray(int _aidl_size) {
                return new ApexInfo[_aidl_size];
            }
        };

        @Override
        public void writeToParcel(Parcel _aidl_parcel, int _aidl_flag) {
            int _aidl_start_pos = _aidl_parcel.dataPosition();
            _aidl_parcel.writeInt(0);
            _aidl_parcel.writeString(this.packageName);
            _aidl_parcel.writeLong(this.longVersion);
            _aidl_parcel.writeByteArray(this.digest);
            _aidl_parcel.writeInt(this.digestAlgorithm);
            _aidl_parcel.writeStringArray(this.signerDigests);
            _aidl_parcel.writeString(this.moduleName);
            int _aidl_end_pos = _aidl_parcel.dataPosition();
            _aidl_parcel.setDataPosition(_aidl_start_pos);
            _aidl_parcel.writeInt(_aidl_end_pos - _aidl_start_pos);
            _aidl_parcel.setDataPosition(_aidl_end_pos);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFromParcel(Parcel _aidl_parcel) {
            int _aidl_start_pos = _aidl_parcel.dataPosition();
            int _aidl_parcelable_size = _aidl_parcel.readInt();
            try {
                if (_aidl_parcelable_size < 4) {
                    throw new BadParcelableException("Parcelable too small");
                }
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.packageName = _aidl_parcel.readString();
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.longVersion = _aidl_parcel.readLong();
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.digest = _aidl_parcel.createByteArray();
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.digestAlgorithm = _aidl_parcel.readInt();
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.signerDigests = _aidl_parcel.createStringArray();
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.moduleName = _aidl_parcel.readString();
            }
            finally {
                if (_aidl_start_pos > Integer.MAX_VALUE - _aidl_parcelable_size) {
                    throw new BadParcelableException("Overflow in the size of parcelable");
                }
                _aidl_parcel.setDataPosition(_aidl_start_pos + _aidl_parcelable_size);
            }
        }

        @Override
        public int describeContents() {
            int _mask = 0;
            return _mask;
        }
    }

    public static abstract class Stub
    extends Binder
    implements IBinaryTransparencyService {
        static final int TRANSACTION_getSignedImageInfo = 1;
        static final int TRANSACTION_recordMeasurementsForAllPackages = 2;
        static final int TRANSACTION_collectAllApexInfo = 3;
        static final int TRANSACTION_collectAllUpdatedPreloadInfo = 4;
        static final int TRANSACTION_collectAllSilentInstalledMbaInfo = 5;

        public Stub() {
            this.attachInterface(this, IBinaryTransparencyService.DESCRIPTOR);
        }

        public static IBinaryTransparencyService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IBinaryTransparencyService.DESCRIPTOR);
            if (iin != null && iin instanceof IBinaryTransparencyService) {
                return (IBinaryTransparencyService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getSignedImageInfo";
                }
                case 2: {
                    return "recordMeasurementsForAllPackages";
                }
                case 3: {
                    return "collectAllApexInfo";
                }
                case 4: {
                    return "collectAllUpdatedPreloadInfo";
                }
                case 5: {
                    return "collectAllSilentInstalledMbaInfo";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IBinaryTransparencyService.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _result = this.getSignedImageInfo();
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 2: {
                    this.recordMeasurementsForAllPackages();
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    List<ApexInfo> _result = this.collectAllApexInfo(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 4: {
                    Bundle _arg0 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    List<AppInfo> _result = this.collectAllUpdatedPreloadInfo(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 5: {
                    Bundle _arg0 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    List<AppInfo> _result = this.collectAllSilentInstalledMbaInfo(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 4;
        }

        private static class Proxy
        implements IBinaryTransparencyService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IBinaryTransparencyService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getSignedImageInfo() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBinaryTransparencyService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void recordMeasurementsForAllPackages() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBinaryTransparencyService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ApexInfo> collectAllApexInfo(boolean includeTestOnly) throws RemoteException {
                ArrayList<ApexInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBinaryTransparencyService.DESCRIPTOR);
                    _data.writeBoolean(includeTestOnly);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(ApexInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AppInfo> collectAllUpdatedPreloadInfo(Bundle packagesToSkip) throws RemoteException {
                ArrayList<AppInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBinaryTransparencyService.DESCRIPTOR);
                    _data.writeTypedObject(packagesToSkip, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AppInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AppInfo> collectAllSilentInstalledMbaInfo(Bundle packagesToSkip) throws RemoteException {
                ArrayList<AppInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBinaryTransparencyService.DESCRIPTOR);
                    _data.writeTypedObject(packagesToSkip, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AppInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IBinaryTransparencyService {
        @Override
        public String getSignedImageInfo() throws RemoteException {
            return null;
        }

        @Override
        public void recordMeasurementsForAllPackages() throws RemoteException {
        }

        @Override
        public List<ApexInfo> collectAllApexInfo(boolean includeTestOnly) throws RemoteException {
            return null;
        }

        @Override
        public List<AppInfo> collectAllUpdatedPreloadInfo(Bundle packagesToSkip) throws RemoteException {
            return null;
        }

        @Override
        public List<AppInfo> collectAllSilentInstalledMbaInfo(Bundle packagesToSkip) throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

