/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.util.IndentingPrintWriter;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.power.ModemPowerProfile;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import org.xmlpull.v1.XmlPullParserException;

public class PowerProfile {
    public static final String TAG = "PowerProfile";
    public static final String POWER_CPU_SUSPEND = "cpu.suspend";
    @UnsupportedAppUsage
    public static final String POWER_CPU_IDLE = "cpu.idle";
    @UnsupportedAppUsage
    public static final String POWER_CPU_ACTIVE = "cpu.active";
    @UnsupportedAppUsage
    public static final String POWER_WIFI_SCAN = "wifi.scan";
    @UnsupportedAppUsage
    public static final String POWER_WIFI_ON = "wifi.on";
    @UnsupportedAppUsage
    public static final String POWER_WIFI_ACTIVE = "wifi.active";
    public static final String POWER_WIFI_CONTROLLER_IDLE = "wifi.controller.idle";
    public static final String POWER_WIFI_CONTROLLER_RX = "wifi.controller.rx";
    public static final String POWER_WIFI_CONTROLLER_TX = "wifi.controller.tx";
    public static final String POWER_WIFI_CONTROLLER_TX_LEVELS = "wifi.controller.tx_levels";
    public static final String POWER_WIFI_CONTROLLER_OPERATING_VOLTAGE = "wifi.controller.voltage";
    public static final String POWER_BLUETOOTH_CONTROLLER_IDLE = "bluetooth.controller.idle";
    public static final String POWER_BLUETOOTH_CONTROLLER_RX = "bluetooth.controller.rx";
    public static final String POWER_BLUETOOTH_CONTROLLER_TX = "bluetooth.controller.tx";
    public static final String POWER_BLUETOOTH_CONTROLLER_OPERATING_VOLTAGE = "bluetooth.controller.voltage";
    public static final String POWER_MODEM_CONTROLLER_SLEEP = "modem.controller.sleep";
    public static final String POWER_MODEM_CONTROLLER_IDLE = "modem.controller.idle";
    public static final String POWER_MODEM_CONTROLLER_RX = "modem.controller.rx";
    public static final String POWER_MODEM_CONTROLLER_TX = "modem.controller.tx";
    public static final String POWER_MODEM_CONTROLLER_OPERATING_VOLTAGE = "modem.controller.voltage";
    @UnsupportedAppUsage
    public static final String POWER_GPS_ON = "gps.on";
    public static final String POWER_GPS_SIGNAL_QUALITY_BASED = "gps.signalqualitybased";
    public static final String POWER_GPS_OPERATING_VOLTAGE = "gps.voltage";
    @Deprecated
    @UnsupportedAppUsage
    public static final String POWER_BLUETOOTH_ON = "bluetooth.on";
    @Deprecated
    public static final String POWER_BLUETOOTH_ACTIVE = "bluetooth.active";
    @Deprecated
    @UnsupportedAppUsage
    public static final String POWER_BLUETOOTH_AT_CMD = "bluetooth.at";
    @Deprecated
    public static final String POWER_AMBIENT_DISPLAY = "ambient.on";
    @Deprecated
    @UnsupportedAppUsage
    public static final String POWER_SCREEN_ON = "screen.on";
    @UnsupportedAppUsage
    public static final String POWER_RADIO_ON = "radio.on";
    @UnsupportedAppUsage
    public static final String POWER_RADIO_SCANNING = "radio.scanning";
    @UnsupportedAppUsage
    public static final String POWER_RADIO_ACTIVE = "radio.active";
    @Deprecated
    @UnsupportedAppUsage
    public static final String POWER_SCREEN_FULL = "screen.full";
    public static final String POWER_AUDIO = "audio";
    public static final String POWER_VIDEO = "video";
    public static final String POWER_FLASHLIGHT = "camera.flashlight";
    public static final String POWER_MEMORY = "memory.bandwidths";
    public static final String POWER_CAMERA = "camera.avg";
    public static final String POWER_WIFI_BATCHED_SCAN = "wifi.batchedscan";
    public static final String POWER_BATTERY_CAPACITY = "battery.capacity";
    public static final String POWER_GROUP_DISPLAY_AMBIENT = "ambient.on.display";
    public static final String POWER_GROUP_DISPLAY_SCREEN_ON = "screen.on.display";
    public static final String POWER_GROUP_DISPLAY_SCREEN_FULL = "screen.full.display";
    private static final long SUBSYSTEM_MASK = 0xF00000000L;
    public static final long SUBSYSTEM_NONE = 0L;
    public static final long SUBSYSTEM_MODEM = 0x100000000L;
    private static final long SUBSYSTEM_FIELDS_MASK = -1L;
    static final HashMap<String, Double> sPowerItemMap = new HashMap();
    static final HashMap<String, Double[]> sPowerArrayMap = new HashMap();
    static final ModemPowerProfile sModemPowerProfile = new ModemPowerProfile();
    private static final String TAG_DEVICE = "device";
    private static final String TAG_ITEM = "item";
    private static final String TAG_ARRAY = "array";
    private static final String TAG_ARRAYITEM = "value";
    private static final String ATTR_NAME = "name";
    private static final String TAG_MODEM = "modem";
    private static final Object sLock = new Object();
    private int mCpuPowerBracketCount;
    private CpuClusterKey[] mCpuClusters;
    private static final String CPU_PER_CLUSTER_CORE_COUNT = "cpu.clusters.cores";
    private static final String CPU_CLUSTER_POWER_COUNT = "cpu.cluster_power.cluster";
    private static final String CPU_CORE_SPEED_PREFIX = "cpu.core_speeds.cluster";
    private static final String CPU_CORE_POWER_PREFIX = "cpu.core_power.cluster";
    private static final String CPU_POWER_BRACKETS_PREFIX = "cpu.power_brackets.cluster";
    private static final int DEFAULT_CPU_POWER_BRACKET_NUMBER = 3;
    private int mNumDisplays;

    @VisibleForTesting
    @UnsupportedAppUsage
    public PowerProfile(Context context) {
        this(context, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public PowerProfile(Context context, boolean forTest) {
        Object object = sLock;
        synchronized (object) {
            int xmlId = forTest ? 18284564 : 18284563;
            this.initLocked(context, xmlId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void forceInitForTesting(Context context, int xmlId) {
        Object object = sLock;
        synchronized (object) {
            sPowerItemMap.clear();
            sPowerArrayMap.clear();
            sModemPowerProfile.clear();
            this.initLocked(context, xmlId);
        }
    }

    @GuardedBy(value={"sLock"})
    private void initLocked(Context context, int xmlId) {
        if (sPowerItemMap.size() == 0 && sPowerArrayMap.size() == 0) {
            this.readPowerValuesFromXml(context, xmlId);
        }
        this.initCpuClusters();
        this.initDisplays();
        this.initModem();
    }

    private void readPowerValuesFromXml(Context context, int xmlId) {
        Resources resources = context.getResources();
        XmlResourceParser parser = resources.getXml(xmlId);
        boolean parsingArray = false;
        ArrayList<Double> array2 = new ArrayList<Double>();
        String arrayName = null;
        try {
            XmlUtils.beginDocument(parser, TAG_DEVICE);
            while (true) {
                XmlUtils.nextElement(parser);
                String element = parser.getName();
                if (element == null) break;
                if (parsingArray && !element.equals(TAG_ARRAYITEM)) {
                    sPowerArrayMap.put(arrayName, array2.toArray(new Double[array2.size()]));
                    parsingArray = false;
                }
                if (element.equals(TAG_ARRAY)) {
                    parsingArray = true;
                    array2.clear();
                    arrayName = parser.getAttributeValue(null, ATTR_NAME);
                    continue;
                }
                if (element.equals(TAG_ITEM) || element.equals(TAG_ARRAYITEM)) {
                    String name = null;
                    if (!parsingArray) {
                        name = parser.getAttributeValue(null, ATTR_NAME);
                    }
                    if (parser.next() != 4) continue;
                    String power = parser.getText();
                    double value = 0.0;
                    try {
                        value = Double.valueOf(power);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (element.equals(TAG_ITEM)) {
                        sPowerItemMap.put(name, value);
                        continue;
                    }
                    if (!parsingArray) continue;
                    array2.add(value);
                    continue;
                }
                if (!element.equals(TAG_MODEM)) continue;
                sModemPowerProfile.parseFromXml(parser);
            }
            if (parsingArray) {
                sPowerArrayMap.put(arrayName, array2.toArray(new Double[array2.size()]));
            }
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            parser.close();
        }
        int[] configResIds = new int[]{17694759, 17694761, 17694762, 17694760};
        String[] configResIdKeys = new String[]{POWER_BLUETOOTH_CONTROLLER_IDLE, POWER_BLUETOOTH_CONTROLLER_RX, POWER_BLUETOOTH_CONTROLLER_TX, POWER_BLUETOOTH_CONTROLLER_OPERATING_VOLTAGE};
        for (int i = 0; i < configResIds.length; ++i) {
            int value;
            String key = configResIdKeys[i];
            if (sPowerItemMap.containsKey(key) && sPowerItemMap.get(key) > 0.0 || (value = resources.getInteger(configResIds[i])) <= 0) continue;
            sPowerItemMap.put(key, Double.valueOf(value));
        }
    }

    private void initCpuClusters() {
        if (sPowerArrayMap.containsKey(CPU_PER_CLUSTER_CORE_COUNT)) {
            Double[] data = sPowerArrayMap.get(CPU_PER_CLUSTER_CORE_COUNT);
            this.mCpuClusters = new CpuClusterKey[data.length];
            for (int cluster = 0; cluster < data.length; ++cluster) {
                int numCpusInCluster = (int)Math.round(data[cluster]);
                this.mCpuClusters[cluster] = new CpuClusterKey(CPU_CORE_SPEED_PREFIX + cluster, CPU_CLUSTER_POWER_COUNT + cluster, CPU_CORE_POWER_PREFIX + cluster, numCpusInCluster);
            }
        } else {
            this.mCpuClusters = new CpuClusterKey[1];
            int numCpus = 1;
            if (sPowerItemMap.containsKey(CPU_PER_CLUSTER_CORE_COUNT)) {
                numCpus = (int)Math.round(sPowerItemMap.get(CPU_PER_CLUSTER_CORE_COUNT));
            }
            this.mCpuClusters[0] = new CpuClusterKey("cpu.core_speeds.cluster0", "cpu.cluster_power.cluster0", "cpu.core_power.cluster0", numCpus);
        }
        this.initCpuPowerBrackets(3);
    }

    @VisibleForTesting
    public void initCpuPowerBrackets(int defaultCpuPowerBracketNumber) {
        int cluster;
        boolean anyBracketsSpecified = false;
        boolean allBracketsSpecified = true;
        for (cluster = 0; cluster < this.mCpuClusters.length; ++cluster) {
            int steps = this.getNumSpeedStepsInCpuCluster(cluster);
            this.mCpuClusters[cluster].powerBrackets = new int[steps];
            if (sPowerArrayMap.get(CPU_POWER_BRACKETS_PREFIX + cluster) != null) {
                anyBracketsSpecified = true;
                continue;
            }
            allBracketsSpecified = false;
        }
        if (anyBracketsSpecified && !allBracketsSpecified) {
            throw new RuntimeException("Power brackets should be specified for all clusters or no clusters");
        }
        this.mCpuPowerBracketCount = 0;
        if (allBracketsSpecified) {
            for (cluster = 0; cluster < this.mCpuClusters.length; ++cluster) {
                Double[] data = sPowerArrayMap.get(CPU_POWER_BRACKETS_PREFIX + cluster);
                if (data.length != this.mCpuClusters[cluster].powerBrackets.length) {
                    throw new RuntimeException("Wrong number of items in cpu.power_brackets.cluster" + cluster);
                }
                for (int i = 0; i < data.length; ++i) {
                    int bracket;
                    this.mCpuClusters[cluster].powerBrackets[i] = bracket = (int)Math.round(data[i]);
                    if (bracket <= this.mCpuPowerBracketCount) continue;
                    this.mCpuPowerBracketCount = bracket;
                }
            }
            ++this.mCpuPowerBracketCount;
        } else {
            double minPower = Double.MAX_VALUE;
            double maxPower = Double.MIN_VALUE;
            int stateCount = 0;
            for (int cluster2 = 0; cluster2 < this.mCpuClusters.length; ++cluster2) {
                int steps = this.getNumSpeedStepsInCpuCluster(cluster2);
                for (int step = 0; step < steps; ++step) {
                    double power = this.getAveragePowerForCpuCore(cluster2, step);
                    if (power < minPower) {
                        minPower = power;
                    }
                    if (!(power > maxPower)) continue;
                    maxPower = power;
                }
                stateCount += steps;
            }
            if (stateCount <= defaultCpuPowerBracketNumber) {
                this.mCpuPowerBracketCount = stateCount;
                int bracket = 0;
                for (int cluster3 = 0; cluster3 < this.mCpuClusters.length; ++cluster3) {
                    int steps = this.getNumSpeedStepsInCpuCluster(cluster3);
                    for (int step = 0; step < steps; ++step) {
                        this.mCpuClusters[cluster3].powerBrackets[step] = bracket++;
                    }
                }
            } else {
                this.mCpuPowerBracketCount = defaultCpuPowerBracketNumber;
                double minLogPower = Math.log(minPower);
                double logBracket = (Math.log(maxPower) - minLogPower) / (double)defaultCpuPowerBracketNumber;
                for (int cluster4 = 0; cluster4 < this.mCpuClusters.length; ++cluster4) {
                    int steps = this.getNumSpeedStepsInCpuCluster(cluster4);
                    for (int step = 0; step < steps; ++step) {
                        double power = this.getAveragePowerForCpuCore(cluster4, step);
                        int bracket = (int)((Math.log(power) - minLogPower) / logBracket);
                        if (bracket >= defaultCpuPowerBracketNumber) {
                            bracket = defaultCpuPowerBracketNumber - 1;
                        }
                        this.mCpuClusters[cluster4].powerBrackets[step] = bracket;
                    }
                }
            }
        }
    }

    @UnsupportedAppUsage
    public int getNumCpuClusters() {
        return this.mCpuClusters.length;
    }

    public int getNumCoresInCpuCluster(int cluster) {
        if (cluster < 0 || cluster >= this.mCpuClusters.length) {
            return 0;
        }
        return this.mCpuClusters[cluster].numCpus;
    }

    @UnsupportedAppUsage
    public int getNumSpeedStepsInCpuCluster(int cluster) {
        if (cluster < 0 || cluster >= this.mCpuClusters.length) {
            return 0;
        }
        if (sPowerArrayMap.containsKey(this.mCpuClusters[cluster].freqKey)) {
            return sPowerArrayMap.get(this.mCpuClusters[cluster].freqKey).length;
        }
        return 1;
    }

    public double getAveragePowerForCpuCluster(int cluster) {
        if (cluster >= 0 && cluster < this.mCpuClusters.length) {
            return this.getAveragePower(this.mCpuClusters[cluster].clusterPowerKey);
        }
        return 0.0;
    }

    public double getAveragePowerForCpuCore(int cluster, int step) {
        if (cluster >= 0 && cluster < this.mCpuClusters.length) {
            return this.getAveragePower(this.mCpuClusters[cluster].corePowerKey, step);
        }
        return 0.0;
    }

    public int getCpuPowerBracketCount() {
        return this.mCpuPowerBracketCount;
    }

    public String getCpuPowerBracketDescription(int powerBracket) {
        StringBuilder sb = new StringBuilder();
        for (int cluster = 0; cluster < this.mCpuClusters.length; ++cluster) {
            int[] brackets = this.mCpuClusters[cluster].powerBrackets;
            for (int step = 0; step < brackets.length; ++step) {
                Double[] freqs;
                if (brackets[step] != powerBracket) continue;
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                if (this.mCpuClusters.length > 1) {
                    sb.append(cluster).append('/');
                }
                if ((freqs = sPowerArrayMap.get(this.mCpuClusters[cluster].freqKey)) != null && step < freqs.length) {
                    sb.append(freqs[step].intValue() / 1000);
                }
                sb.append('(');
                sb.append(String.format(Locale.US, "%.1f", this.getAveragePowerForCpuCore(cluster, step)));
                sb.append(')');
            }
        }
        return sb.toString();
    }

    public int getPowerBracketForCpuCore(int cluster, int step) {
        if (cluster >= 0 && cluster < this.mCpuClusters.length && step >= 0 && step < this.mCpuClusters[cluster].powerBrackets.length) {
            return this.mCpuClusters[cluster].powerBrackets[step];
        }
        return 0;
    }

    private void initDisplays() {
        Double deprecatedScreenFull;
        Double deprecatedScreenOn;
        this.mNumDisplays = 0;
        while (!(Double.isNaN(this.getAveragePowerForOrdinal(POWER_GROUP_DISPLAY_AMBIENT, this.mNumDisplays, Double.NaN)) && Double.isNaN(this.getAveragePowerForOrdinal(POWER_GROUP_DISPLAY_SCREEN_ON, this.mNumDisplays, Double.NaN)) && Double.isNaN(this.getAveragePowerForOrdinal(POWER_GROUP_DISPLAY_SCREEN_FULL, this.mNumDisplays, Double.NaN)))) {
            ++this.mNumDisplays;
        }
        Double deprecatedAmbientDisplay = sPowerItemMap.get(POWER_AMBIENT_DISPLAY);
        boolean legacy = false;
        if (deprecatedAmbientDisplay != null && this.mNumDisplays == 0) {
            String key = PowerProfile.getOrdinalPowerType(POWER_GROUP_DISPLAY_AMBIENT, 0);
            Slog.w(TAG, "ambient.on is deprecated! Use " + key + " instead.");
            sPowerItemMap.put(key, deprecatedAmbientDisplay);
            legacy = true;
        }
        if ((deprecatedScreenOn = sPowerItemMap.get(POWER_SCREEN_ON)) != null && this.mNumDisplays == 0) {
            String key = PowerProfile.getOrdinalPowerType(POWER_GROUP_DISPLAY_SCREEN_ON, 0);
            Slog.w(TAG, "screen.on is deprecated! Use " + key + " instead.");
            sPowerItemMap.put(key, deprecatedScreenOn);
            legacy = true;
        }
        if ((deprecatedScreenFull = sPowerItemMap.get(POWER_SCREEN_FULL)) != null && this.mNumDisplays == 0) {
            String key = PowerProfile.getOrdinalPowerType(POWER_GROUP_DISPLAY_SCREEN_FULL, 0);
            Slog.w(TAG, "screen.full is deprecated! Use " + key + " instead.");
            sPowerItemMap.put(key, deprecatedScreenFull);
            legacy = true;
        }
        if (legacy) {
            this.mNumDisplays = 1;
        }
    }

    public int getNumDisplays() {
        return this.mNumDisplays;
    }

    private void initModem() {
        this.handleDeprecatedModemConstant(0, POWER_MODEM_CONTROLLER_SLEEP, 0);
        this.handleDeprecatedModemConstant(0x10000000, POWER_MODEM_CONTROLLER_IDLE, 0);
        this.handleDeprecatedModemConstant(0x20000000, POWER_MODEM_CONTROLLER_RX, 0);
        this.handleDeprecatedModemConstant(0x30000000, POWER_MODEM_CONTROLLER_TX, 0);
        this.handleDeprecatedModemConstant(0x31000000, POWER_MODEM_CONTROLLER_TX, 1);
        this.handleDeprecatedModemConstant(0x32000000, POWER_MODEM_CONTROLLER_TX, 2);
        this.handleDeprecatedModemConstant(0x33000000, POWER_MODEM_CONTROLLER_TX, 3);
        this.handleDeprecatedModemConstant(0x34000000, POWER_MODEM_CONTROLLER_TX, 4);
    }

    private void handleDeprecatedModemConstant(int key, String deprecatedKey, int level) {
        double drain = sModemPowerProfile.getAverageBatteryDrainMa(key);
        if (!Double.isNaN(drain)) {
            return;
        }
        double deprecatedDrain = this.getAveragePower(deprecatedKey, level);
        sModemPowerProfile.setPowerConstant(key, Double.toString(deprecatedDrain));
    }

    public int getNumElements(String key) {
        if (sPowerItemMap.containsKey(key)) {
            return 1;
        }
        if (sPowerArrayMap.containsKey(key)) {
            return sPowerArrayMap.get(key).length;
        }
        return 0;
    }

    public double getAveragePowerOrDefault(String type, double defaultValue) {
        if (sPowerItemMap.containsKey(type)) {
            return sPowerItemMap.get(type);
        }
        if (sPowerArrayMap.containsKey(type)) {
            return sPowerArrayMap.get(type)[0];
        }
        return defaultValue;
    }

    @UnsupportedAppUsage
    public double getAveragePower(String type) {
        return this.getAveragePowerOrDefault(type, 0.0);
    }

    public double getAverageBatteryDrainOrDefaultMa(long key, double defaultValue) {
        long subsystemType = key & 0xF00000000L;
        int subsystemFields = (int)(key & 0xFFFFFFFFFFFFFFFFL);
        double value = subsystemType == 0x100000000L ? sModemPowerProfile.getAverageBatteryDrainMa(subsystemFields) : Double.NaN;
        if (Double.isNaN(value)) {
            return defaultValue;
        }
        return value;
    }

    public double getAverageBatteryDrainMa(long key) {
        return this.getAverageBatteryDrainOrDefaultMa(key, 0.0);
    }

    @UnsupportedAppUsage
    public double getAveragePower(String type, int level) {
        if (sPowerItemMap.containsKey(type)) {
            return sPowerItemMap.get(type);
        }
        if (sPowerArrayMap.containsKey(type)) {
            Double[] values = sPowerArrayMap.get(type);
            if (values.length > level && level >= 0) {
                return values[level];
            }
            if (level < 0 || values.length == 0) {
                return 0.0;
            }
            return values[values.length - 1];
        }
        return 0.0;
    }

    public double getAveragePowerForOrdinal(String group, int ordinal, double defaultValue) {
        String type = PowerProfile.getOrdinalPowerType(group, ordinal);
        return this.getAveragePowerOrDefault(type, defaultValue);
    }

    public double getAveragePowerForOrdinal(String group, int ordinal) {
        return this.getAveragePowerForOrdinal(group, ordinal, 0.0);
    }

    @UnsupportedAppUsage
    public double getBatteryCapacity() {
        return this.getAveragePower(POWER_BATTERY_CAPACITY);
    }

    public void dumpDebug(ProtoOutputStream proto) {
        this.writePowerConstantToProto(proto, POWER_CPU_SUSPEND, 0x10100000001L);
        this.writePowerConstantToProto(proto, POWER_CPU_IDLE, 0x10100000002L);
        this.writePowerConstantToProto(proto, POWER_CPU_ACTIVE, 0x10100000003L);
        for (int cluster = 0; cluster < this.mCpuClusters.length; ++cluster) {
            long token = proto.start(2246267895848L);
            proto.write(0x10500000001L, cluster);
            proto.write(0x10100000002L, sPowerItemMap.get(this.mCpuClusters[cluster].clusterPowerKey));
            proto.write(1120986464259L, this.mCpuClusters[cluster].numCpus);
            for (Double speed : sPowerArrayMap.get(this.mCpuClusters[cluster].freqKey)) {
                proto.write(2211908157444L, speed);
            }
            for (Double corePower : sPowerArrayMap.get(this.mCpuClusters[cluster].corePowerKey)) {
                proto.write(2203318222853L, corePower);
            }
            proto.end(token);
        }
        this.writePowerConstantToProto(proto, POWER_WIFI_SCAN, 0x10100000004L);
        this.writePowerConstantToProto(proto, POWER_WIFI_ON, 0x10100000005L);
        this.writePowerConstantToProto(proto, POWER_WIFI_ACTIVE, 0x10100000006L);
        this.writePowerConstantToProto(proto, POWER_WIFI_CONTROLLER_IDLE, 0x10100000007L);
        this.writePowerConstantToProto(proto, POWER_WIFI_CONTROLLER_RX, 0x10100000008L);
        this.writePowerConstantToProto(proto, POWER_WIFI_CONTROLLER_TX, 0x10100000009L);
        this.writePowerConstantArrayToProto(proto, POWER_WIFI_CONTROLLER_TX_LEVELS, 2203318222858L);
        this.writePowerConstantToProto(proto, POWER_WIFI_CONTROLLER_OPERATING_VOLTAGE, 0x1010000000BL);
        this.writePowerConstantToProto(proto, POWER_BLUETOOTH_CONTROLLER_IDLE, 0x1010000000CL);
        this.writePowerConstantToProto(proto, POWER_BLUETOOTH_CONTROLLER_RX, 0x1010000000DL);
        this.writePowerConstantToProto(proto, POWER_BLUETOOTH_CONTROLLER_TX, 0x1010000000EL);
        this.writePowerConstantToProto(proto, POWER_BLUETOOTH_CONTROLLER_OPERATING_VOLTAGE, 0x1010000000FL);
        this.writePowerConstantToProto(proto, POWER_MODEM_CONTROLLER_SLEEP, 0x10100000010L);
        this.writePowerConstantToProto(proto, POWER_MODEM_CONTROLLER_IDLE, 0x10100000011L);
        this.writePowerConstantToProto(proto, POWER_MODEM_CONTROLLER_RX, 0x10100000012L);
        this.writePowerConstantArrayToProto(proto, POWER_MODEM_CONTROLLER_TX, 2203318222867L);
        this.writePowerConstantToProto(proto, POWER_MODEM_CONTROLLER_OPERATING_VOLTAGE, 0x10100000014L);
        this.writePowerConstantToProto(proto, POWER_GPS_ON, 0x10100000015L);
        this.writePowerConstantArrayToProto(proto, POWER_GPS_SIGNAL_QUALITY_BASED, 2203318222870L);
        this.writePowerConstantToProto(proto, POWER_GPS_OPERATING_VOLTAGE, 0x10100000017L);
        this.writePowerConstantToProto(proto, POWER_BLUETOOTH_ON, 0x10100000018L);
        this.writePowerConstantToProto(proto, POWER_BLUETOOTH_ACTIVE, 0x10100000019L);
        this.writePowerConstantToProto(proto, POWER_BLUETOOTH_AT_CMD, 0x1010000001AL);
        this.writePowerConstantToProto(proto, POWER_AMBIENT_DISPLAY, 0x1010000001BL);
        this.writePowerConstantToProto(proto, POWER_SCREEN_ON, 0x1010000001CL);
        this.writePowerConstantToProto(proto, POWER_RADIO_ON, 0x1010000001DL);
        this.writePowerConstantToProto(proto, POWER_RADIO_SCANNING, 0x1010000001EL);
        this.writePowerConstantToProto(proto, POWER_RADIO_ACTIVE, 0x1010000001FL);
        this.writePowerConstantToProto(proto, POWER_SCREEN_FULL, 0x10100000020L);
        this.writePowerConstantToProto(proto, POWER_AUDIO, 0x10100000021L);
        this.writePowerConstantToProto(proto, POWER_VIDEO, 0x10100000022L);
        this.writePowerConstantToProto(proto, POWER_FLASHLIGHT, 1103806595107L);
        this.writePowerConstantToProto(proto, POWER_MEMORY, 1103806595108L);
        this.writePowerConstantToProto(proto, POWER_CAMERA, 1103806595109L);
        this.writePowerConstantToProto(proto, POWER_WIFI_BATCHED_SCAN, 1103806595110L);
        this.writePowerConstantToProto(proto, POWER_BATTERY_CAPACITY, 1103806595111L);
    }

    public void dump(PrintWriter pw) {
        IndentingPrintWriter ipw = new IndentingPrintWriter(pw);
        sPowerItemMap.forEach((key, value) -> {
            ipw.print((String)key, value);
            ipw.println();
        });
        sPowerArrayMap.forEach((key, value) -> {
            ipw.print((String)key, Arrays.toString((Object[])value));
            ipw.println();
        });
        ipw.println("Modem values:");
        ipw.increaseIndent();
        sModemPowerProfile.dump(ipw);
        ipw.decreaseIndent();
    }

    private void writePowerConstantToProto(ProtoOutputStream proto, String key, long fieldId) {
        if (sPowerItemMap.containsKey(key)) {
            proto.write(fieldId, sPowerItemMap.get(key));
        }
    }

    private void writePowerConstantArrayToProto(ProtoOutputStream proto, String key, long fieldId) {
        if (sPowerArrayMap.containsKey(key)) {
            for (Double d : sPowerArrayMap.get(key)) {
                proto.write(fieldId, d);
            }
        }
    }

    private static String getOrdinalPowerType(String group, int ordinal) {
        return group + ordinal;
    }

    private static class CpuClusterKey {
        public final String freqKey;
        public final String clusterPowerKey;
        public final String corePowerKey;
        public final int numCpus;
        public int[] powerBrackets;

        private CpuClusterKey(String freqKey, String clusterPowerKey, String corePowerKey, int numCpus) {
            this.freqKey = freqKey;
            this.clusterPowerKey = clusterPowerKey;
            this.corePowerKey = corePowerKey;
            this.numCpus = numCpus;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Subsystem {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PowerGroup {
    }
}

