/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.net.LocalSocket;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.lang.ref.Reference;

class ZygoteCommandBuffer
implements AutoCloseable {
    private long mNativeBuffer;
    private final LocalSocket mSocket;
    private final int mNativeSocket;

    ZygoteCommandBuffer(LocalSocket socket) {
        this.mSocket = socket;
        this.mNativeSocket = socket == null ? -1 : this.mSocket.getFileDescriptor().getInt$();
        this.mNativeBuffer = ZygoteCommandBuffer.getNativeBuffer(this.mNativeSocket);
    }

    ZygoteCommandBuffer(String[] args) {
        this((LocalSocket)null);
        this.setCommand(args);
    }

    private static long getNativeBuffer(int n) {
        return OverrideMethod.invokeL("com.android.internal.os.ZygoteCommandBuffer#getNativeBuffer(I)J", true, null);
    }

    @Override
    public void close() {
        ZygoteCommandBuffer.freeNativeBuffer(this.mNativeBuffer);
        this.mNativeBuffer = 0L;
    }

    private static void freeNativeBuffer(long l) {
        OverrideMethod.invokeV("com.android.internal.os.ZygoteCommandBuffer#freeNativeBuffer(J)V", true, null);
    }

    int getCount() {
        try {
            int n = ZygoteCommandBuffer.nativeGetCount(this.mNativeBuffer);
            return n;
        }
        finally {
            Reference.reachabilityFence(this.mSocket);
        }
    }

    private static int nativeGetCount(long l) {
        return OverrideMethod.invokeI("com.android.internal.os.ZygoteCommandBuffer#nativeGetCount(J)I", true, null);
    }

    private void setCommand(String[] command) {
        int nArgs = command.length;
        ZygoteCommandBuffer.insert(this.mNativeBuffer, Integer.toString(nArgs));
        for (String s : command) {
            ZygoteCommandBuffer.insert(this.mNativeBuffer, s);
        }
    }

    private static void insert(long l, String string2) {
        OverrideMethod.invokeV("com.android.internal.os.ZygoteCommandBuffer#insert(JLjava/lang/String;)V", true, null);
    }

    String nextArg() {
        try {
            String string2 = ZygoteCommandBuffer.nativeNextArg(this.mNativeBuffer);
            return string2;
        }
        finally {
            Reference.reachabilityFence(this.mSocket);
        }
    }

    private static String nativeNextArg(long l) {
        return (String)OverrideMethod.invokeA("com.android.internal.os.ZygoteCommandBuffer#nativeNextArg(J)Ljava/lang/String;", true, null);
    }

    void readFullyAndReset() {
        try {
            ZygoteCommandBuffer.nativeReadFullyAndReset(this.mNativeBuffer);
        }
        finally {
            Reference.reachabilityFence(this.mSocket);
        }
    }

    private static void nativeReadFullyAndReset(long l) {
        OverrideMethod.invokeV("com.android.internal.os.ZygoteCommandBuffer#nativeReadFullyAndReset(J)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean forkRepeatedly(FileDescriptor zygoteSocket, int expectedUid, int minUid, String firstNiceName) {
        try {
            boolean bl = ZygoteCommandBuffer.nativeForkRepeatedly(this.mNativeBuffer, zygoteSocket.getInt$(), expectedUid, minUid, firstNiceName);
            return bl;
        }
        finally {
            Reference.reachabilityFence(this.mSocket);
            Reference.reachabilityFence(zygoteSocket);
        }
    }

    private static boolean nativeForkRepeatedly(long l, int n, int n2, int n3, String string2) {
        return OverrideMethod.invokeI("com.android.internal.os.ZygoteCommandBuffer#nativeForkRepeatedly(JIIILjava/lang/String;)Z", true, null) != 0;
    }
}

