/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.security;

import android.os.SystemProperties;
import android.os._Original_Build;
import android.system.Os;
import android.system.OsConstants;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.android.internal.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.android.internal.org.bouncycastle.cms.CMSException;
import com.android.internal.org.bouncycastle.cms.CMSProcessable;
import com.android.internal.org.bouncycastle.cms.CMSProcessableByteArray;
import com.android.internal.org.bouncycastle.cms.CMSSignedData;
import com.android.internal.org.bouncycastle.cms.SignerInformation;
import com.android.internal.org.bouncycastle.cms.SignerInformationVerifier;
import com.android.internal.org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import com.android.internal.org.bouncycastle.operator.OperatorCreationException;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public abstract class VerityUtils {
    private static final String TAG = "VerityUtils";
    public static final String FSVERITY_SIGNATURE_FILE_EXTENSION = ".fsv_sig";
    private static final int HASH_SIZE_BYTES = 32;

    public static boolean isFsVeritySupported() {
        return _Original_Build.VERSION.DEVICE_INITIAL_SDK_INT >= 30 || SystemProperties.getInt("ro.apk_verity.mode", 0) == 2;
    }

    public static boolean isFsveritySignatureFile(File file) {
        return file.getName().endsWith(FSVERITY_SIGNATURE_FILE_EXTENSION);
    }

    public static String getFsveritySignatureFilePath(String filePath) {
        return filePath + FSVERITY_SIGNATURE_FILE_EXTENSION;
    }

    public static void setUpFsverity(String filePath) throws IOException {
        int errno = VerityUtils.enableFsverityNative(filePath);
        if (errno != 0) {
            throw new IOException("Failed to enable fs-verity on " + filePath + ": " + Os.strerror(errno));
        }
    }

    public static void setUpFsverity(int fd) throws IOException {
        int errno = VerityUtils.enableFsverityForFdNative(fd);
        if (errno != 0) {
            throw new IOException("Failed to enable fs-verity on FD(" + fd + "): " + Os.strerror(errno));
        }
    }

    public static boolean hasFsverity(String filePath) {
        int retval = VerityUtils.statxForFsverityNative(filePath);
        if (retval < 0) {
            Slog.e(TAG, "Failed to check whether fs-verity is enabled, errno " + -retval + ": " + filePath);
            return false;
        }
        return retval == 1;
    }

    public static boolean verifyPkcs7DetachedSignature(byte[] signatureBlock, byte[] digest, InputStream derCertInputStream) {
        if (digest.length != 32) {
            Slog.w(TAG, "Only sha256 is currently supported");
            return false;
        }
        try {
            CMSSignedData signedData = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(VerityUtils.toFormattedDigest(digest)), signatureBlock);
            if (!signedData.isDetachedSignature()) {
                Slog.w(TAG, "Expect only detached siganture");
                return false;
            }
            if (!signedData.getCertificates().getMatches(null).isEmpty()) {
                Slog.w(TAG, "Expect no certificate in signature");
                return false;
            }
            if (!signedData.getCRLs().getMatches(null).isEmpty()) {
                Slog.w(TAG, "Expect no CRL in signature");
                return false;
            }
            X509Certificate trustedCert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(derCertInputStream);
            SignerInformationVerifier verifier = new JcaSimpleSignerInfoVerifierBuilder().build(trustedCert);
            for (SignerInformation si : signedData.getSignerInfos().getSigners()) {
                if (si.getSignedAttributes() != null && si.getSignedAttributes().size() > 0) {
                    Slog.w(TAG, "Unexpected signed attributes");
                    return false;
                }
                if (si.getUnsignedAttributes() != null && si.getUnsignedAttributes().size() > 0) {
                    Slog.w(TAG, "Unexpected unsigned attributes");
                    return false;
                }
                if (!NISTObjectIdentifiers.id_sha256.getId().equals(si.getDigestAlgOID())) {
                    Slog.w(TAG, "Unsupported digest algorithm OID: " + si.getDigestAlgOID());
                    return false;
                }
                if (!PKCSObjectIdentifiers.rsaEncryption.getId().equals(si.getEncryptionAlgOID())) {
                    Slog.w(TAG, "Unsupported encryption algorithm OID: " + si.getEncryptionAlgOID());
                    return false;
                }
                if (!si.verify(verifier)) continue;
                return true;
            }
            return false;
        }
        catch (CMSException | OperatorCreationException | CertificateException e) {
            Slog.w(TAG, "Error occurred during the PKCS#7 signature verification", e);
            return false;
        }
    }

    public static byte[] getFsverityDigest(String filePath) {
        byte[] result = new byte[32];
        int retval = VerityUtils.measureFsverityNative(filePath, result);
        if (retval < 0) {
            if (retval != -OsConstants.ENODATA) {
                Slog.e(TAG, "Failed to measure fs-verity, errno " + -retval + ": " + filePath);
            }
            return null;
        }
        return result;
    }

    @VisibleForTesting
    public static byte[] toFormattedDigest(byte[] digest) {
        ByteBuffer buffer = ByteBuffer.allocate(12 + digest.length);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put("FSVerity".getBytes(StandardCharsets.US_ASCII));
        buffer.putShort((short)1);
        buffer.putShort((short)digest.length);
        buffer.put(digest);
        return buffer.array();
    }

    private static int enableFsverityNative(String string2) {
        return OverrideMethod.invokeI("com.android.internal.security.VerityUtils#enableFsverityNative(Ljava/lang/String;)I", true, null);
    }

    private static int enableFsverityForFdNative(int n) {
        return OverrideMethod.invokeI("com.android.internal.security.VerityUtils#enableFsverityForFdNative(I)I", true, null);
    }

    private static int measureFsverityNative(String string2, byte[] byArray) {
        return OverrideMethod.invokeI("com.android.internal.security.VerityUtils#measureFsverityNative(Ljava/lang/String;[B)I", true, null);
    }

    private static int statxForFsverityNative(String string2) {
        return OverrideMethod.invokeI("com.android.internal.security.VerityUtils#statxForFsverityNative(Ljava/lang/String;)I", true, null);
    }
}

