/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.statusbar;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.android.internal.logging.InstanceId;

public interface ISessionListener
extends IInterface {
    public static final String DESCRIPTOR = "com.android.internal.statusbar.ISessionListener";

    public void onSessionStarted(int var1, InstanceId var2) throws RemoteException;

    public void onSessionEnded(int var1, InstanceId var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISessionListener {
        static final int TRANSACTION_onSessionStarted = 1;
        static final int TRANSACTION_onSessionEnded = 2;

        public Stub() {
            this.attachInterface(this, ISessionListener.DESCRIPTOR);
        }

        public static ISessionListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISessionListener.DESCRIPTOR);
            if (iin != null && iin instanceof ISessionListener) {
                return (ISessionListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onSessionStarted";
                }
                case 2: {
                    return "onSessionEnded";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISessionListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    InstanceId _arg1 = data.readTypedObject(InstanceId.CREATOR);
                    data.enforceNoDataAvail();
                    this.onSessionStarted(_arg0, _arg1);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    InstanceId _arg1 = data.readTypedObject(InstanceId.CREATOR);
                    data.enforceNoDataAvail();
                    this.onSessionEnded(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements ISessionListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISessionListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionStarted(int sessionType, InstanceId instance) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISessionListener.DESCRIPTOR);
                    _data.writeInt(sessionType);
                    _data.writeTypedObject(instance, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionEnded(int sessionType, InstanceId instance) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISessionListener.DESCRIPTOR);
                    _data.writeInt(sessionType);
                    _data.writeTypedObject(instance, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISessionListener {
        @Override
        public void onSessionStarted(int sessionType, InstanceId instance) throws RemoteException {
        }

        @Override
        public void onSessionEnded(int sessionType, InstanceId instance) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

