/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.statusbar;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IUndoMediaTransferCallback
extends IInterface {
    public static final String DESCRIPTOR = "com.android.internal.statusbar.IUndoMediaTransferCallback";

    public void onUndoTriggered() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IUndoMediaTransferCallback {
        static final int TRANSACTION_onUndoTriggered = 1;

        public Stub() {
            this.attachInterface(this, IUndoMediaTransferCallback.DESCRIPTOR);
        }

        public static IUndoMediaTransferCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IUndoMediaTransferCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IUndoMediaTransferCallback) {
                return (IUndoMediaTransferCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onUndoTriggered";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IUndoMediaTransferCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    this.onUndoTriggered();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IUndoMediaTransferCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IUndoMediaTransferCallback.DESCRIPTOR;
            }

            @Override
            public void onUndoTriggered() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IUndoMediaTransferCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IUndoMediaTransferCallback {
        @Override
        public void onUndoTriggered() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

