/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telecom;

import android.os.Binder;
import android.os.Bundle;
import android.os.OutcomeReceiver;
import android.os.ResultReceiver;
import android.telecom.CallAttributes;
import android.telecom.CallControl;
import android.telecom.CallControlCallback;
import android.telecom.CallEndpoint;
import android.telecom.CallEventCallback;
import android.telecom.CallException;
import android.telecom.DisconnectCause;
import android.telecom.PhoneAccountHandle;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telecom.ClientTransactionalServiceRepository;
import com.android.internal.telecom.ICallControl;
import com.android.internal.telecom.ICallEventCallback;
import com.android.internal.telecom.TransactionalCall;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class ClientTransactionalServiceWrapper {
    private static final String TAG = ClientTransactionalServiceWrapper.class.getSimpleName();
    private final PhoneAccountHandle mPhoneAccountHandle;
    private final ClientTransactionalServiceRepository mRepository;
    private final ConcurrentHashMap<String, TransactionalCall> mCallIdToTransactionalCall = new ConcurrentHashMap();
    private static final String EXECUTOR_FAIL_MSG = "Telecom hit an exception while handling a CallEventCallback on an executor: ";
    private final ICallEventCallback mCallEventCallback = new ICallEventCallback.Stub(){
        private static final String ON_SET_ACTIVE = "onSetActive";
        private static final String ON_SET_INACTIVE = "onSetInactive";
        private static final String ON_ANSWER = "onAnswer";
        private static final String ON_DISCONNECT = "onDisconnect";
        private static final String ON_STREAMING_STARTED = "onStreamingStarted";
        private static final String ON_REQ_ENDPOINT_CHANGE = "onRequestEndpointChange";
        private static final String ON_AVAILABLE_CALL_ENDPOINTS = "onAvailableCallEndpointsChanged";
        private static final String ON_MUTE_STATE_CHANGED = "onMuteStateChanged";
        private static final String ON_CALL_STREAMING_FAILED = "onCallStreamingFailed";
        private static final String ON_EVENT = "onEvent";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleCallEventCallback(String action, String callId, ResultReceiver ackResultReceiver, Object ... args) {
            Log.i(TAG, TextUtils.formatSimple("hCEC: id=[%s], action=[%s]", callId, action));
            TransactionalCall call = ClientTransactionalServiceWrapper.this.mCallIdToTransactionalCall.get(callId);
            if (call != null) {
                CallControlCallback callback = call.getCallControlCallback();
                ReceiverWrapper outcomeReceiverWrapper = new ReceiverWrapper(ackResultReceiver);
                long identity = Binder.clearCallingIdentity();
                try {
                    call.getExecutor().execute(() -> {
                        switch (action) {
                            case "onSetActive": {
                                callback.onSetActive(outcomeReceiverWrapper);
                                break;
                            }
                            case "onSetInactive": {
                                callback.onSetInactive(outcomeReceiverWrapper);
                                break;
                            }
                            case "onDisconnect": {
                                callback.onDisconnect((DisconnectCause)args[0], outcomeReceiverWrapper);
                                ClientTransactionalServiceWrapper.this.untrackCall(callId);
                                break;
                            }
                            case "onAnswer": {
                                callback.onAnswer((Integer)args[0], outcomeReceiverWrapper);
                                break;
                            }
                            case "onStreamingStarted": {
                                callback.onCallStreamingStarted(outcomeReceiverWrapper);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    Log.e(TAG, ClientTransactionalServiceWrapper.EXECUTOR_FAIL_MSG + e);
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }

        @Override
        public void onAddCallControl(String callId, int resultCode, ICallControl callControl, CallException transactionalException) {
            Log.i(TAG, TextUtils.formatSimple("oACC: id=[%s], code=[%d]", callId, resultCode));
            TransactionalCall call = ClientTransactionalServiceWrapper.this.mCallIdToTransactionalCall.get(callId);
            if (call != null) {
                OutcomeReceiver<CallControl, CallException> pendingControl = call.getPendingControl();
                if (resultCode == 0) {
                    CallControl control = new CallControl(callId, callControl, ClientTransactionalServiceWrapper.this.mRepository, ClientTransactionalServiceWrapper.this.mPhoneAccountHandle);
                    pendingControl.onResult(control);
                    call.setCallControl(control);
                } else {
                    pendingControl.onError(transactionalException);
                    ClientTransactionalServiceWrapper.this.mCallIdToTransactionalCall.remove(callId);
                }
            } else {
                ClientTransactionalServiceWrapper.this.untrackCall(callId);
                Log.e(TAG, "oACC: TransactionalCall object not found for call w/ id=" + callId);
            }
        }

        @Override
        public void onSetActive(String callId, ResultReceiver resultReceiver) {
            this.handleCallEventCallback(ON_SET_ACTIVE, callId, resultReceiver, new Object[0]);
        }

        @Override
        public void onSetInactive(String callId, ResultReceiver resultReceiver) {
            this.handleCallEventCallback(ON_SET_INACTIVE, callId, resultReceiver, new Object[0]);
        }

        @Override
        public void onAnswer(String callId, int videoState, ResultReceiver resultReceiver) {
            this.handleCallEventCallback(ON_ANSWER, callId, resultReceiver, videoState);
        }

        @Override
        public void onDisconnect(String callId, DisconnectCause cause, ResultReceiver resultReceiver) {
            this.handleCallEventCallback(ON_DISCONNECT, callId, resultReceiver, cause);
        }

        @Override
        public void onCallEndpointChanged(String callId, CallEndpoint endpoint) {
            this.handleEventCallback(callId, ON_REQ_ENDPOINT_CHANGE, endpoint);
        }

        @Override
        public void onAvailableCallEndpointsChanged(String callId, List<CallEndpoint> endpoints) {
            this.handleEventCallback(callId, ON_AVAILABLE_CALL_ENDPOINTS, endpoints);
        }

        @Override
        public void onMuteStateChanged(String callId, boolean isMuted) {
            this.handleEventCallback(callId, ON_MUTE_STATE_CHANGED, isMuted);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEventCallback(String callId, String action, Object arg) {
            Log.d(TAG, TextUtils.formatSimple("hEC: [%s], callId=[%s]", action, callId));
            TransactionalCall call = ClientTransactionalServiceWrapper.this.mCallIdToTransactionalCall.get(callId);
            if (call != null) {
                CallEventCallback callback = call.getCallStateCallback();
                Executor executor = call.getExecutor();
                long identity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> {
                        switch (action) {
                            case "onRequestEndpointChange": {
                                callback.onCallEndpointChanged((CallEndpoint)arg);
                                break;
                            }
                            case "onAvailableCallEndpointsChanged": {
                                callback.onAvailableCallEndpointsChanged((List)arg);
                                break;
                            }
                            case "onMuteStateChanged": {
                                callback.onMuteStateChanged((Boolean)arg);
                                break;
                            }
                            case "onCallStreamingFailed": {
                                callback.onCallStreamingFailed((Integer)arg);
                            }
                        }
                    });
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }

        @Override
        public void removeCallFromTransactionalServiceWrapper(String callId) {
            ClientTransactionalServiceWrapper.this.untrackCall(callId);
        }

        @Override
        public void onCallStreamingStarted(String callId, ResultReceiver resultReceiver) {
            this.handleCallEventCallback(ON_STREAMING_STARTED, callId, resultReceiver, new Object[0]);
        }

        @Override
        public void onCallStreamingFailed(String callId, int reason) {
            Log.i(TAG, TextUtils.formatSimple("oCSF: id=[%s], reason=[%s]", callId, reason));
            this.handleEventCallback(callId, ON_CALL_STREAMING_FAILED, reason);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEvent(String callId, String event, Bundle extras) {
            TransactionalCall call = ClientTransactionalServiceWrapper.this.mCallIdToTransactionalCall.get(callId);
            if (call != null) {
                CallEventCallback callback = call.getCallStateCallback();
                Executor executor = call.getExecutor();
                long identity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> callback.onEvent(event, extras));
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }
    };

    public ClientTransactionalServiceWrapper(PhoneAccountHandle handle, ClientTransactionalServiceRepository repo) {
        this.mPhoneAccountHandle = handle;
        this.mRepository = repo;
    }

    public void untrackCall(String callId) {
        TransactionalCall call;
        CallControl control;
        Log.i(TAG, TextUtils.formatSimple("removeCall: with id=[%s]", callId));
        if (this.mCallIdToTransactionalCall.containsKey(callId) && (control = (call = this.mCallIdToTransactionalCall.remove(callId)).getCallControl()) != null) {
            call.setCallControl(null);
        }
        if (this.mCallIdToTransactionalCall.size() == 0) {
            this.mRepository.removeServiceWrapper(this.mPhoneAccountHandle);
        }
    }

    public String trackCall(CallAttributes callAttributes, Executor executor, OutcomeReceiver<CallControl, CallException> pendingControl, CallControlCallback handshakes, CallEventCallback events) {
        String newCallId = UUID.randomUUID().toString();
        this.mCallIdToTransactionalCall.put(newCallId, new TransactionalCall(newCallId, callAttributes, executor, pendingControl, handshakes, events));
        return newCallId;
    }

    public ICallEventCallback getCallEventCallback() {
        return this.mCallEventCallback;
    }

    private class ReceiverWrapper
    implements Consumer<Boolean> {
        private final ResultReceiver mRepeaterReceiver;

        ReceiverWrapper(ResultReceiver resultReceiver) {
            this.mRepeaterReceiver = resultReceiver;
        }

        @Override
        public void accept(Boolean clientCompletedCallbackSuccessfully) {
            if (clientCompletedCallbackSuccessfully.booleanValue()) {
                this.mRepeaterReceiver.send(0, null);
            } else {
                this.mRepeaterReceiver.send(1, null);
            }
        }

        @Override
        public Consumer<Boolean> andThen(Consumer<? super Boolean> after) {
            return Consumer.super.andThen(after);
        }
    }
}

