/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telecom;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.telecom.CallEndpoint;
import android.telecom.CallException;
import android.telecom.DisconnectCause;
import com.android.internal.telecom.ICallControl;
import java.util.ArrayList;
import java.util.List;

public interface ICallEventCallback
extends IInterface {
    public static final String DESCRIPTOR = "com.android.internal.telecom.ICallEventCallback";

    public void onAddCallControl(String var1, int var2, ICallControl var3, CallException var4) throws RemoteException;

    public void onSetActive(String var1, ResultReceiver var2) throws RemoteException;

    public void onSetInactive(String var1, ResultReceiver var2) throws RemoteException;

    public void onAnswer(String var1, int var2, ResultReceiver var3) throws RemoteException;

    public void onDisconnect(String var1, DisconnectCause var2, ResultReceiver var3) throws RemoteException;

    public void onCallStreamingStarted(String var1, ResultReceiver var2) throws RemoteException;

    public void onCallStreamingFailed(String var1, int var2) throws RemoteException;

    public void onCallEndpointChanged(String var1, CallEndpoint var2) throws RemoteException;

    public void onAvailableCallEndpointsChanged(String var1, List<CallEndpoint> var2) throws RemoteException;

    public void onMuteStateChanged(String var1, boolean var2) throws RemoteException;

    public void onEvent(String var1, String var2, Bundle var3) throws RemoteException;

    public void removeCallFromTransactionalServiceWrapper(String var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICallEventCallback {
        static final int TRANSACTION_onAddCallControl = 1;
        static final int TRANSACTION_onSetActive = 2;
        static final int TRANSACTION_onSetInactive = 3;
        static final int TRANSACTION_onAnswer = 4;
        static final int TRANSACTION_onDisconnect = 5;
        static final int TRANSACTION_onCallStreamingStarted = 6;
        static final int TRANSACTION_onCallStreamingFailed = 7;
        static final int TRANSACTION_onCallEndpointChanged = 8;
        static final int TRANSACTION_onAvailableCallEndpointsChanged = 9;
        static final int TRANSACTION_onMuteStateChanged = 10;
        static final int TRANSACTION_onEvent = 11;
        static final int TRANSACTION_removeCallFromTransactionalServiceWrapper = 12;

        public Stub() {
            this.attachInterface(this, ICallEventCallback.DESCRIPTOR);
        }

        public static ICallEventCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ICallEventCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ICallEventCallback) {
                return (ICallEventCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onAddCallControl";
                }
                case 2: {
                    return "onSetActive";
                }
                case 3: {
                    return "onSetInactive";
                }
                case 4: {
                    return "onAnswer";
                }
                case 5: {
                    return "onDisconnect";
                }
                case 6: {
                    return "onCallStreamingStarted";
                }
                case 7: {
                    return "onCallStreamingFailed";
                }
                case 8: {
                    return "onCallEndpointChanged";
                }
                case 9: {
                    return "onAvailableCallEndpointsChanged";
                }
                case 10: {
                    return "onMuteStateChanged";
                }
                case 11: {
                    return "onEvent";
                }
                case 12: {
                    return "removeCallFromTransactionalServiceWrapper";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ICallEventCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    ICallControl _arg2 = ICallControl.Stub.asInterface(data.readStrongBinder());
                    CallException _arg3 = data.readTypedObject(CallException.CREATOR);
                    data.enforceNoDataAvail();
                    this.onAddCallControl(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    ResultReceiver _arg1 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.onSetActive(_arg0, _arg1);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    ResultReceiver _arg1 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.onSetInactive(_arg0, _arg1);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    ResultReceiver _arg2 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.onAnswer(_arg0, _arg1, _arg2);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    DisconnectCause _arg1 = data.readTypedObject(DisconnectCause.CREATOR);
                    ResultReceiver _arg2 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.onDisconnect(_arg0, _arg1, _arg2);
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    ResultReceiver _arg1 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.onCallStreamingStarted(_arg0, _arg1);
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onCallStreamingFailed(_arg0, _arg1);
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    CallEndpoint _arg1 = data.readTypedObject(CallEndpoint.CREATOR);
                    data.enforceNoDataAvail();
                    this.onCallEndpointChanged(_arg0, _arg1);
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    ArrayList<CallEndpoint> _arg1 = data.createTypedArrayList(CallEndpoint.CREATOR);
                    data.enforceNoDataAvail();
                    this.onAvailableCallEndpointsChanged(_arg0, _arg1);
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onMuteStateChanged(_arg0, _arg1);
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onEvent(_arg0, _arg1, _arg2);
                    break;
                }
                case 12: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.removeCallFromTransactionalServiceWrapper(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 11;
        }

        private static class Proxy
        implements ICallEventCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ICallEventCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAddCallControl(String callId, int resultCode, ICallControl callControl, CallException exception) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICallEventCallback.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeInt(resultCode);
                    _data.writeStrongInterface(callControl);
                    _data.writeTypedObject(exception, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSetActive(String callId, ResultReceiver callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICallEventCallback.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSetInactive(String callId, ResultReceiver callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICallEventCallback.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAnswer(String callId, int videoState, ResultReceiver callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICallEventCallback.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeInt(videoState);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDisconnect(String callId, DisconnectCause cause, ResultReceiver callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICallEventCallback.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeTypedObject(cause, 0);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCallStreamingStarted(String callId, ResultReceiver callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICallEventCallback.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCallStreamingFailed(String callId, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICallEventCallback.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeInt(reason);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCallEndpointChanged(String callId, CallEndpoint endpoint) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICallEventCallback.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeTypedObject(endpoint, 0);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAvailableCallEndpointsChanged(String callId, List<CallEndpoint> endpoint) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICallEventCallback.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeTypedList(endpoint, 0);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMuteStateChanged(String callId, boolean isMuted) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICallEventCallback.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeBoolean(isMuted);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEvent(String callId, String event, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICallEventCallback.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeString(event);
                    _data.writeTypedObject(extras, 0);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeCallFromTransactionalServiceWrapper(String callId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICallEventCallback.DESCRIPTOR);
                    _data.writeString(callId);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ICallEventCallback {
        @Override
        public void onAddCallControl(String callId, int resultCode, ICallControl callControl, CallException exception) throws RemoteException {
        }

        @Override
        public void onSetActive(String callId, ResultReceiver callback) throws RemoteException {
        }

        @Override
        public void onSetInactive(String callId, ResultReceiver callback) throws RemoteException {
        }

        @Override
        public void onAnswer(String callId, int videoState, ResultReceiver callback) throws RemoteException {
        }

        @Override
        public void onDisconnect(String callId, DisconnectCause cause, ResultReceiver callback) throws RemoteException {
        }

        @Override
        public void onCallStreamingStarted(String callId, ResultReceiver callback) throws RemoteException {
        }

        @Override
        public void onCallStreamingFailed(String callId, int reason) throws RemoteException {
        }

        @Override
        public void onCallEndpointChanged(String callId, CallEndpoint endpoint) throws RemoteException {
        }

        @Override
        public void onAvailableCallEndpointsChanged(String callId, List<CallEndpoint> endpoint) throws RemoteException {
        }

        @Override
        public void onMuteStateChanged(String callId, boolean isMuted) throws RemoteException {
        }

        @Override
        public void onEvent(String callId, String event, Bundle extras) throws RemoteException {
        }

        @Override
        public void removeCallFromTransactionalServiceWrapper(String callId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

