/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.CallForwardingInfo;

public interface ICallForwardingInfoCallback
extends IInterface {
    public static final String DESCRIPTOR = "com.android.internal.telephony.ICallForwardingInfoCallback";

    public void onCallForwardingInfoAvailable(CallForwardingInfo var1) throws RemoteException;

    public void onError(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICallForwardingInfoCallback {
        static final int TRANSACTION_onCallForwardingInfoAvailable = 1;
        static final int TRANSACTION_onError = 2;

        public Stub() {
            this.attachInterface(this, ICallForwardingInfoCallback.DESCRIPTOR);
        }

        public static ICallForwardingInfoCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ICallForwardingInfoCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ICallForwardingInfoCallback) {
                return (ICallForwardingInfoCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onCallForwardingInfoAvailable";
                }
                case 2: {
                    return "onError";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ICallForwardingInfoCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    CallForwardingInfo _arg0 = data.readTypedObject(CallForwardingInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onCallForwardingInfoAvailable(_arg0);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onError(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements ICallForwardingInfoCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ICallForwardingInfoCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCallForwardingInfoAvailable(CallForwardingInfo info) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICallForwardingInfoCallback.DESCRIPTOR);
                    _data.writeTypedObject(info, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(int error) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICallForwardingInfoCallback.DESCRIPTOR);
                    _data.writeInt(error);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ICallForwardingInfoCallback {
        @Override
        public void onCallForwardingInfoAvailable(CallForwardingInfo info) throws RemoteException {
        }

        @Override
        public void onError(int error) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

