/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface ICarrierPrivilegesCallback
extends IInterface {
    public static final String DESCRIPTOR = "com.android.internal.telephony.ICarrierPrivilegesCallback";

    public void onCarrierPrivilegesChanged(List<String> var1, int[] var2) throws RemoteException;

    public void onCarrierServiceChanged(String var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICarrierPrivilegesCallback {
        static final int TRANSACTION_onCarrierPrivilegesChanged = 1;
        static final int TRANSACTION_onCarrierServiceChanged = 2;

        public Stub() {
            this.attachInterface(this, ICarrierPrivilegesCallback.DESCRIPTOR);
        }

        public static ICarrierPrivilegesCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ICarrierPrivilegesCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ICarrierPrivilegesCallback) {
                return (ICarrierPrivilegesCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onCarrierPrivilegesChanged";
                }
                case 2: {
                    return "onCarrierServiceChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ICarrierPrivilegesCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    ArrayList<String> _arg0 = data.createStringArrayList();
                    int[] _arg1 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.onCarrierPrivilegesChanged(_arg0, _arg1);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onCarrierServiceChanged(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements ICarrierPrivilegesCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ICarrierPrivilegesCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCarrierPrivilegesChanged(List<String> privilegedPackageNames, int[] privilegedUids) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICarrierPrivilegesCallback.DESCRIPTOR);
                    _data.writeStringList(privilegedPackageNames);
                    _data.writeIntArray(privilegedUids);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCarrierServiceChanged(String carrierServicePackageName, int carrierServiceUid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICarrierPrivilegesCallback.DESCRIPTOR);
                    _data.writeString(carrierServicePackageName);
                    _data.writeInt(carrierServiceUid);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ICarrierPrivilegesCallback {
        @Override
        public void onCarrierPrivilegesChanged(List<String> privilegedPackageNames, int[] privilegedUids) throws RemoteException {
        }

        @Override
        public void onCarrierServiceChanged(String carrierServicePackageName, int carrierServiceUid) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

