/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IImsStateCallback
extends IInterface {
    public static final String DESCRIPTOR = "com.android.internal.telephony.IImsStateCallback";

    public void onUnavailable(int var1) throws RemoteException;

    public void onAvailable() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IImsStateCallback {
        static final int TRANSACTION_onUnavailable = 1;
        static final int TRANSACTION_onAvailable = 2;

        public Stub() {
            this.attachInterface(this, IImsStateCallback.DESCRIPTOR);
        }

        public static IImsStateCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IImsStateCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IImsStateCallback) {
                return (IImsStateCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onUnavailable";
                }
                case 2: {
                    return "onAvailable";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IImsStateCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onUnavailable(_arg0);
                    break;
                }
                case 2: {
                    this.onAvailable();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IImsStateCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IImsStateCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUnavailable(int reason) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsStateCallback.DESCRIPTOR);
                    _data.writeInt(reason);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onAvailable() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsStateCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IImsStateCallback {
        @Override
        public void onUnavailable(int reason) throws RemoteException {
        }

        @Override
        public void onAvailable() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

