/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.BarringInfo;
import android.telephony.CallState;
import android.telephony.CellIdentity;
import android.telephony.CellInfo;
import android.telephony.DataConnectionRealTimeInfo;
import android.telephony.LinkCapacityEstimate;
import android.telephony.PhoneCapability;
import android.telephony.PhysicalChannelConfig;
import android.telephony.PreciseCallState;
import android.telephony.PreciseDataConnectionState;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.TelephonyDisplayInfo;
import android.telephony.emergency.EmergencyNumber;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.MediaQualityStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface IPhoneStateListener
extends IInterface {
    public void onServiceStateChanged(ServiceState var1) throws RemoteException;

    public void onSignalStrengthChanged(int var1) throws RemoteException;

    public void onMessageWaitingIndicatorChanged(boolean var1) throws RemoteException;

    public void onCallForwardingIndicatorChanged(boolean var1) throws RemoteException;

    public void onCellLocationChanged(CellIdentity var1) throws RemoteException;

    public void onLegacyCallStateChanged(int var1, String var2) throws RemoteException;

    public void onCallStateChanged(int var1) throws RemoteException;

    public void onDataConnectionStateChanged(int var1, int var2) throws RemoteException;

    public void onDataActivity(int var1) throws RemoteException;

    public void onSignalStrengthsChanged(SignalStrength var1) throws RemoteException;

    public void onCellInfoChanged(List<CellInfo> var1) throws RemoteException;

    public void onPreciseCallStateChanged(PreciseCallState var1) throws RemoteException;

    public void onPreciseDataConnectionStateChanged(PreciseDataConnectionState var1) throws RemoteException;

    public void onDataConnectionRealTimeInfoChanged(DataConnectionRealTimeInfo var1) throws RemoteException;

    public void onSrvccStateChanged(int var1) throws RemoteException;

    public void onVoiceActivationStateChanged(int var1) throws RemoteException;

    public void onDataActivationStateChanged(int var1) throws RemoteException;

    public void onOemHookRawEvent(byte[] var1) throws RemoteException;

    public void onCarrierNetworkChange(boolean var1) throws RemoteException;

    public void onUserMobileDataStateChanged(boolean var1) throws RemoteException;

    public void onDisplayInfoChanged(TelephonyDisplayInfo var1) throws RemoteException;

    public void onPhoneCapabilityChanged(PhoneCapability var1) throws RemoteException;

    public void onActiveDataSubIdChanged(int var1) throws RemoteException;

    public void onRadioPowerStateChanged(int var1) throws RemoteException;

    public void onCallStatesChanged(List<CallState> var1) throws RemoteException;

    public void onEmergencyNumberListChanged(Map var1) throws RemoteException;

    public void onOutgoingEmergencyCall(EmergencyNumber var1, int var2) throws RemoteException;

    public void onOutgoingEmergencySms(EmergencyNumber var1, int var2) throws RemoteException;

    public void onCallDisconnectCauseChanged(int var1, int var2) throws RemoteException;

    public void onImsCallDisconnectCauseChanged(ImsReasonInfo var1) throws RemoteException;

    public void onRegistrationFailed(CellIdentity var1, String var2, int var3, int var4, int var5) throws RemoteException;

    public void onBarringInfoChanged(BarringInfo var1) throws RemoteException;

    public void onPhysicalChannelConfigChanged(List<PhysicalChannelConfig> var1) throws RemoteException;

    public void onDataEnabledChanged(boolean var1, int var2) throws RemoteException;

    public void onAllowedNetworkTypesChanged(int var1, long var2) throws RemoteException;

    public void onLinkCapacityEstimateChanged(List<LinkCapacityEstimate> var1) throws RemoteException;

    public void onMediaQualityStatusChanged(MediaQualityStatus var1) throws RemoteException;

    public void onCallBackModeStarted(int var1) throws RemoteException;

    public void onCallBackModeStopped(int var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPhoneStateListener {
        public static final String DESCRIPTOR = "com.android.internal.telephony.IPhoneStateListener";
        static final int TRANSACTION_onServiceStateChanged = 1;
        static final int TRANSACTION_onSignalStrengthChanged = 2;
        static final int TRANSACTION_onMessageWaitingIndicatorChanged = 3;
        static final int TRANSACTION_onCallForwardingIndicatorChanged = 4;
        static final int TRANSACTION_onCellLocationChanged = 5;
        static final int TRANSACTION_onLegacyCallStateChanged = 6;
        static final int TRANSACTION_onCallStateChanged = 7;
        static final int TRANSACTION_onDataConnectionStateChanged = 8;
        static final int TRANSACTION_onDataActivity = 9;
        static final int TRANSACTION_onSignalStrengthsChanged = 10;
        static final int TRANSACTION_onCellInfoChanged = 11;
        static final int TRANSACTION_onPreciseCallStateChanged = 12;
        static final int TRANSACTION_onPreciseDataConnectionStateChanged = 13;
        static final int TRANSACTION_onDataConnectionRealTimeInfoChanged = 14;
        static final int TRANSACTION_onSrvccStateChanged = 15;
        static final int TRANSACTION_onVoiceActivationStateChanged = 16;
        static final int TRANSACTION_onDataActivationStateChanged = 17;
        static final int TRANSACTION_onOemHookRawEvent = 18;
        static final int TRANSACTION_onCarrierNetworkChange = 19;
        static final int TRANSACTION_onUserMobileDataStateChanged = 20;
        static final int TRANSACTION_onDisplayInfoChanged = 21;
        static final int TRANSACTION_onPhoneCapabilityChanged = 22;
        static final int TRANSACTION_onActiveDataSubIdChanged = 23;
        static final int TRANSACTION_onRadioPowerStateChanged = 24;
        static final int TRANSACTION_onCallStatesChanged = 25;
        static final int TRANSACTION_onEmergencyNumberListChanged = 26;
        static final int TRANSACTION_onOutgoingEmergencyCall = 27;
        static final int TRANSACTION_onOutgoingEmergencySms = 28;
        static final int TRANSACTION_onCallDisconnectCauseChanged = 29;
        static final int TRANSACTION_onImsCallDisconnectCauseChanged = 30;
        static final int TRANSACTION_onRegistrationFailed = 31;
        static final int TRANSACTION_onBarringInfoChanged = 32;
        static final int TRANSACTION_onPhysicalChannelConfigChanged = 33;
        static final int TRANSACTION_onDataEnabledChanged = 34;
        static final int TRANSACTION_onAllowedNetworkTypesChanged = 35;
        static final int TRANSACTION_onLinkCapacityEstimateChanged = 36;
        static final int TRANSACTION_onMediaQualityStatusChanged = 37;
        static final int TRANSACTION_onCallBackModeStarted = 38;
        static final int TRANSACTION_onCallBackModeStopped = 39;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IPhoneStateListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IPhoneStateListener) {
                return (IPhoneStateListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onServiceStateChanged";
                }
                case 2: {
                    return "onSignalStrengthChanged";
                }
                case 3: {
                    return "onMessageWaitingIndicatorChanged";
                }
                case 4: {
                    return "onCallForwardingIndicatorChanged";
                }
                case 5: {
                    return "onCellLocationChanged";
                }
                case 6: {
                    return "onLegacyCallStateChanged";
                }
                case 7: {
                    return "onCallStateChanged";
                }
                case 8: {
                    return "onDataConnectionStateChanged";
                }
                case 9: {
                    return "onDataActivity";
                }
                case 10: {
                    return "onSignalStrengthsChanged";
                }
                case 11: {
                    return "onCellInfoChanged";
                }
                case 12: {
                    return "onPreciseCallStateChanged";
                }
                case 13: {
                    return "onPreciseDataConnectionStateChanged";
                }
                case 14: {
                    return "onDataConnectionRealTimeInfoChanged";
                }
                case 15: {
                    return "onSrvccStateChanged";
                }
                case 16: {
                    return "onVoiceActivationStateChanged";
                }
                case 17: {
                    return "onDataActivationStateChanged";
                }
                case 18: {
                    return "onOemHookRawEvent";
                }
                case 19: {
                    return "onCarrierNetworkChange";
                }
                case 20: {
                    return "onUserMobileDataStateChanged";
                }
                case 21: {
                    return "onDisplayInfoChanged";
                }
                case 22: {
                    return "onPhoneCapabilityChanged";
                }
                case 23: {
                    return "onActiveDataSubIdChanged";
                }
                case 24: {
                    return "onRadioPowerStateChanged";
                }
                case 25: {
                    return "onCallStatesChanged";
                }
                case 26: {
                    return "onEmergencyNumberListChanged";
                }
                case 27: {
                    return "onOutgoingEmergencyCall";
                }
                case 28: {
                    return "onOutgoingEmergencySms";
                }
                case 29: {
                    return "onCallDisconnectCauseChanged";
                }
                case 30: {
                    return "onImsCallDisconnectCauseChanged";
                }
                case 31: {
                    return "onRegistrationFailed";
                }
                case 32: {
                    return "onBarringInfoChanged";
                }
                case 33: {
                    return "onPhysicalChannelConfigChanged";
                }
                case 34: {
                    return "onDataEnabledChanged";
                }
                case 35: {
                    return "onAllowedNetworkTypesChanged";
                }
                case 36: {
                    return "onLinkCapacityEstimateChanged";
                }
                case 37: {
                    return "onMediaQualityStatusChanged";
                }
                case 38: {
                    return "onCallBackModeStarted";
                }
                case 39: {
                    return "onCallBackModeStopped";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    ServiceState _arg0 = data.readTypedObject(ServiceState.CREATOR);
                    data.enforceNoDataAvail();
                    this.onServiceStateChanged(_arg0);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSignalStrengthChanged(_arg0);
                    break;
                }
                case 3: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onMessageWaitingIndicatorChanged(_arg0);
                    break;
                }
                case 4: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onCallForwardingIndicatorChanged(_arg0);
                    break;
                }
                case 5: {
                    CellIdentity _arg0 = data.readTypedObject(CellIdentity.CREATOR);
                    data.enforceNoDataAvail();
                    this.onCellLocationChanged(_arg0);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.onLegacyCallStateChanged(_arg0, _arg1);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onCallStateChanged(_arg0);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onDataConnectionStateChanged(_arg0, _arg1);
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onDataActivity(_arg0);
                    break;
                }
                case 10: {
                    SignalStrength _arg0 = data.readTypedObject(SignalStrength.CREATOR);
                    data.enforceNoDataAvail();
                    this.onSignalStrengthsChanged(_arg0);
                    break;
                }
                case 11: {
                    ArrayList<CellInfo> _arg0 = data.createTypedArrayList(CellInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onCellInfoChanged(_arg0);
                    break;
                }
                case 12: {
                    PreciseCallState _arg0 = data.readTypedObject(PreciseCallState.CREATOR);
                    data.enforceNoDataAvail();
                    this.onPreciseCallStateChanged(_arg0);
                    break;
                }
                case 13: {
                    PreciseDataConnectionState _arg0 = data.readTypedObject(PreciseDataConnectionState.CREATOR);
                    data.enforceNoDataAvail();
                    this.onPreciseDataConnectionStateChanged(_arg0);
                    break;
                }
                case 14: {
                    DataConnectionRealTimeInfo _arg0 = data.readTypedObject(DataConnectionRealTimeInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onDataConnectionRealTimeInfoChanged(_arg0);
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSrvccStateChanged(_arg0);
                    break;
                }
                case 16: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onVoiceActivationStateChanged(_arg0);
                    break;
                }
                case 17: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onDataActivationStateChanged(_arg0);
                    break;
                }
                case 18: {
                    byte[] _arg0 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.onOemHookRawEvent(_arg0);
                    break;
                }
                case 19: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onCarrierNetworkChange(_arg0);
                    break;
                }
                case 20: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onUserMobileDataStateChanged(_arg0);
                    break;
                }
                case 21: {
                    TelephonyDisplayInfo _arg0 = data.readTypedObject(TelephonyDisplayInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onDisplayInfoChanged(_arg0);
                    break;
                }
                case 22: {
                    PhoneCapability _arg0 = data.readTypedObject(PhoneCapability.CREATOR);
                    data.enforceNoDataAvail();
                    this.onPhoneCapabilityChanged(_arg0);
                    break;
                }
                case 23: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onActiveDataSubIdChanged(_arg0);
                    break;
                }
                case 24: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRadioPowerStateChanged(_arg0);
                    break;
                }
                case 25: {
                    ArrayList<CallState> _arg0 = data.createTypedArrayList(CallState.CREATOR);
                    data.enforceNoDataAvail();
                    this.onCallStatesChanged(_arg0);
                    break;
                }
                case 26: {
                    ClassLoader cl = this.getClass().getClassLoader();
                    HashMap _arg0 = data.readHashMap(cl);
                    data.enforceNoDataAvail();
                    this.onEmergencyNumberListChanged(_arg0);
                    break;
                }
                case 27: {
                    EmergencyNumber _arg0 = data.readTypedObject(EmergencyNumber.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onOutgoingEmergencyCall(_arg0, _arg1);
                    break;
                }
                case 28: {
                    EmergencyNumber _arg0 = data.readTypedObject(EmergencyNumber.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onOutgoingEmergencySms(_arg0, _arg1);
                    break;
                }
                case 29: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onCallDisconnectCauseChanged(_arg0, _arg1);
                    break;
                }
                case 30: {
                    ImsReasonInfo _arg0 = data.readTypedObject(ImsReasonInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onImsCallDisconnectCauseChanged(_arg0);
                    break;
                }
                case 31: {
                    CellIdentity _arg0 = data.readTypedObject(CellIdentity.CREATOR);
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRegistrationFailed(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 32: {
                    BarringInfo _arg0 = data.readTypedObject(BarringInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onBarringInfoChanged(_arg0);
                    break;
                }
                case 33: {
                    ArrayList<PhysicalChannelConfig> _arg0 = data.createTypedArrayList(PhysicalChannelConfig.CREATOR);
                    data.enforceNoDataAvail();
                    this.onPhysicalChannelConfigChanged(_arg0);
                    break;
                }
                case 34: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onDataEnabledChanged(_arg0, _arg1);
                    break;
                }
                case 35: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    this.onAllowedNetworkTypesChanged(_arg0, _arg1);
                    break;
                }
                case 36: {
                    ArrayList<LinkCapacityEstimate> _arg0 = data.createTypedArrayList(LinkCapacityEstimate.CREATOR);
                    data.enforceNoDataAvail();
                    this.onLinkCapacityEstimateChanged(_arg0);
                    break;
                }
                case 37: {
                    MediaQualityStatus _arg0 = data.readTypedObject(MediaQualityStatus.CREATOR);
                    data.enforceNoDataAvail();
                    this.onMediaQualityStatusChanged(_arg0);
                    break;
                }
                case 38: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onCallBackModeStarted(_arg0);
                    break;
                }
                case 39: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onCallBackModeStopped(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 38;
        }

        private static class Proxy
        implements IPhoneStateListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onServiceStateChanged(ServiceState serviceState) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(serviceState, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSignalStrengthChanged(int asu) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(asu);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMessageWaitingIndicatorChanged(boolean mwi) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(mwi);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCallForwardingIndicatorChanged(boolean cfi) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(cfi);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCellLocationChanged(CellIdentity location) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(location, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLegacyCallStateChanged(int state, String incomingNumber) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(state);
                    _data.writeString(incomingNumber);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCallStateChanged(int state) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(state);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDataConnectionStateChanged(int state, int networkType) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(state);
                    _data.writeInt(networkType);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDataActivity(int direction) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(direction);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSignalStrengthsChanged(SignalStrength signalStrength) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(signalStrength, 0);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCellInfoChanged(List<CellInfo> cellInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(cellInfo, 0);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPreciseCallStateChanged(PreciseCallState callState) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(callState, 0);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPreciseDataConnectionStateChanged(PreciseDataConnectionState dataConnectionState) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(dataConnectionState, 0);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDataConnectionRealTimeInfoChanged(DataConnectionRealTimeInfo dcRtInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(dcRtInfo, 0);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSrvccStateChanged(int state) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(state);
                    boolean bl = this.mRemote.transact(15, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onVoiceActivationStateChanged(int activationState) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(activationState);
                    boolean bl = this.mRemote.transact(16, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDataActivationStateChanged(int activationState) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(activationState);
                    boolean bl = this.mRemote.transact(17, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onOemHookRawEvent(byte[] rawData) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(rawData);
                    boolean bl = this.mRemote.transact(18, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCarrierNetworkChange(boolean active) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(active);
                    boolean bl = this.mRemote.transact(19, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUserMobileDataStateChanged(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean bl = this.mRemote.transact(20, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDisplayInfoChanged(TelephonyDisplayInfo telephonyDisplayInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(telephonyDisplayInfo, 0);
                    boolean bl = this.mRemote.transact(21, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPhoneCapabilityChanged(PhoneCapability capability) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(capability, 0);
                    boolean bl = this.mRemote.transact(22, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onActiveDataSubIdChanged(int subId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    boolean bl = this.mRemote.transact(23, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRadioPowerStateChanged(int state) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(state);
                    boolean bl = this.mRemote.transact(24, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCallStatesChanged(List<CallState> callStateList) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(callStateList, 0);
                    boolean bl = this.mRemote.transact(25, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEmergencyNumberListChanged(Map emergencyNumberList) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeMap(emergencyNumberList);
                    boolean bl = this.mRemote.transact(26, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onOutgoingEmergencyCall(EmergencyNumber placedEmergencyNumber, int subscriptionId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(placedEmergencyNumber, 0);
                    _data.writeInt(subscriptionId);
                    boolean bl = this.mRemote.transact(27, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onOutgoingEmergencySms(EmergencyNumber sentEmergencyNumber, int subscriptionId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(sentEmergencyNumber, 0);
                    _data.writeInt(subscriptionId);
                    boolean bl = this.mRemote.transact(28, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCallDisconnectCauseChanged(int disconnectCause, int preciseDisconnectCause) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(disconnectCause);
                    _data.writeInt(preciseDisconnectCause);
                    boolean bl = this.mRemote.transact(29, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onImsCallDisconnectCauseChanged(ImsReasonInfo imsReasonInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(imsReasonInfo, 0);
                    boolean bl = this.mRemote.transact(30, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRegistrationFailed(CellIdentity cellIdentity, String chosenPlmn, int domain, int causeCode, int additionalCauseCode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(cellIdentity, 0);
                    _data.writeString(chosenPlmn);
                    _data.writeInt(domain);
                    _data.writeInt(causeCode);
                    _data.writeInt(additionalCauseCode);
                    boolean bl = this.mRemote.transact(31, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBarringInfoChanged(BarringInfo barringInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(barringInfo, 0);
                    boolean bl = this.mRemote.transact(32, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPhysicalChannelConfigChanged(List<PhysicalChannelConfig> configs) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(configs, 0);
                    boolean bl = this.mRemote.transact(33, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDataEnabledChanged(boolean enabled, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    _data.writeInt(reason);
                    boolean bl = this.mRemote.transact(34, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAllowedNetworkTypesChanged(int reason, long allowedNetworkType) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(reason);
                    _data.writeLong(allowedNetworkType);
                    boolean bl = this.mRemote.transact(35, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLinkCapacityEstimateChanged(List<LinkCapacityEstimate> linkCapacityEstimateList) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(linkCapacityEstimateList, 0);
                    boolean bl = this.mRemote.transact(36, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMediaQualityStatusChanged(MediaQualityStatus mediaQualityStatus) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(mediaQualityStatus, 0);
                    boolean bl = this.mRemote.transact(37, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCallBackModeStarted(int type) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(type);
                    boolean bl = this.mRemote.transact(38, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCallBackModeStopped(int type, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(type);
                    _data.writeInt(reason);
                    boolean bl = this.mRemote.transact(39, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IPhoneStateListener {
        @Override
        public void onServiceStateChanged(ServiceState serviceState) throws RemoteException {
        }

        @Override
        public void onSignalStrengthChanged(int asu) throws RemoteException {
        }

        @Override
        public void onMessageWaitingIndicatorChanged(boolean mwi) throws RemoteException {
        }

        @Override
        public void onCallForwardingIndicatorChanged(boolean cfi) throws RemoteException {
        }

        @Override
        public void onCellLocationChanged(CellIdentity location) throws RemoteException {
        }

        @Override
        public void onLegacyCallStateChanged(int state, String incomingNumber) throws RemoteException {
        }

        @Override
        public void onCallStateChanged(int state) throws RemoteException {
        }

        @Override
        public void onDataConnectionStateChanged(int state, int networkType) throws RemoteException {
        }

        @Override
        public void onDataActivity(int direction) throws RemoteException {
        }

        @Override
        public void onSignalStrengthsChanged(SignalStrength signalStrength) throws RemoteException {
        }

        @Override
        public void onCellInfoChanged(List<CellInfo> cellInfo) throws RemoteException {
        }

        @Override
        public void onPreciseCallStateChanged(PreciseCallState callState) throws RemoteException {
        }

        @Override
        public void onPreciseDataConnectionStateChanged(PreciseDataConnectionState dataConnectionState) throws RemoteException {
        }

        @Override
        public void onDataConnectionRealTimeInfoChanged(DataConnectionRealTimeInfo dcRtInfo) throws RemoteException {
        }

        @Override
        public void onSrvccStateChanged(int state) throws RemoteException {
        }

        @Override
        public void onVoiceActivationStateChanged(int activationState) throws RemoteException {
        }

        @Override
        public void onDataActivationStateChanged(int activationState) throws RemoteException {
        }

        @Override
        public void onOemHookRawEvent(byte[] rawData) throws RemoteException {
        }

        @Override
        public void onCarrierNetworkChange(boolean active) throws RemoteException {
        }

        @Override
        public void onUserMobileDataStateChanged(boolean enabled) throws RemoteException {
        }

        @Override
        public void onDisplayInfoChanged(TelephonyDisplayInfo telephonyDisplayInfo) throws RemoteException {
        }

        @Override
        public void onPhoneCapabilityChanged(PhoneCapability capability) throws RemoteException {
        }

        @Override
        public void onActiveDataSubIdChanged(int subId) throws RemoteException {
        }

        @Override
        public void onRadioPowerStateChanged(int state) throws RemoteException {
        }

        @Override
        public void onCallStatesChanged(List<CallState> callStateList) throws RemoteException {
        }

        @Override
        public void onEmergencyNumberListChanged(Map emergencyNumberList) throws RemoteException {
        }

        @Override
        public void onOutgoingEmergencyCall(EmergencyNumber placedEmergencyNumber, int subscriptionId) throws RemoteException {
        }

        @Override
        public void onOutgoingEmergencySms(EmergencyNumber sentEmergencyNumber, int subscriptionId) throws RemoteException {
        }

        @Override
        public void onCallDisconnectCauseChanged(int disconnectCause, int preciseDisconnectCause) throws RemoteException {
        }

        @Override
        public void onImsCallDisconnectCauseChanged(ImsReasonInfo imsReasonInfo) throws RemoteException {
        }

        @Override
        public void onRegistrationFailed(CellIdentity cellIdentity, String chosenPlmn, int domain, int causeCode, int additionalCauseCode) throws RemoteException {
        }

        @Override
        public void onBarringInfoChanged(BarringInfo barringInfo) throws RemoteException {
        }

        @Override
        public void onPhysicalChannelConfigChanged(List<PhysicalChannelConfig> configs) throws RemoteException {
        }

        @Override
        public void onDataEnabledChanged(boolean enabled, int reason) throws RemoteException {
        }

        @Override
        public void onAllowedNetworkTypesChanged(int reason, long allowedNetworkType) throws RemoteException {
        }

        @Override
        public void onLinkCapacityEstimateChanged(List<LinkCapacityEstimate> linkCapacityEstimateList) throws RemoteException {
        }

        @Override
        public void onMediaQualityStatusChanged(MediaQualityStatus mediaQualityStatus) throws RemoteException {
        }

        @Override
        public void onCallBackModeStarted(int type) throws RemoteException {
        }

        @Override
        public void onCallBackModeStopped(int type, int reason) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

