/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.os.UserHandle;
import android.telephony.SubscriptionInfo;
import com.android.internal.telephony.ISetOpportunisticDataCallback;
import java.util.ArrayList;
import java.util.List;

public interface ISub
extends IInterface {
    public List<SubscriptionInfo> getAllSubInfoList(String var1, String var2) throws RemoteException;

    public SubscriptionInfo getActiveSubscriptionInfo(int var1, String var2, String var3) throws RemoteException;

    public SubscriptionInfo getActiveSubscriptionInfoForIccId(String var1, String var2, String var3) throws RemoteException;

    public SubscriptionInfo getActiveSubscriptionInfoForSimSlotIndex(int var1, String var2, String var3) throws RemoteException;

    public List<SubscriptionInfo> getActiveSubscriptionInfoList(String var1, String var2) throws RemoteException;

    public int getActiveSubInfoCount(String var1, String var2) throws RemoteException;

    public int getActiveSubInfoCountMax() throws RemoteException;

    public List<SubscriptionInfo> getAvailableSubscriptionInfoList(String var1, String var2) throws RemoteException;

    public List<SubscriptionInfo> getAccessibleSubscriptionInfoList(String var1) throws RemoteException;

    public void requestEmbeddedSubscriptionInfoListRefresh(int var1) throws RemoteException;

    public int addSubInfo(String var1, String var2, int var3, int var4) throws RemoteException;

    public boolean removeSubInfo(String var1, int var2) throws RemoteException;

    public int setIconTint(int var1, int var2) throws RemoteException;

    public int setDisplayNameUsingSrc(String var1, int var2, int var3) throws RemoteException;

    public int setDisplayNumber(String var1, int var2) throws RemoteException;

    public int setDataRoaming(int var1, int var2) throws RemoteException;

    public int setOpportunistic(boolean var1, int var2, String var3) throws RemoteException;

    public ParcelUuid createSubscriptionGroup(int[] var1, String var2) throws RemoteException;

    public void setPreferredDataSubscriptionId(int var1, boolean var2, ISetOpportunisticDataCallback var3) throws RemoteException;

    public int getPreferredDataSubscriptionId() throws RemoteException;

    public List<SubscriptionInfo> getOpportunisticSubscriptions(String var1, String var2) throws RemoteException;

    public void removeSubscriptionsFromGroup(int[] var1, ParcelUuid var2, String var3) throws RemoteException;

    public void addSubscriptionsIntoGroup(int[] var1, ParcelUuid var2, String var3) throws RemoteException;

    public List<SubscriptionInfo> getSubscriptionsInGroup(ParcelUuid var1, String var2, String var3) throws RemoteException;

    public int getSlotIndex(int var1) throws RemoteException;

    public int getSubId(int var1) throws RemoteException;

    public int getDefaultSubId() throws RemoteException;

    public int getPhoneId(int var1) throws RemoteException;

    public int getDefaultDataSubId() throws RemoteException;

    public void setDefaultDataSubId(int var1) throws RemoteException;

    public int getDefaultVoiceSubId() throws RemoteException;

    public void setDefaultVoiceSubId(int var1) throws RemoteException;

    public int getDefaultSmsSubId() throws RemoteException;

    public void setDefaultSmsSubId(int var1) throws RemoteException;

    public int[] getActiveSubIdList(boolean var1) throws RemoteException;

    public void setSubscriptionProperty(int var1, String var2, String var3) throws RemoteException;

    public String getSubscriptionProperty(int var1, String var2, String var3, String var4) throws RemoteException;

    public boolean isSubscriptionEnabled(int var1) throws RemoteException;

    public int getEnabledSubscriptionId(int var1) throws RemoteException;

    public boolean isActiveSubId(int var1, String var2, String var3) throws RemoteException;

    public int getActiveDataSubscriptionId() throws RemoteException;

    public boolean canDisablePhysicalSubscription() throws RemoteException;

    public void setUiccApplicationsEnabled(boolean var1, int var2) throws RemoteException;

    public int setDeviceToDeviceStatusSharing(int var1, int var2) throws RemoteException;

    public int setDeviceToDeviceStatusSharingContacts(String var1, int var2) throws RemoteException;

    public String getPhoneNumber(int var1, int var2, String var3, String var4) throws RemoteException;

    public String getPhoneNumberFromFirstAvailableSource(int var1, String var2, String var3) throws RemoteException;

    public void setPhoneNumber(int var1, int var2, String var3, String var4, String var5) throws RemoteException;

    public int setUsageSetting(int var1, int var2, String var3) throws RemoteException;

    public int setSubscriptionUserHandle(UserHandle var1, int var2) throws RemoteException;

    public UserHandle getSubscriptionUserHandle(int var1) throws RemoteException;

    public boolean isSubscriptionAssociatedWithUser(int var1, UserHandle var2) throws RemoteException;

    public List<SubscriptionInfo> getSubscriptionInfoListAssociatedWithUser(UserHandle var1) throws RemoteException;

    public void restoreAllSimSpecificSettingsFromBackup(byte[] var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISub {
        public static final String DESCRIPTOR = "com.android.internal.telephony.ISub";
        static final int TRANSACTION_getAllSubInfoList = 1;
        static final int TRANSACTION_getActiveSubscriptionInfo = 2;
        static final int TRANSACTION_getActiveSubscriptionInfoForIccId = 3;
        static final int TRANSACTION_getActiveSubscriptionInfoForSimSlotIndex = 4;
        static final int TRANSACTION_getActiveSubscriptionInfoList = 5;
        static final int TRANSACTION_getActiveSubInfoCount = 6;
        static final int TRANSACTION_getActiveSubInfoCountMax = 7;
        static final int TRANSACTION_getAvailableSubscriptionInfoList = 8;
        static final int TRANSACTION_getAccessibleSubscriptionInfoList = 9;
        static final int TRANSACTION_requestEmbeddedSubscriptionInfoListRefresh = 10;
        static final int TRANSACTION_addSubInfo = 11;
        static final int TRANSACTION_removeSubInfo = 12;
        static final int TRANSACTION_setIconTint = 13;
        static final int TRANSACTION_setDisplayNameUsingSrc = 14;
        static final int TRANSACTION_setDisplayNumber = 15;
        static final int TRANSACTION_setDataRoaming = 16;
        static final int TRANSACTION_setOpportunistic = 17;
        static final int TRANSACTION_createSubscriptionGroup = 18;
        static final int TRANSACTION_setPreferredDataSubscriptionId = 19;
        static final int TRANSACTION_getPreferredDataSubscriptionId = 20;
        static final int TRANSACTION_getOpportunisticSubscriptions = 21;
        static final int TRANSACTION_removeSubscriptionsFromGroup = 22;
        static final int TRANSACTION_addSubscriptionsIntoGroup = 23;
        static final int TRANSACTION_getSubscriptionsInGroup = 24;
        static final int TRANSACTION_getSlotIndex = 25;
        static final int TRANSACTION_getSubId = 26;
        static final int TRANSACTION_getDefaultSubId = 27;
        static final int TRANSACTION_getPhoneId = 28;
        static final int TRANSACTION_getDefaultDataSubId = 29;
        static final int TRANSACTION_setDefaultDataSubId = 30;
        static final int TRANSACTION_getDefaultVoiceSubId = 31;
        static final int TRANSACTION_setDefaultVoiceSubId = 32;
        static final int TRANSACTION_getDefaultSmsSubId = 33;
        static final int TRANSACTION_setDefaultSmsSubId = 34;
        static final int TRANSACTION_getActiveSubIdList = 35;
        static final int TRANSACTION_setSubscriptionProperty = 36;
        static final int TRANSACTION_getSubscriptionProperty = 37;
        static final int TRANSACTION_isSubscriptionEnabled = 38;
        static final int TRANSACTION_getEnabledSubscriptionId = 39;
        static final int TRANSACTION_isActiveSubId = 40;
        static final int TRANSACTION_getActiveDataSubscriptionId = 41;
        static final int TRANSACTION_canDisablePhysicalSubscription = 42;
        static final int TRANSACTION_setUiccApplicationsEnabled = 43;
        static final int TRANSACTION_setDeviceToDeviceStatusSharing = 44;
        static final int TRANSACTION_setDeviceToDeviceStatusSharingContacts = 45;
        static final int TRANSACTION_getPhoneNumber = 46;
        static final int TRANSACTION_getPhoneNumberFromFirstAvailableSource = 47;
        static final int TRANSACTION_setPhoneNumber = 48;
        static final int TRANSACTION_setUsageSetting = 49;
        static final int TRANSACTION_setSubscriptionUserHandle = 50;
        static final int TRANSACTION_getSubscriptionUserHandle = 51;
        static final int TRANSACTION_isSubscriptionAssociatedWithUser = 52;
        static final int TRANSACTION_getSubscriptionInfoListAssociatedWithUser = 53;
        static final int TRANSACTION_restoreAllSimSpecificSettingsFromBackup = 54;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ISub asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ISub) {
                return (ISub)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getAllSubInfoList";
                }
                case 2: {
                    return "getActiveSubscriptionInfo";
                }
                case 3: {
                    return "getActiveSubscriptionInfoForIccId";
                }
                case 4: {
                    return "getActiveSubscriptionInfoForSimSlotIndex";
                }
                case 5: {
                    return "getActiveSubscriptionInfoList";
                }
                case 6: {
                    return "getActiveSubInfoCount";
                }
                case 7: {
                    return "getActiveSubInfoCountMax";
                }
                case 8: {
                    return "getAvailableSubscriptionInfoList";
                }
                case 9: {
                    return "getAccessibleSubscriptionInfoList";
                }
                case 10: {
                    return "requestEmbeddedSubscriptionInfoListRefresh";
                }
                case 11: {
                    return "addSubInfo";
                }
                case 12: {
                    return "removeSubInfo";
                }
                case 13: {
                    return "setIconTint";
                }
                case 14: {
                    return "setDisplayNameUsingSrc";
                }
                case 15: {
                    return "setDisplayNumber";
                }
                case 16: {
                    return "setDataRoaming";
                }
                case 17: {
                    return "setOpportunistic";
                }
                case 18: {
                    return "createSubscriptionGroup";
                }
                case 19: {
                    return "setPreferredDataSubscriptionId";
                }
                case 20: {
                    return "getPreferredDataSubscriptionId";
                }
                case 21: {
                    return "getOpportunisticSubscriptions";
                }
                case 22: {
                    return "removeSubscriptionsFromGroup";
                }
                case 23: {
                    return "addSubscriptionsIntoGroup";
                }
                case 24: {
                    return "getSubscriptionsInGroup";
                }
                case 25: {
                    return "getSlotIndex";
                }
                case 26: {
                    return "getSubId";
                }
                case 27: {
                    return "getDefaultSubId";
                }
                case 28: {
                    return "getPhoneId";
                }
                case 29: {
                    return "getDefaultDataSubId";
                }
                case 30: {
                    return "setDefaultDataSubId";
                }
                case 31: {
                    return "getDefaultVoiceSubId";
                }
                case 32: {
                    return "setDefaultVoiceSubId";
                }
                case 33: {
                    return "getDefaultSmsSubId";
                }
                case 34: {
                    return "setDefaultSmsSubId";
                }
                case 35: {
                    return "getActiveSubIdList";
                }
                case 36: {
                    return "setSubscriptionProperty";
                }
                case 37: {
                    return "getSubscriptionProperty";
                }
                case 38: {
                    return "isSubscriptionEnabled";
                }
                case 39: {
                    return "getEnabledSubscriptionId";
                }
                case 40: {
                    return "isActiveSubId";
                }
                case 41: {
                    return "getActiveDataSubscriptionId";
                }
                case 42: {
                    return "canDisablePhysicalSubscription";
                }
                case 43: {
                    return "setUiccApplicationsEnabled";
                }
                case 44: {
                    return "setDeviceToDeviceStatusSharing";
                }
                case 45: {
                    return "setDeviceToDeviceStatusSharingContacts";
                }
                case 46: {
                    return "getPhoneNumber";
                }
                case 47: {
                    return "getPhoneNumberFromFirstAvailableSource";
                }
                case 48: {
                    return "setPhoneNumber";
                }
                case 49: {
                    return "setUsageSetting";
                }
                case 50: {
                    return "setSubscriptionUserHandle";
                }
                case 51: {
                    return "getSubscriptionUserHandle";
                }
                case 52: {
                    return "isSubscriptionAssociatedWithUser";
                }
                case 53: {
                    return "getSubscriptionInfoListAssociatedWithUser";
                }
                case 54: {
                    return "restoreAllSimSpecificSettingsFromBackup";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    List<SubscriptionInfo> _result = this.getAllSubInfoList(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    SubscriptionInfo _result = this.getActiveSubscriptionInfo(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    SubscriptionInfo _result = this.getActiveSubscriptionInfoForIccId(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    SubscriptionInfo _result = this.getActiveSubscriptionInfoForSimSlotIndex(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    List<SubscriptionInfo> _result = this.getActiveSubscriptionInfoList(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.getActiveSubInfoCount(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 7: {
                    int _result = this.getActiveSubInfoCountMax();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    List<SubscriptionInfo> _result = this.getAvailableSubscriptionInfoList(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    List<SubscriptionInfo> _result = this.getAccessibleSubscriptionInfoList(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.requestEmbeddedSubscriptionInfoListRefresh(_arg0);
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.addSubInfo(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 12: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.removeSubInfo(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.setIconTint(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 14: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.setDisplayNameUsingSrc(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 15: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.setDisplayNumber(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 16: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.setDataRoaming(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 17: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.setOpportunistic(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 18: {
                    int[] _arg0 = data.createIntArray();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    ParcelUuid _result = this.createSubscriptionGroup(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 19: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    ISetOpportunisticDataCallback _arg2 = ISetOpportunisticDataCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setPreferredDataSubscriptionId(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    int _result = this.getPreferredDataSubscriptionId();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 21: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    List<SubscriptionInfo> _result = this.getOpportunisticSubscriptions(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 22: {
                    int[] _arg0 = data.createIntArray();
                    ParcelUuid _arg1 = data.readTypedObject(ParcelUuid.CREATOR);
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.removeSubscriptionsFromGroup(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    int[] _arg0 = data.createIntArray();
                    ParcelUuid _arg1 = data.readTypedObject(ParcelUuid.CREATOR);
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.addSubscriptionsIntoGroup(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    ParcelUuid _arg0 = data.readTypedObject(ParcelUuid.CREATOR);
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    List<SubscriptionInfo> _result = this.getSubscriptionsInGroup(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 25: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getSlotIndex(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 26: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getSubId(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 27: {
                    int _result = this.getDefaultSubId();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 28: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getPhoneId(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 29: {
                    int _result = this.getDefaultDataSubId();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 30: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setDefaultDataSubId(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 31: {
                    int _result = this.getDefaultVoiceSubId();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 32: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setDefaultVoiceSubId(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 33: {
                    int _result = this.getDefaultSmsSubId();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 34: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setDefaultSmsSubId(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 35: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    int[] _result = this.getActiveSubIdList(_arg0);
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 36: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.setSubscriptionProperty(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 37: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    String _result = this.getSubscriptionProperty(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 38: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isSubscriptionEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 39: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getEnabledSubscriptionId(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 40: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isActiveSubId(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 41: {
                    int _result = this.getActiveDataSubscriptionId();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 42: {
                    boolean _result = this.canDisablePhysicalSubscription();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 43: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setUiccApplicationsEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 44: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.setDeviceToDeviceStatusSharing(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 45: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.setDeviceToDeviceStatusSharingContacts(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 46: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    String _result = this.getPhoneNumber(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 47: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    String _result = this.getPhoneNumberFromFirstAvailableSource(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 48: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    data.enforceNoDataAvail();
                    this.setPhoneNumber(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 49: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.setUsageSetting(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 50: {
                    UserHandle _arg0 = data.readTypedObject(UserHandle.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.setSubscriptionUserHandle(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 51: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    UserHandle _result = this.getSubscriptionUserHandle(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 52: {
                    int _arg0 = data.readInt();
                    UserHandle _arg1 = data.readTypedObject(UserHandle.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.isSubscriptionAssociatedWithUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 53: {
                    UserHandle _arg0 = data.readTypedObject(UserHandle.CREATOR);
                    data.enforceNoDataAvail();
                    List<SubscriptionInfo> _result = this.getSubscriptionInfoListAssociatedWithUser(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 54: {
                    byte[] _arg0 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.restoreAllSimSpecificSettingsFromBackup(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 53;
        }

        private static class Proxy
        implements ISub {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SubscriptionInfo> getAllSubInfoList(String callingPackage, String callingFeatureId) throws RemoteException {
                ArrayList<SubscriptionInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(SubscriptionInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SubscriptionInfo getActiveSubscriptionInfo(int subId, String callingPackage, String callingFeatureId) throws RemoteException {
                SubscriptionInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SubscriptionInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SubscriptionInfo getActiveSubscriptionInfoForIccId(String iccId, String callingPackage, String callingFeatureId) throws RemoteException {
                SubscriptionInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(iccId);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SubscriptionInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SubscriptionInfo getActiveSubscriptionInfoForSimSlotIndex(int slotIndex, String callingPackage, String callingFeatureId) throws RemoteException {
                SubscriptionInfo _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(slotIndex);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SubscriptionInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SubscriptionInfo> getActiveSubscriptionInfoList(String callingPackage, String callingFeatureId) throws RemoteException {
                ArrayList<SubscriptionInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(SubscriptionInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getActiveSubInfoCount(String callingPackage, String callingFeatureId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getActiveSubInfoCountMax() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SubscriptionInfo> getAvailableSubscriptionInfoList(String callingPackage, String callingFeatureId) throws RemoteException {
                ArrayList<SubscriptionInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(SubscriptionInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SubscriptionInfo> getAccessibleSubscriptionInfoList(String callingPackage) throws RemoteException {
                ArrayList<SubscriptionInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(SubscriptionInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestEmbeddedSubscriptionInfoListRefresh(int cardId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(cardId);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int addSubInfo(String uniqueId, String displayName, int slotIndex, int subscriptionType) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(uniqueId);
                    _data.writeString(displayName);
                    _data.writeInt(slotIndex);
                    _data.writeInt(subscriptionType);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removeSubInfo(String uniqueId, int subscriptionType) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(uniqueId);
                    _data.writeInt(subscriptionType);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setIconTint(int subId, int tint) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeInt(tint);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setDisplayNameUsingSrc(String displayName, int subId, int nameSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(displayName);
                    _data.writeInt(subId);
                    _data.writeInt(nameSource);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setDisplayNumber(String number, int subId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(number);
                    _data.writeInt(subId);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setDataRoaming(int roaming, int subId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(roaming);
                    _data.writeInt(subId);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setOpportunistic(boolean opportunistic, int subId, String callingPackage) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(opportunistic);
                    _data.writeInt(subId);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelUuid createSubscriptionGroup(int[] subIdList, String callingPackage) throws RemoteException {
                ParcelUuid _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(subIdList);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParcelUuid.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPreferredDataSubscriptionId(int subId, boolean needValidation, ISetOpportunisticDataCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeBoolean(needValidation);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getPreferredDataSubscriptionId() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SubscriptionInfo> getOpportunisticSubscriptions(String callingPackage, String callingFeatureId) throws RemoteException {
                ArrayList<SubscriptionInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(SubscriptionInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeSubscriptionsFromGroup(int[] subIdList, ParcelUuid groupUuid, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(subIdList);
                    _data.writeTypedObject(groupUuid, 0);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addSubscriptionsIntoGroup(int[] subIdList, ParcelUuid groupUuid, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(subIdList);
                    _data.writeTypedObject(groupUuid, 0);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SubscriptionInfo> getSubscriptionsInGroup(ParcelUuid groupUuid, String callingPackage, String callingFeatureId) throws RemoteException {
                ArrayList<SubscriptionInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(groupUuid, 0);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(SubscriptionInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getSlotIndex(int subId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getSubId(int slotIndex) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(slotIndex);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDefaultSubId() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getPhoneId(int subId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDefaultDataSubId() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDefaultDataSubId(int subId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDefaultVoiceSubId() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDefaultVoiceSubId(int subId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDefaultSmsSubId() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDefaultSmsSubId(int subId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getActiveSubIdList(boolean visibleOnly) throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(visibleOnly);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSubscriptionProperty(int subId, String propKey, String propValue) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeString(propKey);
                    _data.writeString(propValue);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getSubscriptionProperty(int subId, String propKey, String callingPackage, String callingFeatureId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeString(propKey);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSubscriptionEnabled(int subId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getEnabledSubscriptionId(int slotIndex) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(slotIndex);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isActiveSubId(int subId, String callingPackage, String callingFeatureId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getActiveDataSubscriptionId() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean canDisablePhysicalSubscription() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUiccApplicationsEnabled(boolean enabled, int subscriptionId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    _data.writeInt(subscriptionId);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setDeviceToDeviceStatusSharing(int sharing, int subId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sharing);
                    _data.writeInt(subId);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setDeviceToDeviceStatusSharingContacts(String contacts, int subscriptionId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(contacts);
                    _data.writeInt(subscriptionId);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getPhoneNumber(int subId, int source, String callingPackage, String callingFeatureId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeInt(source);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getPhoneNumberFromFirstAvailableSource(int subId, String callingPackage, String callingFeatureId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPhoneNumber(int subId, int source, String number, String callingPackage, String callingFeatureId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    _data.writeInt(source);
                    _data.writeString(number);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setUsageSetting(int usageSetting, int subId, String callingPackage) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(usageSetting);
                    _data.writeInt(subId);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setSubscriptionUserHandle(UserHandle userHandle, int subId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(userHandle, 0);
                    _data.writeInt(subId);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public UserHandle getSubscriptionUserHandle(int subId) throws RemoteException {
                UserHandle _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(UserHandle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSubscriptionAssociatedWithUser(int subscriptionId, UserHandle userHandle) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subscriptionId);
                    _data.writeTypedObject(userHandle, 0);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SubscriptionInfo> getSubscriptionInfoListAssociatedWithUser(UserHandle userHandle) throws RemoteException {
                ArrayList<SubscriptionInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(userHandle, 0);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(SubscriptionInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void restoreAllSimSpecificSettingsFromBackup(byte[] data) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(data);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISub {
        @Override
        public List<SubscriptionInfo> getAllSubInfoList(String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public SubscriptionInfo getActiveSubscriptionInfo(int subId, String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public SubscriptionInfo getActiveSubscriptionInfoForIccId(String iccId, String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public SubscriptionInfo getActiveSubscriptionInfoForSimSlotIndex(int slotIndex, String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public List<SubscriptionInfo> getActiveSubscriptionInfoList(String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public int getActiveSubInfoCount(String callingPackage, String callingFeatureId) throws RemoteException {
            return 0;
        }

        @Override
        public int getActiveSubInfoCountMax() throws RemoteException {
            return 0;
        }

        @Override
        public List<SubscriptionInfo> getAvailableSubscriptionInfoList(String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public List<SubscriptionInfo> getAccessibleSubscriptionInfoList(String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public void requestEmbeddedSubscriptionInfoListRefresh(int cardId) throws RemoteException {
        }

        @Override
        public int addSubInfo(String uniqueId, String displayName, int slotIndex, int subscriptionType) throws RemoteException {
            return 0;
        }

        @Override
        public boolean removeSubInfo(String uniqueId, int subscriptionType) throws RemoteException {
            return false;
        }

        @Override
        public int setIconTint(int subId, int tint) throws RemoteException {
            return 0;
        }

        @Override
        public int setDisplayNameUsingSrc(String displayName, int subId, int nameSource) throws RemoteException {
            return 0;
        }

        @Override
        public int setDisplayNumber(String number, int subId) throws RemoteException {
            return 0;
        }

        @Override
        public int setDataRoaming(int roaming, int subId) throws RemoteException {
            return 0;
        }

        @Override
        public int setOpportunistic(boolean opportunistic, int subId, String callingPackage) throws RemoteException {
            return 0;
        }

        @Override
        public ParcelUuid createSubscriptionGroup(int[] subIdList, String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public void setPreferredDataSubscriptionId(int subId, boolean needValidation, ISetOpportunisticDataCallback callback) throws RemoteException {
        }

        @Override
        public int getPreferredDataSubscriptionId() throws RemoteException {
            return 0;
        }

        @Override
        public List<SubscriptionInfo> getOpportunisticSubscriptions(String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public void removeSubscriptionsFromGroup(int[] subIdList, ParcelUuid groupUuid, String callingPackage) throws RemoteException {
        }

        @Override
        public void addSubscriptionsIntoGroup(int[] subIdList, ParcelUuid groupUuid, String callingPackage) throws RemoteException {
        }

        @Override
        public List<SubscriptionInfo> getSubscriptionsInGroup(ParcelUuid groupUuid, String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public int getSlotIndex(int subId) throws RemoteException {
            return 0;
        }

        @Override
        public int getSubId(int slotIndex) throws RemoteException {
            return 0;
        }

        @Override
        public int getDefaultSubId() throws RemoteException {
            return 0;
        }

        @Override
        public int getPhoneId(int subId) throws RemoteException {
            return 0;
        }

        @Override
        public int getDefaultDataSubId() throws RemoteException {
            return 0;
        }

        @Override
        public void setDefaultDataSubId(int subId) throws RemoteException {
        }

        @Override
        public int getDefaultVoiceSubId() throws RemoteException {
            return 0;
        }

        @Override
        public void setDefaultVoiceSubId(int subId) throws RemoteException {
        }

        @Override
        public int getDefaultSmsSubId() throws RemoteException {
            return 0;
        }

        @Override
        public void setDefaultSmsSubId(int subId) throws RemoteException {
        }

        @Override
        public int[] getActiveSubIdList(boolean visibleOnly) throws RemoteException {
            return null;
        }

        @Override
        public void setSubscriptionProperty(int subId, String propKey, String propValue) throws RemoteException {
        }

        @Override
        public String getSubscriptionProperty(int subId, String propKey, String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public boolean isSubscriptionEnabled(int subId) throws RemoteException {
            return false;
        }

        @Override
        public int getEnabledSubscriptionId(int slotIndex) throws RemoteException {
            return 0;
        }

        @Override
        public boolean isActiveSubId(int subId, String callingPackage, String callingFeatureId) throws RemoteException {
            return false;
        }

        @Override
        public int getActiveDataSubscriptionId() throws RemoteException {
            return 0;
        }

        @Override
        public boolean canDisablePhysicalSubscription() throws RemoteException {
            return false;
        }

        @Override
        public void setUiccApplicationsEnabled(boolean enabled, int subscriptionId) throws RemoteException {
        }

        @Override
        public int setDeviceToDeviceStatusSharing(int sharing, int subId) throws RemoteException {
            return 0;
        }

        @Override
        public int setDeviceToDeviceStatusSharingContacts(String contacts, int subscriptionId) throws RemoteException {
            return 0;
        }

        @Override
        public String getPhoneNumber(int subId, int source, String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public String getPhoneNumberFromFirstAvailableSource(int subId, String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public void setPhoneNumber(int subId, int source, String number, String callingPackage, String callingFeatureId) throws RemoteException {
        }

        @Override
        public int setUsageSetting(int usageSetting, int subId, String callingPackage) throws RemoteException {
            return 0;
        }

        @Override
        public int setSubscriptionUserHandle(UserHandle userHandle, int subId) throws RemoteException {
            return 0;
        }

        @Override
        public UserHandle getSubscriptionUserHandle(int subId) throws RemoteException {
            return null;
        }

        @Override
        public boolean isSubscriptionAssociatedWithUser(int subscriptionId, UserHandle userHandle) throws RemoteException {
            return false;
        }

        @Override
        public List<SubscriptionInfo> getSubscriptionInfoListAssociatedWithUser(UserHandle userHandle) throws RemoteException {
            return null;
        }

        @Override
        public void restoreAllSimSpecificSettingsFromBackup(byte[] data) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

