/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.util;

import android.app.ActivityManager;
import android.app.role.RoleManager;
import android.content.Context;
import android.content.pm.ComponentInfo;
import android.content.pm.ResolveInfo;
import android.os.Binder;
import android.os.Bundle;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.os._Original_Build;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyFrameworkInitializer;
import android.util.Log;
import com.android.internal.telephony.ITelephony;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class TelephonyUtils {
    private static final String LOG_TAG = "TelephonyUtils";
    public static boolean IS_USER = "user".equals(_Original_Build.TYPE);
    public static boolean IS_DEBUGGABLE = SystemProperties.getInt("ro.debuggable", 0) == 1;
    public static final Executor DIRECT_EXECUTOR = Runnable::run;

    public static boolean checkDumpPermission(Context context, String tag, PrintWriter pw) {
        if (context.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump " + tag + " from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " due to missing android.permission.DUMP permission");
            return false;
        }
        return true;
    }

    public static String emptyIfNull(String str) {
        return str == null ? "" : str;
    }

    public static <T> List<T> emptyIfNull(List<T> cur) {
        return cur == null ? Collections.emptyList() : cur;
    }

    public static ComponentInfo getComponentInfo(ResolveInfo resolveInfo) {
        if (resolveInfo.activityInfo != null) {
            return resolveInfo.activityInfo;
        }
        if (resolveInfo.serviceInfo != null) {
            return resolveInfo.serviceInfo;
        }
        if (resolveInfo.providerInfo != null) {
            return resolveInfo.providerInfo;
        }
        throw new IllegalStateException("Missing ComponentInfo!");
    }

    public static void runWithCleanCallingIdentity(Runnable action) {
        long callingIdentity = Binder.clearCallingIdentity();
        try {
            action.run();
        }
        finally {
            Binder.restoreCallingIdentity(callingIdentity);
        }
    }

    public static void runWithCleanCallingIdentity(Runnable action, Executor executor) {
        if (action != null) {
            if (executor != null) {
                executor.execute(() -> TelephonyUtils.runWithCleanCallingIdentity(action));
            } else {
                TelephonyUtils.runWithCleanCallingIdentity(action);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runWithCleanCallingIdentity(Supplier<T> action) {
        long callingIdentity = Binder.clearCallingIdentity();
        try {
            T t = action.get();
            return t;
        }
        finally {
            Binder.restoreCallingIdentity(callingIdentity);
        }
    }

    public static Bundle filterValues(Bundle bundle) {
        Bundle ret = new Bundle(bundle);
        for (String key : bundle.keySet()) {
            Object value = bundle.get(key);
            if (value instanceof Integer || value instanceof Long || value instanceof Double || value instanceof String || value instanceof int[] || value instanceof long[] || value instanceof double[] || value instanceof String[] || value instanceof PersistableBundle || value == null || value instanceof Boolean || value instanceof boolean[]) continue;
            if (value instanceof Bundle) {
                ret.putBundle(key, TelephonyUtils.filterValues((Bundle)value));
                continue;
            }
            if (value.getClass().getName().startsWith("android.")) continue;
            ret.remove(key);
        }
        return ret;
    }

    public static void waitUntilReady(CountDownLatch latch, long timeoutMs) {
        try {
            latch.await(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String dataStateToString(int state) {
        switch (state) {
            case 0: {
                return "DISCONNECTED";
            }
            case 1: {
                return "CONNECTING";
            }
            case 2: {
                return "CONNECTED";
            }
            case 3: {
                return "SUSPENDED";
            }
            case 4: {
                return "DISCONNECTING";
            }
            case 5: {
                return "HANDOVERINPROGRESS";
            }
            case -1: {
                return "UNKNOWN";
            }
        }
        return "UNKNOWN(" + state + ")";
    }

    public static String mobileDataPolicyToString(int mobileDataPolicy) {
        switch (mobileDataPolicy) {
            case 1: {
                return "DATA_ON_NON_DEFAULT_DURING_VOICE_CALL";
            }
            case 2: {
                return "MMS_ALWAYS_ALLOWED";
            }
            case 3: {
                return "AUTO_DATA_SWITCH";
            }
        }
        return "UNKNOWN(" + mobileDataPolicy + ")";
    }

    public static UserHandle getSubscriptionUserHandle(Context context, int subId) {
        UserHandle userHandle = null;
        SubscriptionManager subManager = context.getSystemService(SubscriptionManager.class);
        if (subManager != null && SubscriptionManager.isValidSubscriptionId(subId)) {
            userHandle = subManager.getSubscriptionUserHandle(subId);
        }
        return userHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showSwitchToManagedProfileDialogIfAppropriate(Context context, int subId, int callingUid, String callingPackage) {
        long token = Binder.clearCallingIdentity();
        try {
            ITelephony iTelephony;
            UserHandle callingUserHandle = UserHandle.getUserHandleForUid(callingUid);
            if (!TelephonyUtils.isUidForeground(context, callingUid) || !TelephonyUtils.isPackageSMSRoleHolderForUser(context, callingPackage, callingUserHandle)) {
                return;
            }
            SubscriptionManager subscriptionManager = context.getSystemService(SubscriptionManager.class);
            UserHandle associatedUserHandle = subscriptionManager.getSubscriptionUserHandle(subId);
            UserManager um = context.getSystemService(UserManager.class);
            if (associatedUserHandle != null && um.isManagedProfile(associatedUserHandle.getIdentifier()) && (iTelephony = ITelephony.Stub.asInterface(TelephonyFrameworkInitializer.getTelephonyServiceManager().getTelephonyServiceRegisterer().get())) != null) {
                try {
                    iTelephony.showSwitchToManagedProfileDialog();
                }
                catch (RemoteException e) {
                    Log.e(LOG_TAG, "Failed to launch switch to managed profile dialog.");
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private static boolean isUidForeground(Context context, int uid) {
        ActivityManager am = context.getSystemService(ActivityManager.class);
        boolean result = am != null && am.getUidImportance(uid) == 100;
        return result;
    }

    private static boolean isPackageSMSRoleHolderForUser(Context context, String callingPackage, UserHandle user) {
        RoleManager roleManager = context.getSystemService(RoleManager.class);
        List<String> smsRoleHolder = roleManager.getRoleHoldersAsUser("android.app.role.SMS", user);
        return !smsRoleHolder.isEmpty() && callingPackage.equals(smsRoleHolder.get(0));
    }
}

