/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.annotation.RequiresPermission;
import android.app.ActivityThread;
import android.app.Application;
import android.content.Context;
import android.os.SystemClock;
import android.os.Trace;
import android.os._Original_Build;
import android.provider.DeviceConfig;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.FrameworkStatsLog;
import com.android.internal.util.PerfettoTrigger;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;

public class LatencyTracker {
    private static final String TAG = "LatencyTracker";
    public static final String SETTINGS_ENABLED_KEY = "enabled";
    private static final String SETTINGS_SAMPLING_INTERVAL_KEY = "sampling_interval";
    private static final boolean DEBUG = false;
    private static final boolean DEFAULT_ENABLED = _Original_Build.IS_DEBUGGABLE;
    private static final int DEFAULT_SAMPLING_INTERVAL = 5;
    public static final int ACTION_EXPAND_PANEL = 0;
    public static final int ACTION_TOGGLE_RECENTS = 1;
    public static final int ACTION_FINGERPRINT_WAKE_AND_UNLOCK = 2;
    public static final int ACTION_CHECK_CREDENTIAL = 3;
    public static final int ACTION_CHECK_CREDENTIAL_UNLOCKED = 4;
    public static final int ACTION_TURN_ON_SCREEN = 5;
    public static final int ACTION_ROTATE_SCREEN = 6;
    public static final int ACTION_FACE_WAKE_AND_UNLOCK = 7;
    public static final int ACTION_START_RECENTS_ANIMATION = 8;
    public static final int ACTION_ROTATE_SCREEN_CAMERA_CHECK = 9;
    public static final int ACTION_ROTATE_SCREEN_SENSOR = 10;
    public static final int ACTION_LOCKSCREEN_UNLOCK = 11;
    public static final int ACTION_USER_SWITCH = 12;
    public static final int ACTION_SWITCH_DISPLAY_UNFOLD = 13;
    public static final int ACTION_UDFPS_ILLUMINATE = 14;
    public static final int ACTION_SHOW_BACK_ARROW = 15;
    public static final int ACTION_LOAD_SHARE_SHEET = 16;
    public static final int ACTION_SHOW_SELECTION_TOOLBAR = 17;
    public static final int ACTION_FOLD_TO_AOD = 18;
    public static final int ACTION_SHOW_VOICE_INTERACTION = 19;
    public static final int ACTION_REQUEST_IME_SHOWN = 20;
    public static final int ACTION_REQUEST_IME_HIDDEN = 21;
    public static final int ACTION_SMARTSPACE_DOORBELL = 22;
    private static final int[] ACTIONS_ALL = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22};
    @VisibleForTesting
    public static final int[] STATSD_ACTION = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private final SparseArray<Session> mSessions = new SparseArray();
    @GuardedBy(value={"mLock"})
    private final SparseArray<ActionProperties> mActionPropertiesMap = new SparseArray();
    @GuardedBy(value={"mLock"})
    private boolean mEnabled;
    private final DeviceConfig.OnPropertiesChangedListener mOnPropertiesChangedListener = this::updateProperties;

    public static LatencyTracker getInstance(Context context) {
        return SLatencyTrackerHolder.sLatencyTracker;
    }

    @RequiresPermission(value="android.permission.READ_DEVICE_CONFIG")
    @VisibleForTesting
    public LatencyTracker() {
        this.mEnabled = DEFAULT_ENABLED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProperties(DeviceConfig.Properties properties) {
        Object object = this.mLock;
        synchronized (object) {
            int samplingInterval = properties.getInt(SETTINGS_SAMPLING_INTERVAL_KEY, 5);
            this.mEnabled = properties.getBoolean(SETTINGS_ENABLED_KEY, DEFAULT_ENABLED);
            for (int action : ACTIONS_ALL) {
                String actionName = LatencyTracker.getNameOfAction(STATSD_ACTION[action]).toLowerCase(Locale.ROOT);
                int legacyActionTraceThreshold = properties.getInt(actionName + "", -1);
                this.mActionPropertiesMap.put(action, new ActionProperties(action, properties.getBoolean(actionName + "_enable", this.mEnabled), properties.getInt(actionName + "_sample_interval", samplingInterval), properties.getInt(actionName + "_trace_threshold", legacyActionTraceThreshold)));
            }
            this.onDeviceConfigPropertiesUpdated(this.mActionPropertiesMap);
        }
    }

    @VisibleForTesting
    @RequiresPermission(value="android.permission.READ_DEVICE_CONFIG")
    public void startListeningForLatencyTrackerConfigChanges() {
        Application context = ActivityThread.currentApplication();
        if (context == null) {
            return;
        }
        if (((Context)context).checkCallingOrSelfPermission("android.permission.READ_DEVICE_CONFIG") != 0) {
            return;
        }
        BackgroundThread.getHandler().post(() -> {
            try {
                this.updateProperties(DeviceConfig.getProperties("latency_tracker", new String[0]));
                DeviceConfig.addOnPropertiesChangedListener("latency_tracker", BackgroundThread.getExecutor(), this.mOnPropertiesChangedListener);
            }
            catch (SecurityException ex) {
                Log.d(TAG, "Can't get properties: READ_DEVICE_CONFIG granted=" + context.checkCallingOrSelfPermission("android.permission.READ_DEVICE_CONFIG") + ", package=" + context.getPackageName());
            }
        });
    }

    @VisibleForTesting
    public void stopListeningForLatencyTrackerConfigChanges() {
        DeviceConfig.removeOnPropertiesChangedListener(this.mOnPropertiesChangedListener);
    }

    public static String getNameOfAction(int atomsProtoAction) {
        switch (atomsProtoAction) {
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "ACTION_EXPAND_PANEL";
            }
            case 2: {
                return "ACTION_TOGGLE_RECENTS";
            }
            case 3: {
                return "ACTION_FINGERPRINT_WAKE_AND_UNLOCK";
            }
            case 4: {
                return "ACTION_CHECK_CREDENTIAL";
            }
            case 5: {
                return "ACTION_CHECK_CREDENTIAL_UNLOCKED";
            }
            case 6: {
                return "ACTION_TURN_ON_SCREEN";
            }
            case 7: {
                return "ACTION_ROTATE_SCREEN";
            }
            case 8: {
                return "ACTION_FACE_WAKE_AND_UNLOCK";
            }
            case 9: {
                return "ACTION_START_RECENTS_ANIMATION";
            }
            case 10: {
                return "ACTION_ROTATE_SCREEN_CAMERA_CHECK";
            }
            case 11: {
                return "ACTION_ROTATE_SCREEN_SENSOR";
            }
            case 12: {
                return "ACTION_LOCKSCREEN_UNLOCK";
            }
            case 13: {
                return "ACTION_USER_SWITCH";
            }
            case 14: {
                return "ACTION_SWITCH_DISPLAY_UNFOLD";
            }
            case 15: {
                return "ACTION_UDFPS_ILLUMINATE";
            }
            case 16: {
                return "ACTION_SHOW_BACK_ARROW";
            }
            case 17: {
                return "ACTION_LOAD_SHARE_SHEET";
            }
            case 18: {
                return "ACTION_SHOW_SELECTION_TOOLBAR";
            }
            case 19: {
                return "ACTION_FOLD_TO_AOD";
            }
            case 20: {
                return "ACTION_SHOW_VOICE_INTERACTION";
            }
            case 21: {
                return "ACTION_REQUEST_IME_SHOWN";
            }
            case 22: {
                return "ACTION_REQUEST_IME_HIDDEN";
            }
            case 23: {
                return "ACTION_SMARTSPACE_DOORBELL";
            }
        }
        throw new IllegalArgumentException("Invalid action");
    }

    private static String getTraceNameOfAction(int action, String tag) {
        if (TextUtils.isEmpty(tag)) {
            return "L<" + LatencyTracker.getNameOfAction(STATSD_ACTION[action]) + ">";
        }
        return "L<" + LatencyTracker.getNameOfAction(STATSD_ACTION[action]) + "::" + tag + ">";
    }

    private static String getTraceTriggerNameForAction(int action) {
        return "com.android.telemetry.latency-tracker-" + LatencyTracker.getNameOfAction(STATSD_ACTION[action]);
    }

    @Deprecated
    public static boolean isEnabled(Context ctx) {
        return LatencyTracker.getInstance(ctx).isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean isEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mEnabled;
        }
    }

    public static boolean isEnabled(Context ctx, int action) {
        return LatencyTracker.getInstance(ctx).isEnabled(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled(int action) {
        Object object = this.mLock;
        synchronized (object) {
            ActionProperties actionProperties = this.mActionPropertiesMap.get(action);
            if (actionProperties != null) {
                return actionProperties.isEnabled();
            }
            return false;
        }
    }

    public void onActionStart(int action) {
        this.onActionStart(action, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActionStart(int action, String tag) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isEnabled(action)) {
                return;
            }
            if (this.mSessions.get(action) != null) {
                return;
            }
            Session session = new Session(action, tag);
            session.begin(() -> this.onActionCancel(action));
            this.mSessions.put(action, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActionEnd(int action) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isEnabled(action)) {
                return;
            }
            Session session = this.mSessions.get(action);
            if (session == null) {
                return;
            }
            session.end();
            this.mSessions.delete(action);
            this.logAction(action, session.duration());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActionCancel(int action) {
        Object object = this.mLock;
        synchronized (object) {
            Session session = this.mSessions.get(action);
            if (session == null) {
                return;
            }
            session.cancel();
            this.mSessions.delete(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public long getActiveActionStartTime(int action) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSessions.contains(action)) {
                return this.mSessions.get((int)action).mStartRtc;
            }
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logAction(int action, int duration) {
        int traceThreshold;
        boolean shouldSample;
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isEnabled(action)) {
                return;
            }
            ActionProperties actionProperties = this.mActionPropertiesMap.get(action);
            if (actionProperties == null) {
                return;
            }
            int nextRandNum = ThreadLocalRandom.current().nextInt(actionProperties.getSamplingInterval());
            shouldSample = nextRandNum == 0;
            traceThreshold = actionProperties.getTraceThreshold();
        }
        boolean shouldTriggerPerfettoTrace = traceThreshold > 0 && duration >= traceThreshold;
        EventLog.writeEvent(36070, action, duration);
        if (shouldTriggerPerfettoTrace) {
            this.onTriggerPerfetto(LatencyTracker.getTraceTriggerNameForAction(action));
        }
        if (shouldSample) {
            this.onLogToFrameworkStats(new FrameworkStatsLogEvent(action, 306, STATSD_ACTION[action], duration));
        }
    }

    @VisibleForTesting
    public void onDeviceConfigPropertiesUpdated(SparseArray<ActionProperties> actionProperties) {
    }

    @VisibleForTesting
    public void onTriggerPerfetto(String triggerName) {
        PerfettoTrigger.trigger(triggerName);
    }

    @VisibleForTesting
    public void onLogToFrameworkStats(FrameworkStatsLogEvent event) {
        FrameworkStatsLog.write(event.logCode, event.statsdAction, event.durationMillis);
    }

    @VisibleForTesting
    public static class ActionProperties {
        static final String ENABLE_SUFFIX = "_enable";
        static final String SAMPLE_INTERVAL_SUFFIX = "_sample_interval";
        static final String LEGACY_TRACE_THRESHOLD_SUFFIX = "";
        static final String TRACE_THRESHOLD_SUFFIX = "_trace_threshold";
        private final int mAction;
        private final boolean mEnabled;
        private final int mSamplingInterval;
        private final int mTraceThreshold;

        @VisibleForTesting
        public ActionProperties(int action, boolean enabled, int samplingInterval, int traceThreshold) {
            this.mAction = action;
            AnnotationValidations.validate(Action.class, null, this.mAction);
            this.mEnabled = enabled;
            this.mSamplingInterval = samplingInterval;
            this.mTraceThreshold = traceThreshold;
        }

        @VisibleForTesting
        public int getAction() {
            return this.mAction;
        }

        @VisibleForTesting
        public boolean isEnabled() {
            return this.mEnabled;
        }

        @VisibleForTesting
        public int getSamplingInterval() {
            return this.mSamplingInterval;
        }

        @VisibleForTesting
        public int getTraceThreshold() {
            return this.mTraceThreshold;
        }

        public String toString() {
            return "ActionProperties{ mAction=" + this.mAction + ", mEnabled=" + this.mEnabled + ", mSamplingInterval=" + this.mSamplingInterval + ", mTraceThreshold=" + this.mTraceThreshold + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof ActionProperties)) {
                return false;
            }
            ActionProperties that = (ActionProperties)o;
            return this.mAction == that.mAction && this.mEnabled == that.mEnabled && this.mSamplingInterval == that.mSamplingInterval && this.mTraceThreshold == that.mTraceThreshold;
        }

        public int hashCode() {
            int _hash = 1;
            _hash = 31 * _hash + this.mAction;
            _hash = 31 * _hash + Boolean.hashCode(this.mEnabled);
            _hash = 31 * _hash + this.mSamplingInterval;
            _hash = 31 * _hash + this.mTraceThreshold;
            return _hash;
        }
    }

    private static class SLatencyTrackerHolder {
        private static final LatencyTracker sLatencyTracker = new LatencyTracker();

        private SLatencyTrackerHolder() {
        }

        static {
            sLatencyTracker.startListeningForLatencyTrackerConfigChanges();
        }
    }

    static class Session {
        private final int mAction;
        private final String mTag;
        private final String mName;
        private Runnable mTimeoutRunnable;
        private long mStartRtc = -1L;
        private long mEndRtc = -1L;

        Session(int action, String tag) {
            this.mAction = action;
            this.mTag = tag;
            this.mName = TextUtils.isEmpty(this.mTag) ? LatencyTracker.getNameOfAction(STATSD_ACTION[this.mAction]) : LatencyTracker.getNameOfAction(STATSD_ACTION[this.mAction]) + "::" + this.mTag;
        }

        String name() {
            return this.mName;
        }

        String traceName() {
            return LatencyTracker.getTraceNameOfAction(this.mAction, this.mTag);
        }

        void begin(Runnable timeoutAction) {
            this.mStartRtc = SystemClock.elapsedRealtime();
            Trace.asyncTraceForTrackBegin(4096L, this.traceName(), this.traceName(), 0);
            this.mTimeoutRunnable = () -> {
                Trace.instantForTrack(4096L, this.traceName(), "timeout");
                timeoutAction.run();
            };
            BackgroundThread.getHandler().postDelayed(this.mTimeoutRunnable, TimeUnit.SECONDS.toMillis(15L));
        }

        void end() {
            this.mEndRtc = SystemClock.elapsedRealtime();
            Trace.asyncTraceForTrackEnd(4096L, this.traceName(), 0);
            BackgroundThread.getHandler().removeCallbacks(this.mTimeoutRunnable);
            this.mTimeoutRunnable = null;
        }

        void cancel() {
            Trace.instantForTrack(4096L, this.traceName(), "cancel");
            Trace.asyncTraceForTrackEnd(4096L, this.traceName(), 0);
            BackgroundThread.getHandler().removeCallbacks(this.mTimeoutRunnable);
            this.mTimeoutRunnable = null;
        }

        int duration() {
            return (int)(this.mEndRtc - this.mStartRtc);
        }
    }

    @VisibleForTesting
    public static class FrameworkStatsLogEvent {
        @VisibleForTesting
        public final int action;
        @VisibleForTesting
        public final int logCode;
        @VisibleForTesting
        public final int statsdAction;
        @VisibleForTesting
        public final int durationMillis;

        private FrameworkStatsLogEvent(int action, int logCode, int statsdAction, int durationMillis) {
            this.action = action;
            this.logCode = logCode;
            this.statsdAction = statsdAction;
            this.durationMillis = durationMillis;
        }

        public String toString() {
            return "FrameworkStatsLogEvent{ logCode=" + this.logCode + ", statsdAction=" + this.statsdAction + ", durationMillis=" + this.durationMillis + "}";
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Action {
    }
}

