/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.net.Uri;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Log;
import android.view.WindowManager;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ScreenshotRequest;
import java.util.function.Consumer;

public class ScreenshotHelper {
    public static final int SCREENSHOT_MSG_URI = 1;
    public static final int SCREENSHOT_MSG_PROCESS_COMPLETE = 2;
    private static final String TAG = "ScreenshotHelper";
    private final int SCREENSHOT_TIMEOUT_MS = 10000;
    private final Object mScreenshotLock = new Object();
    private IBinder mScreenshotService = null;
    private ServiceConnection mScreenshotConnection = null;
    private final Context mContext;
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            Object object = ScreenshotHelper.this.mScreenshotLock;
            synchronized (object) {
                if ("android.intent.action.USER_SWITCHED".equals(intent.getAction())) {
                    ScreenshotHelper.this.resetConnection();
                }
            }
        }
    };

    public ScreenshotHelper(Context context) {
        this.mContext = context;
        IntentFilter filter = new IntentFilter("android.intent.action.USER_SWITCHED");
        this.mContext.registerReceiver(this.mBroadcastReceiver, filter, 2);
    }

    public void takeScreenshot(@WindowManager.ScreenshotSource int source, Handler handler, Consumer<Uri> completionConsumer) {
        ScreenshotRequest request = new ScreenshotRequest.Builder(1, source).build();
        this.takeScreenshot(request, handler, completionConsumer);
    }

    public void takeScreenshot(ScreenshotRequest request, Handler handler, Consumer<Uri> completionConsumer) {
        this.takeScreenshotInternal(request, handler, completionConsumer, 10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void takeScreenshotInternal(ScreenshotRequest request, final Handler handler, final Consumer<Uri> completionConsumer, long timeoutMs) {
        Object object = this.mScreenshotLock;
        synchronized (object) {
            final Runnable mScreenshotTimeout = () -> {
                Object object = this.mScreenshotLock;
                synchronized (object) {
                    if (this.mScreenshotConnection != null) {
                        Log.e(TAG, "Timed out before getting screenshot capture response");
                        this.resetConnection();
                        this.notifyScreenshotError();
                    }
                }
                if (completionConsumer != null) {
                    completionConsumer.accept(null);
                }
            };
            final Message msg = Message.obtain(null, 0, request);
            Handler h = new Handler(handler.getLooper()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handleMessage(Message msg) {
                    switch (msg.what) {
                        case 1: {
                            if (completionConsumer != null) {
                                completionConsumer.accept((Uri)msg.obj);
                            }
                            handler.removeCallbacks(mScreenshotTimeout);
                            break;
                        }
                        case 2: {
                            Object object = ScreenshotHelper.this.mScreenshotLock;
                            synchronized (object) {
                                ScreenshotHelper.this.resetConnection();
                                break;
                            }
                        }
                    }
                }
            };
            msg.replyTo = new Messenger(h);
            if (this.mScreenshotConnection == null || this.mScreenshotService == null) {
                if (this.mScreenshotConnection != null) {
                    this.resetConnection();
                }
                ComponentName serviceComponent = ComponentName.unflattenFromString(this.mContext.getResources().getString(17040002));
                Intent serviceIntent = new Intent();
                serviceIntent.setComponent(serviceComponent);
                ServiceConnection conn = new ServiceConnection(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onServiceConnected(ComponentName name, IBinder service) {
                        Object object = ScreenshotHelper.this.mScreenshotLock;
                        synchronized (object) {
                            block6: {
                                if (ScreenshotHelper.this.mScreenshotConnection != this) {
                                    return;
                                }
                                ScreenshotHelper.this.mScreenshotService = service;
                                Messenger messenger = new Messenger(ScreenshotHelper.this.mScreenshotService);
                                try {
                                    messenger.send(msg);
                                }
                                catch (RemoteException e) {
                                    Log.e(ScreenshotHelper.TAG, "Couldn't take screenshot: " + e);
                                    if (completionConsumer == null) break block6;
                                    completionConsumer.accept(null);
                                }
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onServiceDisconnected(ComponentName name) {
                        Object object = ScreenshotHelper.this.mScreenshotLock;
                        synchronized (object) {
                            if (ScreenshotHelper.this.mScreenshotConnection != null) {
                                ScreenshotHelper.this.resetConnection();
                                if (handler.hasCallbacks(mScreenshotTimeout)) {
                                    Log.e(ScreenshotHelper.TAG, "Screenshot service disconnected");
                                    handler.removeCallbacks(mScreenshotTimeout);
                                    ScreenshotHelper.this.notifyScreenshotError();
                                }
                            }
                        }
                    }
                };
                if (this.mContext.bindServiceAsUser(serviceIntent, conn, 0x4000001, UserHandle.CURRENT)) {
                    this.mScreenshotConnection = conn;
                    handler.postDelayed(mScreenshotTimeout, timeoutMs);
                } else {
                    this.mContext.unbindService(conn);
                }
            } else {
                block10: {
                    Messenger messenger = new Messenger(this.mScreenshotService);
                    try {
                        messenger.send(msg);
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Couldn't take screenshot: " + e);
                        if (completionConsumer == null) break block10;
                        completionConsumer.accept(null);
                    }
                }
                handler.postDelayed(mScreenshotTimeout, timeoutMs);
            }
        }
    }

    private void resetConnection() {
        if (this.mScreenshotConnection != null) {
            this.mContext.unbindService(this.mScreenshotConnection);
            this.mScreenshotConnection = null;
            this.mScreenshotService = null;
        }
    }

    private void notifyScreenshotError() {
        ComponentName errorComponent = ComponentName.unflattenFromString(this.mContext.getResources().getString(17040001));
        Intent errorIntent = new Intent("android.intent.action.USER_PRESENT");
        errorIntent.setComponent(errorComponent);
        errorIntent.addFlags(0x14000000);
        this.mContext.sendBroadcastAsUser(errorIntent, UserHandle.CURRENT);
    }
}

