/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;

public class UserIcons {
    private static final int[] USER_ICON_COLORS = new int[]{17171235, 17171236, 17171237, 17171238, 17171239, 17171240, 17171241, 17171242};

    public static Bitmap convertToBitmap(Drawable icon) {
        return UserIcons.convertToBitmapAtSize(icon, icon.getIntrinsicWidth(), icon.getIntrinsicHeight());
    }

    public static Bitmap convertToBitmapAtUserIconSize(Resources res, Drawable icon) {
        int size = res.getDimensionPixelSize(17105639);
        return UserIcons.convertToBitmapAtSize(icon, size, size);
    }

    private static Bitmap convertToBitmapAtSize(Drawable icon, int width, int height) {
        if (icon == null) {
            return null;
        }
        Bitmap bitmap = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        icon.setBounds(0, 0, width, height);
        icon.draw(canvas);
        return bitmap;
    }

    public static Drawable getDefaultUserIcon(Resources resources, int userId, boolean light) {
        int colorResId;
        int n = colorResId = light ? 17171244 : 17171243;
        if (userId != -10000) {
            colorResId = USER_ICON_COLORS[userId % USER_ICON_COLORS.length];
        }
        return UserIcons.getDefaultUserIconInColor(resources, resources.getColor(colorResId, null));
    }

    public static Drawable getDefaultUserIconInColor(Resources resources, int color2) {
        Drawable icon = resources.getDrawable(17302319, null).mutate();
        icon.setColorFilter(color2, PorterDuff.Mode.SRC_IN);
        icon.setBounds(0, 0, icon.getIntrinsicWidth(), icon.getIntrinsicHeight());
        return icon;
    }

    public static int[] getUserIconColors(Resources resources) {
        int[] result = new int[USER_ICON_COLORS.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = resources.getColor(USER_ICON_COLORS[i], null);
        }
        return result;
    }
}

